/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.redshift.client.interfaces.Notification;
import com.amazon.redshift.client.messages.inbound.NotificationResponse;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.core.PGJDBCPropertyKey;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.IWarningListener;
import com.amazon.support.Warning;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PGCoreUtils {
    private static final Pattern URL_PATTERN = Pattern.compile("(iam:)?//([^:/?]+)(:([^/?]*))?(/([^?;]*))?([?;](.*))?");
    private static final Pattern HOST_PATTERN = Pattern.compile("(.+)\\.(.+)\\.(.+).redshift(-dev)?\\.amazonaws\\.com(.)*");
    private static final String DEFAULT_PORT = System.getProperty("redshift.default-port", "5439");
    public static String NON_VALIDATING_SSL_FACTORY_PART1 = "org.post";
    public static String NON_VALIDATING_SSL_FACTORY_PART2 = "gresql.ssl.NonValidatingFactory";
    public static String NON_VALIDATING_SSL_FACTORY = NON_VALIDATING_SSL_FACTORY_PART1 + NON_VALIDATING_SSL_FACTORY_PART2;

    public static boolean parseSubName(String string, Properties properties, boolean bl) {
        String string2;
        String[] stringArray;
        Matcher matcher = URL_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        boolean bl2 = matcher.group(1) != null;
        String string3 = matcher.group(2);
        String string4 = matcher.group(4);
        String string5 = matcher.group(6);
        String string6 = matcher.group(8);
        treeMap.put(PGJDBCPropertyKey.IAM_AUTH.getKey(), String.valueOf(bl2));
        if (bl2) {
            if (null != string4 && !string4.matches("\\d*")) {
                treeMap.put(PGJDBCPropertyKey.CLUSTER_IDENTIFIER.getKey(), string3);
                treeMap.put(PGJDBCPropertyKey.AWS_REGION.getKey(), string4);
            } else {
                treeMap.put(PGJDBCPropertyKey.HOST_KEY.getKey(), string3);
                if (null == string4 || string4.isEmpty()) {
                    string4 = DEFAULT_PORT;
                }
                treeMap.put(PGJDBCPropertyKey.PORT_KEY.getKey(), string4);
                stringArray = HOST_PATTERN.matcher(string3);
                if (stringArray.matches()) {
                    treeMap.put(PGJDBCPropertyKey.CLUSTER_IDENTIFIER.getKey(), stringArray.group(1));
                    treeMap.put(PGJDBCPropertyKey.AWS_REGION.getKey(), stringArray.group(3));
                }
            }
        } else {
            treeMap.put(PGJDBCPropertyKey.HOST_KEY.getKey(), string3);
            if (null == string4 || string4.isEmpty()) {
                string4 = DEFAULT_PORT;
            }
            treeMap.put(PGJDBCPropertyKey.PORT_KEY.getKey(), string4);
        }
        if (null != string5) {
            treeMap.put(PGJDBCPropertyKey.SCHEMA_KEY.getKey(), string5);
        }
        if (string6 != null && !string6.isEmpty()) {
            stringArray = string6.split("[;&]");
            boolean bl3 = false;
            int n = -1;
            int n2 = -1;
            String string7 = PGJDBCPropertyKey.PASSWORD.getKey();
            String string8 = PGJDBCPropertyKey.PASSWORD_ALT.getKey();
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2;
                String string9 = stringArray[i];
                if (string9.length() > string7.length() && string9.substring(0, string7.length()).equalsIgnoreCase(string7) || string9.length() > string8.length() && string9.substring(0, string8.length()).equalsIgnoreCase(string8)) {
                    bl3 = true;
                    stringArray2 = string9.split("=", 2);
                    if (stringArray2.length > 1) {
                        treeMap.put(string7.toUpperCase(), stringArray2[1]);
                        n = string6.indexOf(stringArray2[1]);
                        continue;
                    }
                    treeMap.put(string9, "");
                    continue;
                }
                if (bl3) {
                    stringArray2 = string9.split("=", 2);
                    if (stringArray2.length > 1 && PGJDBCPropertyKey.getSettingsList().contains(stringArray2[0].toUpperCase())) {
                        treeMap.put(stringArray2[0], stringArray2[1]);
                        if (!bl3) continue;
                        bl3 = false;
                        continue;
                    }
                    if (stringArray2.length > 1 && !PGJDBCPropertyKey.getSettingsList().contains(stringArray2[0].toUpperCase())) {
                        n2 = string6.indexOf(string9, n + ((String)treeMap.get(string7)).length()) + string9.length();
                        treeMap.put(string7, string6.substring(n, n2));
                        continue;
                    }
                    n2 = string6.indexOf(string9, n + ((String)treeMap.get(string7)).length()) + string9.length();
                    if (string9.isEmpty()) {
                        ++n2;
                    }
                    treeMap.put(string7, string6.substring(n, n2));
                    continue;
                }
                stringArray2 = string9.split("=", 2);
                if (stringArray2.length > 1) {
                    treeMap.put(stringArray2[0], stringArray2[1]);
                    continue;
                }
                treeMap.put(string9, "");
            }
        }
        stringArray = properties.keys();
        while (stringArray.hasMoreElements()) {
            String string10 = (String)stringArray.nextElement();
            if (treeMap.containsKey(string10)) continue;
            treeMap.put(string10, properties.get(string10).toString());
        }
        if (bl && treeMap.containsKey(PGJDBCPropertyKey.OPEN_SOURCE_OVERRIDE.getKey()) && Boolean.parseBoolean((String)treeMap.get(PGJDBCPropertyKey.OPEN_SOURCE_OVERRIDE.getKey()))) {
            try {
                Class.forName("org.postgresql.Driver");
                return false;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (null != (string2 = (String)treeMap.remove(PGJDBCPropertyKey.USERNAME_ALT.getKey()))) {
            treeMap.put(PGJDBCPropertyKey.USERNAME.getKey(), string2);
        }
        if (null != (string2 = (String)treeMap.remove(PGJDBCPropertyKey.PASSWORD_ALT.getKey()))) {
            treeMap.put(PGJDBCPropertyKey.PASSWORD.getKey(), string2);
        }
        if (bl2) {
            if (!treeMap.containsKey(PGJDBCPropertyKey.USERNAME.getKey())) {
                treeMap.put(PGJDBCPropertyKey.USERNAME.getKey(), "*");
            }
            if (!treeMap.containsKey(PGJDBCPropertyKey.PASSWORD.getKey())) {
                treeMap.put(PGJDBCPropertyKey.PASSWORD.getKey(), "*");
            }
        }
        properties.clear();
        properties.putAll((Map<?, ?>)treeMap);
        return true;
    }

    public static int safeLongToInt(long l) throws ErrorException {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_DATA_CONVERSION_ERROR_INTEGER.name(), new BigDecimal(l).toString(), ExceptionType.DATA);
        }
        return (int)l;
    }

    public static List<Notification> getNotifications(IWarningListener iWarningListener) {
        List<Warning> list;
        ArrayList<NotificationResponse> arrayList = null;
        if (null != iWarningListener && null != (list = iWarningListener.getWarnings())) {
            NotificationResponse notificationResponse = null;
            arrayList = new ArrayList<NotificationResponse>();
            for (Warning warning : list) {
                if (null == warning || null == (notificationResponse = new NotificationResponse(warning)).getName()) continue;
                arrayList.add(notificationResponse);
            }
        }
        return arrayList;
    }

    public static void clearNotifications(IWarningListener iWarningListener) {
        List<Warning> list;
        if (null != iWarningListener && null != (list = iWarningListener.getWarnings())) {
            list.clear();
        }
    }

    public static boolean willAdditionOverflow(long l, long l2) {
        return ((l ^ l2 ^ 0xFFFFFFFFFFFFFFFFL) & (l ^ l + l2)) < 0L;
    }

    public static enum TransactionVerb {
        BEGIN,
        COMMIT,
        ROLLBACK,
        NONE;

    }
}

