/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.dsi.core.utilities.ConnSettingRequestMap;
import com.amazon.dsi.core.utilities.Variant;
import com.amazon.redshift.AuthMech;
import com.amazon.redshift.CredentialsHolder;
import com.amazon.redshift.IPlugin;
import com.amazon.redshift.core.PGJDBCConnection;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.core.PGJDBCPropertyKey;
import com.amazon.redshift.core.PGJDBCSettings;
import com.amazon.redshift.core.PluginProfilesConfigFile;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.auth.profile.ProfilesConfigFile;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.redshift.AmazonRedshift;
import com.amazonaws.services.redshift.AmazonRedshiftClientBuilder;
import com.amazonaws.services.redshift.model.Cluster;
import com.amazonaws.services.redshift.model.DescribeClustersRequest;
import com.amazonaws.services.redshift.model.Endpoint;
import com.amazonaws.services.redshift.model.GetClusterCredentialsRequest;
import com.amazonaws.services.redshift.model.GetClusterCredentialsResult;
import com.amazonaws.util.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class IamHelper {
    private static final int MAX_AMAZONCLIENT_RETRY = 5;
    private static final int MAX_AMAZONCLIENT_RETRY_DELAY_MS = 1000;
    private PGJDBCSettings m_settings;
    private ILogger m_log;
    private static Map<String, GetClusterCredentialsResult> m_credentialsCache = new HashMap<String, GetClusterCredentialsResult>();

    public IamHelper(PGJDBCSettings pGJDBCSettings, ILogger iLogger) {
        this.m_settings = pGJDBCSettings;
        this.m_log = iLogger;
        if (this.m_log != null) {
            LogUtilities.logDebug("PGJDBCSettings{m_host='" + this.m_settings.m_host + '\'' + ", m_port=" + this.m_settings.m_port + ", m_loginTimeoutMS=" + this.m_settings.m_loginTimeoutMS + ", m_rowsFetchedPerBlock=" + this.m_settings.m_rowsFetchedPerBlock + ", m_unknownLength=" + this.m_settings.m_unknownLength + ", m_authMech=" + (Object)((Object)this.m_settings.m_authMech) + ", m_username='" + this.m_settings.m_username + '\'' + ", m_password='" + (this.m_settings.m_password == null ? "null" : "**") + '\'' + ", m_krbRealm='" + this.m_settings.m_krbRealm + '\'' + ", m_krbServiceName='" + this.m_settings.m_krbServiceName + '\'' + ", m_krbHostFQDN='" + this.m_settings.m_krbHostFQDN + '\'' + ", m_sslKeyStore='" + this.m_settings.m_sslKeyStore + '\'' + ", m_sslKeyStorePwd='" + (this.m_settings.m_sslKeyStorePwd == null ? "null" : "**") + '\'' + ", m_sslPassword='" + (this.m_settings.m_sslPassword == null ? "null" : "**") + '\'' + ", m_sslKey='" + this.m_settings.m_sslKey + '\'' + ", m_sslCert='" + this.m_settings.m_sslCert + '\'' + ", m_sslRootCert='" + this.m_settings.m_sslRootCert + '\'' + ", m_Schema='" + this.m_settings.m_Schema + '\'' + ", m_delegationUID='" + this.m_settings.m_delegationUID + '\'' + ", m_nRowMode=" + this.m_settings.m_nRowMode + ", m_newTCPConnectionKeepAliveMinutes=" + this.m_settings.m_newTCPConnectionKeepAliveMinutes + ", m_filterLevel='" + this.m_settings.m_filterLevel + '\'' + ", m_socketTimeoutMS=" + this.m_settings.m_socketTimeoutMS + ", m_disableIsValid=" + this.m_settings.m_disableIsValid + ", m_iamAuth=" + this.m_settings.m_iamAuth + ", m_iamAccessKeyID='" + (this.m_settings.m_iamAccessKeyID == null ? "null" : "**") + '\'' + ", m_iamSecretKey='" + (this.m_settings.m_iamSecretKey == null ? "null" : "**") + '\'' + ", m_iamSessionToken='" + this.m_settings.m_iamSessionToken + '\'' + ", m_profile='" + this.m_settings.m_profile + '\'' + ", m_externalId='" + this.m_settings.m_externalId + '\'' + ", m_clusterIdentifier='" + this.m_settings.m_clusterIdentifier + '\'' + ", m_iamDuration=" + this.m_settings.m_iamDuration + ", m_autocreate=" + this.m_settings.m_autocreate + ", m_dbUser='" + this.m_settings.m_dbUser + '\'' + ", m_dbGroups=" + this.m_settings.m_dbGroups + ", m_forceLowercase=" + this.m_settings.m_forceLowercase + ", m_endpoint='" + this.m_settings.m_endpoint + '\'' + ", m_awsRegion='" + this.m_settings.m_awsRegion + '\'' + ", m_credentialsProvider='" + this.m_settings.m_credentialsProvider + '\'' + ", m_sslTrustStorePath='" + this.m_settings.m_sslTrustStorePath + '\'' + ", m_sslTrustStorePwd='" + (this.m_settings.m_sslTrustStorePwd == null ? "null" : "**") + '\'' + ", m_pluginArgs=" + this.m_settings.m_pluginArgs + ", m_hasExtSchemaPatternMatch=" + this.m_settings.m_hasExtSchemaPatternMatch + ", m_selectorProvider='" + this.m_settings.m_selectorProvider + '\'' + ", m_selectorProviderArg='" + this.m_settings.m_selectorProviderArg + '\'' + ", m_readonly=" + this.m_settings.m_readonly + '\'' + ", m_queryGroup=" + this.m_settings.m_queryGroup + '\'' + ", m_databaseMetadataCurrentDbOnly=" + this.m_settings.m_databaseMetadataCurrentDbOnly + '}', this.m_log);
        }
    }

    public void setIAMProperties(ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        if (this.m_settings.m_authMech.ordinal() < AuthMech.VERIFY_CA.ordinal()) {
            this.m_settings.m_authMech = AuthMech.VERIFY_CA;
        }
        Variant variant = PGJDBCConnection.getRequiredConnSetting(PGJDBCPropertyKey.CLUSTER_IDENTIFIER.getKey(), connSettingRequestMap);
        Variant variant2 = PGJDBCConnection.getOptionalConnSetting(PGJDBCPropertyKey.AWS_REGION.getKey(), connSettingRequestMap);
        Variant variant3 = PGJDBCConnection.getOptionalConnSetting(PGJDBCPropertyKey.ENDPOINT_URL.getKey(), connSettingRequestMap);
        Variant variant4 = PGJDBCConnection.getOptionalConnSetting(PGJDBCPropertyKey.USERNAME.getKey(), connSettingRequestMap);
        Variant variant5 = PGJDBCConnection.getOptionalConnSetting(PGJDBCPropertyKey.PASSWORD.getKey(), connSettingRequestMap);
        Variant variant6 = PGJDBCConnection.getOptionalConnSetting(PGJDBCPropertyKey.AWS_PROFILE.getKey(), connSettingRequestMap);
        Variant variant7 = PGJDBCConnection.getOptionalConnSetting(PGJDBCPropertyKey.IAM_DURATION.getKey(), connSettingRequestMap);
        Variant variant8 = PGJDBCConnection.getOptionalConnSetting(PGJDBCPropertyKey.IAM_ACCESS_KEY_ID.getKey(), connSettingRequestMap);
        Variant variant9 = PGJDBCConnection.getOptionalConnSetting(PGJDBCPropertyKey.IAM_SECRET_ACCESS_KEY.getKey(), connSettingRequestMap);
        Variant variant10 = PGJDBCConnection.getOptionalConnSetting(PGJDBCPropertyKey.IAM_SESSION_TOKEN.getKey(), connSettingRequestMap);
        Variant variant11 = PGJDBCConnection.getOptionalConnSetting(PGJDBCPropertyKey.CREDENTIALS_PROVIDER.getKey(), connSettingRequestMap);
        Variant variant12 = PGJDBCConnection.getOptionalConnSetting(PGJDBCPropertyKey.USER_AUTOCREATE.getKey(), connSettingRequestMap);
        Variant variant13 = PGJDBCConnection.getOptionalConnSetting(PGJDBCPropertyKey.DB_USER.getKey(), connSettingRequestMap);
        Variant variant14 = PGJDBCConnection.getOptionalConnSetting(PGJDBCPropertyKey.DB_GROUPS.getKey(), connSettingRequestMap);
        Variant variant15 = PGJDBCConnection.getOptionalConnSetting(PGJDBCPropertyKey.FORCE_LOWERCASE.getKey(), connSettingRequestMap);
        LogUtilities.logDebug(connSettingRequestMap.toString(), this.m_log);
        this.m_settings.m_clusterIdentifier = variant.getString();
        if (this.m_settings.m_clusterIdentifier.isEmpty()) {
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_MISSING_PROPERTY_ERROR, PGJDBCPropertyKey.CLUSTER_IDENTIFIER.getKey());
        }
        if (null != variant2) {
            this.m_settings.m_awsRegion = variant2.getString().trim().toLowerCase();
        }
        this.m_settings.m_endpoint = null != variant3 ? variant3.getString() : System.getProperty("redshift.endpoint-url");
        if (null != variant4) {
            this.m_settings.m_username = variant4.getString();
        }
        if (null != variant5) {
            this.m_settings.m_password = variant5.getString();
        }
        if (null != variant6) {
            this.m_settings.m_profile = variant6.getString();
        }
        if (null != variant7) {
            try {
                this.m_settings.m_iamDuration = Integer.parseInt(variant7.getString());
                if (this.m_settings.m_iamDuration < 900 || this.m_settings.m_iamDuration > 3600) {
                    ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_INVALID_PROPERTY_VALUE_TYPE_OR_RANGE.name(), new String[]{PGJDBCPropertyKey.IAM_DURATION.getKey(), variant7.getString(), "900", "3600"});
                    LogUtilities.logError(errorException, this.m_log);
                    throw errorException;
                }
            }
            catch (NumberFormatException numberFormatException) {
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_INVALID_PROPERTY_VALUE.name(), new String[]{PGJDBCPropertyKey.IAM_DURATION.getKey(), variant7.getString()});
                LogUtilities.logError(errorException, this.m_log);
                throw errorException;
            }
        }
        if (null != variant8) {
            this.m_settings.m_iamAccessKeyID = variant8.getString();
        }
        if (null != variant9) {
            if (StringUtils.isNullOrEmpty((String)this.m_settings.m_iamAccessKeyID)) {
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_MISSING_PROPERTY_ERROR, PGJDBCPropertyKey.IAM_ACCESS_KEY_ID.getKey());
                LogUtilities.logError(errorException, this.m_log);
                throw errorException;
            }
            this.m_settings.m_iamSecretKey = variant9.getString();
            if (this.m_settings.m_iamSecretKey.isEmpty()) {
                this.m_settings.m_iamSecretKey = this.m_settings.m_password;
            }
        } else {
            this.m_settings.m_iamSecretKey = this.m_settings.m_password;
        }
        if (null != variant10) {
            if (StringUtils.isNullOrEmpty((String)this.m_settings.m_iamAccessKeyID)) {
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_MISSING_PROPERTY_ERROR, PGJDBCPropertyKey.IAM_ACCESS_KEY_ID.getKey());
                LogUtilities.logError(errorException, this.m_log);
                throw errorException;
            }
            this.m_settings.m_iamSessionToken = variant10.getString();
        }
        if (null != variant11) {
            this.m_settings.m_credentialsProvider = variant11.getString();
        }
        Iterator<String> iterator = connSettingRequestMap.getKeysIterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toLowerCase(Locale.getDefault());
            String string2 = connSettingRequestMap.getProperty(string).getString();
            if ("*".equals(string2)) continue;
            this.m_settings.m_pluginArgs.put(string, string2);
        }
        this.m_settings.m_autocreate = variant12 == null ? null : Boolean.valueOf(variant12.getString());
        Boolean bl = this.m_settings.m_forceLowercase = variant15 == null ? null : Boolean.valueOf(variant15.getString());
        if (null != variant13) {
            this.m_settings.m_dbUser = variant13.getString();
        }
        this.m_settings.m_dbGroups = variant14 != null ? Arrays.asList((this.m_settings.m_forceLowercase != null && this.m_settings.m_forceLowercase != false ? variant14.getString().toLowerCase(Locale.getDefault()) : variant14.getString()).split(",")) : Collections.emptyList();
        this.setIAMCredentials();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void setIAMCredentials() throws ErrorException {
        if (!StringUtils.isNullOrEmpty((String)this.m_settings.m_credentialsProvider)) {
            if (!StringUtils.isNullOrEmpty((String)this.m_settings.m_profile)) {
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_PROPERTY_CONFLICT_ERR, new String[]{PGJDBCPropertyKey.CREDENTIALS_PROVIDER.getKey(), PGJDBCPropertyKey.AWS_PROFILE.getKey()});
            }
            if (!StringUtils.isNullOrEmpty((String)this.m_settings.m_iamAccessKeyID)) {
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_PROPERTY_CONFLICT_ERR, new String[]{PGJDBCPropertyKey.CREDENTIALS_PROVIDER.getKey(), PGJDBCPropertyKey.IAM_ACCESS_KEY_ID.getKey()});
            }
            try {
                var1_1 = Class.forName(this.m_settings.m_credentialsProvider).asSubclass(AWSCredentialsProvider.class);
                var2_4 = (AWSCredentialsProvider)var1_1.newInstance();
                if (!(var2_4 instanceof IPlugin)) ** GOTO lbl31
                var3_5 = (IPlugin)var2_4;
                var3_5.setILogger(this.m_log);
                for (Object var5_7 : this.m_settings.m_pluginArgs.entrySet()) {
                    var3_5.addParameter((String)var5_7.getKey(), (String)var5_7.getValue());
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException var1_2) {
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_INVALID_CREDENTIALS_PROVIDER_CLASS, this.m_settings.m_credentialsProvider);
            }
            catch (NumberFormatException var1_3) {
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(var1_3.getMessage(), this.m_settings.m_credentialsProvider);
            }
        } else if (!StringUtils.isNullOrEmpty((String)this.m_settings.m_profile)) {
            if (!StringUtils.isNullOrEmpty((String)this.m_settings.m_iamAccessKeyID)) {
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_PROPERTY_CONFLICT_ERR, new String[]{PGJDBCPropertyKey.AWS_PROFILE.getKey(), PGJDBCPropertyKey.IAM_ACCESS_KEY_ID.getKey()});
            }
            var1_1 = new PluginProfilesConfigFile(this.m_settings, this.m_log);
            var2_4 = new ProfileCredentialsProvider((ProfilesConfigFile)var1_1, this.m_settings.m_profile);
        } else if (!StringUtils.isNullOrEmpty((String)this.m_settings.m_iamAccessKeyID)) {
            var1_1 = StringUtils.isNullOrEmpty((String)this.m_settings.m_iamSessionToken) == false ? new BasicSessionCredentials(this.m_settings.m_iamAccessKeyID, this.m_settings.m_iamSecretKey, this.m_settings.m_iamSessionToken) : new BasicAWSCredentials(this.m_settings.m_iamAccessKeyID, this.m_settings.m_iamSecretKey);
            var2_4 = new AWSStaticCredentialsProvider((AWSCredentials)var1_1);
        } else {
            var2_4 = new DefaultAWSCredentialsProviderChain();
        }
lbl31:
        // 5 sources

        var1_1 = var2_4.getCredentials();
        if (var1_1 instanceof CredentialsHolder && null != (var3_5 = ((CredentialsHolder)var1_1).getMetadata())) {
            var4_6 = var3_5.getAutoCreate();
            var5_7 = var3_5.getDbUser();
            var6_8 = var3_5.getSamlDbUser();
            var7_9 = var3_5.getProfileDbUser();
            var8_10 = var3_5.getDbGroups();
            var9_11 = var3_5.getForceLowercase();
            var10_12 = var3_5.getAllowDbUserOverride();
            if (null == this.m_settings.m_autocreate) {
                this.m_settings.m_autocreate = var4_6;
            }
            if (null == this.m_settings.m_forceLowercase) {
                this.m_settings.m_forceLowercase = var9_11;
            }
            if (var10_12) {
                if (null != var6_8) {
                    this.m_settings.m_dbUser = var6_8;
                } else if (null != var5_7) {
                    this.m_settings.m_dbUser = var5_7;
                } else if (null != var7_9) {
                    this.m_settings.m_dbUser = var7_9;
                }
            } else if (null != var5_7) {
                this.m_settings.m_dbUser = var5_7;
            } else if (null != var7_9) {
                this.m_settings.m_dbUser = var7_9;
            } else if (null != var6_8) {
                this.m_settings.m_dbUser = var6_8;
            }
            if (this.m_settings.m_dbGroups.isEmpty() && null != var8_10) {
                this.m_settings.m_dbGroups = Arrays.asList((this.m_settings.m_forceLowercase != false ? var8_10.toLowerCase(Locale.getDefault()) : var8_10).split(","));
            }
        }
        if ("*".equals(this.m_settings.m_username) && null == this.m_settings.m_dbUser) {
            var3_5 = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_MISSING_PROPERTY_ERROR, PGJDBCPropertyKey.DB_USER.getKey());
            LogUtilities.logError((ErrorException)var3_5, this.m_log);
            throw var3_5;
        }
        this.setClusterCredentials((AWSCredentialsProvider)var2_4);
    }

    private void setClusterCredentials(AWSCredentialsProvider aWSCredentialsProvider) throws ErrorException {
        try {
            Object object;
            DescribeClustersRequest describeClustersRequest;
            AwsClientBuilder.EndpointConfiguration endpointConfiguration;
            AmazonRedshiftClientBuilder amazonRedshiftClientBuilder = AmazonRedshiftClientBuilder.standard();
            if (this.m_settings.m_endpoint != null) {
                endpointConfiguration = new AwsClientBuilder.EndpointConfiguration(this.m_settings.m_endpoint, this.m_settings.m_endpoint);
                amazonRedshiftClientBuilder.setEndpointConfiguration(endpointConfiguration);
            } else if (this.m_settings.m_awsRegion != null && !this.m_settings.m_awsRegion.isEmpty()) {
                amazonRedshiftClientBuilder.setRegion(this.m_settings.m_awsRegion);
            }
            endpointConfiguration = (AmazonRedshift)((AmazonRedshiftClientBuilder)amazonRedshiftClientBuilder.withCredentials(aWSCredentialsProvider)).build();
            if (null == this.m_settings.m_host || this.m_settings.m_port == 0) {
                describeClustersRequest = new DescribeClustersRequest();
                describeClustersRequest.setClusterIdentifier(this.m_settings.m_clusterIdentifier);
                object = endpointConfiguration.describeClusters(describeClustersRequest);
                List list = object.getClusters();
                if (list.isEmpty()) {
                    throw new AmazonClientException("Failed to describeClusters.");
                }
                Cluster cluster = (Cluster)list.get(0);
                Endpoint endpoint = cluster.getEndpoint();
                if (null == endpoint) {
                    throw new AmazonClientException("Cluster is not fully created yet.");
                }
                this.m_settings.m_host = endpoint.getAddress();
                this.m_settings.m_port = endpoint.getPort();
            }
            describeClustersRequest = IamHelper.getClusterCredentialsResult(this.m_settings, (AmazonRedshift)endpointConfiguration, this.m_log);
            this.m_settings.m_username = describeClustersRequest.getDbUser();
            this.m_settings.m_password = describeClustersRequest.getDbPassword();
            object = new Date();
            LogUtilities.logInfo(object + ": Using GetClusterCredentialsResult with expiration " + describeClustersRequest.getExpiration(), this.m_log);
        }
        catch (AmazonClientException amazonClientException) {
            LogUtilities.logError((Exception)((Object)amazonClientException), this.m_log);
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_IAM_ERROR_RETRIEVING_TEMP_CREDS, amazonClientException.getMessage());
            LogUtilities.logError(errorException, this.m_log);
            throw errorException;
        }
    }

    private static synchronized GetClusterCredentialsResult getClusterCredentialsResult(PGJDBCSettings pGJDBCSettings, AmazonRedshift amazonRedshift, ILogger iLogger) throws AmazonClientException {
        String string = IamHelper.getCredentialsCacheKey(pGJDBCSettings);
        GetClusterCredentialsResult getClusterCredentialsResult = m_credentialsCache.get(string);
        if (getClusterCredentialsResult == null || getClusterCredentialsResult.getExpiration().before(new Date(System.currentTimeMillis() - 300000L))) {
            m_credentialsCache.remove(string);
            GetClusterCredentialsRequest getClusterCredentialsRequest = new GetClusterCredentialsRequest();
            getClusterCredentialsRequest.setClusterIdentifier(pGJDBCSettings.m_clusterIdentifier);
            if (pGJDBCSettings.m_iamDuration > 0) {
                getClusterCredentialsRequest.setDurationSeconds(Integer.valueOf(pGJDBCSettings.m_iamDuration));
            }
            getClusterCredentialsRequest.setDbName(pGJDBCSettings.m_Schema);
            getClusterCredentialsRequest.setDbUser(pGJDBCSettings.m_dbUser == null ? pGJDBCSettings.m_username : pGJDBCSettings.m_dbUser);
            getClusterCredentialsRequest.setAutoCreate(pGJDBCSettings.m_autocreate);
            getClusterCredentialsRequest.setDbGroups(pGJDBCSettings.m_dbGroups);
            LogUtilities.logTrace(getClusterCredentialsRequest.toString(), iLogger);
            for (int i = 0; i < 5; ++i) {
                try {
                    getClusterCredentialsResult = amazonRedshift.getClusterCredentials(getClusterCredentialsRequest);
                    break;
                }
                catch (AmazonClientException amazonClientException) {
                    if (amazonClientException.getMessage().contains("Rate exceeded") && i < 4) {
                        LogUtilities.logWarning("getClusterCredentialsResult caught 'Rate exceeded' error...", iLogger);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                        }
                        continue;
                    }
                    throw amazonClientException;
                }
            }
            m_credentialsCache.put(string, getClusterCredentialsResult);
        }
        return getClusterCredentialsResult;
    }

    private static String getCredentialsCacheKey(PGJDBCSettings pGJDBCSettings) {
        String string = "";
        if (pGJDBCSettings.m_dbGroups != null && !pGJDBCSettings.m_dbGroups.isEmpty()) {
            Collections.sort(pGJDBCSettings.m_dbGroups);
            string = String.join((CharSequence)",", pGJDBCSettings.m_dbGroups);
        }
        return pGJDBCSettings.m_clusterIdentifier + ";" + (pGJDBCSettings.m_dbUser == null ? pGJDBCSettings.m_username : pGJDBCSettings.m_dbUser) + ";" + (pGJDBCSettings.m_Schema == null ? "" : pGJDBCSettings.m_Schema) + ";" + string + ";" + pGJDBCSettings.m_autocreate + ";" + pGJDBCSettings.m_iamDuration;
    }
}

