/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.outbound;

import com.amazon.jdbc.communications.interfaces.AbstractOutboundMessage;
import com.amazon.jdbc.utils.DataTypeUtilities;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import java.nio.ByteBuffer;

public class Startup
extends AbstractOutboundMessage
implements PGConstants {
    private static final byte PROTOCOL_MAJOR_VERSION_3 = 3;
    private static final byte PROTOCOL_MINOR_VERSION_0 = 0;
    private static final byte[] FIELD_USER = PGDataTypeUtilities.toUTF8ByteArray("user");
    private static final byte[] FIELD_DATABASE = PGDataTypeUtilities.toUTF8ByteArray("database");
    private static final byte[] FIELD_EXTRA_FLOAT_DIGITS = PGDataTypeUtilities.toUTF8ByteArray("extra_float_digits");
    private static final byte[] FIELD_EXTRA_FLOAT_DIGITS_DEFAULT_VALUE = PGDataTypeUtilities.toUTF8ByteArray("2");
    private static final byte[] FIELD_DRIVER_VERSION = PGDataTypeUtilities.toUTF8ByteArray("driver_version");
    private static final byte[] FIELD_OS_VERSION = PGDataTypeUtilities.toUTF8ByteArray("os_version");
    private static final byte[] FIELD_PLUGIN_NAME = PGDataTypeUtilities.toUTF8ByteArray("plugin_name");
    private final byte[] user;
    private final byte[] database;
    private final byte[] driverVersion;
    private final byte[] osVersion;
    private final byte[] plugin_name;

    public Startup(String string, String string2, String string3, ILogger iLogger) {
        byte[] byArray;
        this.user = DataTypeUtilities.toUTF8ByteArray(string);
        this.database = DataTypeUtilities.toUTF8ByteArray(string2);
        this.driverVersion = DataTypeUtilities.toUTF8ByteArray("Amazon Redshift JDBC Driver " + PGJDBCDriver.DRIVER_MAJOR_VERSION + "." + PGJDBCDriver.DRIVER_MINOR_VERSION + "." + PGJDBCDriver.DRIVER_HOT_FIX_VERSION + "." + PGJDBCDriver.DRIVER_BUILD_NUMBER);
        try {
            byArray = DataTypeUtilities.toUTF8ByteArray(System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch"));
        }
        catch (Exception exception) {
            byArray = DataTypeUtilities.toUTF8ByteArray("Unknown");
        }
        this.osVersion = byArray;
        this.plugin_name = DataTypeUtilities.toUTF8ByteArray(string3);
    }

    @Override
    public void serialize(ByteBuffer byteBuffer, byte[] byArray) {
        byte[] byArray2 = new byte[]{0, 3, 0, 0};
        byteBuffer.put(byArray);
        byteBuffer.put(byArray2);
        this.addField(byteBuffer, FIELD_USER, this.user);
        this.addField(byteBuffer, FIELD_DATABASE, this.database);
        this.addField(byteBuffer, FIELD_EXTRA_FLOAT_DIGITS, FIELD_EXTRA_FLOAT_DIGITS_DEFAULT_VALUE);
        this.addField(byteBuffer, FIELD_DRIVER_VERSION, this.driverVersion);
        this.addField(byteBuffer, FIELD_OS_VERSION, this.osVersion);
        this.addField(byteBuffer, FIELD_PLUGIN_NAME, this.plugin_name);
        byteBuffer.put(TERMINATOR);
    }

    @Override
    public int getSize() {
        return 8 + FIELD_USER.length + 1 + this.user.length + 1 + FIELD_DATABASE.length + 1 + this.database.length + 1 + FIELD_EXTRA_FLOAT_DIGITS.length + 1 + FIELD_EXTRA_FLOAT_DIGITS_DEFAULT_VALUE.length + 1 + FIELD_DRIVER_VERSION.length + 1 + this.driverVersion.length + 1 + FIELD_OS_VERSION.length + 1 + this.osVersion.length + 1 + FIELD_PLUGIN_NAME.length + 1 + this.plugin_name.length + 1 + 1;
    }

    public void logMessageContent(ILogger iLogger) {
        String string = "=>FE StartupMessage(user=" + this.user + ", database=" + this.database + ", driver_version=" + this.driverVersion + ", os_version=" + this.osVersion + ", plugin_name=" + this.plugin_name + ")";
        LogUtilities.logTrace(string, iLogger);
    }
}

