/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.outbound;

import com.amazon.jdbc.communications.interfaces.AbstractOutboundMessage;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.PGConstants;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import java.nio.ByteBuffer;

public class Query
extends AbstractOutboundMessage
implements PGConstants {
    private final byte[] query;

    public Query(String string, ILogger iLogger) {
        this.query = PGDataTypeUtilities.toUTF8ByteArray(string);
    }

    @Override
    public void serialize(ByteBuffer byteBuffer, byte[] byArray) {
        byteBuffer.put((byte)81);
        byteBuffer.put(byArray);
        byteBuffer.put(this.query);
        byteBuffer.put(TERMINATOR);
    }

    @Override
    public int getSize() {
        return 4 + this.query.length + 1;
    }

    public void logMessageContent(ILogger iLogger) {
        String string = "=>FE Query(" + new String(this.query) + ")";
        LogUtilities.logTrace(string, iLogger);
    }
}

