/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.outbound;

import com.amazon.jdbc.communications.interfaces.AbstractOutboundMessage;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.PGConstants;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import java.nio.ByteBuffer;

public class PasswordMessage
extends AbstractOutboundMessage
implements PGConstants {
    private final byte[] m_password;

    public PasswordMessage(String string, ILogger iLogger) {
        this.m_password = (byte[])(null != string ? PGDataTypeUtilities.toUTF8ByteArray(string) : null);
    }

    public PasswordMessage(byte[] byArray, ILogger iLogger) {
        this.m_password = byArray;
    }

    @Override
    public void serialize(ByteBuffer byteBuffer, byte[] byArray) {
        byteBuffer.put((byte)112);
        byteBuffer.put(byArray);
        if (null != this.m_password) {
            byteBuffer.put(this.m_password);
        }
        byteBuffer.put(TERMINATOR);
    }

    @Override
    public int getSize() {
        return 4 + (this.m_password != null ? this.m_password.length : 0) + 1;
    }

    public void logMessageContent(ILogger iLogger) {
        String string = "=>FE Password(md5digest=" + new String(this.m_password) + ")";
        LogUtilities.logTrace(string, iLogger);
    }
}

