/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.outbound;

import com.amazon.jdbc.communications.interfaces.AbstractOutboundMessage;
import com.amazon.redshift.client.PGConstants;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import java.nio.ByteBuffer;

public class Describe
extends AbstractOutboundMessage
implements PGConstants {
    private static byte DESCRIBE_TYPE_PORTAL = (byte)80;
    private static byte DESCRIBE_TYPE_PREPARED_STATEMENT = (byte)83;
    private final byte[] m_portalOrPreparedStatementName;
    private final DescribeType m_type;

    public Describe(byte[] byArray, DescribeType describeType, ILogger iLogger) {
        this.m_portalOrPreparedStatementName = byArray;
        this.m_type = describeType;
    }

    @Override
    public void serialize(ByteBuffer byteBuffer, byte[] byArray) {
        byteBuffer.put((byte)68);
        byteBuffer.put(byArray);
        switch (this.m_type) {
            case PORTAL: {
                byteBuffer.put(DESCRIBE_TYPE_PORTAL);
                break;
            }
            case PREPARED_STATEMENT: {
                byteBuffer.put(DESCRIBE_TYPE_PREPARED_STATEMENT);
            }
        }
        if (null != this.m_portalOrPreparedStatementName) {
            byteBuffer.put(this.m_portalOrPreparedStatementName);
        }
        byteBuffer.put(TERMINATOR);
    }

    @Override
    public int getSize() {
        return 5 + (this.m_portalOrPreparedStatementName != null ? this.m_portalOrPreparedStatementName.length : 0) + 1;
    }

    public void logMessageContent(ILogger iLogger) {
        String string = this.m_type.name().toLowerCase();
        String string2 = null;
        if (null != this.m_portalOrPreparedStatementName) {
            string2 = new String(this.m_portalOrPreparedStatementName);
        }
        String string3 = "=>FE Describe(" + string + "=" + string2 + ")";
        LogUtilities.logTrace(string3, iLogger);
    }

    public static enum DescribeType {
        PORTAL,
        PREPARED_STATEMENT;

    }
}

