/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.inbound;

import com.amazon.jdbc.communications.interfaces.AbstractInboundMessage;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.client.messages.inbound.FieldDescription;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import java.nio.ByteBuffer;

public class RowDescription
extends AbstractInboundMessage
implements PGConstants {
    private final short m_numberOfFields;
    private final FieldDescription[] m_fieldDescriptions;

    public RowDescription(ByteBuffer byteBuffer, ILogger iLogger) {
        this.m_numberOfFields = byteBuffer.getShort();
        this.m_fieldDescriptions = new FieldDescription[this.m_numberOfFields];
        for (int i = 0; i < this.m_numberOfFields; ++i) {
            this.m_fieldDescriptions[i] = new FieldDescription(byteBuffer, iLogger);
        }
    }

    public int getNumberOfFields() {
        return this.m_numberOfFields;
    }

    public FieldDescription[] getFieldDescriptions() {
        return this.m_fieldDescriptions;
    }

    public void logMessageContent(ILogger iLogger) {
        String string = "<=BE RowDescription(" + this.getNumberOfFields() + ")";
        LogUtilities.logTrace(string, iLogger);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nRowDescription: getNumberOfFields - ");
        stringBuilder.append(this.getNumberOfFields());
        for (FieldDescription fieldDescription : this.m_fieldDescriptions) {
            stringBuilder.append(fieldDescription.toString());
        }
        return stringBuilder.toString();
    }
}

