/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.inbound;

import com.amazon.jdbc.communications.interfaces.AbstractInboundMessage;
import com.amazon.redshift.client.PGConstants;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import java.nio.ByteBuffer;

public class ReadyForQuery
extends AbstractInboundMessage
implements PGConstants {
    private static final char STATUS_IDLE = 'I';
    private static final char STATUS_TRANSACTION_BLOCK = 'T';
    private static final char STATUS_FAILED_TRANSACTION_BLOCK = 'E';
    private final char m_status;

    public ReadyForQuery(ByteBuffer byteBuffer, ILogger iLogger) {
        this.m_status = (char)byteBuffer.get();
    }

    public boolean isIdle() {
        return 'I' == this.m_status;
    }

    public boolean isTransactionBlock() {
        return 'T' == this.m_status;
    }

    public boolean isFailedTransactionBlock() {
        return 'E' == this.m_status;
    }

    public void logMessageContent(ILogger iLogger) {
        String string = "<=BE ReadyForQuery(" + this.m_status + ")";
        LogUtilities.logTrace(string, iLogger);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nReadyForQuery: isIdle - ");
        stringBuilder.append(this.isIdle());
        stringBuilder.append("\nisTransactionBlock - ");
        stringBuilder.append(this.isTransactionBlock());
        stringBuilder.append("\nisFailedTransactionBlock - ");
        stringBuilder.append(this.isFailedTransactionBlock());
        return stringBuilder.toString();
    }
}

