/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.inbound;

import com.amazon.jdbc.communications.interfaces.AbstractInboundMessage;
import com.amazon.redshift.client.PGConstants;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ParameterDescription
extends AbstractInboundMessage
implements PGConstants {
    private final short m_numOfParameters;
    private final int[] m_parameterDataTypeOIDs;

    public ParameterDescription(ByteBuffer byteBuffer, ILogger iLogger) {
        this.m_numOfParameters = byteBuffer.getShort();
        this.m_parameterDataTypeOIDs = new int[this.m_numOfParameters];
        for (int i = 0; i < this.m_numOfParameters; ++i) {
            this.m_parameterDataTypeOIDs[i] = byteBuffer.getInt();
        }
    }

    public short getNumParameters() {
        return this.m_numOfParameters;
    }

    public int[] getParameterDataTypeOIDs() {
        return this.m_parameterDataTypeOIDs;
    }

    public void logMessageContent(ILogger iLogger) {
        String string = "<=BE ParameterDescription(" + this.m_numOfParameters + ")";
        LogUtilities.logTrace(string, iLogger);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nParameterDescription: getFieldName - ");
        stringBuilder.append(this.m_numOfParameters);
        stringBuilder.append("\ngetParameterDataTypeOIDs- ");
        stringBuilder.append(Arrays.toString(this.getParameterDataTypeOIDs()));
        return stringBuilder.toString();
    }
}

