/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.inbound;

import com.amazon.jdbc.communications.interfaces.AbstractInboundMessage;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.PGConstants;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import java.nio.ByteBuffer;

public class KeyData
extends AbstractInboundMessage
implements PGConstants {
    private final byte[] m_processID = new byte[4];
    private final byte[] m_secretKey = new byte[4];

    public KeyData(ByteBuffer byteBuffer, ILogger iLogger) {
        byteBuffer.get(this.m_processID);
        byteBuffer.get(this.m_secretKey);
    }

    public byte[] getProcessID() {
        return this.m_processID;
    }

    public byte[] getSecretKey() {
        return this.m_secretKey;
    }

    public void logMessageContent(ILogger iLogger) {
        String string = new String(PGDataTypeUtilities.toHexString(this.getProcessID()));
        String string2 = new String(PGDataTypeUtilities.toHexString(this.getSecretKey()));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<=BE KeyData(pid=");
        stringBuilder.append(string);
        stringBuilder.append(",ckey=");
        stringBuilder.append(string2);
        stringBuilder.append(")");
        LogUtilities.logTrace(stringBuilder.toString(), iLogger);
    }

    public String toString() {
        String string = new String(PGDataTypeUtilities.toHexString(this.getProcessID()));
        String string2 = new String(PGDataTypeUtilities.toHexString(this.getSecretKey()));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nKeyData: getProcessID - ");
        stringBuilder.append(string);
        stringBuilder.append(", getSecretKey - ");
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }
}

