/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.inbound;

import com.amazon.jdbc.communications.interfaces.AbstractInboundMessage;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class CopyInResponse
extends AbstractInboundMessage {
    private boolean m_overallFormat;
    private short m_numOfColumns;
    private boolean[] m_columnFormat;

    public CopyInResponse(ByteBuffer byteBuffer, ILogger iLogger) {
        this.m_overallFormat = byteBuffer.get() != 0;
        this.m_numOfColumns = byteBuffer.getShort();
        this.m_columnFormat = new boolean[this.m_numOfColumns];
        for (int i = 0; i < this.m_numOfColumns; ++i) {
            this.m_columnFormat[i] = byteBuffer.getChar() != '\u0000';
        }
    }

    public boolean getOverallFormat() {
        return this.m_overallFormat;
    }

    public int getNumOfColumns() {
        return this.m_numOfColumns;
    }

    public boolean[] getColumnFormat() {
        return this.m_columnFormat;
    }

    public void logMessageContent(ILogger iLogger) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<=BE CopyInResponse (");
        stringBuilder.append(this.m_overallFormat);
        stringBuilder.append(",");
        stringBuilder.append(this.m_numOfColumns);
        stringBuilder.append(",");
        stringBuilder.append(Arrays.toString(this.m_columnFormat));
        stringBuilder.append(")");
        LogUtilities.logTrace(stringBuilder.toString(), iLogger);
    }
}

