/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.inbound;

import com.amazon.jdbc.communications.interfaces.AbstractInboundMessage;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.PGConstants;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import java.nio.ByteBuffer;

public class Authentication
extends AbstractInboundMessage
implements PGConstants {
    private final int m_authenticationResult;
    private final byte[] m_md5SaltKey;

    public Authentication(ByteBuffer byteBuffer, ILogger iLogger) {
        this.m_authenticationResult = byteBuffer.getInt();
        if (AuthenticationType.AUTHENTICATION_MD5_PASSWORD.m_id == this.m_authenticationResult) {
            this.m_md5SaltKey = new byte[4];
            byteBuffer.get(this.m_md5SaltKey);
        } else {
            this.m_md5SaltKey = null;
        }
    }

    public byte[] getMD5SaltKey() {
        return this.m_md5SaltKey;
    }

    public boolean isAuthenticationOK() {
        return AuthenticationType.AUTHENTICATION_OK.m_id == this.m_authenticationResult;
    }

    public boolean isKerberos5Required() {
        return AuthenticationType.AUTHENTICATION_KERBEROS_V5.m_id == this.m_authenticationResult;
    }

    public boolean isClearTextPasswordRequired() {
        return AuthenticationType.AUTHENTICATION_CLEARTEXT_PASSWORD.m_id == this.m_authenticationResult;
    }

    public boolean isMD5PasswordRequired() {
        return AuthenticationType.AUTHENTICATION_MD5_PASSWORD.m_id == this.m_authenticationResult;
    }

    public boolean isSCMCredentialsMessageRequired() {
        return AuthenticationType.AUTHENTICATION_SCM_CREDENTIAL.m_id == this.m_authenticationResult;
    }

    public boolean isGSSAPIAuthenticationRequired() {
        return AuthenticationType.AUTHENTICATION_GSS.m_id == this.m_authenticationResult;
    }

    public boolean isSSPIAuthenticationRequired() {
        return AuthenticationType.AUTHENTICATION_SSPI.m_id == this.m_authenticationResult;
    }

    public boolean isGSSContinue() {
        return AuthenticationType.AUTHENTICATION_GSS_CONTINUE.m_id == this.m_authenticationResult;
    }

    public void logMessageContent(ILogger iLogger) {
        String string = null;
        AuthenticationType authenticationType = AuthenticationType.getAuthenticationType(this.m_authenticationResult);
        switch (authenticationType) {
            case AUTHENTICATION_CLEARTEXT_PASSWORD: {
                string = "<=BE AuthenticationReqPassword";
                break;
            }
            case AUTHENTICATION_MD5_PASSWORD: {
                String string2 = new String(PGDataTypeUtilities.toHexString(this.m_md5SaltKey));
                string = "<=BE AuthenticationReqMD5(salt=" + string2 + ")";
                break;
            }
            case AUTHENTICATION_OK: {
                string = "<=BE AuthenticationOk";
                break;
            }
        }
        LogUtilities.logTrace(string, iLogger);
    }

    public String toString() {
        return "\nAuthentication: isAuthenticationOK - " + this.isAuthenticationOK() + "\nisKerberos5Required - " + this.isKerberos5Required() + "\nisClearTextPasswordRequired - " + this.isClearTextPasswordRequired() + "\nisMD5PasswordRequired - " + this.isMD5PasswordRequired() + "\nisSCMCredentialsMessageRequired - " + this.isSCMCredentialsMessageRequired() + "\nisGSSAPIAuthenticationRequired - " + this.isGSSAPIAuthenticationRequired() + "\nisSSPIAuthenticationRequired - " + this.isSSPIAuthenticationRequired() + "\nisGSSContinue - " + this.isGSSContinue();
    }

    private static enum AuthenticationType {
        AUTHENTICATION_OK(0),
        AUTHENTICATION_KERBEROS_V5(2),
        AUTHENTICATION_CLEARTEXT_PASSWORD(3),
        AUTHENTICATION_MD5_PASSWORD(5),
        AUTHENTICATION_SCM_CREDENTIAL(6),
        AUTHENTICATION_GSS(7),
        AUTHENTICATION_SSPI(9),
        AUTHENTICATION_GSS_CONTINUE(8);

        private int m_id;

        private AuthenticationType(int n2) {
            this.m_id = n2;
        }

        private int getId() {
            return this.m_id;
        }

        public static AuthenticationType getAuthenticationType(int n) {
            AuthenticationType authenticationType = null;
            boolean bl = false;
            AuthenticationType[] authenticationTypeArray = AuthenticationType.values();
            for (int i = 0; !bl && i < authenticationTypeArray.length; ++i) {
                if (authenticationTypeArray[i].getId() != n) continue;
                bl = true;
                authenticationType = authenticationTypeArray[i];
            }
            return authenticationType;
        }
    }
}

