/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client;

import com.amazon.dsi.dataengine.utilities.ParameterMetadata;
import com.amazon.jdbc.communications.InboundMessagesContainer;
import com.amazon.jdbc.communications.InboundMessagesPipeline;
import com.amazon.jdbc.communications.exceptions.InboundErrorMessage;
import com.amazon.jdbc.communications.interfaces.IInboundMessage;
import com.amazon.redshift.client.InboundDataHandler;
import com.amazon.redshift.client.PGClient;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.client.messages.inbound.Authentication;
import com.amazon.redshift.client.messages.inbound.BindComplete;
import com.amazon.redshift.client.messages.inbound.CloseComplete;
import com.amazon.redshift.client.messages.inbound.CommandComplete;
import com.amazon.redshift.client.messages.inbound.DataRow;
import com.amazon.redshift.client.messages.inbound.EmptyQueryResponse;
import com.amazon.redshift.client.messages.inbound.ErrorResponse;
import com.amazon.redshift.client.messages.inbound.NoData;
import com.amazon.redshift.client.messages.inbound.NoticeResponse;
import com.amazon.redshift.client.messages.inbound.ParameterDescription;
import com.amazon.redshift.client.messages.inbound.ParseComplete;
import com.amazon.redshift.client.messages.inbound.ReadyForQuery;
import com.amazon.redshift.client.messages.inbound.RowDescription;
import com.amazon.redshift.dataengine.metadata.ColumnsIsNullResultSet;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogLevel;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class PGMessagingContext
extends InboundMessagesPipeline
implements PGConstants {
    private CloseMode m_closeMode;
    private Authentication m_authentication;
    private RowDescription m_rowDescription;
    private boolean m_rowDescriptionPrepareExecute;
    private ParameterDescription m_parameterDescription;
    private NoData m_noData;
    private boolean m_noDataPrepareExecute;
    private EmptyQueryResponse m_emptyQueryResponse;
    private BindComplete m_bindComplete;
    public ParseComplete m_parseComplete;
    public ReadyForQuery m_readyForQueryFromPipelineForQuery;
    public ReadyForQuery m_readyForQueryFromPipelineForPrepare;
    public long m_dataRowCount;
    public CommandComplete m_commandCompleteFromPipeline;
    public boolean m_commandCompleteFromWire = false;
    public ErrorResponse m_errorResponse;
    public AtomicBoolean m_syncSent = new AtomicBoolean(false);
    public boolean m_closeCompleteFromPipeline = false;
    public boolean m_closeCompleteFromWire = false;
    public List<ParameterMetadata> m_parameterMetadata = null;
    public List<Integer> m_parameterOids = null;
    public short[] m_columnTypes = null;
    public AtomicBoolean m_isCanceled = new AtomicBoolean(false);
    public DataRow m_currentDataRow;
    private byte[] m_portalName;
    public byte[] m_serverStatementName;
    public boolean m_hasResults;
    public boolean m_isPreparedStatement;
    public boolean m_isPreparedStatementExecuted;
    private PGClient m_client;
    public int m_maxRow = 0;
    public int m_fetchSize = 0;
    protected ILogger m_log;
    private IWarningListener m_statementWarningListener;
    public ColumnsIsNullResultSet m_columnsIsNullResultSet;
    public String m_columnsIsNullResultSetQuery;
    public boolean m_multipleParameterSetsMode;
    public int m_batchCount;
    public boolean m_finalCommandInBatch = false;
    public int m_batchCommandCompleteToPipelineCount;
    public List<CommandComplete> m_multipleParameterSetsCommandComplete;
    public List<BindComplete> m_multipleParameterSetsBindComplete;

    private PGMessagingContext(PGClient pGClient, String string, int n, int n2, ILogger iLogger, IWarningListener iWarningListener, IWarningListener iWarningListener2) {
        super(n, iLogger, iWarningListener);
        this.m_log = iLogger;
        this.m_query = string;
        this.m_client = pGClient;
        this.m_parameterMetadata = new ArrayList<ParameterMetadata>();
        this.m_parameterOids = new ArrayList<Integer>();
        this.m_statementWarningListener = iWarningListener2;
        this.m_fetchSize = n;
        this.m_maxRow = n2;
        this.m_isPreparedStatement = false;
        this.m_isPreparedStatementExecuted = false;
        this.m_noDataPrepareExecute = false;
        this.m_rowDescriptionPrepareExecute = false;
        this.m_closeMode = CloseMode.ReadyForQuery;
        this.m_finalCommandInBatch = true;
        this.openCurrentOperation();
    }

    public static PGMessagingContext createStatementContext(PGClient pGClient, String string, int n, int n2, ILogger iLogger, IWarningListener iWarningListener, IWarningListener iWarningListener2) {
        return new PGMessagingContext(pGClient, string, n, n2, iLogger, iWarningListener, iWarningListener2);
    }

    public static PGMessagingContext createPreparedStatementContext(PGClient pGClient, String string, int n, int n2, ILogger iLogger, IWarningListener iWarningListener, IWarningListener iWarningListener2) throws ErrorException {
        PGMessagingContext pGMessagingContext = new PGMessagingContext(pGClient, string, n, n2, iLogger, iWarningListener, iWarningListener2);
        pGMessagingContext.m_isPreparedStatement = true;
        return pGMessagingContext;
    }

    private void initialize() {
        try {
            IInboundMessage iInboundMessage;
            while (null != this.m_currentMessagesContainer && this.m_currentMessagesContainer.hasNext()) {
                iInboundMessage = this.m_currentMessagesContainer.next(1);
                if (!this.m_log.isEnabled()) continue;
                LogUtilities.logDebug("Consume message from container: " + iInboundMessage.getClass().getSimpleName(), this.m_log);
            }
            if (this.m_nRowMode == 0) {
                while (this.m_messageContainersQueue.size() != 0) {
                    this.m_currentMessagesContainer = (InboundMessagesContainer)this.m_messageContainersQueue.poll();
                    while (null != this.m_currentMessagesContainer && this.m_currentMessagesContainer.hasNext()) {
                        iInboundMessage = this.m_currentMessagesContainer.next(1);
                        if (!this.m_log.isEnabled()) continue;
                        LogUtilities.logDebug("Consume message from container: " + iInboundMessage.getClass().getSimpleName(), this.m_log);
                    }
                }
            }
        }
        catch (ErrorException errorException) {
            LogUtilities.logDebug("Error while initializing PGMessagingContext, during old message consumption", this.m_log);
            LogUtilities.logDebug(errorException, this.m_log);
        }
        this.m_hasResults = false;
        this.m_isCanceled.set(false);
        this.m_multipleParameterSetsMode = false;
        this.m_multipleParameterSetsCommandComplete = null;
        this.m_multipleParameterSetsBindComplete = null;
        this.m_totalMessageCount = 0L;
        this.m_currentMessageCount = 0L;
        this.m_batchCount = 0;
        this.m_batchCommandCompleteToPipelineCount = 0;
        this.m_peekedMessage = null;
        this.m_dataRowCount = 0L;
        this.m_commandCompleteFromPipeline = null;
        this.m_commandCompleteFromWire = false;
        this.m_isPreparedStatementExecuted = false;
        this.m_readyForQueryFromPipelineForQuery = null;
        this.m_bindComplete = null;
        this.m_currentDataRow = null;
        this.m_emptyQueryResponse = null;
        this.m_closeCompleteFromPipeline = false;
        this.m_closeCompleteFromWire = false;
        this.m_noDataPrepareExecute = false;
        this.m_rowDescriptionPrepareExecute = false;
        if (!this.m_isPreparedStatement) {
            this.m_readyForQueryFromPipelineForPrepare = null;
            this.m_noData = null;
            this.m_rowDescription = null;
            this.m_parameterDescription = null;
        }
    }

    public void openCurrentOperation(int n, boolean bl) {
        this.initialize();
        this.m_maxRow = n;
        this.m_isPreparedStatementExecuted = bl;
        super.openCurrentOperation();
    }

    public void openCurrentOperationParameterSets(int n) {
        this.initialize();
        this.m_multipleParameterSetsMode = true;
        this.m_batchCount = n;
        this.m_multipleParameterSetsCommandComplete = new ArrayList<CommandComplete>(n);
        this.m_multipleParameterSetsBindComplete = new ArrayList<BindComplete>(n);
        this.m_isPreparedStatementExecuted = true;
        super.openCurrentOperation();
    }

    public void setFinalCommandInBatch(boolean bl) {
        this.m_finalCommandInBatch = bl;
    }

    public void setCloseMode(CloseMode closeMode) {
        this.m_closeMode = closeMode;
    }

    public PGClient getClient() {
        return this.m_client;
    }

    public CloseMode getCloseMode() {
        return this.m_closeMode;
    }

    @Override
    protected boolean handleMessage(IInboundMessage iInboundMessage) throws ErrorException {
        if (null != iInboundMessage) {
            if (iInboundMessage instanceof DataRow) {
                this.m_hasResults = true;
                this.m_currentDataRow = (DataRow)iInboundMessage;
            } else {
                if (iInboundMessage instanceof InboundErrorMessage) {
                    this.m_hasResults = true;
                    this.closeCurrentOperation();
                    this.m_client.sync();
                    throw (InboundErrorMessage)iInboundMessage;
                }
                if (iInboundMessage instanceof NoticeResponse) {
                    this.m_hasResults = true;
                    this.handleErrorResponse((NoticeResponse)iInboundMessage);
                } else if (iInboundMessage instanceof Authentication) {
                    this.m_hasResults = true;
                    this.m_authentication = (Authentication)iInboundMessage;
                } else if (iInboundMessage instanceof ErrorResponse) {
                    this.m_hasResults = true;
                    ErrorResponse errorResponse = (ErrorResponse)iInboundMessage;
                    if (errorResponse.getTranslateSeverity() != ErrorResponse.Severity.FATAL) {
                        this.m_errorResponse = errorResponse;
                    }
                    try {
                        this.handleErrorResponse(errorResponse);
                    }
                    finally {
                        this.closeCurrentOperation();
                    }
                } else if (iInboundMessage instanceof CommandComplete) {
                    this.m_hasResults = true;
                    if (this.m_multipleParameterSetsMode) {
                        this.m_multipleParameterSetsCommandComplete.add((CommandComplete)iInboundMessage);
                    } else {
                        this.m_commandCompleteFromPipeline = (CommandComplete)iInboundMessage;
                    }
                    this.evaluateClose(CloseMode.CommandComplete);
                } else if (iInboundMessage instanceof CloseComplete) {
                    this.m_hasResults = true;
                    this.m_closeCompleteFromPipeline = true;
                    this.evaluateClose(CloseMode.CloseComplete);
                } else if (iInboundMessage instanceof EmptyQueryResponse) {
                    this.m_hasResults = true;
                    this.m_emptyQueryResponse = (EmptyQueryResponse)iInboundMessage;
                    if (this.m_multipleParameterSetsMode) {
                        this.m_multipleParameterSetsCommandComplete.add((CommandComplete)iInboundMessage);
                    } else {
                        this.m_commandCompleteFromPipeline = (CommandComplete)iInboundMessage;
                    }
                    this.evaluateClose(CloseMode.CommandComplete);
                } else if (iInboundMessage instanceof ReadyForQuery) {
                    if (this.m_isPreparedStatement && null == this.m_readyForQueryFromPipelineForPrepare) {
                        this.m_readyForQueryFromPipelineForPrepare = (ReadyForQuery)iInboundMessage;
                    } else {
                        this.m_readyForQueryFromPipelineForQuery = (ReadyForQuery)iInboundMessage;
                    }
                    this.evaluateClose(CloseMode.ReadyForQuery);
                } else if (iInboundMessage instanceof BindComplete) {
                    BindComplete bindComplete = (BindComplete)iInboundMessage;
                    if (this.m_multipleParameterSetsMode) {
                        this.m_multipleParameterSetsBindComplete.add(bindComplete);
                    } else {
                        this.m_bindComplete = bindComplete;
                    }
                } else if (iInboundMessage instanceof RowDescription) {
                    if (this.m_isPreparedStatementExecuted && null != this.m_rowDescription) {
                        this.m_rowDescriptionPrepareExecute = true;
                    }
                    this.m_rowDescription = (RowDescription)iInboundMessage;
                } else if (iInboundMessage instanceof ParameterDescription) {
                    this.m_parameterDescription = (ParameterDescription)iInboundMessage;
                } else if (iInboundMessage instanceof NoData) {
                    if (this.m_isPreparedStatementExecuted && null != this.m_noData) {
                        this.m_noDataPrepareExecute = true;
                    }
                    this.m_noData = (NoData)iInboundMessage;
                } else if (iInboundMessage instanceof ParseComplete) {
                    this.m_parseComplete = (ParseComplete)iInboundMessage;
                }
            }
        }
        return true;
    }

    private void evaluateClose(CloseMode closeMode) {
        if (this.m_multipleParameterSetsMode && this.m_multipleParameterSetsCommandComplete.size() != this.m_batchCount) {
            return;
        }
        if (this.m_closeMode == closeMode) {
            this.closeCurrentOperation();
        }
    }

    private void handleErrorResponse(ErrorResponse errorResponse) throws ErrorException {
        if (this.m_log.isEnabled()) {
            LogUtilities.logDebug(errorResponse.toString(), this.m_log);
        }
        switch (errorResponse.getTranslateSeverity()) {
            case FATAL: 
            case PANIC: 
            case ERROR: {
                throw errorResponse.toErrorException();
            }
            case WARNING: {
                if (null != this.m_statementWarningListener) {
                    this.m_statementWarningListener.postWarning(errorResponse.toWarning());
                } else {
                    if (null != this.m_warningListener) {
                        this.m_warningListener.postWarning(errorResponse.toWarning());
                        break;
                    }
                    throw errorResponse.toErrorException();
                }
            }
            case DEBUG: 
            case INFO: 
            case LOG: 
            case NOTICE: {
                if (null != this.m_statementWarningListener) {
                    this.m_statementWarningListener.postWarning(errorResponse.toWarning());
                    break;
                }
                if (null == this.m_warningListener) break;
                this.m_warningListener.postWarning(errorResponse.toWarning());
            }
        }
    }

    public Authentication getAuthentication(int n) throws ErrorException {
        this.m_authentication = null;
        this.getNextMessageOfClass(Authentication.class, n);
        return this.m_authentication;
    }

    public boolean getRowDescriptionForPrepareExecute() throws ErrorException {
        this.moveThroughMetadataPrepareExecute();
        return this.m_rowDescriptionPrepareExecute;
    }

    public boolean getNoDataForPrepareExecute() throws ErrorException {
        this.moveThroughMetadataPrepareExecute();
        return this.m_noDataPrepareExecute;
    }

    private void moveThroughMetadataPrepareExecute() throws ErrorException {
        while (!this.m_noDataPrepareExecute && !this.m_rowDescriptionPrepareExecute && !this.m_close.get() && this.hasOpenOperation()) {
            if (this.doMoveToNextClass(null)) continue;
            LogUtilities.logFatal("PGMessagingContext.moveThroughMetadataPrepareExecute()", this.m_log);
        }
    }

    public RowDescription getRowDescription() throws ErrorException {
        this.moveThroughMetadata();
        return this.m_rowDescription;
    }

    public NoData getNoData() throws ErrorException {
        this.moveThroughMetadata();
        return this.m_noData;
    }

    private void moveThroughMetadata() throws ErrorException {
        while (null == this.m_noData && null == this.m_rowDescription && !this.m_close.get() && this.hasOpenOperation()) {
            if (this.doMoveToNextClass(null)) continue;
            LogUtilities.logFatal("PGMessagingContext.moveThroughMetadata()", this.m_log);
        }
    }

    public BindComplete getBindComplete() throws ErrorException {
        if (null == this.m_bindComplete && !this.doMoveToNextClass(BindComplete.class)) {
            LogUtilities.logFatal("PGMessagingContext.getParameterDescription()", this.m_log);
        }
        return this.m_bindComplete;
    }

    public ParameterDescription getParameterDescription() throws ErrorException {
        if (null == this.m_parameterDescription && !this.doMoveToNextClass(ParameterDescription.class)) {
            LogUtilities.logFatal("PGMessagingContext.getParameterDescription()", this.m_log);
        }
        return this.m_parameterDescription;
    }

    public List<ParameterMetadata> getParameterMetadata() {
        return this.m_parameterMetadata;
    }

    public boolean doMoveToNextRow() throws ErrorException {
        return this.doMoveToNextClass(DataRow.class);
    }

    public CommandComplete getCommandCompleteMessage() throws ErrorException {
        if (null == this.m_commandCompleteFromPipeline && !this.doMoveToNextClass(CommandComplete.class)) {
            LogUtilities.logFatal("PGMessagingContext.getCommandCompleteMessage()", this.m_log);
        }
        return this.m_commandCompleteFromPipeline;
    }

    public boolean getErrorResponse() throws ErrorException {
        return this.doMoveToNextClass(ErrorResponse.class);
    }

    public boolean getReadyForQuery() throws ErrorException {
        return this.doMoveToNextClass(ReadyForQuery.class);
    }

    public boolean doMoveToNextClass(Class clazz) throws ErrorException {
        do {
            if (!this.getNextMessageOfClass(clazz, 0)) continue;
            return true;
        } while (this.hasOpenOperation() && !this.m_close.get());
        return false;
    }

    public void setPortalName(byte[] byArray) {
        this.m_portalName = byArray;
    }

    public void checkErrorResponse(int n) throws ErrorException {
        this.getNextMessageOfClass(ErrorResponse.class, n);
    }

    public void clearPortalName() {
        this.m_portalName = null;
    }

    public byte[] getPortalName() {
        return this.m_portalName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeOperation() {
        try {
            InboundDataHandler inboundDataHandler = this.m_client.getInboundDataHandler();
            synchronized (inboundDataHandler) {
                if (null != this.m_client.getInboundDataHandler().getCancelledQuery()) {
                    if (this.m_log.getLogLevel().equals((Object)LogLevel.TRACE) || this.m_log.getLogLevel().equals((Object)LogLevel.DEBUG)) {
                        LogUtilities.logDebug("Query was cancelled. Close operation.", this.m_log);
                    }
                    if (0L < this.m_dataRowCount) {
                        this.getReadyForQuery();
                        this.m_client.getInboundDataHandler().setCancelledQuery(null);
                    } else {
                        this.m_client.getInboundDataHandler().setCancelledQuery(null);
                        this.closeCurrentOperation();
                    }
                    return;
                }
            }
            if (this.m_isCanceled.get()) {
                if (this.m_log.getLogLevel().equals((Object)LogLevel.TRACE) || this.m_log.getLogLevel().equals((Object)LogLevel.DEBUG)) {
                    LogUtilities.logDebug("Query was cancelled. Close operation.", this.m_log);
                }
                if (0L < this.m_dataRowCount) {
                    this.getReadyForQuery();
                } else {
                    this.closeCurrentOperation();
                }
                return;
            }
            if (null != this.m_client.m_fatalException) {
                LogUtilities.logDebug("Fatal Exception: Connection was lost. Close operation.", this.m_log);
                this.closeCurrentOperation();
            } else if (null == this.m_readyForQueryFromPipelineForQuery) {
                this.getReadyForQuery();
            }
        }
        catch (ErrorException errorException) {
            LogUtilities.logFatal(errorException, this.m_log);
        }
    }

    @Override
    public IInboundMessage peekNextMessage(int n) throws ErrorException {
        boolean bl;
        if (null != this.m_peekedMessage) {
            return this.m_peekedMessage;
        }
        if (!this.m_close.get() && (bl = this.validateCurrentContainer())) {
            this.m_peekedMessage = this.m_currentMessagesContainer.next(n);
            if (null != this.m_peekedMessage) {
                return this.m_peekedMessage;
            }
        }
        if (this.m_isCanceled.get()) {
            return null;
        }
        while (!this.m_close.get()) {
            bl = this.validateCurrentContainer();
            if (!bl && !this.m_close.get() && this.m_log.isEnabled()) {
                LogUtilities.logDebug("Possible hanging for query " + this.m_query, this.m_log);
            }
            if (!bl) continue;
            this.m_peekedMessage = this.m_currentMessagesContainer.next(n);
            if (null != this.m_peekedMessage) {
                return this.m_peekedMessage;
            }
            if (n <= 0) continue;
            return null;
        }
        return null;
    }

    static enum CloseMode {
        CommandComplete,
        CloseComplete,
        ReadyForQuery;

    }
}

