/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client;

import com.amazon.antlr4.sql.escaper.ProcessedStatement;
import com.amazon.exceptions.JDBCMessageKey;
import com.amazon.jdbc.communications.InboundMessagesThread;
import com.amazon.jdbc.communications.exceptions.InboundErrorMessage;
import com.amazon.jdbc.communications.interfaces.AbstractOutboundMessage;
import com.amazon.jdbc.communications.interfaces.IInboundMessage;
import com.amazon.jdbc.communications.interfaces.SocketCloseListener;
import com.amazon.redshift.AuthMech;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.FilterUtilities;
import com.amazon.redshift.client.InboundDataHandler;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.client.messages.inbound.Authentication;
import com.amazon.redshift.client.messages.inbound.CommandComplete;
import com.amazon.redshift.client.messages.inbound.ErrorResponse;
import com.amazon.redshift.client.messages.inbound.FieldDescription;
import com.amazon.redshift.client.messages.inbound.KeyData;
import com.amazon.redshift.client.messages.inbound.ParameterDescription;
import com.amazon.redshift.client.messages.inbound.RowDescription;
import com.amazon.redshift.client.messages.outbound.Bind;
import com.amazon.redshift.client.messages.outbound.CancelRequest;
import com.amazon.redshift.client.messages.outbound.Close;
import com.amazon.redshift.client.messages.outbound.Describe;
import com.amazon.redshift.client.messages.outbound.Execute;
import com.amazon.redshift.client.messages.outbound.Flush;
import com.amazon.redshift.client.messages.outbound.Parse;
import com.amazon.redshift.client.messages.outbound.PasswordMessage;
import com.amazon.redshift.client.messages.outbound.Query;
import com.amazon.redshift.client.messages.outbound.SSLRequest;
import com.amazon.redshift.client.messages.outbound.Startup;
import com.amazon.redshift.client.messages.outbound.Sync;
import com.amazon.redshift.client.messages.outbound.Terminate;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.core.PGJDBCSettings;
import com.amazon.redshift.dataengine.PGCatalogQueryBuilder;
import com.amazon.redshift.dataengine.metadata.ColumnsIsNullResultSet;
import com.amazon.redshift.dataengine.metadata.PGParameterMetadata;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.redshift.ssl.NonValidatingFactory;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogLevel;
import com.amazon.support.LogUtilities;
import com.amazon.support.Warning;
import com.amazon.support.WarningCode;
import com.amazon.support.channels.AbstractSocketChannel;
import com.amazon.support.channels.HostNameValidator;
import com.amazon.support.channels.PlainSocketChannel;
import com.amazon.support.channels.TLSSocketChannel;
import com.amazon.support.exceptions.ErrorException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalSelectorException;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class PGClient
implements SocketCloseListener,
PGConstants {
    private static final String DATASHARE_ENABLED = "datashare_enabled";
    private static final String IS_VALID_TEST_QUERY = " ";
    private static final String SYNTHETIC_PREPARED_STATEMENT_NAME_SEED = "PGJDBCSTMT";
    private static final String SYNTHETIC_PORTAL_NAME_SEED = "PGJDBCPRTL";
    private static final String TRUSTSTORE_PROPERTY = "javax.net.ssl.trustStore";
    private static final String TRUSTSTORE_PWD_PROPERTY = "javax.net.ssl.trustStorePassword";
    private static final int WRITE_BUFFER_CAPACITY = 64000;
    private static final int WRITE_RETRY_DELAY_MS = 10;
    Selector m_selector;
    Selector m_cancelSelector;
    private ILogger m_log;
    private InboundMessagesThread m_backgroundFetcher;
    private final PGJDBCSettings m_settings;
    private AbstractSocketChannel m_socketChannel;
    private IWarningListener m_connectionWarningListener;
    private InboundDataHandler m_dataHandler;
    private final KeyData m_keyData;
    private final AbstractOutboundMessage[] m_oneMessage = new AbstractOutboundMessage[1];
    private final AbstractOutboundMessage[] m_threeMessages = new AbstractOutboundMessage[3];
    private final AbstractOutboundMessage[] m_fourMessages = new AbstractOutboundMessage[4];
    private final AbstractOutboundMessage[] m_fiveMessages = new AbstractOutboundMessage[5];
    private final AbstractOutboundMessage[] m_sixMessages = new AbstractOutboundMessage[6];
    private final AbstractOutboundMessage[] m_sevenMessages = new AbstractOutboundMessage[7];
    private final AbstractOutboundMessage[] m_flushSync = new AbstractOutboundMessage[2];
    public static final int MAX_CACHED_FORMAT_CODE_ARRAYS = 30;
    public short[][] m_cachedBinaryFormatCodes = new short[30][];
    public short[][] m_cachedTextFormatCodes = new short[30][];
    public ErrorException m_fatalException = null;
    private final Flush m_flush;
    private final Sync m_sync;
    private ByteBuffer m_writeBuffer;
    private boolean m_connectionAutoCommit = true;
    private boolean m_datashareEnabled = false;

    public PGClient(PGJDBCSettings pGJDBCSettings, ILogger iLogger, IWarningListener iWarningListener) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        try {
            boolean bl = false;
            this.m_settings = pGJDBCSettings;
            this.m_connectionWarningListener = iWarningListener;
            this.m_log = iLogger;
            this.m_flush = new Flush(this.m_log);
            this.m_sync = new Sync(this.m_log);
            this.m_flushSync[0] = this.m_flush;
            this.m_flushSync[1] = this.m_sync;
            this.m_writeBuffer = ByteBuffer.allocateDirect(64000);
            this.m_dataHandler = new InboundDataHandler(this.m_log, pGJDBCSettings.m_nRowMode, FilterUtilities.translateLevel(pGJDBCSettings.m_filterLevel));
            this.m_socketChannel = this.connect(this.m_dataHandler, bl);
            switch (pGJDBCSettings.m_authMech) {
                case DISABLE: {
                    try {
                        this.startSession();
                        break;
                    }
                    catch (ErrorException errorException) {
                        ErrorException errorException2;
                        if (null != this.m_fatalException) {
                            errorException2 = this.m_fatalException;
                        }
                        throw errorException2;
                    }
                }
                case ALLOW: {
                    try {
                        this.startSession();
                        break;
                    }
                    catch (ErrorException errorException) {
                        this.closeSession();
                        try {
                            this.m_socketChannel = this.connect(this.m_dataHandler, bl);
                            this.m_socketChannel = this.checkSSL(this.m_socketChannel);
                            this.startSession();
                            break;
                        }
                        catch (ErrorException errorException3) {
                            ErrorException errorException4;
                            if (null != this.m_fatalException) {
                                errorException4 = this.m_fatalException;
                            }
                            throw errorException4;
                        }
                    }
                }
                case PREFER: {
                    try {
                        this.m_socketChannel = this.checkSSL(this.m_socketChannel);
                        this.startSession();
                        break;
                    }
                    catch (ErrorException errorException) {
                        this.closeSession();
                        try {
                            this.m_socketChannel = this.connect(this.m_dataHandler, bl);
                            this.startSession();
                            break;
                        }
                        catch (ErrorException errorException5) {
                            ErrorException errorException6;
                            if (null != this.m_fatalException) {
                                errorException6 = this.m_fatalException;
                            }
                            throw errorException6;
                        }
                    }
                }
                case REQUIRE: 
                case VERIFY_CA: 
                case VERIFY_FULL: {
                    try {
                        this.m_socketChannel = this.checkSSL(this.m_socketChannel);
                        this.startSession();
                        break;
                    }
                    catch (ErrorException errorException) {
                        ErrorException errorException7;
                        if (null != this.m_fatalException) {
                            errorException7 = this.m_fatalException;
                        }
                        throw errorException7;
                    }
                }
            }
            this.m_keyData = this.m_dataHandler.m_keyData;
            String string = this.m_dataHandler.getParameterValue(DATASHARE_ENABLED);
            if (null != string) {
                this.m_datashareEnabled = string.equalsIgnoreCase("on");
            }
        }
        catch (ErrorException errorException) {
            LogUtilities.logFatal(errorException, this.m_log);
            this.closeSession();
            throw errorException;
        }
    }

    protected AbstractSocketChannel connect(InboundDataHandler inboundDataHandler, boolean bl) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        boolean bl2 = false;
        AbstractSocketChannel abstractSocketChannel = null;
        try {
            if (null != this.m_keyData) {
                this.m_dataHandler.m_keyData = this.m_keyData;
            }
            SelectorProvider selectorProvider = this.getSelectorProvider();
            abstractSocketChannel = new PlainSocketChannel(selectorProvider.openSocketChannel(), inboundDataHandler, this.m_log);
            if (bl) {
                this.m_cancelSelector = selectorProvider.openSelector();
            } else {
                this.m_selector = selectorProvider.openSelector();
            }
            abstractSocketChannel.getSocketChannel().configureBlocking(true);
            abstractSocketChannel.getSocketChannel().socket().connect(new InetSocketAddress(this.m_settings.m_host, this.m_settings.m_port), this.m_settings.m_loginTimeoutMS);
            abstractSocketChannel.getSocketChannel().socket().setKeepAlive(false);
            if (0 < this.m_settings.m_newTCPConnectionKeepAliveMinutes) {
                abstractSocketChannel.getSocketChannel().socket().setKeepAlive(true);
            }
            bl2 = true;
            AbstractSocketChannel abstractSocketChannel2 = abstractSocketChannel;
            return abstractSocketChannel2;
        }
        catch (IOException iOException) {
            if (this.m_log.isEnabled()) {
                LogUtilities.logDebug(iOException, this.m_log);
            }
            this.closeSession();
            String string = iOException.getLocalizedMessage();
            if (null == string) {
                string = iOException.getClass().getSimpleName();
            }
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), string);
            errorException.initCause(iOException);
            throw errorException;
        }
        finally {
            if (!bl2 && null != abstractSocketChannel && abstractSocketChannel.getSocketChannel().isOpen()) {
                LogUtilities.logDebug("Closing socket channel", this.m_log);
                abstractSocketChannel.close();
                abstractSocketChannel = null;
            }
        }
    }

    private SelectorProvider getSelectorProvider() throws IOException, ErrorException {
        if (null != this.m_settings.m_selectorProvider) {
            try {
                Class<SelectorProvider> clazz = Class.forName(this.m_settings.m_selectorProvider).asSubclass(SelectorProvider.class);
                SelectorProvider selectorProvider = null == this.m_settings.m_selectorProviderArg ? clazz.getConstructor(new Class[0]).newInstance(new Object[0]) : clazz.getConstructor(String.class).newInstance(this.m_settings.m_selectorProviderArg);
                return selectorProvider;
            }
            catch (ClassNotFoundException classNotFoundException) {
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_INVALID_SELECTOR_PROVIDER_CLASS.name(), this.m_settings.m_selectorProvider, (Throwable)classNotFoundException);
                LogUtilities.logError(errorException, this.m_log);
                throw errorException;
            }
            catch (InstantiationException instantiationException) {
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_INVALID_SELECTOR_PROVIDER_CLASS.name(), this.m_settings.m_selectorProvider, (Throwable)instantiationException);
                LogUtilities.logError(errorException, this.m_log);
                throw errorException;
            }
            catch (IllegalAccessException illegalAccessException) {
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_INVALID_SELECTOR_PROVIDER_CLASS.name(), this.m_settings.m_selectorProvider, (Throwable)illegalAccessException);
                LogUtilities.logError(errorException, this.m_log);
                throw errorException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_INVALID_SELECTOR_PROVIDER_CLASS.name(), this.m_settings.m_selectorProvider, (Throwable)illegalArgumentException);
                LogUtilities.logError(errorException, this.m_log);
                throw errorException;
            }
            catch (InvocationTargetException invocationTargetException) {
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_INVALID_SELECTOR_PROVIDER_CLASS.name(), this.m_settings.m_selectorProvider, (Throwable)invocationTargetException);
                LogUtilities.logError(errorException, this.m_log);
                throw errorException;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_INVALID_SELECTOR_PROVIDER_CLASS.name(), this.m_settings.m_selectorProvider, (Throwable)noSuchMethodException);
                LogUtilities.logError(errorException, this.m_log);
                throw errorException;
            }
            catch (SecurityException securityException) {
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_INVALID_SELECTOR_PROVIDER_CLASS.name(), this.m_settings.m_selectorProvider, (Throwable)securityException);
                LogUtilities.logError(errorException, this.m_log);
                throw errorException;
            }
        }
        return SelectorProvider.provider();
    }

    protected void startSession() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        try {
            this.m_socketChannel.getSocketChannel().configureBlocking(false);
            this.m_socketChannel.getSocketChannel().register(this.m_selector, 1);
        }
        catch (IllegalSelectorException illegalSelectorException) {
            LogUtilities.logFatal(illegalSelectorException, this.m_log);
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), illegalSelectorException.getMessage(), (Throwable)illegalSelectorException);
        }
        catch (ClosedChannelException closedChannelException) {
            LogUtilities.logFatal(closedChannelException, this.m_log);
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), closedChannelException.getMessage(), (Throwable)closedChannelException);
        }
        catch (IOException iOException) {
            LogUtilities.logFatal(iOException, this.m_log);
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), iOException.getMessage(), (Throwable)iOException);
        }
        this.m_oneMessage[0] = null != this.m_settings.m_credentialsProvider && !this.m_settings.m_credentialsProvider.isEmpty() ? new Startup(this.m_settings.m_username, this.m_settings.m_Schema, this.m_settings.m_credentialsProvider, this.m_log) : new Startup(this.m_settings.m_username, this.m_settings.m_Schema, "none", this.m_log);
        PGMessagingContext pGMessagingContext = PGMessagingContext.createStatementContext(this, "start", 0, 0, this.m_log, null, null);
        pGMessagingContext.openCurrentOperation();
        this.write(pGMessagingContext, this.m_oneMessage);
        this.m_backgroundFetcher = new InboundMessagesThread(this.m_selector, this.m_socketChannel, this.m_dataHandler, this.m_settings.m_newTCPConnectionKeepAliveMinutes, this.m_settings.m_host, this.m_settings.m_port, this.m_settings.m_socketTimeoutMS, this.m_log);
        this.m_backgroundFetcher.start();
        this.m_backgroundFetcher.addSocketCloseListener(this);
        for (int i = 0; i < 2; ++i) {
            Authentication authentication = null;
            authentication = pGMessagingContext.getAuthentication(this.m_settings.m_loginTimeoutMS);
            if (null == authentication) {
                LogUtilities.logFatal("Timeout waiting for respons to startup message.", this.m_log);
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_TIMEOUT_ERR.name());
            }
            if (authentication.isAuthenticationOK()) {
                if (this.m_log.isEnabled()) {
                    LogUtilities.logDebug("Authentication is OK", this.m_log);
                }
                pGMessagingContext.checkErrorResponse(this.m_settings.m_loginTimeoutMS);
                if (null == this.m_fatalException) break;
                throw this.m_fatalException;
            }
            if (authentication.isClearTextPasswordRequired()) {
                if (null != this.m_settings.m_password) {
                    if (this.m_log.isEnabled()) {
                        LogUtilities.logDebug("Sending cleartext password", this.m_log);
                    }
                    this.m_oneMessage[0] = new PasswordMessage(this.m_settings.m_password, this.m_log);
                    this.write((PGMessagingContext)null, this.m_oneMessage);
                    continue;
                }
                if (this.m_log.isEnabled()) {
                    LogUtilities.logDebug("Password required", this.m_log);
                }
                this.closeBackgroundThread();
                this.closeSocket();
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.INVALID_LOGIN.name(), "Password required");
            }
            if (authentication.isMD5PasswordRequired()) {
                if (null != this.m_settings.m_password) {
                    if (this.m_log.isEnabled()) {
                        LogUtilities.logDebug("Sending MD5 password", this.m_log);
                    }
                    try {
                        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                        messageDigest.update(PGDataTypeUtilities.toUTF8ByteArray(this.m_settings.m_password + this.m_settings.m_username));
                        byte[] byArray = PGDataTypeUtilities.toHexString(messageDigest.digest());
                        messageDigest.update(byArray, 0, byArray.length);
                        messageDigest.update(authentication.getMD5SaltKey());
                        String string = PGDataTypeUtilities.toUTF8String(PGDataTypeUtilities.toHexString(messageDigest.digest()));
                        this.m_oneMessage[0] = new PasswordMessage("md5" + string, this.m_log);
                        this.write((PGMessagingContext)null, this.m_oneMessage);
                        continue;
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        LogUtilities.logFatal(noSuchAlgorithmException, this.m_log);
                        throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_AUTH_MECH_UNSUPPORTED.name(), authentication.toString());
                    }
                }
                if (this.m_log.isEnabled()) {
                    LogUtilities.logDebug("Password required", this.m_log);
                }
                this.closeBackgroundThread();
                this.closeSocket();
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.INVALID_LOGIN.name(), "Password required");
            }
            if (this.m_log.isEnabled()) {
                LogUtilities.logDebug("Authentication mechanism not supported: " + authentication.toString(), this.m_log);
            }
            this.closeBackgroundThread();
            this.closeSocket();
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_AUTH_MECH_UNSUPPORTED.name(), authentication.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelQuery(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, string);
        InboundDataHandler inboundDataHandler = this.m_dataHandler;
        synchronized (inboundDataHandler) {
            this.m_dataHandler.setCancelledQuery(string);
        }
        this.cancelQuery();
    }

    public void cancelQuery() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        try {
            CancelRequest cancelRequest = new CancelRequest(this.m_keyData, this.m_log);
            InboundDataHandler inboundDataHandler = new InboundDataHandler(this.m_log, this.m_settings.m_nRowMode, FilterUtilities.translateLevel(this.m_settings.m_filterLevel));
            AbstractSocketChannel abstractSocketChannel = this.connect(inboundDataHandler, true);
            if (this.m_socketChannel instanceof TLSSocketChannel) {
                abstractSocketChannel = this.checkSSL(abstractSocketChannel);
            }
            AbstractOutboundMessage[] abstractOutboundMessageArray = new AbstractOutboundMessage[]{cancelRequest};
            this.write(abstractSocketChannel, null, null, abstractOutboundMessageArray);
            try {
                abstractSocketChannel.read();
            }
            catch (Exception exception) {
                LogUtilities.logInfo(exception, this.m_log);
            }
            LogUtilities.logInfo("m_cancelSelector.close()", this.m_log);
            this.m_cancelSelector.close();
            this.m_cancelSelector = null;
            abstractSocketChannel.close();
        }
        catch (Exception exception) {
            if (this.m_log.isEnabled()) {
                LogUtilities.logDebug(exception, this.m_log);
            }
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_GENERAL_ERR.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
    }

    @Override
    public void socketClosed(ErrorException errorException) {
        LogUtilities.logFunctionEntrance(this.m_log, errorException);
        if (null != errorException) {
            this.m_fatalException = errorException;
        }
        this.closeSocket();
        this.m_selector = null;
    }

    public void closeSession() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null == this.m_socketChannel || !this.m_socketChannel.getSocketChannel().isConnected()) {
            if (this.m_log.isEnabled()) {
                LogUtilities.logDebug("Channel is not connected.", this.m_log);
            }
        } else if (null != this.m_socketChannel && this.m_socketChannel.getSocketChannel().isConnected()) {
            AbstractOutboundMessage[] abstractOutboundMessageArray = new AbstractOutboundMessage[]{new Terminate(this.m_log)};
            if (this.m_log.isEnabled()) {
                LogUtilities.logDebug("Sending terminate message", this.m_log);
            }
            try {
                this.write(PGMessagingContext.createStatementContext(this, "terminate", this.m_settings.m_nRowMode, 0, this.m_log, null, null), abstractOutboundMessageArray);
            }
            catch (ErrorException errorException) {
                // empty catch block
            }
        }
        this.closeBackgroundThread();
        this.closeSocket();
    }

    public void closeSocket() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_socketChannel && this.m_socketChannel.getSocketChannel().isOpen()) {
            LogUtilities.logDebug("Closing socket channel", this.m_log);
            this.m_socketChannel.close();
            this.m_socketChannel = null;
        }
    }

    public void closeBackgroundThread() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_backgroundFetcher) {
            LogUtilities.logDebug("Closing background thread", this.m_log);
            this.m_backgroundFetcher.close(null);
        }
        if (null != this.m_selector && this.m_selector.isOpen()) {
            try {
                this.m_selector.close();
                this.m_selector = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBlockingRowsMode(int n, boolean bl) {
        StringBuilder stringBuilder = null;
        boolean bl2 = false;
        if (LogLevel.TRACE == this.m_log.getLogLevel()) {
            bl2 = true;
            stringBuilder = new StringBuilder();
            stringBuilder.append("getBlockingRowsMode(");
            stringBuilder.append(n);
            stringBuilder.append(", ");
            stringBuilder.append(bl);
            stringBuilder.append(")");
            stringBuilder.append("=");
        }
        try {
            if (bl) {
                int n2 = 0;
                return n2;
            }
            if (0 == n && 0 == this.m_settings.m_nRowMode) {
                if (bl2) {
                    stringBuilder.append(0);
                }
                int n3 = 0;
                return n3;
            }
            if (n == this.m_settings.m_nRowMode) {
                if (bl2) {
                    stringBuilder.append("m_settings.m_nRowMode=");
                    stringBuilder.append(this.m_settings.m_nRowMode);
                }
                int n4 = this.m_settings.m_nRowMode;
                return n4;
            }
            if (n > 0) {
                if (n >= 5) {
                    if (bl2) {
                        stringBuilder.append("BRMvalueInConnStr=");
                        stringBuilder.append(this.m_settings.m_nRowMode);
                    }
                    int n5 = n;
                    return n5;
                }
                if (bl2) {
                    stringBuilder.append("PGConstants.MIN_BLOCKING_ROWS_MODE=");
                    stringBuilder.append(5);
                }
                int n6 = 5;
                return n6;
            }
            if (bl2) {
                stringBuilder.append("m_settings.m_nRowMode=");
                stringBuilder.append(this.m_settings.m_nRowMode);
            }
            int n7 = this.m_settings.m_nRowMode;
            return n7;
        }
        finally {
            if (bl2) {
                LogUtilities.logDebug(stringBuilder.toString(), this.m_log);
            }
        }
    }

    public PGMessagingContext directExecute(String string, boolean bl, int n, int n2, IWarningListener iWarningListener, boolean bl2) throws ErrorException {
        return this.directExecute(string, bl, n, n2, iWarningListener, bl2, 0);
    }

    public PGMessagingContext directExecute(String string, boolean bl, int n, int n2, IWarningListener iWarningListener, boolean bl2, int n3) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, string);
        int n4 = this.getBlockingRowsMode(n, bl ? bl : bl2);
        if (this.isConnected()) {
            try {
                PGMessagingContext pGMessagingContext = PGMessagingContext.createStatementContext(this, string, n4, 0, this.m_log, this.m_connectionWarningListener, iWarningListener);
                if (!bl && n2 > 0) {
                    pGMessagingContext.clearPortalName();
                    byte[] byArray = this.generateSynthteticPortalName(0);
                    this.m_sevenMessages[0] = new Parse(null, string, null, this.m_log);
                    this.m_sevenMessages[1] = new Bind(byArray, null, null, null, null, this.m_log);
                    this.m_sevenMessages[2] = new Describe(byArray, Describe.DescribeType.PORTAL, this.m_log);
                    this.m_sevenMessages[3] = new Execute(byArray, n2, this.m_log);
                    this.m_sevenMessages[4] = new Close(byArray, Close.CloseType.PORTAL, this.m_log);
                    this.m_sevenMessages[5] = this.m_flush;
                    this.m_sevenMessages[6] = this.m_sync;
                    this.write(pGMessagingContext, this.m_sevenMessages);
                } else {
                    this.m_sixMessages[0] = new Parse(null, string, null, this.m_log);
                    this.m_sixMessages[1] = new Bind(null, null, null, null, null, this.m_log);
                    this.m_sixMessages[2] = new Describe(null, Describe.DescribeType.PORTAL, this.m_log);
                    this.m_sixMessages[3] = new Execute(null, 0, this.m_log);
                    this.m_sixMessages[4] = this.m_flush;
                    this.m_sixMessages[5] = this.m_sync;
                    this.write(pGMessagingContext, this.m_sixMessages);
                }
                this.handleErrors(pGMessagingContext);
                return pGMessagingContext;
            }
            catch (Exception exception) {
                throw this.buildError(exception);
            }
        }
        LogUtilities.logFatal("Not Connected", this.m_log);
        throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
    }

    public PGMessagingContext directExecuteWithMessage(PGMessagingContext pGMessagingContext, boolean bl, int n, int n2, IWarningListener iWarningListener, boolean bl2, int n3) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, pGMessagingContext.m_query);
        if (this.isConnected()) {
            try {
                if (!bl && n2 > 0) {
                    pGMessagingContext.clearPortalName();
                    byte[] byArray = this.generateSynthteticPortalName(0);
                    this.m_sevenMessages[0] = new Parse(null, pGMessagingContext.m_query, null, this.m_log);
                    this.m_sevenMessages[1] = new Bind(byArray, null, null, null, null, this.m_log);
                    this.m_sevenMessages[2] = new Describe(byArray, Describe.DescribeType.PORTAL, this.m_log);
                    this.m_sevenMessages[3] = new Execute(byArray, n2, this.m_log);
                    this.m_sevenMessages[4] = new Close(byArray, Close.CloseType.PORTAL, this.m_log);
                    this.m_sevenMessages[5] = this.m_flush;
                    this.m_sevenMessages[6] = this.m_sync;
                    this.write(pGMessagingContext, this.m_sevenMessages);
                } else {
                    this.m_sixMessages[0] = new Parse(null, pGMessagingContext.m_query, null, this.m_log);
                    this.m_sixMessages[1] = new Bind(null, null, null, null, null, this.m_log);
                    this.m_sixMessages[2] = new Describe(null, Describe.DescribeType.PORTAL, this.m_log);
                    this.m_sixMessages[3] = new Execute(null, 0, this.m_log);
                    this.m_sixMessages[4] = this.m_flush;
                    this.m_sixMessages[5] = this.m_sync;
                    this.write(pGMessagingContext, this.m_sixMessages);
                }
                return pGMessagingContext;
            }
            catch (Exception exception) {
                throw this.buildError(exception);
            }
        }
        LogUtilities.logFatal("Not Connected", this.m_log);
        throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
    }

    public PGMessagingContext directExecuteExtraMetadata(String string, int n, int n2, IWarningListener iWarningListener, boolean bl) throws ErrorException {
        return this.directExecuteExtraMetadata(string, n, n2, iWarningListener, bl, 0);
    }

    public PGMessagingContext directExecuteExtraMetadata(String string, int n, int n2, IWarningListener iWarningListener, boolean bl, int n3) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, string);
        if (this.isConnected()) {
            try {
                PGMessagingContext pGMessagingContext;
                int n4 = this.getBlockingRowsMode(n, bl);
                if (0 != n4) {
                    PGMessagingContext pGMessagingContext2 = PGMessagingContext.createStatementContext(this, string, 0, 0, this.m_log, this.m_connectionWarningListener, iWarningListener);
                    this.m_fiveMessages[0] = new Parse(null, string, null, this.m_log);
                    this.m_fiveMessages[1] = new Bind(null, null, null, null, null, this.m_log);
                    this.m_fiveMessages[2] = new Describe(null, Describe.DescribeType.PORTAL, this.m_log);
                    this.m_fiveMessages[3] = this.m_flush;
                    this.m_fiveMessages[4] = this.m_sync;
                    this.write(pGMessagingContext2, this.m_fiveMessages);
                    this.handleErrors(pGMessagingContext2);
                    ColumnsIsNullResultSet columnsIsNullResultSet = this.createColumnsIsNullResultSet(pGMessagingContext2);
                    pGMessagingContext2.close();
                    pGMessagingContext = this.directExecute(string, null != pGMessagingContext2.getNoData(), n, n2, iWarningListener, bl, n3);
                    pGMessagingContext.m_columnsIsNullResultSet = columnsIsNullResultSet;
                } else {
                    pGMessagingContext = this.directExecute(string, false, n, n2, iWarningListener, bl, n3);
                    if (null == pGMessagingContext.getNoData()) {
                        String string2;
                        pGMessagingContext.m_columnsIsNullResultSetQuery = string2 = this.createColumnsIsNullCatalogQuery(pGMessagingContext);
                    }
                }
                return pGMessagingContext;
            }
            catch (Exception exception) {
                throw this.buildError(exception);
            }
        }
        LogUtilities.logFatal("Not Connected", this.m_log);
        throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
    }

    public PGMessagingContext directExecuteExtraMetadataWithMessage(PGMessagingContext pGMessagingContext, int n, int n2, IWarningListener iWarningListener, boolean bl, boolean bl2, ColumnsIsNullResultSet columnsIsNullResultSet, int n3) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, pGMessagingContext.m_query);
        if (this.isConnected()) {
            try {
                pGMessagingContext = this.directExecuteWithMessage(pGMessagingContext, bl2, n, n2, iWarningListener, bl, n3);
                if (null != columnsIsNullResultSet) {
                    pGMessagingContext.m_columnsIsNullResultSet = columnsIsNullResultSet;
                } else if (null == pGMessagingContext.getNoData()) {
                    String string;
                    pGMessagingContext.m_columnsIsNullResultSetQuery = string = this.createColumnsIsNullCatalogQuery(pGMessagingContext);
                }
                return pGMessagingContext;
            }
            catch (Exception exception) {
                throw this.buildError(exception);
            }
        }
        LogUtilities.logFatal("Not Connected", this.m_log);
        throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
    }

    public List<Object> executeExtraMetadata(String string, int n, int n2, IWarningListener iWarningListener, boolean bl) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, string);
        if (this.isConnected()) {
            PGMessagingContext pGMessagingContext = PGMessagingContext.createStatementContext(this, string, 0, 0, this.m_log, this.m_connectionWarningListener, iWarningListener);
            this.m_fiveMessages[0] = new Parse(null, string, null, this.m_log);
            this.m_fiveMessages[1] = new Bind(null, null, null, null, null, this.m_log);
            this.m_fiveMessages[2] = new Describe(null, Describe.DescribeType.PORTAL, this.m_log);
            this.m_fiveMessages[3] = this.m_flush;
            this.m_fiveMessages[4] = this.m_sync;
            this.write(pGMessagingContext, this.m_fiveMessages);
            this.handleErrors(pGMessagingContext);
            ColumnsIsNullResultSet columnsIsNullResultSet = this.createColumnsIsNullResultSet(pGMessagingContext);
            boolean bl2 = null != pGMessagingContext.getNoData();
            pGMessagingContext.close();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(columnsIsNullResultSet);
            arrayList.add(bl2);
            return arrayList;
        }
        return null;
    }

    public PGMessagingContext directExecuteImmediately(String string, IWarningListener iWarningListener) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, string);
        if (this.isConnected()) {
            try {
                PGMessagingContext pGMessagingContext = PGMessagingContext.createStatementContext(this, string, 0, 0, this.m_log, this.m_connectionWarningListener, iWarningListener);
                pGMessagingContext.m_query = string;
                pGMessagingContext.openCurrentOperation(0, false);
                this.m_oneMessage[0] = new Query(string, this.m_log);
                this.write(pGMessagingContext, this.m_oneMessage);
                this.handleErrorsScenario3(pGMessagingContext);
                pGMessagingContext.closeOperation();
                return pGMessagingContext;
            }
            catch (Exception exception) {
                throw this.buildError(exception);
            }
        }
        LogUtilities.logFatal("Not Connected", this.m_log);
        throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
    }

    public void executePreparedStatement(PGMessagingContext pGMessagingContext, int n, int n2, boolean bl, byte[][] byArray, int n3) throws ErrorException {
        this.executePreparedStatement(pGMessagingContext, n, n2, bl, byArray, n3, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executePreparedStatement(PGMessagingContext pGMessagingContext, int n, int n2, boolean bl, byte[][] byArray, int n3, boolean bl2) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, pGMessagingContext.m_query);
        if (this.isConnected()) {
            try {
                if (null == pGMessagingContext.getNoData()) {
                    if (bl) {
                        this.postBRMDisabledWarning(pGMessagingContext, n);
                    }
                    pGMessagingContext.setNRowMode(this.getBlockingRowsMode(n, bl), this.m_dataHandler);
                } else {
                    pGMessagingContext.setNRowMode(0, this.m_dataHandler);
                    n2 = 0;
                }
                short[] sArray = null;
                if (null != byArray) {
                    sArray = this.buildFormatCodes(byArray.length);
                }
                pGMessagingContext.clearPortalName();
                byte[] byArray2 = this.generateSynthteticPortalName(0);
                pGMessagingContext.setPortalName(byArray2);
                if (n2 > 0) {
                    pGMessagingContext.openCurrentOperation(n2, true);
                    this.m_sixMessages[0] = new Bind(byArray2, pGMessagingContext.m_serverStatementName, sArray, byArray, null, this.m_log);
                    this.m_sixMessages[1] = new Describe(byArray2, Describe.DescribeType.PORTAL, this.m_log);
                    this.m_sixMessages[2] = new Execute(byArray2, pGMessagingContext.m_maxRow, this.m_log);
                    this.m_sixMessages[3] = new Close(byArray2, Close.CloseType.PORTAL, this.m_log);
                    this.m_sixMessages[4] = this.m_flush;
                    this.m_sixMessages[5] = this.m_sync;
                    pGMessagingContext.clearPortalName();
                    this.write(pGMessagingContext, this.m_sixMessages);
                } else {
                    pGMessagingContext.openCurrentOperation(0, true);
                    this.m_fiveMessages[0] = new Bind(byArray2, pGMessagingContext.m_serverStatementName, sArray, byArray, null, this.m_log);
                    this.m_fiveMessages[1] = new Describe(byArray2, Describe.DescribeType.PORTAL, this.m_log);
                    this.m_fiveMessages[2] = new Execute(byArray2, 0, this.m_log);
                    this.m_fiveMessages[3] = this.m_flush;
                    this.m_fiveMessages[4] = this.m_sync;
                    this.write(pGMessagingContext, this.m_fiveMessages);
                }
                if (!bl2) return;
                this.handleErrorsPrepareExecute(pGMessagingContext);
                return;
            }
            catch (Exception exception) {
                throw this.buildError(exception);
            }
        } else {
            LogUtilities.logFatal("Not Connected", this.m_log);
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
        }
    }

    public void executePreparedStatementParameterSets(PGMessagingContext pGMessagingContext, int n, byte[][][] byArray) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, pGMessagingContext.m_query);
        if (this.isConnected()) {
            try {
                int n2;
                AbstractOutboundMessage[] abstractOutboundMessageArray = new AbstractOutboundMessage[byArray.length * 2 + 2];
                pGMessagingContext.setNRowMode(0, this.m_dataHandler);
                pGMessagingContext.openCurrentOperationParameterSets(byArray.length);
                pGMessagingContext.clearPortalName();
                for (n2 = 0; n2 < byArray.length; ++n2) {
                    byte[] byArray2 = this.generateSynthteticPortalName(n2);
                    abstractOutboundMessageArray[n2 * 2] = new Bind(byArray2, pGMessagingContext.m_serverStatementName, this.buildFormatCodes(byArray[n2].length), byArray[n2], null, this.m_log);
                    abstractOutboundMessageArray[n2 * 2 + 1] = new Execute(byArray2, 0, this.m_log);
                }
                abstractOutboundMessageArray[abstractOutboundMessageArray.length - 2] = this.m_flush;
                abstractOutboundMessageArray[abstractOutboundMessageArray.length - 1] = this.m_sync;
                this.write(pGMessagingContext, abstractOutboundMessageArray);
                for (n2 = 0; n2 < byArray.length; ++n2) {
                    int n3 = n2 + n;
                    while (pGMessagingContext.m_multipleParameterSetsBindComplete.size() > n3 && null == pGMessagingContext.m_multipleParameterSetsBindComplete.get(n3) && null == this.m_fatalException) {
                        Thread.yield();
                    }
                    if (null == this.m_fatalException) continue;
                    throw this.m_fatalException;
                }
            }
            catch (Exception exception) {
                throw this.buildError(exception);
            }
        } else {
            LogUtilities.logFatal("Not Connected", this.m_log);
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeAtomicStatement(List<PGMessagingContext> list, List<ProcessedStatement> list2, HashMap<PGMessagingContext, ArrayList<byte[][]>> hashMap, int n, int n2, int n3, IWarningListener iWarningListener, int n4, boolean bl) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.isConnected()) {
            try {
                if (0 == list.size()) {
                    bl2 = true;
                    this.buildAtomicStmtContexts(list, list2, iWarningListener);
                }
                this.postBRMDisabledWarnings(list, n3);
                n3 = 0;
                if (n > 1) {
                    n2 = 0;
                }
                ArrayList<PGMessagingContext> arrayList = new ArrayList<PGMessagingContext>(n * list.size());
                AbstractOutboundMessage[] abstractOutboundMessageArray = this.buildAtomicStmtMessageBuffer(arrayList, list, hashMap, n, n2, n3, bl3);
                this.write(arrayList, abstractOutboundMessageArray);
                if (!bl) return;
                this.handleAtomicStmtErrors(list, bl2);
                if (!bl2) return;
                for (PGMessagingContext pGMessagingContext : list) {
                    pGMessagingContext.m_columnsIsNullResultSet = this.createColumnsIsNullResultSet(pGMessagingContext);
                }
                return;
            }
            catch (Exception exception) {
                throw this.buildError(exception);
            }
        } else {
            LogUtilities.logFatal("Not Connected", this.m_log);
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
        }
    }

    public void handleAtomicStmtErrors(List<PGMessagingContext> list, boolean bl) throws ErrorException {
        for (int i = 0; i < list.size(); ++i) {
            PGMessagingContext pGMessagingContext = list.get(i);
            if (pGMessagingContext.m_multipleParameterSetsMode) {
                while (pGMessagingContext.m_multipleParameterSetsBindComplete.size() > pGMessagingContext.m_batchCount && null == pGMessagingContext.m_multipleParameterSetsBindComplete.get(pGMessagingContext.m_batchCount) && null == this.m_fatalException) {
                    Thread.yield();
                }
            } else if (bl) {
                this.handleErrors(pGMessagingContext);
            } else {
                this.handleErrorsPrepareExecute(pGMessagingContext);
            }
            if (null == this.m_fatalException) continue;
            throw this.m_fatalException;
        }
    }

    private AbstractOutboundMessage[] buildAtomicStmtMessageBuffer(ArrayList<PGMessagingContext> arrayList, List<PGMessagingContext> list, HashMap<PGMessagingContext, ArrayList<byte[][]>> hashMap, int n, int n2, int n3, boolean bl) throws InboundErrorMessage {
        ArrayList<AbstractOutboundMessage> arrayList2 = new ArrayList<AbstractOutboundMessage>();
        byte[] byArray = null;
        if (n2 > 0) {
            byArray = this.generateSynthteticPortalName(0);
        }
        int n4 = list.size();
        PGMessagingContext.CloseMode closeMode = PGMessagingContext.CloseMode.ReadyForQuery;
        if (n4 > 1) {
            closeMode = PGMessagingContext.CloseMode.CommandComplete;
            if (n2 > 0) {
                closeMode = PGMessagingContext.CloseMode.CloseComplete;
            }
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n4; ++j) {
                PGMessagingContext pGMessagingContext = list.get(j);
                ArrayList<byte[][]> arrayList3 = hashMap.get(pGMessagingContext);
                byte[][] byArray2 = null;
                short[] sArray = null;
                if (null != arrayList3) {
                    byArray2 = arrayList3.get(i);
                    sArray = this.buildFormatCodes(byArray2.length);
                }
                if (null == pGMessagingContext.m_serverStatementName) {
                    if (bl) {
                        pGMessagingContext.m_serverStatementName = this.generateSynthteticPreparedStatementName();
                    }
                    arrayList2.add(new Parse(pGMessagingContext.m_serverStatementName, pGMessagingContext.m_query, pGMessagingContext.m_parameterOids, this.m_log));
                }
                arrayList2.add(new Bind(byArray, pGMessagingContext.m_serverStatementName, sArray, byArray2, null, this.m_log));
                if (0 == i) {
                    arrayList2.add(new Describe(byArray, Describe.DescribeType.PORTAL, this.m_log));
                }
                arrayList2.add(new Execute(byArray, n2, this.m_log));
                if (n2 > 0) {
                    arrayList2.add(new Close(byArray, Close.CloseType.PORTAL, this.m_log));
                }
                if (n > 1) {
                    pGMessagingContext.openCurrentOperationParameterSets(n);
                } else {
                    pGMessagingContext.openCurrentOperation(n2, true);
                }
                pGMessagingContext.setNRowMode(n3, this.m_dataHandler);
                pGMessagingContext.setCloseMode(closeMode);
                pGMessagingContext.clearPortalName();
                arrayList.add(pGMessagingContext);
            }
        }
        arrayList2.add(this.m_flush);
        arrayList2.add(this.m_sync);
        return arrayList2.toArray(new AbstractOutboundMessage[arrayList2.size()]);
    }

    private void buildAtomicStmtContexts(List<PGMessagingContext> list, List<ProcessedStatement> list2, IWarningListener iWarningListener) {
        for (ProcessedStatement processedStatement : list2) {
            PGMessagingContext pGMessagingContext = PGMessagingContext.createStatementContext(this, processedStatement.getStatementText(), 0, 0, this.m_log, this.m_connectionWarningListener, iWarningListener);
            pGMessagingContext.setFinalCommandInBatch(false);
            list.add(pGMessagingContext);
        }
        list.get(list.size() - 1).setFinalCommandInBatch(true);
    }

    public PGMessagingContext prepareStatement(String string, IWarningListener iWarningListener, boolean bl) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, string);
        PGMessagingContext pGMessagingContext = PGMessagingContext.createPreparedStatementContext(this, string, 0, 0, this.m_log, this.m_connectionWarningListener, iWarningListener);
        pGMessagingContext.m_serverStatementName = this.generateSynthteticPreparedStatementName();
        if (this.isConnected()) {
            try {
                this.m_fourMessages[0] = new Parse(pGMessagingContext.m_serverStatementName, pGMessagingContext.m_query, pGMessagingContext.m_parameterOids, this.m_log);
                this.m_fourMessages[1] = new Describe(pGMessagingContext.m_serverStatementName, Describe.DescribeType.PREPARED_STATEMENT, this.m_log);
                this.m_fourMessages[2] = this.m_flush;
                this.m_fourMessages[3] = this.m_sync;
                this.write(pGMessagingContext, this.m_fourMessages);
                ParameterDescription parameterDescription = null;
                if (null == pGMessagingContext.m_readyForQueryFromPipelineForQuery) {
                    LogUtilities.logError("ReadyForQuery not received.", this.m_log);
                }
                if (null != (parameterDescription = pGMessagingContext.getParameterDescription())) {
                    for (int i = 0; i < parameterDescription.getParameterDataTypeOIDs().length; ++i) {
                        int n = parameterDescription.getParameterDataTypeOIDs()[i];
                        int n2 = i + 1;
                        PGParameterMetadata pGParameterMetadata = PGDataTypeUtilities.createParameter(n, n2, pGMessagingContext);
                        pGMessagingContext.m_parameterMetadata.add(pGParameterMetadata);
                        pGMessagingContext.m_parameterOids.add(n);
                    }
                }
                pGMessagingContext.getReadyForQuery();
                pGMessagingContext.m_columnsIsNullResultSet = this.createColumnsIsNullResultSet(pGMessagingContext);
                return pGMessagingContext;
            }
            catch (ErrorException errorException) {
                throw errorException;
            }
            catch (Exception exception) {
                throw this.buildError(exception);
            }
        }
        LogUtilities.logFatal("Not Connected", this.m_log);
        throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
    }

    public PGMessagingContext reprepareStatement(PGMessagingContext pGMessagingContext, List<Integer> list, IWarningListener iWarningListener) throws ErrorException {
        if (this.isConnected()) {
            try {
                this.m_threeMessages[0] = new Close(pGMessagingContext.m_serverStatementName, Close.CloseType.PREPARED_STATEMENT, this.m_log);
                this.m_threeMessages[1] = this.m_flush;
                this.m_threeMessages[2] = this.m_sync;
                PGMessagingContext pGMessagingContext2 = PGMessagingContext.createStatementContext(this, "closeContextRePrepare", 0, 0, this.m_log, this.m_connectionWarningListener, iWarningListener);
                this.write(pGMessagingContext2, this.m_threeMessages);
                pGMessagingContext.openCurrentOperation(0, false);
                pGMessagingContext.m_serverStatementName = this.generateSynthteticPreparedStatementName();
                pGMessagingContext.m_readyForQueryFromPipelineForPrepare = null;
                pGMessagingContext.m_parseComplete = null;
                this.m_fourMessages[0] = new Parse(pGMessagingContext.m_serverStatementName, pGMessagingContext.m_query, list, this.m_log);
                this.m_fourMessages[1] = new Describe(pGMessagingContext.m_serverStatementName, Describe.DescribeType.PREPARED_STATEMENT, this.m_log);
                this.m_fourMessages[2] = this.m_flush;
                this.m_fourMessages[3] = this.m_sync;
                this.write(pGMessagingContext, this.m_fourMessages);
                pGMessagingContext2.getReadyForQuery();
                pGMessagingContext2.closeOperation();
            }
            catch (ErrorException errorException) {
                throw errorException;
            }
            catch (Exception exception) {
                throw this.buildError(exception);
            }
            try {
                pGMessagingContext.getReadyForQuery();
                return pGMessagingContext;
            }
            catch (ErrorException errorException) {
                throw errorException;
            }
            catch (Exception exception) {
                throw this.buildError(exception);
            }
        }
        LogUtilities.logFatal("Not Connected", this.m_log);
        throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
    }

    public void closeServerNamedStatement(PGMessagingContext pGMessagingContext, IWarningListener iWarningListener) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, pGMessagingContext.m_query);
        if (this.isConnected()) {
            try {
                PGMessagingContext pGMessagingContext2 = PGMessagingContext.createStatementContext(this, "closeContext", 0, 0, this.m_log, this.m_connectionWarningListener, iWarningListener);
                pGMessagingContext2.openCurrentOperation();
                this.m_threeMessages[0] = new Close(pGMessagingContext.m_serverStatementName, Close.CloseType.PREPARED_STATEMENT, this.m_log);
                this.m_threeMessages[1] = this.m_flush;
                this.m_threeMessages[2] = this.m_sync;
                this.write(pGMessagingContext2, this.m_threeMessages);
                pGMessagingContext2.getReadyForQuery();
            }
            catch (ErrorException errorException) {
                throw errorException;
            }
            catch (Exception exception) {
                throw this.buildError(exception);
            }
        } else {
            LogUtilities.logFatal("Not Connected", this.m_log);
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
        }
    }

    public ColumnsIsNullResultSet createColumnsIsNullResultSet(PGMessagingContext pGMessagingContext) throws ErrorException {
        String string = this.createColumnsIsNullCatalogQuery(pGMessagingContext);
        if (null == string) {
            return null;
        }
        PGMessagingContext pGMessagingContext2 = this.directExecute(string, false, 0, 0, null, true);
        return new ColumnsIsNullResultSet(pGMessagingContext2, this.m_log);
    }

    public String createColumnsIsNullCatalogQuery(PGMessagingContext pGMessagingContext) throws ErrorException {
        RowDescription rowDescription = pGMessagingContext.getRowDescription();
        if (null == rowDescription) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(rowDescription.getNumberOfFields());
        ArrayList<String> arrayList2 = new ArrayList<String>(rowDescription.getNumberOfFields());
        if (0 == rowDescription.getFieldDescriptions().length) {
            return null;
        }
        for (FieldDescription fieldDescription : rowDescription.getFieldDescriptions()) {
            if (fieldDescription.getTableObjectIDString().equals("0")) continue;
            arrayList.add(fieldDescription.getTableObjectIDString());
            arrayList2.add(fieldDescription.getColumnAttributeNumberString());
        }
        if (arrayList.size() == 0) {
            return null;
        }
        String string = PGCatalogQueryBuilder.PGAttNotNullBuilder(arrayList, arrayList2);
        return string;
    }

    public boolean isConnected() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null == this.m_socketChannel || this.m_socketChannel.isClosed()) {
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_CONNECTION_LOST_ERR.name());
        }
        return true;
    }

    private TLSSocketChannel checkSSL(AbstractSocketChannel abstractSocketChannel) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        TLSSocketChannel tLSSocketChannel = null;
        try {
            this.m_oneMessage[0] = new SSLRequest(this.m_log);
            this.write(abstractSocketChannel, null, null, this.m_oneMessage);
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(512);
            int n = abstractSocketChannel.getSocketChannel().read(byteBuffer);
            byteBuffer.flip();
            if (n < 0) {
                LogUtilities.logDebug("createSSLSocketChannel:0 Bytes Read, Server closed socket.", this.m_log);
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), "The server closed the connection.");
            }
            char c = (char)byteBuffer.get();
            switch (c) {
                case 'S': {
                    LogUtilities.logDebug("createSSLSocketChannel:SSL Supported", this.m_log);
                    abstractSocketChannel.getSocketChannel().configureBlocking(false);
                    TrustManager[] trustManagerArray = null;
                    KeyManager[] keyManagerArray = null;
                    trustManagerArray = AuthMech.VERIFY_FULL == this.m_settings.m_authMech || AuthMech.VERIFY_CA == this.m_settings.m_authMech ? (null != this.m_settings.m_sslTrustStorePath ? this.getTrustManagerWithDefinedTrustStore() : (null != this.m_settings.m_sslRootCert ? this.getTrustManagerWithImportedCertificate() : this.getDefaultTrustManager())) : new TrustManager[]{new NonValidatingFactory()};
                    if (null != this.m_settings.m_sslCert && null != this.m_settings.m_sslKey) {
                        keyManagerArray = this.getKeyManagers();
                    }
                    tLSSocketChannel = new TLSSocketChannel(abstractSocketChannel.getSocketChannel(), this.m_dataHandler, this.m_settings.m_host, this.m_settings.m_port, new HostNameValidator(), AuthMech.VERIFY_FULL == this.m_settings.m_authMech, keyManagerArray, trustManagerArray, this.m_log);
                    break;
                }
                case 'N': {
                    LogUtilities.logFatal("createSSLSocketChannel:SSL Not Supported (Unwilling)", this.m_log);
                    break;
                }
                case 'E': {
                    ErrorResponse errorResponse = null;
                    try {
                        int n2 = byteBuffer.getInt();
                        errorResponse = new ErrorResponse(byteBuffer, n2, this.m_log);
                        LogUtilities.logFatal(errorResponse.getMessage(), this.m_log);
                    }
                    catch (Exception exception) {
                        LogUtilities.logFatal("Attempting to connect to very old Server version.", this.m_log);
                        LogUtilities.logFatal(exception, this.m_log);
                    }
                    break;
                }
            }
            return tLSSocketChannel;
        }
        catch (IOException iOException) {
            LogUtilities.logFatal(iOException, this.m_log);
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), iOException.getMessage());
            errorException.initCause(iOException);
            throw errorException;
        }
    }

    public void registerWarningListener(IWarningListener iWarningListener) {
        this.m_connectionWarningListener = iWarningListener;
        this.m_dataHandler.registerWarningListener(iWarningListener);
    }

    public short[] buildFormatCodes(int n) {
        short[][] sArray = this.m_cachedTextFormatCodes;
        if (n < 30 && null != sArray[n]) {
            return sArray[n];
        }
        short[] sArray2 = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray2[i] = 0;
        }
        if (n < 30) {
            sArray[n] = sArray2;
        }
        return sArray2;
    }

    public boolean isValid() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        try {
            if (!this.isConnected()) {
                return false;
            }
            PGMessagingContext pGMessagingContext = PGMessagingContext.createStatementContext(this, IS_VALID_TEST_QUERY, 0, 0, this.m_log, this.m_connectionWarningListener, this.m_connectionWarningListener);
            this.m_sixMessages[0] = new Parse(null, IS_VALID_TEST_QUERY, null, this.m_log);
            this.m_sixMessages[1] = new Bind(null, null, null, null, null, this.m_log);
            this.m_sixMessages[2] = new Describe(null, Describe.DescribeType.PORTAL, this.m_log);
            this.m_sixMessages[3] = new Execute(null, 0, this.m_log);
            this.m_sixMessages[4] = this.m_flush;
            this.m_sixMessages[5] = this.m_sync;
            this.write(pGMessagingContext, this.m_sixMessages);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void setConnectionAutoCommit(boolean bl) {
        this.m_connectionAutoCommit = bl;
    }

    public boolean isConnectionAutoCommit() {
        return this.m_connectionAutoCommit;
    }

    public boolean isDatashareEnabled() {
        return this.m_datashareEnabled;
    }

    public void handleErrors(PGMessagingContext pGMessagingContext) throws ErrorException {
        this.handleErrorsScenario1(pGMessagingContext);
        this.handleErrorsScenario2(pGMessagingContext);
        this.handleErrorsScenario3(pGMessagingContext);
    }

    public void handleErrorsPrepareExecute(PGMessagingContext pGMessagingContext) throws ErrorException {
        this.handleErrorsScenario1(pGMessagingContext);
        this.handleErrorsScenario2ForPrepareExecution(pGMessagingContext);
        this.handleErrorsScenario3(pGMessagingContext);
    }

    private void handleErrorsScenario1(PGMessagingContext pGMessagingContext) throws ErrorException {
        while (null == pGMessagingContext.getBindComplete() && null == this.m_fatalException) {
            ErrorException errorException = pGMessagingContext.receivedFatalExeption();
            if (null != errorException) {
                this.m_fatalException = errorException;
                break;
            }
            if (pGMessagingContext.m_isCanceled.get()) break;
            IInboundMessage iInboundMessage = pGMessagingContext.peekNextMessage(this.m_settings.m_socketTimeoutMS);
            if (!(iInboundMessage instanceof ErrorResponse)) continue;
            pGMessagingContext.getErrorResponse();
        }
        if (null != this.m_fatalException) {
            if (JDBCMessageKey.OPERATION_CANCELED.name() == this.m_fatalException.getMessage()) {
                this.cancelQuery(pGMessagingContext.m_query);
            }
            throw this.m_fatalException;
        }
        if (this.m_log.isEnabled()) {
            LogUtilities.logDebug("Finished handleErrorsScenario1.", this.m_log);
        }
    }

    private void handleErrorsScenario2ForPrepareExecution(PGMessagingContext pGMessagingContext) throws ErrorException {
        IInboundMessage iInboundMessage;
        if (!(pGMessagingContext.getNoDataForPrepareExecute() && pGMessagingContext.getRowDescriptionForPrepareExecute() || !((iInboundMessage = pGMessagingContext.peekNextMessage(this.m_settings.m_socketTimeoutMS)) instanceof ErrorResponse))) {
            pGMessagingContext.getErrorResponse();
        }
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        if (this.m_log.isEnabled()) {
            LogUtilities.logDebug("Finished handleErrorsScenario2ForPrepareExecution.", this.m_log);
        }
    }

    private void handleErrorsScenario2(PGMessagingContext pGMessagingContext) throws ErrorException {
        IInboundMessage iInboundMessage;
        if (null == pGMessagingContext.getNoData() && null == pGMessagingContext.getRowDescription() && (iInboundMessage = pGMessagingContext.peekNextMessage(this.m_settings.m_socketTimeoutMS)) instanceof ErrorResponse) {
            pGMessagingContext.getErrorResponse();
        }
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        if (this.m_log.isEnabled()) {
            LogUtilities.logDebug("Finished handleErrorsScenario2.", this.m_log);
        }
    }

    private void handleErrorsScenario3(PGMessagingContext pGMessagingContext) throws ErrorException {
        IInboundMessage iInboundMessage;
        if (null == pGMessagingContext.m_readyForQueryFromPipelineForQuery && (iInboundMessage = pGMessagingContext.peekNextMessage(this.m_settings.m_socketTimeoutMS)) instanceof ErrorResponse) {
            pGMessagingContext.getErrorResponse();
        }
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        if (this.m_log.isEnabled()) {
            LogUtilities.logDebug("Finished handleErrorsScenario3.", this.m_log);
        }
    }

    private KeyManager[] getKeyManagers() throws ErrorException {
        Serializable serializable;
        Object object;
        String string = null;
        File file = null;
        KeyStore keyStore = null;
        String string2 = UUID.randomUUID().toString();
        try {
            file = File.createTempFile("KeyStore", ".jks");
            string = file.getAbsolutePath();
            if (!file.exists()) {
                String[] stringArray = new String[]{"keystore", string};
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_FILE_NOT_FOUND_ERROR.name(), stringArray);
                LogUtilities.logError(errorException, this.m_log);
                throw errorException;
            }
            file.deleteOnExit();
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, string2.toCharArray());
        }
        catch (Exception exception) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_KEYSTORE_INITIALIZATION_ERROR.name());
            LogUtilities.logError(errorException, this.m_log);
            throw errorException;
        }
        try {
            object = new File(this.m_settings.m_sslKey);
            serializable = this.getPrivateKey((File)object);
            Certificate[] certificateArray = this.getCertificateChain(this.m_settings.m_sslCert);
            keyStore.setKeyEntry(((File)object).getName(), (Key)serializable, string2.toCharArray(), certificateArray);
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            keyStore.store(fileOutputStream, string2.toCharArray());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_IMPORTING_KEY_ERROR.name(), this.m_settings.m_sslKey);
            LogUtilities.logError(errorException, this.m_log);
            throw errorException;
        }
        try {
            object = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            ((KeyManagerFactory)object).init(keyStore, string2.toCharArray());
            return ((KeyManagerFactory)object).getKeyManagers();
        }
        catch (Exception exception) {
            serializable = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_KEYMANAGER_ERROR.name());
            LogUtilities.logError((ErrorException)serializable, this.m_log);
            throw serializable;
        }
    }

    private PrivateKey getPrivateKey(File file) throws ErrorException {
        PrivateKey privateKey = null;
        try {
            String string = this.m_settings.m_sslPassword;
            if (!file.isFile() || !file.exists()) {
                String[] stringArray = new String[]{"key", file.getAbsolutePath()};
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_FILE_NOT_FOUND_ERROR.name(), stringArray);
                LogUtilities.logError(errorException, this.m_log);
                throw errorException;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[(int)file.length()];
            ((InputStream)fileInputStream).read(byArray);
            ((InputStream)fileInputStream).close();
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            if (null != string) {
                EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(byArray);
                SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(encryptedPrivateKeyInfo.getAlgName());
                SecretKey secretKey = secretKeyFactory.generateSecret(new PBEKeySpec(string.toCharArray()));
                Cipher cipher = Cipher.getInstance(encryptedPrivateKeyInfo.getAlgName());
                cipher.init(2, (Key)secretKey, encryptedPrivateKeyInfo.getAlgParameters());
                privateKey = keyFactory.generatePrivate(encryptedPrivateKeyInfo.getKeySpec(cipher));
            } else {
                privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray));
            }
        }
        catch (Exception exception) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_READING_KEY_ERROR.name(), file.getAbsolutePath());
            LogUtilities.logError(errorException, this.m_log);
            throw errorException;
        }
        return privateKey;
    }

    private Certificate[] getCertificateChain(String string) throws ErrorException {
        Certificate[] certificateArray = new Certificate[]{};
        try {
            File file = new File(string);
            if (!file.isFile() || !file.exists()) {
                String[] stringArray = new String[]{"certificate", string};
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_FILE_NOT_FOUND_ERROR.name(), stringArray);
                LogUtilities.logError(errorException, this.m_log);
                throw errorException;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            certificateArray = certificateFactory.generateCertificates(fileInputStream).toArray(certificateArray);
            ((InputStream)fileInputStream).close();
            if (0 >= certificateArray.length || null == certificateArray[0]) {
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_MISSING_CERTIFICATE_ERROR.name(), string);
                LogUtilities.logError(errorException, this.m_log);
                throw errorException;
            }
        }
        catch (Exception exception) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_CERTIFICATE_CHAIN_ERROR.name());
            LogUtilities.logError(errorException, this.m_log);
            throw errorException;
        }
        return certificateArray;
    }

    private TrustManager[] getTrustManagerWithDefinedTrustStore() throws ErrorException {
        KeyStore keyStore = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.m_settings.m_sslTrustStorePath);
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(fileInputStream, this.m_settings.m_sslTrustStorePwd != null ? this.m_settings.m_sslTrustStorePwd.toCharArray() : null);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
            return trustManagerArray;
        }
        catch (Exception exception) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_TRUSTMANAGER_ERROR.name());
            errorException.initCause(exception);
            LogUtilities.logError(errorException, this.m_log);
            throw errorException;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    LogUtilities.logError(iOException, this.m_log);
                }
            }
        }
    }

    private TrustManager[] getTrustManagerWithImportedCertificate() throws ErrorException {
        KeyStore keyStore = this.getDefaultKeystore();
        try {
            Certificate[] certificateArray = this.getCertificateChain(this.m_settings.m_sslRootCert);
            keyStore.setCertificateEntry(this.m_settings.m_sslRootCert, certificateArray[0]);
        }
        catch (Exception exception) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_IMPORTING_CERTIFICATE_ERROR.name());
            errorException.initCause(exception);
            LogUtilities.logError(errorException, this.m_log);
            throw errorException;
        }
        return this.getTrustManager(keyStore);
    }

    private TrustManager[] getDefaultTrustManager() throws ErrorException {
        KeyStore keyStore = this.getDefaultKeystore();
        return this.getTrustManager(keyStore);
    }

    private TrustManager[] getTrustManager(KeyStore keyStore) throws ErrorException {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            return trustManagerFactory.getTrustManagers();
        }
        catch (Exception exception) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), "Error retrieving the available trust managers");
            errorException.initCause(exception);
            LogUtilities.logError(errorException, this.m_log);
            throw errorException;
        }
    }

    private KeyStore getDefaultKeystore() throws ErrorException {
        Object object;
        FileInputStream fileInputStream = null;
        String string = null;
        String string2 = System.getProperty(TRUSTSTORE_PROPERTY);
        string = System.getProperty(TRUSTSTORE_PWD_PROPERTY);
        if (null == string2) {
            object = new StringBuilder();
            ((StringBuilder)object).append(System.getProperty("java.home"));
            ((StringBuilder)object).append(File.separatorChar);
            ((StringBuilder)object).append("lib");
            ((StringBuilder)object).append(File.separatorChar);
            ((StringBuilder)object).append("security");
            ((StringBuilder)object).append(File.separatorChar);
            ((StringBuilder)object).append("cacerts");
            string2 = ((StringBuilder)object).toString();
        }
        try {
            fileInputStream = new FileInputStream(new File(string2));
        }
        catch (Exception exception) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), "Error loading the keystore ");
            LogUtilities.logError(errorException, this.m_log);
            throw errorException;
        }
        try {
            object = KeyStore.getInstance(KeyStore.getDefaultType());
            char[] cArray = null;
            if (null != string) {
                cArray = string.toCharArray();
            }
            ((KeyStore)object).load(fileInputStream, cArray);
            ((InputStream)fileInputStream).close();
            this.loadDefaultCA((KeyStore)object, "redshift.crt");
            this.loadDefaultCA((KeyStore)object, "bjs.redshift.crt");
            this.loadDefaultCA((KeyStore)object, "pdt.redshift.crt");
            return object;
        }
        catch (Exception exception) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), "Error loading the provided keystore");
            LogUtilities.logError(errorException, this.m_log);
            throw errorException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDefaultCA(KeyStore keyStore, String string) throws IOException, GeneralSecurityException {
        try (InputStream inputStream = null;){
            inputStream = NonValidatingFactory.class.getResourceAsStream(string);
            if (inputStream == null) {
                return;
            }
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Certificate certificate = certificateFactory.generateCertificate(inputStream);
            keyStore.setCertificateEntry(string, certificate);
        }
    }

    private byte[] generateSynthteticPortalName(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SYNTHETIC_PORTAL_NAME_SEED);
        stringBuilder.append("-");
        stringBuilder.append(n);
        stringBuilder.append("-");
        stringBuilder.append(System.nanoTime());
        return PGDataTypeUtilities.toUTF8ByteArray(stringBuilder.toString());
    }

    private byte[] generateSynthteticPreparedStatementName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SYNTHETIC_PREPARED_STATEMENT_NAME_SEED);
        stringBuilder.append("-");
        stringBuilder.append(System.nanoTime());
        return PGDataTypeUtilities.toUTF8ByteArray(stringBuilder.toString());
    }

    private ErrorException buildError(Exception exception) {
        if (null != this.m_fatalException) {
            return this.m_fatalException;
        }
        if (exception instanceof ErrorException) {
            return (ErrorException)exception;
        }
        ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
        errorException.initCause(exception);
        return errorException;
    }

    public void sync() throws ErrorException {
        PGMessagingContext pGMessagingContext = PGMessagingContext.createStatementContext(this, "sync", 0, 0, this.m_log, null, null);
        this.write(pGMessagingContext, this.m_flushSync);
        pGMessagingContext.getReadyForQuery();
    }

    public synchronized void write(PGMessagingContext pGMessagingContext, AbstractOutboundMessage[] abstractOutboundMessageArray) throws ErrorException {
        this.write(this.m_socketChannel, pGMessagingContext, null, abstractOutboundMessageArray);
    }

    public synchronized void write(List<PGMessagingContext> list, AbstractOutboundMessage[] abstractOutboundMessageArray) throws ErrorException {
        this.write(this.m_socketChannel, null, list, abstractOutboundMessageArray);
    }

    public synchronized void write(AbstractSocketChannel abstractSocketChannel, PGMessagingContext pGMessagingContext, List<PGMessagingContext> list, AbstractOutboundMessage[] abstractOutboundMessageArray) throws ErrorException {
        if (null != abstractSocketChannel && !abstractSocketChannel.isClosed()) {
            int n = 0;
            for (AbstractOutboundMessage abstractOutboundMessage : abstractOutboundMessageArray) {
                if (null == abstractOutboundMessage) continue;
                n += abstractOutboundMessage.getSize() + 1;
            }
            if (n > this.m_writeBuffer.capacity()) {
                this.m_writeBuffer = ByteBuffer.allocateDirect(n);
            }
            this.m_writeBuffer.clear();
            for (AbstractOutboundMessage abstractOutboundMessage : abstractOutboundMessageArray) {
                if (null == abstractOutboundMessage) continue;
                abstractOutboundMessage.serialize(this.m_writeBuffer);
            }
            this.m_writeBuffer.flip();
            if (null != pGMessagingContext) {
                this.m_dataHandler.addPipeline(pGMessagingContext);
            } else if (null != list) {
                for (PGMessagingContext pGMessagingContext2 : list) {
                    this.m_dataHandler.addPipeline(pGMessagingContext2);
                }
            }
            boolean bl = abstractSocketChannel.write(this.m_writeBuffer);
            while (this.m_writeBuffer.hasRemaining() || !bl) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                bl = abstractSocketChannel.write(this.m_writeBuffer);
            }
        } else {
            if (this.m_log.isEnabled()) {
                LogUtilities.logDebug("Internal channel not connected", this.m_log);
            }
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
        }
    }

    public synchronized void write(PGMessagingContext pGMessagingContext, Iterator<AbstractOutboundMessage> iterator) throws ErrorException {
        AbstractOutboundMessage[] abstractOutboundMessageArray = new AbstractOutboundMessage[1];
        while (iterator.hasNext()) {
            abstractOutboundMessageArray[0] = iterator.next();
            this.write(pGMessagingContext, abstractOutboundMessageArray);
        }
    }

    public PGCoreUtils.TransactionVerb getTransactionVerbOfMessage(PGMessagingContext pGMessagingContext) {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        PGCoreUtils.TransactionVerb transactionVerb = PGCoreUtils.TransactionVerb.NONE;
        if (pGMessagingContext.m_commandCompleteFromWire && null != pGMessagingContext.m_peekedMessage && pGMessagingContext.m_peekedMessage instanceof CommandComplete) {
            CommandComplete commandComplete = (CommandComplete)pGMessagingContext.m_peekedMessage;
            if (commandComplete.isBegin()) {
                transactionVerb = PGCoreUtils.TransactionVerb.BEGIN;
            } else if (commandComplete.isTruncate() && !this.m_connectionAutoCommit) {
                transactionVerb = PGCoreUtils.TransactionVerb.COMMIT;
            } else if (commandComplete.isCommit()) {
                transactionVerb = PGCoreUtils.TransactionVerb.COMMIT;
            } else if (commandComplete.isRollback()) {
                transactionVerb = PGCoreUtils.TransactionVerb.ROLLBACK;
            }
        }
        if (this.m_log.isEnabled()) {
            LogUtilities.logDebug("Transaction verb set to " + (Object)((Object)transactionVerb), this.m_log);
        }
        return transactionVerb;
    }

    public InboundDataHandler getInboundDataHandler() {
        return this.m_dataHandler;
    }

    public ILogger getClientLogger() {
        return this.m_log;
    }

    public IWarningListener getConnectionListener() {
        return this.m_connectionWarningListener;
    }

    private void postBRMDisabledWarnings(List<PGMessagingContext> list, int n) {
        for (PGMessagingContext pGMessagingContext : list) {
            this.postBRMDisabledWarning(pGMessagingContext, n);
        }
    }

    private void postBRMDisabledWarning(PGMessagingContext pGMessagingContext, int n) {
        Integer n2 = null;
        if (0 != n) {
            n2 = n;
        } else if (0 != this.m_settings.m_nRowMode) {
            n2 = this.m_settings.m_nRowMode;
        }
        if (null != n2) {
            pGMessagingContext.m_warningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, PGJDBCMessageKey.PG_QUERY_BLOCK_ROWS_MODE_DISABLED.name(), new String[]{n2.toString()}));
        }
    }
}

