/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSSessionCredentials;
import java.util.Date;

public class CredentialsHolder
implements AWSCredentials {
    protected AWSCredentials m_credentials;
    private Date m_expiration;
    private IamMetadata m_metadata;

    protected CredentialsHolder(AWSCredentials aWSCredentials) {
        this(aWSCredentials, new Date(System.currentTimeMillis() + 900000L));
    }

    protected CredentialsHolder(AWSCredentials aWSCredentials, Date date) {
        this.m_credentials = aWSCredentials;
        if (aWSCredentials instanceof CredentialsHolder) {
            CredentialsHolder credentialsHolder = (CredentialsHolder)aWSCredentials;
            this.m_metadata = credentialsHolder.getMetadata();
            this.m_expiration = credentialsHolder.getExpiration();
        } else {
            this.m_expiration = date;
        }
    }

    public static CredentialsHolder newInstance(AWSCredentials aWSCredentials) {
        if (aWSCredentials instanceof AWSSessionCredentials) {
            return new SessionCredentialsHolder(aWSCredentials);
        }
        return new CredentialsHolder(aWSCredentials);
    }

    public static CredentialsHolder newInstance(AWSCredentials aWSCredentials, Date date) {
        if (aWSCredentials instanceof AWSSessionCredentials) {
            return new SessionCredentialsHolder(aWSCredentials, date);
        }
        return new CredentialsHolder(aWSCredentials, date);
    }

    public String getAWSAccessKeyId() {
        return this.m_credentials.getAWSAccessKeyId();
    }

    public String getAWSSecretKey() {
        return this.m_credentials.getAWSSecretKey();
    }

    public boolean isExpired() {
        return this.m_expiration != null && this.m_expiration.before(new Date(System.currentTimeMillis() - 300000L));
    }

    public Date getExpiration() {
        return this.m_expiration;
    }

    public IamMetadata getMetadata() {
        if (this.m_metadata == null) {
            return null;
        }
        return this.m_metadata.clone();
    }

    public IamMetadata getThisMetadata() {
        if (this.m_metadata == null) {
            return null;
        }
        return this.m_metadata;
    }

    public void setMetadata(IamMetadata iamMetadata) {
        this.m_metadata = iamMetadata;
    }

    public static final class IamMetadata
    implements Cloneable {
        private Boolean autoCreate;
        private String dbUser;
        private String samlDbUser;
        private String profileDbUser;
        private String dbGroups;
        private boolean allowDbUserOverride = false;
        private boolean forceLowercase = false;

        public Boolean getAutoCreate() {
            return this.autoCreate;
        }

        public String getDbUser() {
            return this.dbUser;
        }

        public void setDbUser(String string) {
            this.dbUser = string;
        }

        public void setAutoCreate(Boolean bl) {
            this.autoCreate = bl;
        }

        public String getSamlDbUser() {
            return this.samlDbUser;
        }

        public void setSamlDbUser(String string) {
            this.samlDbUser = string;
        }

        public String getProfileDbUser() {
            return this.profileDbUser;
        }

        public void setProfileDbUser(String string) {
            this.profileDbUser = string;
        }

        public String getDbGroups() {
            return this.dbGroups;
        }

        public void setDbGroups(String string) {
            this.dbGroups = string;
        }

        public boolean getForceLowercase() {
            return this.forceLowercase;
        }

        public void setForceLowercase(boolean bl) {
            this.forceLowercase = bl;
        }

        public boolean getAllowDbUserOverride() {
            return this.allowDbUserOverride;
        }

        public void setAllowDbUserOverride(boolean bl) {
            this.allowDbUserOverride = bl;
        }

        public IamMetadata clone() {
            try {
                return (IamMetadata)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public String toString() {
            return "IamMetadata{autoCreate=" + this.autoCreate + ", dbUser='" + this.dbUser + '\'' + ", samlDbUser='" + this.samlDbUser + '\'' + ", profileDbUser='" + this.profileDbUser + '\'' + ", dbGroups='" + this.dbGroups + '\'' + ", allowDbUserOverride=" + this.allowDbUserOverride + ", forceLowercase=" + this.forceLowercase + "}";
        }
    }

    private static final class SessionCredentialsHolder
    extends CredentialsHolder
    implements AWSSessionCredentials {
        protected SessionCredentialsHolder(AWSCredentials aWSCredentials) {
            super(aWSCredentials);
        }

        protected SessionCredentialsHolder(AWSCredentials aWSCredentials, Date date) {
            super(aWSCredentials, date);
        }

        public String getSessionToken() {
            return ((AWSSessionCredentials)this.m_credentials).getSessionToken();
        }
    }
}

