/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.jdbc42.utilities;

import com.amazon.jdbc.interfaces.IndexedJDBCDataSource;
import com.amazon.jdbc.jdbc41.utilities.ResultSetUtilities;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Map;

public class ResultSetUtilities {
    private static final ZoneId s_utcZoneId = ZoneId.of("UTC");
    private static ResultSetUtilities.Getter<LocalDate> s_localDateGetter = new ResultSetUtilities.Getter<LocalDate>(){

        @Override
        public LocalDate get(IndexedJDBCDataSource indexedJDBCDataSource, int n, Class<LocalDate> clazz) throws SQLException {
            assert (clazz == LocalDate.class);
            Date date = indexedJDBCDataSource.getDate(n);
            return date == null ? null : date.toLocalDate();
        }
    };
    private static ResultSetUtilities.Getter<LocalDateTime> s_localDateTimeGetter = new ResultSetUtilities.Getter<LocalDateTime>(){

        @Override
        public LocalDateTime get(IndexedJDBCDataSource indexedJDBCDataSource, int n, Class<LocalDateTime> clazz) throws SQLException {
            assert (clazz == LocalDateTime.class);
            Timestamp timestamp = indexedJDBCDataSource.getTimestamp(n);
            return timestamp == null ? null : timestamp.toLocalDateTime();
        }
    };
    private static ResultSetUtilities.Getter<LocalTime> s_localTimeGetter = new ResultSetUtilities.Getter<LocalTime>(){

        @Override
        public LocalTime get(IndexedJDBCDataSource indexedJDBCDataSource, int n, Class<LocalTime> clazz) throws SQLException {
            assert (clazz == LocalTime.class);
            Time time = indexedJDBCDataSource.getTime(n);
            return time == null ? null : time.toLocalTime();
        }
    };
    private static ResultSetUtilities.Getter<OffsetDateTime> s_offsetDateTimeGetter = new ResultSetUtilities.Getter<OffsetDateTime>(){

        @Override
        public OffsetDateTime get(IndexedJDBCDataSource indexedJDBCDataSource, int n, Class<OffsetDateTime> clazz) throws SQLException {
            assert (clazz == OffsetDateTime.class);
            Timestamp timestamp = indexedJDBCDataSource.getTimestamp(n);
            return timestamp == null ? null : OffsetDateTime.ofInstant(timestamp.toInstant(), s_utcZoneId);
        }
    };
    private static ResultSetUtilities.Getter<ZonedDateTime> s_zonedDateTimeGetter = new ResultSetUtilities.Getter<ZonedDateTime>(){

        @Override
        public ZonedDateTime get(IndexedJDBCDataSource indexedJDBCDataSource, int n, Class<ZonedDateTime> clazz) throws SQLException {
            assert (clazz == ZonedDateTime.class);
            Timestamp timestamp = indexedJDBCDataSource.getTimestamp(n);
            return timestamp == null ? null : timestamp.toInstant().atZone(s_utcZoneId);
        }
    };
    private static ResultSetUtilities.Getter<Instant> s_instantGetter = new ResultSetUtilities.Getter<Instant>(){

        @Override
        public Instant get(IndexedJDBCDataSource indexedJDBCDataSource, int n, Class<Instant> clazz) throws SQLException {
            assert (clazz == Instant.class);
            Timestamp timestamp = indexedJDBCDataSource.getTimestamp(n);
            return timestamp == null ? null : timestamp.toInstant();
        }
    };

    public static void getGetters(Map<Class<?>, ResultSetUtilities.Getter<?>> map) {
        map.put(LocalDate.class, s_localDateGetter);
        map.put(LocalDateTime.class, s_localDateTimeGetter);
        map.put(LocalTime.class, s_localTimeGetter);
        map.put(OffsetDateTime.class, s_offsetDateTimeGetter);
        map.put(ZonedDateTime.class, s_zonedDateTimeGetter);
        map.put(Instant.class, s_instantGetter);
    }
}

