/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.jdbc42.future;

import com.amazon.dsi.core.interfaces.IStatement;
import com.amazon.dsi.dataengine.utilities.SqlTypeWrapper;
import com.amazon.exceptions.ExceptionConverter;
import com.amazon.exceptions.JDBCMessageKey;
import com.amazon.jdbc.common.BaseStatement;
import com.amazon.jdbc.common.SConnection;
import com.amazon.jdbc.common.future.SPreparedStatement;
import com.amazon.jdbc.jdbc41.future.S41PreparedStatement;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ExceptionType;
import com.amazon.utilities.JDBCVersion;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.Collections;

public class S42PreparedStatement
extends S41PreparedStatement {
    public S42PreparedStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        this(string, iStatement, sConnection, n, JDBCVersion.JDBC42);
    }

    public S42PreparedStatement(String string, IStatement iStatement, SConnection sConnection, int n, JDBCVersion jDBCVersion) throws SQLException {
        super(string, iStatement, sConnection, n, jDBCVersion);
    }

    @Override
    public synchronized void setObject(final int n, final Object object, final SQLType sQLType) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.setNonStream(n, new SPreparedStatement.NonStreamSetter(){

            @Override
            public void set() throws SQLException {
                s_objectSetterWithSQLType.set(S42PreparedStatement.this, n, object, new SqlTypeWrapper(sQLType));
            }
        });
    }

    @Override
    public synchronized void setObject(final int n, final Object object, final SQLType sQLType, final int n2) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.setNonStream(n, new SPreparedStatement.NonStreamSetter(){

            @Override
            public void set() throws SQLException {
                S42PreparedStatement.this.m_tempPrimitiveStorage = n2;
                s_objectSetterWithSQLTypeAndScale.set(S42PreparedStatement.this, n, object, new SqlTypeWrapper(sQLType));
            }
        });
    }

    @Override
    public synchronized long[] executeLargeBatch() throws SQLException, BatchUpdateException {
        try {
            SPreparedStatement.BatchExecResult batchExecResult = this.executePreparedAnyBatch();
            switch (batchExecResult) {
                case BATCH_EXEC_NO_BATCHES: {
                    return new long[0];
                }
                case BATCH_EXEC_SUCCEEDED: {
                    return this.processLargeBatchResults(this.getResultsIterator(), Collections.emptyList(), BaseStatement.BaseBatchType.MULTI_PARAM_SET);
                }
            }
            throw new RuntimeException("Invalid enum value: " + batchExecResult.name());
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long executeLargeUpdate() throws SQLException {
        return this.executeAnyUpdate();
    }

    @Override
    public synchronized long executeLargeUpdate(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String string, int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, n);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String string, int[] nArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, nArray);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, stringArray);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long getLargeUpdateCount() throws SQLException {
        return this.getAnyUpdateCount();
    }

    @Override
    public synchronized long getLargeMaxRows() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_statement.getProperty(2).getLong();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setLargeMaxRows(long l) throws SQLException {
        this.setAnyMaxRows(l);
    }
}

