/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.jdbc42.future;

import com.amazon.dsi.core.interfaces.IStatement;
import com.amazon.dsi.dataengine.interfaces.future.IJDBCExecution;
import com.amazon.dsi.dataengine.utilities.SqlTypeWrapper;
import com.amazon.exceptions.ExceptionConverter;
import com.amazon.exceptions.JDBCMessageKey;
import com.amazon.jdbc.common.BaseStatement;
import com.amazon.jdbc.common.SConnection;
import com.amazon.jdbc.common.future.SPreparedStatement;
import com.amazon.jdbc.jdbc41.future.S41CallableStatement;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ExceptionType;
import com.amazon.utilities.JDBCVersion;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.Collections;

public class S42CallableStatement
extends S41CallableStatement {
    public S42CallableStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        this(string, iStatement, sConnection, n, JDBCVersion.JDBC42);
    }

    public S42CallableStatement(String string, IStatement iStatement, SConnection sConnection, int n, JDBCVersion jDBCVersion) throws SQLException {
        super(string, iStatement, sConnection, n, jDBCVersion);
    }

    @Override
    public synchronized void setObject(final int n, final Object object, final SQLType sQLType) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.setNonStream(n, new SPreparedStatement.NonStreamSetter(){

            @Override
            public void set() throws SQLException {
                s_objectSetterWithSQLType.set(S42CallableStatement.this, n, object, new SqlTypeWrapper(sQLType));
            }
        });
    }

    @Override
    public synchronized void setObject(final int n, final Object object, final SQLType sQLType, final int n2) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.setNonStream(n, new SPreparedStatement.NonStreamSetter(){

            @Override
            public void set() throws SQLException {
                S42CallableStatement.this.m_tempPrimitiveStorage = n2;
                s_objectSetterWithSQLTypeAndScale.set(S42CallableStatement.this, n, object, new SqlTypeWrapper(sQLType));
            }
        });
    }

    @Override
    public synchronized void setObject(String string, Object object, SQLType sQLType) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setObject(this.getParameterIndex(string), object, sQLType);
    }

    @Override
    public synchronized void setObject(String string, Object object, SQLType sQLType, int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setObject(this.getParameterIndex(string), object, sQLType, n);
    }

    @Override
    public synchronized long[] executeLargeBatch() throws SQLException, BatchUpdateException {
        try {
            SPreparedStatement.BatchExecResult batchExecResult = this.executePreparedAnyBatch();
            switch (batchExecResult) {
                case BATCH_EXEC_NO_BATCHES: {
                    return new long[0];
                }
                case BATCH_EXEC_SUCCEEDED: {
                    return this.processLargeBatchResults(this.getResultsIterator(), Collections.emptyList(), BaseStatement.BaseBatchType.MULTI_PARAM_SET);
                }
            }
            throw new RuntimeException("Invalid enum value: " + batchExecResult.name());
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long executeLargeUpdate() throws SQLException {
        return this.executeAnyUpdate();
    }

    @Override
    public synchronized long executeLargeUpdate(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String string, int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, n);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String string, int[] nArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, nArray);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, stringArray);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long getLargeUpdateCount() throws SQLException {
        return this.getAnyUpdateCount();
    }

    @Override
    public synchronized long getLargeMaxRows() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_statement.getProperty(2).getLong();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setLargeMaxRows(long l) throws SQLException {
        this.setAnyMaxRows(l);
    }

    @Override
    public synchronized void registerOutParameter(int n, SQLType sQLType) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, sQLType);
        this.registerOutputParameter(n, new IJDBCExecution.OutputParameterRegistration(new SqlTypeWrapper(sQLType)));
    }

    @Override
    public synchronized void registerOutParameter(int n, SQLType sQLType, int n2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, sQLType, n2);
        this.registerOutputParameter(n, new IJDBCExecution.OutputParameterRegistration((Object)new SqlTypeWrapper(sQLType), n2));
    }

    @Override
    public synchronized void registerOutParameter(int n, SQLType sQLType, String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, sQLType, string);
        this.registerOutputParameter(n, new IJDBCExecution.OutputParameterRegistration((Object)new SqlTypeWrapper(sQLType), string));
    }

    @Override
    public synchronized void registerOutParameter(String string, SQLType sQLType) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, sQLType);
        this.registerOutputParameter(this.getParameterIndex(string), new IJDBCExecution.OutputParameterRegistration(new SqlTypeWrapper(sQLType)));
    }

    @Override
    public synchronized void registerOutParameter(String string, SQLType sQLType, int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, sQLType, n);
        this.registerOutputParameter(this.getParameterIndex(string), new IJDBCExecution.OutputParameterRegistration((Object)new SqlTypeWrapper(sQLType), n));
    }

    @Override
    public synchronized void registerOutParameter(String string, SQLType sQLType, String string2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, sQLType, string2);
        this.registerOutputParameter(this.getParameterIndex(string), new IJDBCExecution.OutputParameterRegistration((Object)new SqlTypeWrapper(sQLType), string2));
    }
}

