/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.jdbc41.future;

import com.amazon.dsi.dataengine.interfaces.future.IResultSet;
import com.amazon.dsi.dataengine.utilities.MetadataSourceID;
import com.amazon.dsi.dataengine.utilities.OrderType;
import com.amazon.exceptions.ExceptionConverter;
import com.amazon.jdbc.common.SConnection;
import com.amazon.jdbc.common.future.SDatabaseMetaData;
import com.amazon.jdbc.jdbc41.future.S41ForwardResultSet;
import com.amazon.jdbc.jdbc41.future.S41MetaDataProxy;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class S41DatabaseMetaData
extends SDatabaseMetaData {
    public S41DatabaseMetaData(SConnection sConnection, ILogger iLogger) throws SQLException {
        super(sConnection, iLogger);
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 1;
    }

    @Override
    protected OrderType getJDBCOrderType() {
        return OrderType.JDBC_41;
    }

    @Override
    protected ResultSet wrapDSIMetadataResultSet(IResultSet iResultSet, MetadataSourceID metadataSourceID) throws SQLException {
        return new S41MetaDataProxy(this, iResultSet, metadataSourceID, this.m_logger);
    }

    @Override
    protected ResultSet wrapDSIResultSet(IResultSet iResultSet) throws SQLException {
        return new S41ForwardResultSet(this, iResultSet, this.m_logger);
    }

    @Override
    public ResultSet getPseudoColumns(String string, String string2, String string3, String string4) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, string2, string3, string4);
            this.checkParentConnection();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            arrayList.add(string2);
            arrayList.add(string3);
            arrayList.add(string4);
            return this.createMetaDataResult(MetadataSourceID.PSEUDO_COLUMNS_JDBC41, arrayList);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }
}

