/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.communications;

import com.amazon.exceptions.JDBCMessageKey;
import com.amazon.jdbc.communications.InboundMessagesContainer;
import com.amazon.jdbc.communications.exceptions.InboundErrorMessage;
import com.amazon.jdbc.communications.interfaces.AbstractInboundDataHandler;
import com.amazon.jdbc.communications.interfaces.IInboundMessage;
import com.amazon.jdbc.communications.interfaces.SocketCloseListener;
import com.amazon.jdbc.communications.interfaces.SocketCloseObservable;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.DiagState;
import com.amazon.support.exceptions.ErrorException;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class InboundMessagesPipeline
implements Closeable,
SocketCloseObservable {
    private static final int BLOCKING_QUEUE_CAPACITY = 1;
    protected static final int TIMEOUT_MS_WAIT = 20;
    public static final int TIMEOUT_MS_BLOCKING_QUEUE = 20;
    public static final int NO_REQUESTED_TIMEOUT = 0;
    private static final int NEXT_PEEK_TIMEOUT_MS = 50;
    private static final int MESSAGE_GRAB_TIMEOUT_MS = 200;
    public BlockingQueue<InboundMessagesContainer> m_messageContainersQueue;
    protected InboundMessagesContainer m_currentMessagesContainer;
    public IWarningListener m_warningListener;
    private AtomicBoolean m_hasOpenOperation = new AtomicBoolean(false);
    protected int m_nRowMode;
    public long m_currentMessageCount;
    public long m_totalMessageCount;
    protected ILogger m_log;
    protected AtomicBoolean m_close;
    public String m_query;
    public IInboundMessage m_peekedMessage = null;
    private List<SocketCloseListener> listeners = new ArrayList<SocketCloseListener>();
    private ErrorException m_fatalException = null;

    public InboundMessagesPipeline(int n, ILogger iLogger, IWarningListener iWarningListener) {
        this.m_log = iLogger;
        this.m_close = new AtomicBoolean(false);
        this.m_warningListener = iWarningListener;
        this.m_nRowMode = n;
        this.m_currentMessageCount = 0L;
        if (n > 0) {
            this.m_currentMessagesContainer = new InboundMessagesContainer(this.m_nRowMode);
            this.m_currentMessagesContainer.setInQueue();
        } else {
            this.initializeMessagesContainersQueue();
        }
    }

    protected abstract boolean handleMessage(IInboundMessage var1) throws ErrorException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getNextMessageOfClass(Class clazz, int n) throws ErrorException {
        boolean bl = false;
        if (n == 0) {
            n = 50;
        } else {
            bl = true;
        }
        while (!this.m_close.get() && (this.m_hasOpenOperation.get() || this.m_currentMessageCount < this.m_totalMessageCount)) {
            if (null != this.m_peekedMessage || this.validateCurrentContainer()) {
                IInboundMessage iInboundMessage = null;
                if (null != this.m_peekedMessage) {
                    iInboundMessage = this.m_peekedMessage;
                    this.m_peekedMessage = null;
                } else {
                    InboundMessagesPipeline inboundMessagesPipeline = this;
                    synchronized (inboundMessagesPipeline) {
                        if (this.isClosed()) {
                            return false;
                        }
                        iInboundMessage = this.m_currentMessagesContainer.next(n);
                    }
                }
                if (null != iInboundMessage) {
                    ++this.m_currentMessageCount;
                    if (!this.handleMessage(iInboundMessage)) {
                        return false;
                    }
                    if (clazz == null || clazz.isInstance(iInboundMessage)) {
                        return true;
                    }
                } else {
                    LogUtilities.logDebug("No message found", this.m_log);
                }
            }
            if (!bl) continue;
            return false;
        }
        return false;
    }

    public IInboundMessage peekNextMessage(int n) throws ErrorException {
        if (null != this.m_peekedMessage) {
            return this.m_peekedMessage;
        }
        while (!this.m_close.get()) {
            if (!this.validateCurrentContainer()) continue;
            this.m_peekedMessage = this.m_currentMessagesContainer.next(n);
            if (null != this.m_peekedMessage) {
                return this.m_peekedMessage;
            }
            if (n <= 0) continue;
            return null;
        }
        return null;
    }

    public boolean validateCurrentContainer() {
        if (this.m_nRowMode > 0) {
            return null != this.m_currentMessagesContainer && !this.m_currentMessagesContainer.isClosed();
        }
        if (null != this.m_currentMessagesContainer && !this.m_currentMessagesContainer.isClosed() && this.m_currentMessagesContainer.hasNext()) {
            return true;
        }
        this.m_currentMessagesContainer = null;
        while (!(this.m_close.get() || null != this.m_currentMessagesContainer || this.m_messageContainersQueue.isEmpty() && this.m_messageContainersQueue.isEmpty() && !this.m_hasOpenOperation.get())) {
            try {
                this.m_currentMessagesContainer = this.m_messageContainersQueue.poll(20L, TimeUnit.MILLISECONDS);
                if (null != this.m_currentMessagesContainer) {
                    return true;
                }
                if (!this.m_log.isEnabled()) continue;
                LogUtilities.logDebug("InboundMessagePipeline waited", this.m_log);
            }
            catch (InterruptedException interruptedException) {
                ErrorException errorException = new ErrorException(DiagState.DIAG_OPER_CANCELED, 1, JDBCMessageKey.OPERATION_CANCELED.name());
                this.close(errorException);
            }
        }
        return false;
    }

    public void openCurrentOperation() {
        this.m_hasOpenOperation.set(true);
    }

    public void closeCurrentOperation() {
        this.m_hasOpenOperation.set(false);
    }

    public boolean hasOpenOperation() {
        return this.m_hasOpenOperation.get();
    }

    public void setWarningListener(IWarningListener iWarningListener) {
        this.m_warningListener = iWarningListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        InboundMessagesPipeline inboundMessagesPipeline = this;
        synchronized (inboundMessagesPipeline) {
            this.m_close.set(true);
            if (null != this.m_currentMessagesContainer) {
                this.m_currentMessagesContainer.close();
            }
            while (this.validateCurrentContainer()) {
                if (null == this.m_currentMessagesContainer) continue;
                this.m_currentMessagesContainer.close();
            }
        }
    }

    @Override
    public void addSocketCloseListener(SocketCloseListener socketCloseListener) {
        this.listeners.add(socketCloseListener);
    }

    @Override
    public void removeSocketCloseListener(SocketCloseListener socketCloseListener) {
        this.listeners.remove(socketCloseListener);
    }

    public void close(ErrorException errorException) {
        for (SocketCloseListener socketCloseListener : this.listeners) {
            socketCloseListener.socketClosed(errorException);
        }
        if (null != errorException) {
            this.m_fatalException = errorException;
        }
        this.close();
    }

    public int getNRowMode() {
        return this.m_nRowMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNRowMode(int n, AbstractInboundDataHandler abstractInboundDataHandler) throws InboundErrorMessage {
        block12: {
            LogUtilities.logFunctionEntrance(this.m_log, n);
            abstractInboundDataHandler.m_addToPipelineLock.lock();
            try {
                InboundMessagesContainer inboundMessagesContainer;
                if (n == this.m_nRowMode) {
                    return;
                }
                this.m_nRowMode = n;
                if (null == this.m_currentMessagesContainer) {
                    this.m_currentMessagesContainer = new InboundMessagesContainer(this.m_nRowMode);
                    this.m_currentMessagesContainer.setInQueue();
                } else {
                    inboundMessagesContainer = this.m_currentMessagesContainer;
                    this.m_currentMessagesContainer = new InboundMessagesContainer(this.m_nRowMode);
                    while (inboundMessagesContainer.hasNext()) {
                        this.m_currentMessagesContainer.add(inboundMessagesContainer.next(200));
                    }
                    this.m_currentMessagesContainer.setInQueue();
                }
                if (null == this.m_messageContainersQueue && 0 == this.m_nRowMode) {
                    this.initializeMessagesContainersQueue();
                }
                if (null == this.m_messageContainersQueue) break block12;
                inboundMessagesContainer = null;
                try {
                    inboundMessagesContainer = this.m_messageContainersQueue.poll(200L, TimeUnit.MILLISECONDS);
                    while (null != inboundMessagesContainer && inboundMessagesContainer.hasNext()) {
                        this.m_currentMessagesContainer.add(inboundMessagesContainer.next(200));
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                abstractInboundDataHandler.m_addToPipelineLock.unlock();
            }
        }
    }

    private boolean isClosed() throws ErrorException {
        if (this.m_close.get()) {
            if (null != this.m_fatalException) {
                throw this.m_fatalException;
            }
            return true;
        }
        return false;
    }

    public ErrorException receivedFatalExeption() {
        return this.m_fatalException;
    }

    public InboundMessagesContainer getCurrentMessagesContainer() {
        return this.m_currentMessagesContainer;
    }

    private void initializeMessagesContainersQueue() {
        this.m_messageContainersQueue = new ArrayBlockingQueue<InboundMessagesContainer>(1, true);
    }
}

