/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.common.utilities;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public final class NameToIndexMap {
    private final String[] m_names;
    private final int[] m_indices;

    private NameToIndexMap(SortedMap<String, Integer> sortedMap) {
        this.m_names = new String[sortedMap.size()];
        this.m_indices = new int[sortedMap.size()];
        int n = 0;
        for (Map.Entry<String, Integer> entry : sortedMap.entrySet()) {
            this.m_names[n] = entry.getKey();
            this.m_indices[n] = entry.getValue();
            ++n;
        }
    }

    private static <T> SortedMap<String, Integer> listToMap(List<? extends T> list, NameGetter<T> nameGetter) {
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < list.size(); ++i) {
            String string = nameGetter.getName(list.get(i));
            if (string == null || treeMap.containsKey(string)) continue;
            treeMap.put(string, i + 1);
        }
        return treeMap;
    }

    public <T> NameToIndexMap(List<? extends T> list, NameGetter<T> nameGetter) {
        this(NameToIndexMap.listToMap(list, nameGetter));
    }

    public int getIndex(String string) {
        int n = Arrays.binarySearch(this.m_names, string, String.CASE_INSENSITIVE_ORDER);
        if (n < 0) {
            return 0;
        }
        return this.m_indices[n];
    }

    public static interface NameGetter<T> {
        public String getName(T var1);
    }
}

