/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.common.future;

import com.amazon.dsi.core.interfaces.IStatement;
import com.amazon.dsi.dataengine.impl.DSIErrorResult;
import com.amazon.dsi.dataengine.impl.DSISimpleRowCountResult;
import com.amazon.dsi.dataengine.interfaces.IErrorResult;
import com.amazon.dsi.dataengine.interfaces.IRowCountResult;
import com.amazon.dsi.dataengine.interfaces.future.IBatchResult;
import com.amazon.dsi.dataengine.interfaces.future.IDataEngine;
import com.amazon.dsi.dataengine.interfaces.future.IExecution;
import com.amazon.dsi.dataengine.interfaces.future.IOutputConsumer;
import com.amazon.dsi.dataengine.interfaces.future.IQueryExecutor;
import com.amazon.dsi.dataengine.interfaces.future.IResultSet;
import com.amazon.dsi.dataengine.interfaces.future.IResults;
import com.amazon.dsi.dataengine.utilities.ExecutionResult;
import com.amazon.dsi.dataengine.utilities.ExecutionResultType;
import com.amazon.dsi.dataengine.utilities.ParameterGeneratedValues;
import com.amazon.exceptions.ExceptionConverter;
import com.amazon.exceptions.JDBCMessageKey;
import com.amazon.jdbc.common.BaseStatement;
import com.amazon.jdbc.common.SConnection;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionType;
import com.amazon.utilities.FunctionID;
import java.sql.BatchUpdateException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class SStatement
extends BaseStatement<IResultSet> {
    private final SConnection m_parentConnection;
    protected final IDataEngine m_dataEngine;
    protected IQueryExecutor m_queryExecutor = null;
    protected IExecution m_execution = null;
    protected IResults m_results = null;
    private Iterator<ExecutionResult> m_resultIterator = null;
    private final List<BaseStatement.BaseResultContext> m_resultSets = new ArrayList<BaseStatement.BaseResultContext>();

    public SStatement(IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        super(sConnection, iStatement, n);
        try {
            this.m_parentConnection = sConnection;
            this.m_dataEngine = (IDataEngine)((Object)iStatement.createDataEngine());
        }
        catch (ErrorException errorException) {
            try {
                iStatement.close();
            }
            catch (ErrorException errorException2) {
                // empty catch block
            }
            throw ExceptionConverter.getInstance().toSQLException(errorException, this.m_warningListener);
        }
    }

    @Override
    protected void doCancel() throws ErrorException {
        if (this.m_execution != null) {
            this.m_execution.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeDSIIObjects(boolean bl) {
        IResults iResults;
        IExecution iExecution;
        IQueryExecutor iQueryExecutor;
        this.m_resultIterator = null;
        Object object = this.m_cancelLock;
        synchronized (object) {
            if (bl) {
                iQueryExecutor = this.m_queryExecutor;
                this.m_queryExecutor = null;
            } else {
                iQueryExecutor = null;
            }
            iExecution = this.m_execution;
            this.m_execution = null;
            iResults = this.m_results;
            this.m_results = null;
        }
        if (iResults != null) {
            iResults.close();
        }
        if (iExecution != null) {
            iExecution.close();
        }
        if (iQueryExecutor != null) {
            iQueryExecutor.close();
        }
    }

    @Override
    protected void doClose() {
        this.closeDSIIObjects(true);
    }

    @Override
    protected final List<? extends BaseStatement.BaseResultContext> getResultsets() {
        return this.m_resultSets;
    }

    @Override
    protected final boolean hasNextResult() {
        try {
            Iterator<ExecutionResult> iterator = this.getResultsIterator();
            return iterator != null && iterator.hasNext();
        }
        catch (ErrorException errorException) {
            throw new RuntimeException(errorException);
        }
    }

    protected IOutputConsumer getOutputConsumer() {
        return new NoParamsOutputConsumer();
    }

    @Override
    protected final Iterator<ExecutionResult> getResultsIterator() throws ErrorException {
        if (this.m_results == null) {
            return null;
        }
        if (this.m_resultIterator == null) {
            this.m_resultIterator = new Iterator<ExecutionResult>(){
                private final IOutputConsumer m_outputConsumer;
                private ExecutionResult m_cachedNextResult;
                {
                    this.m_outputConsumer = SStatement.this.getOutputConsumer();
                    this.m_cachedNextResult = null;
                }

                @Override
                public boolean hasNext() {
                    try {
                        if (this.m_cachedNextResult != null) {
                            return true;
                        }
                        Boolean bl = SStatement.this.m_results.hasNext();
                        if (bl == null) {
                            this.m_cachedNextResult = this.next();
                            bl = this.m_cachedNextResult != null;
                        }
                        return bl;
                    }
                    catch (ErrorException errorException) {
                        throw new RuntimeException(errorException);
                    }
                }

                @Override
                public ExecutionResult next() {
                    try {
                        if (this.m_cachedNextResult != null) {
                            ExecutionResult executionResult = this.m_cachedNextResult;
                            this.m_cachedNextResult = null;
                            return executionResult;
                        }
                        return SStatement.this.m_results.next(this.m_outputConsumer);
                    }
                    catch (ErrorException errorException) {
                        throw new RuntimeException(errorException);
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return this.m_resultIterator;
    }

    @Override
    protected void executeAnyBatch() throws SQLException, BatchUpdateException {
        assert (!(this instanceof PreparedStatement));
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        new CancelableFunction(){

            @Override
            protected void doExecute() throws ErrorException, SQLException {
                try {
                    SStatement.this.clearResultsFromPreviousExecution();
                    SStatement.this.getParentConnection().beginTransaction();
                    SStatement.this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_EXECUTE);
                    if (this.isCanceled()) {
                        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.OPERATION_CANCELED, (IWarningListener)SStatement.this.m_warningListener, ExceptionType.TRANSIENT, new Object[0]);
                    }
                    final List list = SStatement.this.getBatchSqlStatements();
                    final IBatchResult iBatchResult = SStatement.this.m_dataEngine.executeBatch(list);
                    SStatement.this.m_results = new IResults(){
                        int m_resultsLeftToReturn;
                        {
                            this.m_resultsLeftToReturn = list.size();
                        }

                        @Override
                        public ExecutionResult next(IOutputConsumer iOutputConsumer) throws ErrorException {
                            assert (this.m_resultsLeftToReturn > 0);
                            --this.m_resultsLeftToReturn;
                            IBatchResult.ResultType resultType = iBatchResult.next();
                            switch (resultType) {
                                case ERROR: {
                                    return new ExecutionResult(new DSIErrorResult(iBatchResult.getError()), false);
                                }
                                case ROWCOUNT: {
                                    return new ExecutionResult(new DSISimpleRowCountResult(iBatchResult.getRowCount()));
                                }
                            }
                            throw new RuntimeException("Unexpected enum value " + (Object)((Object)resultType));
                        }

                        @Override
                        public Boolean hasNext() {
                            return this.m_resultsLeftToReturn > 0;
                        }

                        @Override
                        public void close() {
                            iBatchResult.close();
                        }
                    };
                }
                finally {
                    SStatement.this.clearBatchSqlStatements();
                }
            }

            @Override
            protected boolean shouldCheckIfOpen() {
                return true;
            }
        }.execute();
    }

    @Override
    public SConnection getParentConnection() {
        return this.m_parentConnection;
    }

    protected final BaseStatement.BaseResultContext createResultPair(ExecutionResult executionResult) throws SQLException {
        if (ExecutionResultType.ROW_COUNT == executionResult.getType()) {
            IRowCountResult iRowCountResult = (IRowCountResult)executionResult.getResult();
            return new BaseStatement.BaseResultContext(iRowCountResult);
        }
        if (ExecutionResultType.RESULT_SET == executionResult.getType()) {
            ResultSet resultSet = this.createResultSet(executionResult);
            return new BaseStatement.BaseResultContext(resultSet);
        }
        if (ExecutionResultType.ERROR_RESULT_SET == executionResult.getType()) {
            IErrorResult iErrorResult = (IErrorResult)executionResult.getResult();
            return new BaseStatement.BaseResultContext(iErrorResult, true);
        }
        IErrorResult iErrorResult = (IErrorResult)executionResult.getResult();
        return new BaseStatement.BaseResultContext(iErrorResult, false);
    }

    @Override
    protected void addResultPair(ExecutionResult executionResult) {
        try {
            this.m_resultSets.add(this.createResultPair(executionResult));
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    @Override
    protected void addResultSet(ResultSet resultSet) {
        this.m_resultSets.add(new BaseStatement.BaseResultContext(resultSet));
    }

    @Override
    protected void doClearResults() {
        this.m_resultIterator = null;
        if (this.m_results != null) {
            try {
                this.m_results.close();
            }
            finally {
                this.m_results = null;
            }
        }
    }

    @Override
    protected ExecutionResult getNextResult() throws SQLException {
        try {
            assert (this.getResultsIterator().hasNext());
            return this.getResultsIterator().next();
        }
        catch (ErrorException errorException) {
            throw ExceptionConverter.getInstance().toSQLException(errorException, this.m_warningListener, this.m_logger);
        }
    }

    protected void doPrepare(String string, boolean bl, boolean bl2, boolean bl3) throws SQLException {
        try {
            if (bl) {
                this.getParentConnection().beginTransaction();
            }
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_PREPARE);
            IDataEngine.PrepareParameters prepareParameters = new IDataEngine.PrepareParameters(this.doSqlNativeSqlIfNeeded(string));
            if (bl2) {
                prepareParameters.setDirectExecute();
            }
            if (!bl3) {
                prepareParameters.setMetadataNeeded(false);
            }
            this.m_queryExecutor = this.m_dataEngine.prepareQuery(prepareParameters);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    protected void clearResultsFromPreviousExecution() {
        this.clearResults();
        this.closeDSIIObjects(true);
    }

    @Override
    protected void executeNoParams(final String string, final ParameterGeneratedValues parameterGeneratedValues, final BaseStatement.BaseThrowCondition baseThrowCondition) throws SQLException {
        new CancelableFunction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void doExecute() throws ErrorException, SQLException {
                try {
                    SStatement.this.clearResultsFromPreviousExecution();
                    boolean bl = true;
                    if (BaseStatement.BaseThrowCondition.None == baseThrowCondition) {
                        bl = false;
                    }
                    SStatement.this.doPrepare(string, true, true, bl);
                    if (this.isCanceled()) {
                        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.OPERATION_CANCELED, (IWarningListener)SStatement.this.m_warningListener, ExceptionType.TRANSIENT, new Object[0]);
                    }
                    if (SStatement.this.m_queryExecutor.getNumParams() != 0) {
                        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_PARAM, (IWarningListener)SStatement.this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                    }
                    SStatement.this.checkCondition(string, baseThrowCondition);
                    SStatement.this.m_warningListener.setCurrentFunction(FunctionID.STATEMENT_EXECUTE);
                    Object object = SStatement.this.m_cancelLock;
                    synchronized (object) {
                        SStatement.this.m_execution = SStatement.this.m_queryExecutor.startNewExecution(1L, null);
                    }
                    SStatement.this.m_execution.addBatch();
                    SStatement.this.m_results = SStatement.this.m_execution.execute(parameterGeneratedValues, new NoParamsOutputConsumer());
                    assert (SStatement.this.m_results != null);
                }
                catch (Exception exception) {
                    SStatement.this.closeDSIIObjects(true);
                    throw ExceptionConverter.getInstance().toSQLException(exception, SStatement.this.m_warningListener, SStatement.this.m_logger);
                }
            }
        }.execute();
    }

    @Override
    protected ResultSet createResultSet(IResultSet iResultSet, boolean bl, int n) throws SQLException {
        ResultSet resultSet = this.m_parentConnection.getJDBCObjectFactory().newResultSet(this, iResultSet, bl, this.getLogger());
        resultSet.setFetchSize(n);
        return resultSet;
    }

    protected abstract class CancelableFunction {
        protected CancelableFunction() {
        }

        protected abstract void doExecute() throws ErrorException, SQLException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() throws SQLException {
            if (this.shouldCheckIfOpen()) {
                SStatement.this.checkIfOpen();
            }
            Object object = SStatement.this.m_cancelLock;
            synchronized (object) {
                assert (!SStatement.this.m_isInCancelableFunction);
                assert (!SStatement.this.m_isCanceled);
                SStatement.this.m_isInCancelableFunction = true;
            }
            try {
                this.doExecute();
            }
            catch (ErrorException errorException) {
                throw ExceptionConverter.getInstance().toSQLException(errorException, SStatement.this.m_warningListener, SStatement.this.m_logger);
            }
            finally {
                Object object2 = SStatement.this.m_cancelLock;
                synchronized (object2) {
                    assert (SStatement.this.m_isInCancelableFunction);
                    SStatement.this.m_isInCancelableFunction = false;
                    SStatement.this.m_isCanceled = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean isCanceled() {
            Object object = SStatement.this.m_cancelLock;
            synchronized (object) {
                return SStatement.this.m_isCanceled;
            }
        }

        protected boolean shouldCheckIfOpen() {
            return false;
        }
    }

    private class NoParamsOutputConsumer
    implements IOutputConsumer {
        private boolean m_hasMovedToFirstSet = false;

        private NoParamsOutputConsumer() {
        }

        @Override
        public int getNextParameterSet() throws ErrorException {
            return this.m_hasMovedToFirstSet ? 0 : 1;
        }

        @Override
        public void notifyParameterSetFailed() throws ErrorException {
            this.m_hasMovedToFirstSet = true;
        }

        @Override
        public void notifyParameterSetSucceeded() throws ErrorException {
            this.m_hasMovedToFirstSet = true;
        }

        @Override
        public void notifyParameterSetNotExecuted() throws ErrorException {
            this.m_hasMovedToFirstSet = true;
        }
    }
}

