/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.common;

import com.amazon.dsi.core.interfaces.IConnection;
import com.amazon.dsi.dataengine.interfaces.IArray;
import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.interfaces.IResultSet;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.exceptions.IncorrectTypeException;
import com.amazon.exceptions.ExceptionConverter;
import com.amazon.exceptions.JDBCMessageKey;
import com.amazon.jdbc.common.BaseForwardResultSet;
import com.amazon.jdbc.common.SArray;
import com.amazon.jdbc.common.SStatement;
import com.amazon.streams.IStream;
import com.amazon.streams.resultset.AsciiStream;
import com.amazon.streams.resultset.BinaryStream;
import com.amazon.streams.resultset.CharacterStream;
import com.amazon.streams.resultset.UnicodeStream;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ExceptionType;
import com.amazon.utilities.TypeNames;
import com.amazon.utilities.conversion.TypeConverter;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public abstract class SForwardResultSet
extends BaseForwardResultSet<SStatement, IResultSet> {
    protected List<DataWrapper> m_cachedDataWrappers = null;
    protected IStream m_currentStream = null;
    protected int m_streamBufferSize;

    protected SForwardResultSet(SStatement sStatement, IResultSet iResultSet, ILogger iLogger) throws SQLException {
        super(sStatement, iResultSet, iLogger);
        if (sStatement != null) {
            this.m_streamBufferSize = this.getStreamBufferSize();
        }
    }

    @Override
    protected void initializeColumnNameMap() throws SQLException {
        if (this.m_cachedDataWrappers == null) {
            super.initializeColumnNameMap();
            int n = this.getMetaData().getColumnCount();
            this.m_cachedDataWrappers = new ArrayList<DataWrapper>(n);
            for (int i = 0; i < n; ++i) {
                this.m_cachedDataWrappers.add(new DataWrapper());
            }
        }
    }

    @Override
    protected void closeCurrentStream() throws SQLException {
        if (null == this.m_currentStream) {
            return;
        }
        try {
            this.m_currentStream.close();
            this.m_currentStream = null;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }

    protected int getStreamBufferSize() throws SQLException {
        try {
            IConnection iConnection = this.getParentConnection();
            int n = iConnection.getProperty(1007).getInt();
            return n > 0 ? n : 32000;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Array getArray(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                IArray iArray = dataWrapper.getArray();
                this.m_wasLastValueNull = dataWrapper.isNull();
                if (dataWrapper.isNull()) {
                    return null;
                }
                return this.createArrayResult(iArray);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(2003));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, 0L);
            if (TypeConverter.canConvertStreamFrom(dataWrapper.getType(), -1)) {
                this.m_wasLastValueNull = dataWrapper.isNull();
                if (dataWrapper.isNull()) {
                    return null;
                }
                AsciiStream asciiStream = new AsciiStream((IResultSet)this.m_resultSet, n - 1, this.m_streamBufferSize);
                this.m_currentStream = asciiStream;
                return asciiStream;
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), "AsciiStream");
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                this.m_wasLastValueNull = dataWrapper.isNull();
                return TypeConverter.toBigDecimal(dataWrapper, this.m_warningListener);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(2));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, n2);
        BigDecimal bigDecimal = this.getBigDecimal(n);
        if (null != bigDecimal) {
            return bigDecimal.setScale(n2, RoundingMode.HALF_UP);
        }
        return null;
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, 0L);
            if (TypeConverter.canConvertStreamFrom(dataWrapper.getType(), -4)) {
                this.m_wasLastValueNull = dataWrapper.isNull();
                if (dataWrapper.isNull()) {
                    return null;
                }
                BinaryStream binaryStream = new BinaryStream((IResultSet)this.m_resultSet, n - 1, this.m_streamBufferSize);
                this.m_currentStream = binaryStream;
                return binaryStream;
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), "BinaryStream");
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(n);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                this.m_wasLastValueNull = dataWrapper.isNull();
                return TypeConverter.toBoolean(dataWrapper, this.m_warningListener);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(16));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public byte getByte(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                this.m_wasLastValueNull = dataWrapper.isNull();
                return TypeConverter.toByte(dataWrapper, this.m_warningListener);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(-6));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                this.m_wasLastValueNull = dataWrapper.isNull();
                return TypeConverter.toBytes(dataWrapper);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(-2));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, 0L);
            if (TypeConverter.canConvertStreamFrom(dataWrapper.getType(), -1)) {
                this.m_wasLastValueNull = dataWrapper.isNull();
                if (dataWrapper.isNull()) {
                    return null;
                }
                CharacterStream characterStream = new CharacterStream((IResultSet)this.m_resultSet, n - 1, this.m_streamBufferSize);
                this.m_currentStream = characterStream;
                return characterStream;
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), "CharacterStream");
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(n);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Date getDate(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                Date date = TypeConverter.toDate(dataWrapper, this.m_warningListener);
                this.m_wasLastValueNull = dataWrapper.isNull();
                return date;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(91));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, calendar);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                Date date = TypeConverter.toDate(dataWrapper, calendar, this.m_warningListener);
                this.m_wasLastValueNull = dataWrapper.isNull();
                return date;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(91));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public double getDouble(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                this.m_wasLastValueNull = dataWrapper.isNull();
                return TypeConverter.toDouble(dataWrapper, this.m_warningListener);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(8));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public float getFloat(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                this.m_wasLastValueNull = dataWrapper.isNull();
                return TypeConverter.toFloat(dataWrapper, this.m_warningListener);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(7));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getInt(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                this.m_wasLastValueNull = dataWrapper.isNull();
                return TypeConverter.toInt(dataWrapper, this.m_warningListener);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(4));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public long getLong(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                this.m_wasLastValueNull = dataWrapper.isNull();
                return TypeConverter.toLong(dataWrapper, this.m_warningListener);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(-5));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Object getObject(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                IColumn iColumn = (IColumn)this.m_resultSetColumns.get(n - 1);
                if (2003 == iColumn.getTypeMetadata().getType()) {
                    return this.getArray(n);
                }
                Object object = TypeConverter.toObject(dataWrapper, iColumn.getTypeMetadata(), this.m_warningListener);
                this.m_wasLastValueNull = dataWrapper.isNull();
                return object;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(2000));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, map);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(n);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(n);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public short getShort(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                this.m_wasLastValueNull = dataWrapper.isNull();
                return TypeConverter.toShort(dataWrapper, this.m_warningListener);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(5));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getString(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                this.m_wasLastValueNull = dataWrapper.isNull();
                IColumn iColumn = (IColumn)this.m_resultSetColumns.get(n - 1);
                return TypeConverter.toString(dataWrapper, iColumn.getTypeMetadata());
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(12));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Time getTime(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                IColumn iColumn = (IColumn)this.m_resultSetColumns.get(n - 1);
                Time time = TypeConverter.toTime(dataWrapper, iColumn.getTypeMetadata(), this.m_warningListener);
                this.m_wasLastValueNull = dataWrapper.isNull();
                return time;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(92));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                IColumn iColumn = (IColumn)this.m_resultSetColumns.get(n - 1);
                Time time = TypeConverter.toTime(dataWrapper, calendar, iColumn.getTypeMetadata(), this.m_warningListener);
                this.m_wasLastValueNull = dataWrapper.isNull();
                return time;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(92));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                this.m_wasLastValueNull = dataWrapper.isNull();
                IColumn iColumn = (IColumn)this.m_resultSetColumns.get(n - 1);
                return TypeConverter.toTimestamp(dataWrapper, iColumn.getTypeMetadata(), this.m_warningListener);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(93));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, calendar);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                this.m_wasLastValueNull = dataWrapper.isNull();
                IColumn iColumn = (IColumn)this.m_resultSetColumns.get(n - 1);
                return TypeConverter.toTimestamp(dataWrapper, calendar, iColumn.getTypeMetadata(), this.m_warningListener);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(93));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, 0L);
            if (TypeConverter.canConvertStreamFrom(dataWrapper.getType(), -1)) {
                this.m_wasLastValueNull = dataWrapper.isNull();
                if (dataWrapper.isNull()) {
                    return null;
                }
                UnicodeStream unicodeStream = new UnicodeStream((IResultSet)this.m_resultSet, n - 1, this.m_streamBufferSize);
                this.m_currentStream = unicodeStream;
                return unicodeStream;
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), "UnicodeStream");
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public URL getURL(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(n);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n);
        this.checkIfOpen();
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public NClob getNClob(int n) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n);
        this.checkIfOpen();
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public String getNString(int n) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n);
        this.checkIfOpen();
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public RowId getRowId(int n) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n);
        this.checkIfOpen();
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n);
        this.checkIfOpen();
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    protected SArray createArrayResult(IArray iArray) throws SQLException {
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.FEATURE_NOT_SUPPORTED, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, "getArray");
    }

    protected DataWrapper getData(int n, long l) throws SQLException {
        this.checkIfValidColumnNumber(n);
        this.checkIfValidRowNumber();
        --n;
        try {
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n);
            ((IResultSet)this.m_resultSet).getData(n, 0L, l, dataWrapper);
            return dataWrapper;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }
}

