/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.common;

import com.amazon.dsi.core.utilities.Variant;
import com.amazon.jdbc.exceptions.CommonJDBCMessageKey;
import com.amazon.support.IWarningListener;
import com.amazon.support.Warning;
import com.amazon.support.WarningCode;

public enum OAuthFlow {
    TOKEN_PASSTHROUGH,
    CLIENT_CREDENTIALS;


    public static OAuthFlow convertToOAuthFlow(Variant variant, IWarningListener iWarningListener) {
        try {
            int n = variant.getInt();
            if (n >= 0 && n < OAuthFlow.values().length) {
                return OAuthFlow.values()[n];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null != iWarningListener) {
            iWarningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 105, CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"Auth_Flow", variant.getString(), "Invalid OAuth flow value"}));
        }
        return null;
    }
}

