/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.common;

import com.amazon.jdbc.common.SConnection;
import com.amazon.jdbc.interfaces.IConnectionHandle;
import com.amazon.jdbc.interfaces.IPooledConnection;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;

public abstract class BasePooledConnection
implements IPooledConnection {
    private final List<ConnectionEventListener> m_listeners = new CopyOnWriteArrayList<ConnectionEventListener>();
    private final List<StatementEventListener> m_statementlisteners = new CopyOnWriteArrayList<StatementEventListener>();
    private IConnectionHandle m_connectionHandle;
    protected ILogger m_logger;

    public BasePooledConnection(SConnection sConnection) throws SQLException {
        this.m_logger = sConnection.getConnection().getConnectionLog();
        LogUtilities.logFunctionEntrance(this.m_logger, sConnection);
        this.m_connectionHandle = this.createConnectionHandle(sConnection);
    }

    public abstract IConnectionHandle createConnectionHandle(SConnection var1) throws SQLException;

    @Override
    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        LogUtilities.logFunctionEntrance(this.m_logger, connectionEventListener);
        this.m_listeners.add(this.ensureNotNull(connectionEventListener));
    }

    @Override
    public void close() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_connectionHandle.forceClose();
    }

    @Override
    public Connection getConnection() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_connectionHandle.open();
        return this.m_connectionHandle;
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        LogUtilities.logFunctionEntrance(this.m_logger, connectionEventListener);
        this.m_listeners.remove(this.ensureNotNull(connectionEventListener));
    }

    @Override
    public void addStatementEventListener(StatementEventListener statementEventListener) {
        LogUtilities.logFunctionEntrance(this.m_logger, statementEventListener);
        this.m_statementlisteners.add(this.ensureNotNull(statementEventListener));
    }

    @Override
    public void removeStatementEventListener(StatementEventListener statementEventListener) {
        LogUtilities.logFunctionEntrance(this.m_logger, statementEventListener);
        this.m_statementlisteners.remove(this.ensureNotNull(statementEventListener));
    }

    @Override
    public void onHandleError(SQLException sQLException) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        ConnectionEvent connectionEvent = new ConnectionEvent(this, sQLException);
        for (ConnectionEventListener connectionEventListener : this.m_listeners) {
            connectionEventListener.connectionErrorOccurred(connectionEvent);
        }
    }

    @Override
    public void onHandleStatementClose(PreparedStatement preparedStatement) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        StatementEvent statementEvent = new StatementEvent(this, preparedStatement);
        for (StatementEventListener statementEventListener : this.m_statementlisteners) {
            statementEventListener.statementClosed(statementEvent);
        }
    }

    @Override
    public void onHandleStatementError(PreparedStatement preparedStatement, SQLException sQLException) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        StatementEvent statementEvent = new StatementEvent(this, preparedStatement, sQLException);
        for (StatementEventListener statementEventListener : this.m_statementlisteners) {
            statementEventListener.statementErrorOccurred(statementEvent);
        }
    }

    @Override
    public void onHandleClose() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        ConnectionEvent connectionEvent = new ConnectionEvent(this);
        for (ConnectionEventListener connectionEventListener : this.m_listeners) {
            connectionEventListener.connectionClosed(connectionEvent);
        }
    }

    private <S> S ensureNotNull(S s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        return s;
    }
}

