/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dsi.ext.aetree;

import java.security.InvalidParameterException;

public enum ComparisonType {
    EQUAL,
    NOT_EQUAL,
    GREATER_THAN,
    GREATER_THAN_OR_EQUAL,
    LESS_THAN,
    LESS_THAN_OR_EQUAL,
    INVALID;

    private static final ComparisonType[] s_mappingTable;

    public static final ComparisonType getType(int n) {
        if (-1 == n) {
            return INVALID;
        }
        if (0 <= n && s_mappingTable.length > n) {
            return s_mappingTable[n];
        }
        throw new InvalidParameterException();
    }

    public static final ComparisonType reverse(ComparisonType comparisonType) {
        switch (comparisonType) {
            case GREATER_THAN: {
                return LESS_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return LESS_THAN_OR_EQUAL;
            }
            case LESS_THAN: {
                return GREATER_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return GREATER_THAN_OR_EQUAL;
            }
        }
        return comparisonType;
    }

    public String toString() {
        switch (this) {
            case EQUAL: {
                return " = ";
            }
            case NOT_EQUAL: {
                return " <> ";
            }
            case GREATER_THAN: {
                return " > ";
            }
            case GREATER_THAN_OR_EQUAL: {
                return " >= ";
            }
            case LESS_THAN: {
                return " <= ";
            }
            case LESS_THAN_OR_EQUAL: {
                return " < ";
            }
        }
        return " [ERROR: Unknown comparison type] ";
    }

    static {
        s_mappingTable = ComparisonType.values();
    }
}

