/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dsi.ext.aetree;

import com.amazon.dsi.ext.aetree.AEAdd;
import com.amazon.dsi.ext.aetree.AEAggrFunction;
import com.amazon.dsi.ext.aetree.AEAggregate;
import com.amazon.dsi.ext.aetree.AEAnd;
import com.amazon.dsi.ext.aetree.AEBooleanTrue;
import com.amazon.dsi.ext.aetree.AECastFn;
import com.amazon.dsi.ext.aetree.AEColumn;
import com.amazon.dsi.ext.aetree.AEComparison;
import com.amazon.dsi.ext.aetree.AECountStarAggrFunction;
import com.amazon.dsi.ext.aetree.AECrossJoin;
import com.amazon.dsi.ext.aetree.AEDistinct;
import com.amazon.dsi.ext.aetree.AEDivide;
import com.amazon.dsi.ext.aetree.AEDummyTable;
import com.amazon.dsi.ext.aetree.AEExistsPredicate;
import com.amazon.dsi.ext.aetree.AEInPredicate;
import com.amazon.dsi.ext.aetree.AEIntervalLiteral;
import com.amazon.dsi.ext.aetree.AEJoin;
import com.amazon.dsi.ext.aetree.AELikePredicate;
import com.amazon.dsi.ext.aetree.AELiteral;
import com.amazon.dsi.ext.aetree.AEMultiply;
import com.amazon.dsi.ext.aetree.AENegate;
import com.amazon.dsi.ext.aetree.AENode;
import com.amazon.dsi.ext.aetree.AENodeType;
import com.amazon.dsi.ext.aetree.AENot;
import com.amazon.dsi.ext.aetree.AENull;
import com.amazon.dsi.ext.aetree.AENullPredicate;
import com.amazon.dsi.ext.aetree.AEOr;
import com.amazon.dsi.ext.aetree.AEParameter;
import com.amazon.dsi.ext.aetree.AEProcedure;
import com.amazon.dsi.ext.aetree.AEProject;
import com.amazon.dsi.ext.aetree.AEProxyColumn;
import com.amazon.dsi.ext.aetree.AEQuantifiedComparison;
import com.amazon.dsi.ext.aetree.AERename;
import com.amazon.dsi.ext.aetree.AEScalarFn;
import com.amazon.dsi.ext.aetree.AESelect;
import com.amazon.dsi.ext.aetree.AESimpleCase;
import com.amazon.dsi.ext.aetree.AESubQuery;
import com.amazon.dsi.ext.aetree.AESubtract;
import com.amazon.dsi.ext.aetree.AETable;
import com.amazon.dsi.ext.aetree.AETop;
import com.amazon.dsi.ext.aetree.AEValueList;
import com.amazon.dsi.ext.aetree.AEValueSubQuery;
import com.amazon.dsi.ext.aetree.AggrFunctionID;
import com.amazon.dsi.ext.aetree.ComparisonType;
import com.amazon.dsi.ext.aetree.JoinType;
import com.amazon.dsi.ext.aetree.LiteralType;
import com.amazon.dsi.ext.aetree.ScalarFunctionID;
import java.security.InvalidParameterException;

public final class AENodeFactory {
    private static final INodeCreator[] s_mappingTable = new INodeCreator[AENodeType.values().length - 1];

    public static final AENode createNode(long l) {
        return AENodeFactory.createNode(l, AENode.getNodeType(l));
    }

    public static final AENode createNode(long l, int n) {
        INodeCreator iNodeCreator;
        if (0 <= n && s_mappingTable.length > n && null != (iNodeCreator = s_mappingTable[n])) {
            AENode aENode = iNodeCreator.create(l);
            assert (null != aENode);
            assert (aENode.getNodeType() == AENodeType.getType(n));
            return aENode;
        }
        throw new InvalidParameterException();
    }

    static {
        AENodeFactory.s_mappingTable[AENodeType.BX_AND.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AEAnd(l);
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.BX_BETWEENPREDICATE.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.BX_BOOLEANTRUE.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AEBooleanTrue(l);
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.BX_COMPARISON.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                ComparisonType comparisonType = ComparisonType.getType(AEComparison.getComparisonType(l));
                return new AEComparison(l, comparisonType);
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.BX_EXISTSPREDICATE.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AEExistsPredicate(l);
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.BX_INPREDICATE.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AEInPredicate(l);
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.BX_LIKEPREDICATE.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AELikePredicate(l);
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.BX_NOT.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AENot(l);
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.BX_NULLPREDICATE.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AENullPredicate(l);
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.BX_OR.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AEOr(l);
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.BX_QUANTIFIEDCOMPARISON.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AEQuantifiedComparison(l);
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.RX_AGGREGATE.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AEAggregate(l);
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.RX_CROSSJOIN.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AECrossJoin(l);
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.RX_DISTINCT.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AEDistinct(l);
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.RX_DUMMYTABLE.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AEDummyTable(l);
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.RX_EXCEPT.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.RX_INTERSECT.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.RX_JOIN.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AEJoin(l, JoinType.getType(AEJoin.getJoinType(l)));
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.RX_NATIVEQUERY.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.RX_PIVOT.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.RX_UNPIVOT.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.RX_PROCEDURE.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                AEValueList aEValueList = AEProcedure.getArguments(l);
                boolean bl = AEProcedure.hasReturnValue(l);
                return new AEProcedure(l, aEValueList, bl);
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.RX_PROJECT.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AEProject(l);
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.RX_SELECT.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AESelect(l);
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.RX_SUBQUERY.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                boolean bl = AESubQuery.isCorrelated(l);
                boolean bl2 = AESubQuery.isInFromClause(l);
                return new AESubQuery(l, bl, bl2);
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.RX_TABLE.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AETable(l, AETable.getDSITable(l));
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.RX_TABLECONSTRUCTOR.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.RX_TOP.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AETop(l, AETop.isPercent(l));
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.RX_UNION.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.RX_INSERTIONTABLE.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.VX_ADD.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AEAdd(l);
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.VX_AGGR_FN.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                AggrFunctionID aggrFunctionID = AggrFunctionID.getID(AEAggrFunction.getFunctionID(l));
                boolean bl = AEAggrFunction.isDistinctSet(l);
                return new AEAggrFunction(l, aggrFunctionID, bl);
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.VX_BOOLEAN.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.VX_CASTFN.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                ScalarFunctionID scalarFunctionID = ScalarFunctionID.getID(AEScalarFn.getScalarFnID(l));
                return new AECastFn(l, scalarFunctionID);
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.VX_COLUMN.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AEColumn(l, AEColumn.getColumnNum(l));
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.VX_COUNTSTAR.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AECountStarAggrFunction(l);
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.VX_CUSTOM_AGGR_FN.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.VX_CUSTOM_SCALAR_FN.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.VX_DEFAULT.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.VX_DIVIDE.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AEDivide(l);
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.VX_INTERVAL_LITERAL.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AEIntervalLiteral(l, LiteralType.getType(AEIntervalLiteral.getLiteralType(l)));
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.VX_LITERAL.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AELiteral(l, LiteralType.getType(AELiteral.getLiteralType(l)));
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.VX_MULTIPLY.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AEMultiply(l);
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.VX_NATIVEVALUE.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.VX_NEGATE.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AENegate(l);
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.VX_NULL.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AENull(l);
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.VX_PARAMETER.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AEParameter(l);
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.VX_PROXY_COLUMN.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AEProxyColumn(l, AEProxyColumn.getColumnNum(l));
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.VX_RENAME.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AERename(l);
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.VX_RELATIONSHIP_COLUMN.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.VX_SCALARFN.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                ScalarFunctionID scalarFunctionID = ScalarFunctionID.getID(AEScalarFn.getScalarFnID(l));
                return new AEScalarFn(l, scalarFunctionID);
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.VX_SEARCHEDCASE.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.VX_SEARCHEDWHENCLAUSE.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.VX_SIMPLECASE.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AESimpleCase(l);
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.VX_SIMPLEWHENCLAUSE.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.VX_SUBQUERY.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AEValueSubQuery(l, AEValueSubQuery.isCorrelated(l));
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.VX_SUBTRACT.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AESubtract(l);
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.VALUELIST.ordinal()] = new INodeCreator(){

            @Override
            public AENode create(long l) {
                return new AEValueList(l);
            }
        };
        AENodeFactory.s_mappingTable[AENodeType.PIVOTCOLUMN.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.PIVOTCOLUMNLIST.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.UNPIVOTGROUPDEFINITION.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.UNPIVOTGROUPDEFINITIONLIST.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.SORT.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.SETCLAUSE.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.SETCLAUSELIST.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.TOPNSORT.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.STMT_ALTERTABLE.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.STMT_CREATEINDEX.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.STMT_CREATETABLE.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.STMT_CREATETABLEASSELECT.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.STMT_CREATEVIEW.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.STMT_DROPINDEX.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.STMT_DROPTABLE.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.STMT_DROPVIEW.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.STMT_GRANT.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.STMT_INSERT.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.STMT_INSERTDEFAULTS.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.STMT_MERGE.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.STMT_PROCEDURECALL.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.STMT_QUERY.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.STMT_REVOKE.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.STMT_SEARCHEDDELETE.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.STMT_SEARCHEDUPDATE.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.STMT_SETCATALOG.ordinal()] = null;
        AENodeFactory.s_mappingTable[AENodeType.STMT_SETSCHEMA.ordinal()] = null;
    }

    private static interface INodeCreator {
        public AENode create(long var1);
    }
}

