/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dsi.ext.aetree;

import com.amazon.dsi.CppClassWrapper;
import com.amazon.dsi.ext.aetree.AENodeFactory;
import com.amazon.dsi.ext.aetree.AENodeType;
import java.util.ArrayList;

public abstract class AENode
extends CppClassWrapper {
    private int m_childCount = -1;
    private AENodeType m_nodeType = AENodeType.INVALID;
    private ArrayList<AENode> m_children = null;

    public static void init() {
    }

    public AENode(long l, AENodeType aENodeType) {
        super(l);
        assert (!aENodeType.equals((Object)AENodeType.INVALID));
        this.m_nodeType = aENodeType;
    }

    public AENode getChild(int n) {
        if (null == this.m_children) {
            this.m_children = new ArrayList();
            this.m_children.ensureCapacity(this.getChildCount());
            for (int i = 0; i < this.getChildCount(); ++i) {
                long l = AENode.getChild(this.getObjRef(), i);
                this.m_children.add(AENodeFactory.createNode(l));
            }
        }
        if (n >= this.m_children.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.m_children.get(n);
    }

    public final int getChildCount() {
        if (-1 == this.m_childCount) {
            this.m_childCount = AENode.getChildCount(this.getObjRef());
            assert (this.m_childCount >= 0);
        }
        return this.m_childCount;
    }

    public final AENodeType getNodeType() {
        return this.m_nodeType;
    }

    static final native int getNodeType(long var0);

    private static final native long getChild(long var0, int var2);

    private static final native int getChildCount(long var0);
}

