/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dsi.ext;

import com.amazon.dsi.ext.AbstractBooleanExprHandler;
import com.amazon.dsi.ext.ColumnRef;
import com.amazon.dsi.ext.aetree.AEBooleanExpr;
import com.amazon.dsi.ext.aetree.AEComparison;
import com.amazon.dsi.ext.aetree.AEInPredicate;
import com.amazon.dsi.ext.aetree.AELiteral;
import com.amazon.dsi.ext.aetree.AENodeType;
import com.amazon.dsi.ext.aetree.AENot;
import com.amazon.dsi.ext.aetree.AENullPredicate;
import com.amazon.dsi.ext.aetree.AEValueExpr;
import com.amazon.dsi.ext.aetree.AEValueList;
import com.amazon.dsi.ext.aetree.ComparisonType;
import java.util.ArrayList;

public abstract class SimpleBooleanExprHandler
extends AbstractBooleanExprHandler {
    @Override
    public boolean passdownComparison(AEComparison aEComparison) {
        assert (null != aEComparison);
        AEValueList aEValueList = aEComparison.getLeftOperand();
        AEValueList aEValueList2 = aEComparison.getRightOperand();
        assert (null != aEValueList);
        assert (null != aEValueList2);
        if (1 == aEValueList.getChildCount() && 1 == aEValueList2.getChildCount()) {
            AEValueExpr aEValueExpr = aEValueList.getChild(0);
            AEValueExpr aEValueExpr2 = aEValueList2.getChild(0);
            assert (null != aEValueExpr);
            assert (null != aEValueExpr2);
            ComparisonType comparisonType = aEComparison.getComparisonType();
            ColumnRef columnRef = ColumnRef.getTableColRef(aEValueExpr);
            ColumnRef columnRef2 = ColumnRef.getTableColRef(aEValueExpr2);
            if (aEValueExpr.getNodeType().equals((Object)AENodeType.VX_LITERAL)) {
                if (null != columnRef2) {
                    return this.passdownSimpleComparison(columnRef2, new LiteralValue((AELiteral)aEValueExpr, false), ComparisonType.reverse(comparisonType));
                }
            } else if (aEValueExpr.getNodeType().equals((Object)AENodeType.VX_NEGATE) && aEValueExpr.getChild(0).getNodeType().equals((Object)AENodeType.VX_LITERAL)) {
                if (null != columnRef2) {
                    return this.passdownSimpleComparison(columnRef2, new LiteralValue((AELiteral)aEValueExpr.getChild(0), true), ComparisonType.reverse(comparisonType));
                }
            } else if (null != columnRef) {
                if (aEValueExpr2.getNodeType().equals((Object)AENodeType.VX_LITERAL)) {
                    return this.passdownSimpleComparison(columnRef, new LiteralValue((AELiteral)aEValueExpr2, false), comparisonType);
                }
                if (aEValueExpr2.getNodeType().equals((Object)AENodeType.VX_NEGATE) && aEValueExpr2.getChild(0).getNodeType().equals((Object)AENodeType.VX_LITERAL)) {
                    return this.passdownSimpleComparison(columnRef, new LiteralValue((AELiteral)aEValueExpr2.getChild(0), true), comparisonType);
                }
                if (null != columnRef2) {
                    return this.passdownSimpleComparison(columnRef, columnRef2, comparisonType);
                }
            }
        }
        return false;
    }

    @Override
    public boolean passdownInPredicate(AEInPredicate aEInPredicate) {
        assert (null != aEInPredicate);
        AEValueList aEValueList = aEInPredicate.getFirstOperand();
        assert (null != aEValueList);
        assert (null != aEInPredicate.getSecondOperand());
        if (1 == aEValueList.getChildCount() && aEInPredicate.getSecondOperand().getNodeType().equals((Object)AENodeType.VALUELIST)) {
            AEValueList aEValueList2 = (AEValueList)aEInPredicate.getSecondOperand();
            assert (null != aEValueList2);
            ColumnRef columnRef = ColumnRef.getTableColRef(aEValueList.getChild(0));
            if (null != columnRef) {
                int n = aEValueList2.getChildCount();
                ArrayList<LiteralValue> arrayList = new ArrayList<LiteralValue>(n);
                for (int i = 0; i < n; ++i) {
                    AEValueExpr aEValueExpr = aEValueList2.getChild(i);
                    assert (null != aEValueExpr);
                    if (aEValueExpr.getNodeType().equals((Object)AENodeType.VX_LITERAL)) {
                        arrayList.add(new LiteralValue((AELiteral)aEValueExpr, false));
                        continue;
                    }
                    if (aEValueExpr.getNodeType().equals((Object)AENodeType.VX_NEGATE) && aEValueExpr.getChild(0).getNodeType().equals((Object)AENodeType.VX_LITERAL)) {
                        arrayList.add(new LiteralValue((AELiteral)aEValueExpr.getChild(0), true));
                        continue;
                    }
                    return false;
                }
                return this.passdownSimpleInPredicate(columnRef, arrayList);
            }
        }
        return false;
    }

    @Override
    public boolean passdownNot(AENot aENot) {
        assert (null != aENot);
        AEBooleanExpr aEBooleanExpr = (AEBooleanExpr)aENot.getChild(0);
        assert (null != aEBooleanExpr);
        if (1 == aEBooleanExpr.getChildCount() && aEBooleanExpr.getNodeType().equals((Object)AENodeType.BX_NULLPREDICATE)) {
            AEValueList aEValueList;
            ColumnRef columnRef;
            AENullPredicate aENullPredicate = (AENullPredicate)aEBooleanExpr;
            assert (null != aENullPredicate);
            if (1 == aENullPredicate.getChild(0).getChildCount() && null != (columnRef = ColumnRef.getTableColRef((aEValueList = (AEValueList)aENullPredicate.getChild(0)).getChild(0)))) {
                return this.passdownSimpleNullPredicate(columnRef, false);
            }
        }
        return false;
    }

    @Override
    public boolean passdownNullPredicate(AENullPredicate aENullPredicate) {
        AEValueList aEValueList;
        ColumnRef columnRef;
        assert (null != aENullPredicate);
        if (1 == aENullPredicate.getChild(0).getChildCount() && null != (columnRef = ColumnRef.getTableColRef((aEValueList = (AEValueList)aENullPredicate.getChild(0)).getChild(0)))) {
            return this.passdownSimpleNullPredicate(columnRef, true);
        }
        return false;
    }

    protected abstract boolean passdownSimpleComparison(ColumnRef var1, LiteralValue var2, ComparisonType var3);

    protected abstract boolean passdownSimpleComparison(ColumnRef var1, ColumnRef var2, ComparisonType var3);

    protected abstract boolean passdownSimpleInPredicate(ColumnRef var1, ArrayList<LiteralValue> var2);

    protected abstract boolean passdownSimpleNullPredicate(ColumnRef var1, boolean var2);

    protected static class LiteralValue {
        private AELiteral m_literalNode;
        private boolean m_isNegated;

        protected LiteralValue(AELiteral aELiteral, boolean bl) {
            this.m_literalNode = aELiteral;
            this.m_isNegated = bl;
        }

        public boolean isNegated() {
            return this.m_isNegated;
        }

        public AELiteral getLiteralNode() {
            return this.m_literalNode;
        }
    }
}

