/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dsi.ext;

import com.amazon.dsi.core.impl.DSIDriver;
import com.amazon.dsi.dataengine.interfaces.IResultSet;
import com.amazon.dsi.utilities.DSIMessageKey;
import com.amazon.support.ArgValidator;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionType;
import java.util.BitSet;
import java.util.List;

public abstract class DSIExtResultSet
implements IResultSet {
    public static final int INVALID_COLUMN_NUMBER = 65535;
    private BitSet m_needsData = new BitSet();

    public abstract String getCatalogName();

    @Override
    public boolean getDataNeeded(int n) {
        return this.m_needsData.get(n);
    }

    @Override
    public int getFetchSize() throws ErrorException {
        return 0;
    }

    public abstract String getSchemaName();

    public abstract String getTableName();

    @Override
    public boolean hasMoreRows() throws ErrorException {
        return false;
    }

    public IResultSet onFinishDMLBatch() throws ErrorException {
        return null;
    }

    public void onStartDMLBatch(DMLType dMLType, long l, List<Integer> list) throws ErrorException {
        ArgValidator.checkParameterNonNull((Object)dMLType, "dmlType");
        if (null != list) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
        }
    }

    public abstract void reset() throws ErrorException;

    public int resolveColumn(DSIExtResultSet dSIExtResultSet, int n) throws ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
    }

    @Override
    public boolean rowDeleted() {
        return false;
    }

    @Override
    public boolean rowInserted() {
        return false;
    }

    @Override
    public boolean rowUpdated() {
        return false;
    }

    @Override
    public void setDataNeeded(int n, boolean bl) {
        this.m_needsData.set(n, bl);
    }

    @Override
    public void setFetchSize(int n) throws ErrorException {
    }

    @Override
    public boolean supportsHasMoreRows() {
        return false;
    }

    public static enum DMLType {
        INSERT,
        UPDATE,
        DELETE;

    }
}

