/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dsi.core.utilities.impl.future;

import com.amazon.dsi.core.utilities.impl.future.NumericJDBCDataSource;
import com.amazon.dsi.exceptions.IncorrectTypeException;
import com.amazon.support.IWarningListener;
import com.amazon.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.SQLException;

public abstract class UnsignedIntJDBCDataSource
extends NumericJDBCDataSource {
    private static final long TWO_TO_32 = 0x100000000L;

    public UnsignedIntJDBCDataSource(IWarningListener iWarningListener) {
        super(iWarningListener);
    }

    @Override
    public Long get() throws ErrorException {
        try {
            long l = this.getAndCheck();
            if (l == 0L && this.wasNull()) {
                return null;
            }
            return l;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public String getString() throws ErrorException, IncorrectTypeException, SQLException {
        long l = this.getAndCheck();
        if (l == 0L && this.wasNull()) {
            return null;
        }
        return Long.toString(l);
    }

    @Override
    public boolean getBoolean() throws ErrorException, IncorrectTypeException, SQLException {
        return this.getAndCheck() != 0L;
    }

    @Override
    public byte getByte() throws ErrorException, IncorrectTypeException, SQLException {
        long l = this.getAndCheck();
        if (l > 127L) {
            this.onOverflow(l, "getByte");
        }
        return (byte)l;
    }

    @Override
    public short getShort() throws ErrorException, IncorrectTypeException, SQLException {
        long l = this.getAndCheck();
        if (l > 32767L) {
            this.onOverflow(l, "getShort");
        }
        return (short)l;
    }

    @Override
    public int getInt() throws ErrorException, IncorrectTypeException, SQLException {
        long l = this.getAndCheck();
        if (l > Integer.MAX_VALUE) {
            this.onOverflow(l, "getInt");
        }
        return (int)l;
    }

    @Override
    public abstract long getLong() throws ErrorException, SQLException;

    protected final long getAndCheck() throws ErrorException, SQLException {
        long l = this.getLong();
        assert (l >= 0L && l <= 0x100000000L);
        return l;
    }

    @Override
    public float getFloat() throws ErrorException, IncorrectTypeException, SQLException {
        return this.getAndCheck();
    }

    @Override
    public double getDouble() throws ErrorException, IncorrectTypeException, SQLException {
        return this.getAndCheck();
    }

    @Override
    public BigDecimal getBigDecimal() throws ErrorException, IncorrectTypeException, SQLException {
        long l = this.getAndCheck();
        if (l == 0L && this.wasNull()) {
            return null;
        }
        return new BigDecimal(l);
    }
}

