/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dsi.core.utilities.impl.future;

import com.amazon.dsi.core.utilities.impl.future.UnsignedBigIntJDBCDataSource;
import com.amazon.dsi.dataengine.interfaces.future.ISqlDataSource;
import com.amazon.support.IWarningListener;
import com.amazon.support.exceptions.ErrorException;
import java.math.BigInteger;

public class UnsignedBigIntJDBCDataSourceAdapter
extends UnsignedBigIntJDBCDataSource {
    private static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger TWO_TO_64 = BigInteger.valueOf(2L).pow(64);
    private final ISqlDataSource m_wrapped;

    public UnsignedBigIntJDBCDataSourceAdapter(ISqlDataSource iSqlDataSource, IWarningListener iWarningListener) {
        super(iWarningListener);
        if (iSqlDataSource == null) {
            throw null;
        }
        this.m_wrapped = iSqlDataSource;
    }

    protected final ISqlDataSource getWrapped() {
        return this.m_wrapped;
    }

    @Override
    protected long doGet() throws ErrorException {
        long l;
        Object object = this.m_wrapped.get();
        if (object == null) {
            this.setWasNull(true);
            return 0L;
        }
        if (object instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)object;
            if (bigInteger.compareTo(LONG_MAX) > 0) {
                bigInteger = bigInteger.subtract(TWO_TO_64);
            }
            l = bigInteger.longValue();
        } else {
            l = (Long)object;
        }
        this.setWasNull(false);
        return l;
    }
}

