/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dsi.core.utilities.impl.future;

import com.amazon.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.amazon.dsi.core.utilities.impl.future.NumberJDBCDataSink;
import com.amazon.dsi.exceptions.IncorrectTypeException;
import com.amazon.support.IWarningListener;
import com.amazon.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;

public abstract class UnsignedBigIntJDBCDataSink
extends NumberJDBCDataSink<BigInteger> {
    private static final BigDecimal LONG_MAX = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal LONG_MIN = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final BigInteger TWO_TO_64 = BigInteger.valueOf(2L).pow(64);

    public UnsignedBigIntJDBCDataSink(IWarningListener iWarningListener) {
        super(iWarningListener);
    }

    @Override
    protected abstract void doSet(BigInteger var1) throws ErrorException;

    @Override
    protected abstract void doSet(Long var1) throws ErrorException;

    private void setFromLong(long l, String string) throws ErrorException {
        if (l >= 0L) {
            this.doSet(l);
        } else {
            this.setBigInteger(BigInteger.valueOf(l), string);
        }
    }

    protected void setBigInteger(BigInteger bigInteger, String string) throws ErrorException {
        if (bigInteger == null) {
            this.doSet((BigInteger)null);
        } else {
            BigInteger bigInteger2 = bigInteger.mod(TWO_TO_64);
            if (!bigInteger2.equals(bigInteger)) {
                this.onOverflow(bigInteger, string);
            }
            this.doSet(bigInteger2);
        }
    }

    @Override
    public void set(Object object) throws IncorrectTypeException, ErrorException {
        if (object == null) {
            this.doSet((Long)null);
        } else if (object instanceof Long) {
            this.setFromLong((Long)object, "set");
        } else if (object instanceof BigInteger) {
            this.setBigInteger((BigInteger)object, "set");
        } else {
            BigDecimal bigDecimal = NonTrivialJDBCConversions.objectToBigDecimal(object, null, this.getAndClearListener());
            BigInteger bigInteger = NonTrivialJDBCConversions.DecimalConverter.toUInt64(bigDecimal, this.getAndClearListener());
            this.handleConversionResult(object, "set");
            this.doSet(bigInteger);
        }
    }

    @Override
    public void setByte(byte by) throws IncorrectTypeException, SQLException, ErrorException {
        this.setLong(by);
    }

    @Override
    public void setShort(short s) throws IncorrectTypeException, SQLException, ErrorException {
        this.setLong(s);
    }

    @Override
    public void setInt(int n) throws IncorrectTypeException, SQLException, ErrorException {
        this.setLong(n);
    }

    @Override
    public void setLong(long l) throws IncorrectTypeException, SQLException, ErrorException {
        this.setFromLong(l, "setLong");
    }

    @Override
    public void setFloat(float f) throws IncorrectTypeException, SQLException, ErrorException {
        BigInteger bigInteger = NonTrivialJDBCConversions.DoubleConverter.toUInt64(f, this.getAndClearListener());
        this.handleConversionResult(Float.valueOf(f), "setFloat");
        this.doSet(bigInteger);
    }

    @Override
    public void setDouble(double d) throws IncorrectTypeException, SQLException, ErrorException {
        BigInteger bigInteger = NonTrivialJDBCConversions.DoubleConverter.toUInt64(d, this.getAndClearListener());
        this.handleConversionResult(d, "setDouble");
        this.doSet(bigInteger);
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws IncorrectTypeException, SQLException, ErrorException {
        if (bigDecimal == null) {
            this.setNull(3);
        } else if (bigDecimal.compareTo(LONG_MIN) >= 0 && bigDecimal.compareTo(LONG_MAX) <= 0) {
            this.setLong(bigDecimal.longValue());
        } else {
            BigInteger bigInteger = NonTrivialJDBCConversions.DecimalConverter.toUInt64(bigDecimal, this.getAndClearListener());
            this.handleConversionResult(bigDecimal, "setBigDecimal");
            this.doSet(bigInteger);
        }
    }

    @Override
    public void setString(String string) throws IncorrectTypeException, SQLException, ErrorException {
        if (string == null) {
            this.setNull(1);
        } else {
            string = string.trim();
            try {
                this.setFromLong(Long.parseLong(string), "setString");
            }
            catch (NumberFormatException numberFormatException) {
                BigInteger bigInteger = NonTrivialJDBCConversions.DecimalConverter.toUInt64(new BigDecimal(string), this.getAndClearListener());
                this.handleConversionResult(string, "setString");
                this.doSet(bigInteger);
            }
        }
    }
}

