/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dsi.core.utilities.impl.future;

import com.amazon.dsi.core.utilities.impl.future.NumericJDBCDataSource;
import com.amazon.dsi.exceptions.IncorrectTypeException;
import com.amazon.support.IWarningListener;
import com.amazon.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.SQLException;

public abstract class BitBooleanJDBCDataSource
extends NumericJDBCDataSource {
    public BitBooleanJDBCDataSource(IWarningListener iWarningListener) {
        super(iWarningListener);
    }

    @Override
    public abstract Boolean get() throws ErrorException;

    @Override
    public String getString() throws ErrorException, IncorrectTypeException, SQLException {
        Boolean bl = this.get();
        if (bl == null) {
            return null;
        }
        return bl != false ? "1" : "0";
    }

    @Override
    public boolean getBoolean() throws ErrorException, IncorrectTypeException, SQLException {
        Boolean bl = this.get();
        if (bl == null) {
            return false;
        }
        return bl;
    }

    @Override
    public byte getByte() throws ErrorException, IncorrectTypeException, SQLException {
        return (byte)this.getInt();
    }

    @Override
    public short getShort() throws ErrorException, IncorrectTypeException, SQLException {
        return (short)this.getInt();
    }

    @Override
    public int getInt() throws ErrorException, IncorrectTypeException, SQLException {
        Boolean bl = this.get();
        if (bl == null) {
            return 0;
        }
        if (bl.booleanValue()) {
            return 1;
        }
        return 0;
    }

    @Override
    public long getLong() throws ErrorException, IncorrectTypeException, SQLException {
        return this.getInt();
    }

    @Override
    public float getFloat() throws ErrorException, IncorrectTypeException, SQLException {
        return this.getInt();
    }

    @Override
    public double getDouble() throws ErrorException, IncorrectTypeException, SQLException {
        return this.getInt();
    }

    @Override
    public BigDecimal getBigDecimal() throws ErrorException, IncorrectTypeException, SQLException {
        Boolean bl = this.get();
        if (bl == null) {
            return null;
        }
        if (bl.booleanValue()) {
            return BigDecimal.ONE;
        }
        return BigDecimal.ZERO;
    }
}

