/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dsi.core.utilities.impl.future;

import com.amazon.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.amazon.dsi.core.utilities.impl.future.ConvertingJDBCDataSource;
import com.amazon.dsi.dataengine.interfaces.future.IJDBCExecution;
import com.amazon.dsi.exceptions.IncorrectTypeException;
import com.amazon.support.IWarningListener;
import com.amazon.support.exceptions.ErrorException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;

public abstract class BinaryJDBCDataSource
extends ConvertingJDBCDataSource {
    public BinaryJDBCDataSource(IWarningListener iWarningListener) {
        super(iWarningListener);
    }

    public abstract byte[] get() throws ErrorException;

    @Override
    public Reader getAsReader() throws IncorrectTypeException, ErrorException {
        InputStream inputStream = this.getAsInputStream();
        if (inputStream == null) {
            return null;
        }
        return new NonTrivialJDBCConversions.HexStringReader(inputStream, true);
    }

    @Override
    public InputStream getAsInputStream() throws ErrorException {
        byte[] byArray = this.get();
        if (byArray == null) {
            return null;
        }
        return new ByteArrayInputStream(byArray);
    }

    @Override
    public String getString() throws ErrorException, IncorrectTypeException, SQLException {
        byte[] byArray = this.get();
        if (byArray == null) {
            return null;
        }
        return NonTrivialJDBCConversions.bytesToHex(byArray);
    }

    @Override
    public byte[] getBytes() throws ErrorException, IncorrectTypeException, SQLException {
        return this.get();
    }

    @Override
    protected boolean supportsConversionToRegisteredType(IJDBCExecution.OutputParameterRegistration outputParameterRegistration) {
        int n = this.getSqlTypeFromRegistration(outputParameterRegistration);
        switch (n) {
            case 2000: {
                return true;
            }
        }
        return this.isCharType(n) || this.isBinaryType(n);
    }
}

