/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.antlr4.sql.escaper;

import com.amazon.antlr4.sql.escaper.AbstractStoredProcedureHelper;
import com.amazon.antlr4.sql.escaper.JDBCEscaperGrammar;
import com.amazon.antlr4.sql.escaper.NoOpJDBCReplacer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class PGJDBCReplacer
extends NoOpJDBCReplacer {
    private static final String DATE = "date";
    private static final String TIME = "time";
    private static final int OUTPUT = 4;
    protected static final char COMMA = ',';
    private boolean m_callAsCall = true;
    private Exception m_errorWhileGettingSPInfo = null;
    private boolean m_paramMarkerAsCallArg = false;

    public PGJDBCReplacer(CommonTokenStream commonTokenStream, boolean bl, AbstractStoredProcedureHelper abstractStoredProcedureHelper) {
        super(commonTokenStream);
        this.m_callAsCall = bl;
        if (null != abstractStoredProcedureHelper) {
            this.m_storedProcedureHelper = abstractStoredProcedureHelper;
        }
    }

    @Override
    public void printParam(JDBCEscaperGrammar.ParamContext paramContext) {
        String string = paramContext.getText();
        String string2 = "$" + this.m_paramCount;
        this.m_statementBuilder.append(string);
        this.m_statementBuilder.replace(this.m_statementBuilder.length() - 1, this.m_statementBuilder.length(), string2);
    }

    @Override
    public Void visitCallProc(JDBCEscaperGrammar.CallProcContext callProcContext) {
        this.m_errorWhileGettingSPInfo = null;
        this.m_paramMarkerAsCallArg = false;
        boolean bl = !this.m_IsInEscapeSequence || this.m_callAsCall;
        try {
            this.retrieveProcedureInfo(callProcContext.procName());
        }
        catch (Exception exception) {
            this.m_errorWhileGettingSPInfo = exception;
            bl = true;
        }
        if (this.m_IsInEscapeSequence) {
            if (bl) {
                bl = !this.m_storedProcedureHelper.m_isFunction;
            } else if (!this.m_storedProcedureHelper.m_isFunction && this.m_storedProcedureHelper.m_outputParamCount <= 1) {
                bl = true;
            }
        }
        if (!bl) {
            this.m_statementBuilder.append("SELECT ");
        }
        ParseTree parseTree = null;
        for (int i = 0; i < callProcContext.getChildCount(); ++i) {
            parseTree = callProcContext.getChild(i);
            if (bl || !(parseTree instanceof TerminalNode) || ((TerminalNode)parseTree).getSymbol().getType() != 10) {
                this.visit(parseTree);
                continue;
            }
            parseTree.getText().substring(4);
        }
        if (null == callProcContext.argumentList()) {
            this.m_statementBuilder.append("()");
            this.m_errorWhileGettingSPInfo = null;
        }
        if (!bl) {
            this.m_statementBuilder.append(" AS RESULT");
        }
        if ((this.m_paramMarkerAsCallArg || this.m_storedProcedureHelper.m_hasReturnParameter) && null != this.m_errorWhileGettingSPInfo) {
            this.m_fatalError = this.m_errorWhileGettingSPInfo;
        }
        this.m_storedProcedureHelper.finalizeParamsList();
        if (0 < this.m_storedProcedureHelper.m_outputParamCount) {
            this.m_containsCallWithOutputParam = true;
        }
        return null;
    }

    @Override
    public Void visitReturnArg(JDBCEscaperGrammar.ReturnArgContext returnArgContext) {
        this.m_storedProcedureHelper.m_hasReturnParameter = true;
        this.addHiddenTokens(returnArgContext.param(), NoOpJDBCReplacer.hiddenTokenSide.LEFT, true);
        this.addHiddenTokens(returnArgContext.param(), NoOpJDBCReplacer.hiddenTokenSide.RIGHT, true);
        this.addHiddenTokens(returnArgContext.EQUAL(), NoOpJDBCReplacer.hiddenTokenSide.RIGHT, true);
        return null;
    }

    @Override
    public Void visitArgumentList(JDBCEscaperGrammar.ArgumentListContext argumentListContext) {
        if (argumentListContext.getParent() instanceof JDBCEscaperGrammar.CallProcContext) {
            ParseTree parseTree = null;
            int n = this.m_storedProcedureHelper.m_isFunction && this.m_storedProcedureHelper.m_firstOutputParameter == 0 ? 1 : 0;
            for (int i = 0; i < argumentListContext.getChildCount(); ++i) {
                parseTree = argumentListContext.getChild(i);
                if (parseTree instanceof JDBCEscaperGrammar.ArgContext) {
                    if (0 < parseTree.getChildCount() && !(parseTree.getChild(0) instanceof JDBCEscaperGrammar.ParamContext)) {
                        if (null == this.m_errorWhileGettingSPInfo) {
                            this.m_storedProcedureHelper.removeParamWithValue(n);
                            --n;
                        }
                        this.visit(parseTree);
                    } else {
                        this.m_paramMarkerAsCallArg = true;
                        if (null == this.m_errorWhileGettingSPInfo) {
                            boolean bl = false;
                            while (!bl) {
                                AbstractStoredProcedureHelper.ParamInfo paramInfo = this.m_storedProcedureHelper.getArg(n);
                                if (null == paramInfo || paramInfo.m_paramMode != 4) {
                                    if (n <= this.m_storedProcedureHelper.m_firstInputParameter && ',' == this.m_statementBuilder.charAt(this.m_statementBuilder.length() - 1)) {
                                        this.m_statementBuilder.deleteCharAt(this.m_statementBuilder.length() - 1);
                                    }
                                    this.visit(parseTree);
                                    bl = true;
                                    continue;
                                }
                                if (paramInfo.m_paramMode == 4 && this.m_storedProcedureHelper.m_hasReturnParameter && n == this.m_storedProcedureHelper.m_firstOutputParameter) {
                                    ++n;
                                    continue;
                                }
                                if (',' == this.m_statementBuilder.charAt(this.m_statementBuilder.length() - 1)) {
                                    this.m_statementBuilder.deleteCharAt(this.m_statementBuilder.length() - 1);
                                }
                                bl = true;
                            }
                        } else {
                            return null;
                        }
                    }
                    ++n;
                    continue;
                }
                this.visit(parseTree);
            }
        } else {
            super.visitArgumentList(argumentListContext);
        }
        return null;
    }

    @Override
    public Void visitDateLiteral(JDBCEscaperGrammar.DateLiteralContext dateLiteralContext) {
        this.m_statementBuilder.append("date ");
        if (this.m_isUnload) {
            this.m_statementBuilder.append("'");
        }
        this.visit((ParseTree)dateLiteralContext.DATE_LITERAL());
        if (this.m_isUnload) {
            this.m_statementBuilder.append("'");
        }
        return null;
    }

    @Override
    public Void visitTimeLiteral(JDBCEscaperGrammar.TimeLiteralContext timeLiteralContext) {
        this.m_statementBuilder.append("time ");
        if (this.m_isUnload) {
            this.m_statementBuilder.append("'");
        }
        this.visit((ParseTree)timeLiteralContext.TIME_LITERAL());
        if (this.m_isUnload) {
            this.m_statementBuilder.append("'");
        }
        return null;
    }

    @Override
    public Void visitTimestampLiteral(JDBCEscaperGrammar.TimestampLiteralContext timestampLiteralContext) {
        this.m_statementBuilder.append("timestamp ");
        if (this.m_isUnload) {
            this.m_statementBuilder.append("'");
        }
        this.visit((ParseTree)timestampLiteralContext.TIMESTAMP_LITERAL());
        if (this.m_isUnload) {
            this.m_statementBuilder.append("'");
        }
        return null;
    }

    @Override
    public Void visitLog(JDBCEscaperGrammar.LogContext logContext) {
        this.addFunctionNameWithHiddenTokens(logContext, "LN");
        this.buildScalarFnArgumentList(logContext);
        return null;
    }

    @Override
    public Void visitLog10(JDBCEscaperGrammar.Log10Context log10Context) {
        this.addFunctionNameWithHiddenTokens(log10Context, "LOG");
        this.buildScalarFnArgumentList(log10Context);
        return null;
    }

    @Override
    public Void visitTruncate(JDBCEscaperGrammar.TruncateContext truncateContext) {
        this.addFunctionNameWithHiddenTokens(truncateContext, "TRUNC");
        this.buildScalarFnArgumentList(truncateContext);
        return null;
    }

    @Override
    public Void visitPosition_octets(JDBCEscaperGrammar.Position_octetsContext position_octetsContext) {
        this.addFunctionNameWithHiddenTokens(position_octetsContext, "OCTETINDEX");
        this.visit((ParseTree)position_octetsContext.LPAREN());
        int n = this.m_statementBuilder.length();
        this.visit((ParseTree)position_octetsContext.arg(1));
        if (' ' == this.m_statementBuilder.charAt(n)) {
            this.m_statementBuilder.deleteCharAt(n);
        }
        this.m_statementBuilder.append(", ");
        this.visit((ParseTree)position_octetsContext.arg(0));
        this.visit((ParseTree)position_octetsContext.RPAREN());
        return null;
    }

    @Override
    public Void visitChar_fn(JDBCEscaperGrammar.Char_fnContext char_fnContext) {
        this.addFunctionNameWithHiddenTokens(char_fnContext, "CHR");
        this.buildScalarFnArgumentList(char_fnContext);
        return null;
    }

    @Override
    public Void visitCharLength(JDBCEscaperGrammar.CharLengthContext charLengthContext) {
        this.addFunctionNameWithHiddenTokens(charLengthContext, "LEN");
        this.m_statementBuilder.append("(");
        this.visit((ParseTree)charLengthContext.arg());
        this.m_statementBuilder.append(")");
        return null;
    }

    @Override
    public Void visitInsert(JDBCEscaperGrammar.InsertContext insertContext) {
        List list = insertContext.getRuleContexts(JDBCEscaperGrammar.ArgContext.class);
        this.m_statementBuilder.append("(");
        this.addHiddenTokens(insertContext.start, NoOpJDBCReplacer.hiddenTokenSide.RIGHT, false);
        this.m_statementBuilder.append("SUBSTRING((");
        this.visit((ParseTree)list.get(0));
        this.m_statementBuilder.append(")::TEXT FROM 1 FOR (");
        this.visit((ParseTree)list.get(1));
        this.m_statementBuilder.append(") - 1) || ");
        this.visit((ParseTree)list.get(3));
        this.m_statementBuilder.append(" || SUBSTRING((");
        this.visit((ParseTree)list.get(0));
        this.m_statementBuilder.append(")::TEXT FROM (");
        this.visit((ParseTree)list.get(1));
        this.m_statementBuilder.append(") + (");
        this.visit((ParseTree)list.get(2));
        this.m_statementBuilder.append(")))");
        return null;
    }

    @Override
    public Void visitLcase(JDBCEscaperGrammar.LcaseContext lcaseContext) {
        this.addFunctionNameWithHiddenTokens(lcaseContext, "LOWER");
        this.buildScalarFnArgumentList(lcaseContext);
        return null;
    }

    @Override
    public Void visitLocate(JDBCEscaperGrammar.LocateContext locateContext) {
        List<JDBCEscaperGrammar.ArgContext> list = locateContext.arg();
        if (3 == list.size()) {
            this.m_statementBuilder.append("(STRPOS");
            this.visit((ParseTree)locateContext.LPAREN());
            this.m_statementBuilder.append("SUBSTRING(");
            this.visit((ParseTree)list.get(1));
            this.m_statementBuilder.append(" from ((");
            this.visit((ParseTree)list.get(2));
            this.m_statementBuilder.append(")::int)), ");
            this.visit((ParseTree)list.get(0));
            this.visit((ParseTree)locateContext.RPAREN());
            this.m_statementBuilder.append(" + ((");
            this.visit((ParseTree)list.get(2));
            this.m_statementBuilder.append(")::int) - 1)");
        } else {
            this.m_statementBuilder.append("STRPOS");
            this.visit((ParseTree)locateContext.LPAREN());
            int n = this.m_statementBuilder.length();
            boolean bl = false;
            this.visit((ParseTree)list.get(1));
            if (' ' == this.m_statementBuilder.charAt(n)) {
                this.m_statementBuilder.deleteCharAt(n);
                bl = true;
            }
            this.visit((ParseTree)locateContext.COMMA(0));
            n = this.m_statementBuilder.length();
            this.visit((ParseTree)list.get(0));
            if (bl && ' ' != this.m_statementBuilder.charAt(n)) {
                this.m_statementBuilder.insert(n, ' ');
            }
            this.visit((ParseTree)locateContext.RPAREN());
        }
        return null;
    }

    @Override
    public Void visitOctetLength(JDBCEscaperGrammar.OctetLengthContext octetLengthContext) {
        this.addFunctionNameWithHiddenTokens(octetLengthContext, "OCTET_LENGTH");
        this.visit((ParseTree)octetLengthContext.LPAREN());
        this.visit((ParseTree)octetLengthContext.arg());
        this.visit((ParseTree)octetLengthContext.RPAREN());
        return null;
    }

    @Override
    public Void visitPosition_chars(JDBCEscaperGrammar.Position_charsContext position_charsContext) {
        TerminalNode terminalNode = position_charsContext.COMMA();
        TerminalNode terminalNode2 = position_charsContext.CHARACTERS();
        for (int i = 0; i < position_charsContext.getChildCount(); ++i) {
            String string;
            ParseTree parseTree = position_charsContext.getChild(i);
            if (parseTree.equals(terminalNode)) {
                string = terminalNode.getText();
                this.addBlanksAndCommentForPositionChars(string.substring(0, string.length() - 1));
                continue;
            }
            if (parseTree.equals(terminalNode2)) {
                string = terminalNode2.getText();
                this.addBlanksAndCommentForPositionChars(string.substring(0, string.length() - 10));
                continue;
            }
            this.visit(parseTree);
        }
        return null;
    }

    @Override
    public Void visitSpace(JDBCEscaperGrammar.SpaceContext spaceContext) {
        this.addFunctionNameWithHiddenTokens(spaceContext, "REPEAT");
        this.visit((ParseTree)spaceContext.LPAREN());
        this.m_statementBuilder.append("' ', ");
        this.visit((ParseTree)spaceContext.arg());
        this.visit((ParseTree)spaceContext.RPAREN());
        return null;
    }

    @Override
    public Void visitSubstringChar(JDBCEscaperGrammar.SubstringCharContext substringCharContext) {
        this.m_statementBuilder.append(substringCharContext.start.getText().toUpperCase());
        this.addHiddenTokens(substringCharContext.start, NoOpJDBCReplacer.hiddenTokenSide.RIGHT, false);
        this.visit((ParseTree)substringCharContext.LPAREN());
        List<JDBCEscaperGrammar.ArgContext> list = substringCharContext.arg();
        List<TerminalNode> list2 = substringCharContext.COMMA();
        for (int i = 0; i < list.size(); ++i) {
            if (i >= 1) {
                this.visit((ParseTree)list2.get(i - 1));
            }
            this.visit((ParseTree)list.get(i));
        }
        this.visit((ParseTree)substringCharContext.RPAREN());
        return null;
    }

    @Override
    public Void visitSubstringOctet(JDBCEscaperGrammar.SubstringOctetContext substringOctetContext) {
        this.addFunctionNameWithHiddenTokens(substringOctetContext, "CAST");
        TerminalNode terminalNode = substringOctetContext.LPAREN();
        TerminalNode terminalNode2 = substringOctetContext.RPAREN();
        JDBCEscaperGrammar.ArgContext argContext = substringOctetContext.text;
        JDBCEscaperGrammar.ArgContext argContext2 = substringOctetContext.start;
        JDBCEscaperGrammar.ArgContext argContext3 = substringOctetContext.length;
        if (null != terminalNode && null != terminalNode2 && null != argContext && null != argContext2 && null != argContext3) {
            this.visit((ParseTree)terminalNode);
            this.m_statementBuilder.append("LTRIM((");
            this.visit((ParseTree)argContext);
            this.m_statementBuilder.append("), CAST((");
            this.visit((ParseTree)argContext);
            this.m_statementBuilder.append(") AS VARCHAR(");
            this.visit((ParseTree)argContext2);
            this.m_statementBuilder.append("))) AS VARCHAR(");
            this.visit((ParseTree)argContext3);
            this.m_statementBuilder.append(")");
            if (null != terminalNode2) {
                this.visit((ParseTree)terminalNode2);
            }
        } else {
            super.visitSubstringOctet(substringOctetContext);
        }
        return null;
    }

    @Override
    public Void visitUcase(JDBCEscaperGrammar.UcaseContext ucaseContext) {
        this.addFunctionNameWithHiddenTokens(ucaseContext, "UPPER");
        this.buildScalarFnArgumentList(ucaseContext);
        return null;
    }

    @Override
    public Void visitCurdate(JDBCEscaperGrammar.CurdateContext curdateContext) {
        this.addFunctionNameWithHiddenTokens(curdateContext, "CURRENT_DATE");
        this.addBlanksAndCommentsForEmptyArgsList(curdateContext.RPAREN());
        return null;
    }

    @Override
    public Void visitCurtime(JDBCEscaperGrammar.CurtimeContext curtimeContext) {
        this.addFunctionNameWithHiddenTokens(curtimeContext, "CURRENT_TIME::time");
        this.addBlanksAndCommentsForEmptyArgsList(curtimeContext.RPAREN());
        return null;
    }

    @Override
    public Void visitCurtimestamp(JDBCEscaperGrammar.CurtimestampContext curtimestampContext) {
        this.addFunctionNameWithHiddenTokens(curtimestampContext, "GETDATE");
        if (curtimestampContext.getChildCount() > 1) {
            this.buildScalarFnArgumentList(curtimestampContext);
        } else {
            this.m_statementBuilder.append("()");
        }
        return null;
    }

    @Override
    public Void visitDayName(JDBCEscaperGrammar.DayNameContext dayNameContext) {
        this.addFunctionNameWithHiddenTokens(dayNameContext, "TO_CHAR");
        this.m_statementBuilder.append("((");
        this.visit((ParseTree)dayNameContext.arg());
        if (this.m_isUnload) {
            this.m_statementBuilder.append(")::date, ''day''");
        } else {
            this.m_statementBuilder.append(")::date, 'day'");
        }
        this.m_statementBuilder.append(")");
        return null;
    }

    @Override
    public Void visitDayOfMonth(JDBCEscaperGrammar.DayOfMonthContext dayOfMonthContext) {
        this.extractDatePart(dayOfMonthContext, "day", dayOfMonthContext.arg());
        return null;
    }

    @Override
    public Void visitDayofweek(JDBCEscaperGrammar.DayofweekContext dayofweekContext) {
        this.m_statementBuilder.append("((");
        this.extractDatePart(dayofweekContext, "dow", dayofweekContext.arg());
        this.m_statementBuilder.append(") + 1 )");
        return null;
    }

    @Override
    public Void visitDayofyear(JDBCEscaperGrammar.DayofyearContext dayofyearContext) {
        this.extractDatePart(dayofyearContext, "doy", dayofyearContext.arg());
        return null;
    }

    @Override
    public Void visitHour(JDBCEscaperGrammar.HourContext hourContext) {
        this.m_statementBuilder.append("(");
        this.extractTimePart(hourContext, "hour", hourContext.arg());
        this.m_statementBuilder.append("::int)");
        return null;
    }

    @Override
    public Void visitMinute(JDBCEscaperGrammar.MinuteContext minuteContext) {
        this.m_statementBuilder.append("(");
        this.extractTimePart(minuteContext, "minute", minuteContext.arg());
        this.m_statementBuilder.append("::int)");
        return null;
    }

    @Override
    public Void visitMonth(JDBCEscaperGrammar.MonthContext monthContext) {
        this.m_statementBuilder.append("(");
        this.extractDatePart(monthContext, "month", monthContext.arg());
        this.m_statementBuilder.append("::int)");
        return null;
    }

    @Override
    public Void visitMonthname(JDBCEscaperGrammar.MonthnameContext monthnameContext) {
        this.addFunctionNameWithHiddenTokens(monthnameContext, "TO_CHAR");
        this.m_statementBuilder.append("((");
        this.visit((ParseTree)monthnameContext.arg());
        if (this.m_isUnload) {
            this.m_statementBuilder.append(")::date, ''month''");
        } else {
            this.m_statementBuilder.append(")::date, 'month'");
        }
        this.m_statementBuilder.append(")");
        return null;
    }

    @Override
    public Void visitQuarter(JDBCEscaperGrammar.QuarterContext quarterContext) {
        this.m_statementBuilder.append("(");
        this.extractDatePart(quarterContext, "quarter", quarterContext.arg());
        this.m_statementBuilder.append("::int)");
        return null;
    }

    @Override
    public Void visitSecond(JDBCEscaperGrammar.SecondContext secondContext) {
        this.m_statementBuilder.append("(");
        this.extractTimePart(secondContext, "second", secondContext.arg());
        this.m_statementBuilder.append("::int)");
        return null;
    }

    @Override
    public Void visitTimestampadd(JDBCEscaperGrammar.TimestampaddContext timestampaddContext) {
        List<JDBCEscaperGrammar.ArgContext> list = timestampaddContext.arg();
        this.addFunctionNameWithHiddenTokens(timestampaddContext, "DATEADD");
        this.m_statementBuilder.append("(");
        this.replaceIntervalName(timestampaddContext.intervalType);
        this.m_statementBuilder.append(",");
        this.visit((ParseTree)list.get(1));
        this.m_statementBuilder.append(",");
        this.visit((ParseTree)list.get(2));
        this.m_statementBuilder.append(")");
        return null;
    }

    @Override
    public Void visitTimestampdiff(JDBCEscaperGrammar.TimestampdiffContext timestampdiffContext) {
        List<JDBCEscaperGrammar.ArgContext> list = timestampdiffContext.arg();
        this.addFunctionNameWithHiddenTokens(timestampdiffContext, "DATEDIFF");
        this.m_statementBuilder.append("(");
        this.replaceIntervalName(timestampdiffContext.intervalType);
        this.m_statementBuilder.append(",");
        this.visit((ParseTree)list.get(1));
        this.m_statementBuilder.append(",");
        this.visit((ParseTree)list.get(2));
        this.m_statementBuilder.append(")");
        return null;
    }

    @Override
    public Void visitWeek(JDBCEscaperGrammar.WeekContext weekContext) {
        this.extractDatePart(weekContext, "week", weekContext.arg());
        return null;
    }

    @Override
    public Void visitYear(JDBCEscaperGrammar.YearContext yearContext) {
        this.extractDatePart(yearContext, "year", yearContext.arg());
        return null;
    }

    @Override
    public Void visitDatabase(JDBCEscaperGrammar.DatabaseContext databaseContext) {
        this.addFunctionNameWithHiddenTokens(databaseContext, "CURRENT_DATABASE");
        this.m_statementBuilder.append("()");
        return null;
    }

    @Override
    public Void visitIfnull(JDBCEscaperGrammar.IfnullContext ifnullContext) {
        List<JDBCEscaperGrammar.ArgContext> list = ifnullContext.arg();
        this.addFunctionNameWithHiddenTokens(ifnullContext, "NVL2");
        this.m_statementBuilder.append("(");
        this.visit((ParseTree)list.get(0));
        this.m_statementBuilder.append(", ");
        this.visit((ParseTree)list.get(0));
        this.m_statementBuilder.append(",");
        this.visit((ParseTree)list.get(1));
        this.m_statementBuilder.append(")");
        return null;
    }

    @Override
    public Void visitUser(JDBCEscaperGrammar.UserContext userContext) {
        this.addFunctionNameWithHiddenTokens(userContext, "CURRENT_USER");
        return null;
    }

    @Override
    public Void visitConvert(JDBCEscaperGrammar.ConvertContext convertContext) {
        this.m_statementBuilder.append("CAST");
        this.addHiddenTokens(convertContext.start, NoOpJDBCReplacer.hiddenTokenSide.RIGHT, true);
        this.m_statementBuilder.append("(");
        this.visit((ParseTree)convertContext.arg());
        this.m_statementBuilder.append(" AS ");
        this.visit((ParseTree)convertContext.sqlType());
        this.m_statementBuilder.append(")");
        return null;
    }

    @Override
    public Void visitSqlType(JDBCEscaperGrammar.SqlTypeContext sqlTypeContext) {
        String string = sqlTypeContext.getText();
        String string2 = string.toUpperCase().trim();
        if (string2.equals("SQL_BIGINT") || string2.equals("BIGINT")) {
            this.m_statementBuilder.append("int8");
        } else if (string2.equals("SQL_LONGVARBINARY") || string2.equals("LONGVARBINARY") || string2.equals("SQL_VARBINARY") || string2.equals("VARBINARY") || string2.equals("SQL_BINARY") || string2.equals("BINARY")) {
            this.m_statementBuilder.append("bytea");
        } else if (string2.equals("SQL_BIT") || string2.equals("BIT")) {
            this.m_statementBuilder.append("bit");
        } else if (string2.equals("SQL_BOOLEAN") || string2.equals("BOOLEAN")) {
            this.m_statementBuilder.append("bool");
        } else if (string2.equals("SQL_CHAR") || string2.equals("CHAR") || string2.equals("SQL_NCHAR") || string2.equals("NCHAR")) {
            this.m_statementBuilder.append("char");
        } else if (string2.equals("SQL_DATE") || string2.equals("DATE")) {
            this.m_statementBuilder.append(DATE);
        } else if (string2.equals("SQL_DECIMAL") || string2.equals("DECIMAL") || string2.equals("SQL_NUMERIC") || string2.equals("NUMERIC")) {
            this.m_statementBuilder.append("decimal");
        } else if (string2.equals("SQL_DOUBLE") || string2.equals("DOUBLE") || string2.equals("SQL_FLOAT") || string2.equals("FLOAT")) {
            this.m_statementBuilder.append("float8");
        } else if (string2.equals("SQL_INTEGER") || string2.equals("INTEGER")) {
            this.m_statementBuilder.append("int");
        } else if (string2.equals("SQL_LONGNVARCHAR") || string2.equals("LONGNVARCHAR") || string2.equals("SQL_LONGVARCHAR") || string2.equals("LONGVARCHAR") || string2.equals("SQL_NVARCHAR") || string2.equals("NVARCHAR") || string2.equals("SQL_VARCHAR") || string2.equals("VARCHAR")) {
            this.m_statementBuilder.append("varchar");
        } else if (string2.equals("SQL_REAL") || string2.equals("REAL")) {
            this.m_statementBuilder.append("float4");
        } else if (string2.equals("SQL_SMALLINT") || string2.equals("SMALLINT")) {
            this.m_statementBuilder.append("int2");
        } else if (string2.equals("SQL_TIME") || string2.equals("TIME")) {
            this.m_statementBuilder.append(TIME);
        } else if (string2.equals("SQL_TIMESTAMP") || string2.equals("TIMESTAMP")) {
            this.m_statementBuilder.append("timestamp");
        } else {
            if (string.startsWith(" ")) {
                this.m_statementBuilder.deleteCharAt(this.m_statementBuilder.length() - 1);
            }
            super.visitSqlType(sqlTypeContext);
        }
        return null;
    }

    private void addBlanksAndCommentsForEmptyArgsList(TerminalNode terminalNode) {
        if (null != terminalNode) {
            String string = terminalNode.getText();
            if (0 < (string = string.substring(0, string.length() - 1)).length()) {
                if (' ' != string.charAt(0)) {
                    this.m_statementBuilder.append(' ');
                }
                this.m_statementBuilder.append(string);
            }
        }
    }

    private void addBlanksAndCommentForPositionChars(String string) {
        if (null != string && 0 < (string = TRAILING_BLANKS.matcher(string).replaceAll("")).length()) {
            this.m_statementBuilder.append(string);
        }
    }

    private void extractDatePart(ParserRuleContext parserRuleContext, String string, JDBCEscaperGrammar.ArgContext argContext) {
        this.extractDateTimePart(parserRuleContext, string, DATE, argContext);
    }

    private void extractDateTimePart(ParserRuleContext parserRuleContext, String string, String string2, JDBCEscaperGrammar.ArgContext argContext) {
        TerminalNode terminalNode = parserRuleContext.getToken(7, 0);
        if (null != terminalNode) {
            this.addFunctionNameWithHiddenTokens(parserRuleContext, "EXTRACT");
            this.m_statementBuilder.append("(");
            this.addHiddenTokens(terminalNode.getSymbol(), NoOpJDBCReplacer.hiddenTokenSide.RIGHT, false);
            this.m_statementBuilder.append(string);
            this.m_statementBuilder.append(" FROM (");
            this.visit((ParseTree)argContext);
            this.m_statementBuilder.append(")::");
            this.m_statementBuilder.append(string2);
            this.m_statementBuilder.append(parserRuleContext.stop.getText());
        } else {
            this.visit((ParseTree)parserRuleContext);
        }
    }

    private void extractTimePart(ParserRuleContext parserRuleContext, String string, JDBCEscaperGrammar.ArgContext argContext) {
        this.extractDateTimePart(parserRuleContext, string, TIME, argContext);
    }

    private void addFunctionNameWithHiddenTokens(ParserRuleContext parserRuleContext, String string) {
        this.m_statementBuilder.append(string);
        this.addHiddenTokens(parserRuleContext.start, NoOpJDBCReplacer.hiddenTokenSide.RIGHT, false);
    }

    private void replaceIntervalName(JDBCEscaperGrammar.ArgContext argContext) {
        String string = argContext.getText().toUpperCase().trim();
        if (string.equals("SQL_TSI_FRAC_SECOND") || string.equals("TSI_FRAC_SECOND")) {
            this.m_statementBuilder.append("microsecond");
        } else if (string.equals("SQL_TSI_SECOND") || string.equals("TSI_SECOND")) {
            this.m_statementBuilder.append("second");
        } else if (string.equals("SQL_TSI_MINUTE") || string.equals("TSI_MINUTE")) {
            this.m_statementBuilder.append("minute");
        } else if (string.equals("SQL_TSI_HOUR") || string.equals("TSI_HOUR")) {
            this.m_statementBuilder.append("hour");
        } else if (string.equals("SQL_TSI_DAY") || string.equals("TSI_DAY")) {
            this.m_statementBuilder.append("day");
        } else if (string.equals("SQL_TSI_WEEK") || string.equals("TSI_WEEK")) {
            this.m_statementBuilder.append("week");
        } else if (string.equals("SQL_TSI_MONTH") || string.equals("TSI_MONTH")) {
            this.m_statementBuilder.append("month");
        } else if (string.equals("SQL_TSI_QUARTER") || string.equals("TSI_QUARTER")) {
            this.m_statementBuilder.append("quarter");
        } else if (string.equals("SQL_TSI_YEAR") || string.equals("TSI_YEAR")) {
            this.m_statementBuilder.append("year");
        } else {
            this.visit((ParseTree)argContext);
        }
    }

    private void retrieveProcedureInfo(JDBCEscaperGrammar.ProcNameContext procNameContext) throws Exception {
        this.m_storedProcedureHelper.m_procedureName = procNameContext.getText();
        if (null != procNameContext && 0 < procNameContext.getChildCount()) {
            String[] stringArray;
            int n;
            List<JDBCEscaperGrammar.NonLiteralContext> list = procNameContext.nonLiteral();
            int n2 = list.size();
            JDBCEscaperGrammar.NonLiteralContext nonLiteralContext = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = null;
            for (n = n2; n > 0; --n) {
                nonLiteralContext = list.get(n - 1);
                string = nonLiteralContext.getText().trim();
                if (null != nonLiteralContext.QUOTED_ID()) {
                    arrayList.add(string.substring(1, string.length() - 1));
                    continue;
                }
                stringArray = string.split("\\.");
                arrayList.addAll(Arrays.asList(stringArray));
            }
            n = arrayList.size();
            stringArray = null;
            String string2 = null;
            if (0 < n) {
                stringArray = (String[])arrayList.get(arrayList.size() - 1);
                if (1 < n) {
                    string2 = (String)arrayList.get(arrayList.size() - 2);
                }
            }
            this.m_storedProcedureHelper.getArgInfoForStoredProcedure((String)stringArray, string2);
        }
    }
}

