/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.antlr4.sql.escaper;

import com.amazon.antlr4.sql.escaper.AbstractStoredProcedureHelper;
import com.amazon.antlr4.sql.escaper.JDBCEscaperGrammar;
import com.amazon.antlr4.sql.escaper.JDBCEscaperLexer;
import com.amazon.antlr4.sql.escaper.NoOpJDBCReplacer;
import com.amazon.antlr4.sql.escaper.PGJDBCReplacer;
import com.amazon.antlr4.sql.escaper.ProcessedStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public class PGJDBCParse {
    private static final Pattern BLANKS = Pattern.compile("^\\s+\\Z");
    private static final Pattern TRAILING_BLANKS = Pattern.compile("\\s+\\Z");

    public int parameterCounter(String string) throws Exception {
        NoOpJDBCReplacer.EscaperResult escaperResult = PGJDBCParse.escape(string, true, null);
        return escaperResult.getTotalParamCount();
    }

    public static NoOpJDBCReplacer.EscaperResult escape(String string, boolean bl, AbstractStoredProcedureHelper abstractStoredProcedureHelper) throws Exception {
        NoOpJDBCReplacer.EscaperResult escaperResult = null;
        if (null != string) {
            JDBCEscaperLexer jDBCEscaperLexer = new JDBCEscaperLexer((CharStream)CharStreams.fromString((String)string));
            CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)jDBCEscaperLexer);
            JDBCEscaperGrammar jDBCEscaperGrammar = new JDBCEscaperGrammar((TokenStream)commonTokenStream);
            JDBCEscaperGrammar.QueryContext queryContext = jDBCEscaperGrammar.query();
            PGJDBCReplacer pGJDBCReplacer = new PGJDBCReplacer(commonTokenStream, bl, abstractStoredProcedureHelper);
            escaperResult = pGJDBCReplacer.replace(queryContext);
        }
        return escaperResult;
    }

    public static String apply(String string) throws Exception {
        NoOpJDBCReplacer.EscaperResult escaperResult = PGJDBCParse.escape(string, true, null);
        List<ProcessedStatement> list = escaperResult.getStatements();
        if (null != list && list.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (ProcessedStatement processedStatement : list) {
                stringBuilder.append(processedStatement.getStatementText());
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public static boolean isUnloadStatement(String string) throws Exception {
        boolean bl = false;
        NoOpJDBCReplacer.EscaperResult escaperResult = PGJDBCParse.escape(string, true, null);
        List<ProcessedStatement> list = escaperResult.getStatements();
        if (null != list && list.size() > 0) {
            for (ProcessedStatement processedStatement : list) {
                if (!processedStatement.getIsUnload()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static List<String> splitQueries(String string) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        NoOpJDBCReplacer.EscaperResult escaperResult = PGJDBCParse.escape(string, true, null);
        List<ProcessedStatement> list = escaperResult.getStatements();
        if (null != list && list.size() > 0) {
            for (ProcessedStatement processedStatement : list) {
                string2 = TRAILING_BLANKS.matcher(processedStatement.getStatementText()).replaceFirst("");
                if (string2.charAt(string2.length() - 1) == ';') {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                if (BLANKS.matcher(string2).find() || string2.isEmpty()) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    public static int stmtsCounter(String string) throws Exception {
        int n = 0;
        NoOpJDBCReplacer.EscaperResult escaperResult = PGJDBCParse.escape(string, true, null);
        List<ProcessedStatement> list = escaperResult.getStatements();
        if (null != list) {
            n = list.size();
        }
        return n;
    }
}

