/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.antlr4.sql.escaper;

import com.amazon.antlr4.sql.escaper.AbstractStoredProcedureHelper;
import com.amazon.antlr4.sql.escaper.JDBCEscaperGrammar;
import com.amazon.antlr4.sql.escaper.JDBCEscaperGrammarBaseVisitor;
import com.amazon.antlr4.sql.escaper.ProcessedStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;

public class NoOpJDBCReplacer
extends JDBCEscaperGrammarBaseVisitor<Void> {
    private static final int BLANK_CHANNEL = 2;
    private static final int COMMENT_CHANNEL = 3;
    private static final String LEADING_BLANK_REGEX = "^\\s+";
    protected static final Pattern TRAILING_BLANKS = Pattern.compile("\\s+\\Z");
    private static final String LEADING_COMMENTS_OR_BLANK = "(\\*/)|\\s";
    private static final String TRAILING_COMMENTS_OR_BLANK = "(/\\*)|(--)|\\s";
    private static final Pattern LEADING_BLANKS = Pattern.compile("^\\s+");
    protected static final char SPACE = ' ';
    private CommonTokenStream m_tokens;
    private List<ProcessedStatement> m_statements = null;
    protected StringBuilder m_queryBuilder = new StringBuilder();
    protected StringBuilder m_statementBuilder = null;
    protected int m_paramCount = 0;
    protected int m_totalParamCount = 0;
    protected boolean m_isUnload = false;
    protected AbstractStoredProcedureHelper m_storedProcedureHelper = new NoOpSPHelper();
    protected Exception m_fatalError;
    protected boolean m_IsInEscapeSequence;
    protected boolean m_containsCallWithOutputParam = false;

    public NoOpJDBCReplacer(CommonTokenStream commonTokenStream) {
        this.m_tokens = commonTokenStream;
        this.m_statementBuilder = new StringBuilder();
        this.m_paramCount = 0;
        this.m_isUnload = false;
        this.m_statements = new ArrayList<ProcessedStatement>();
    }

    public EscaperResult replace(ParserRuleContext parserRuleContext) throws Exception {
        this.visit((ParseTree)parserRuleContext);
        if (null != this.m_fatalError) {
            throw this.m_fatalError;
        }
        return new EscaperResult(this.m_statements, this.m_totalParamCount, this.m_queryBuilder.toString(), this.m_containsCallWithOutputParam);
    }

    public String getTranslatedQuery() {
        return this.m_queryBuilder.toString();
    }

    public Void visit(ParseTree parseTree) {
        if (null == this.m_fatalError) {
            if (null != parseTree) {
                return (Void)super.visit(parseTree);
            }
            return null;
        }
        return null;
    }

    public Void visitErrorNode(ErrorNode errorNode) {
        this.m_statementBuilder.append(errorNode.getText());
        String string = this.getHiddenTokens((TerminalNode)errorNode, hiddenTokenSide.RIGHT);
        if (null != string) {
            this.m_statementBuilder.append(string);
        }
        return (Void)super.visitErrorNode(errorNode);
    }

    @Override
    public Void visitQuery(JDBCEscaperGrammar.QueryContext queryContext) {
        super.visitQuery(queryContext);
        TerminalNode terminalNode = queryContext.EOF();
        if (null != terminalNode) {
            if (terminalNode.getSymbol().getStopIndex() >= terminalNode.getSymbol().getStartIndex()) {
                String string = queryContext.EOF().getText();
                if (null != this.m_statements && this.m_statements.size() > 0) {
                    this.m_statements.get((int)(this.m_statements.size() - 1)).m_sbuilder.append(string);
                } else if (!string.isEmpty()) {
                    this.m_statementBuilder.append(string);
                }
            }
            if (null == this.m_statements || this.m_statements.size() == 0) {
                this.addStatement();
            }
        }
        if (this.m_statementBuilder.length() > 0 && this.m_statements.size() == 0) {
            this.addStatement();
        }
        return null;
    }

    @Override
    public Void visitStatement(JDBCEscaperGrammar.StatementContext statementContext) {
        return this.visitGenericStatement(statementContext);
    }

    @Override
    public Void visitLastStatement(JDBCEscaperGrammar.LastStatementContext lastStatementContext) {
        return this.visitGenericStatement(lastStatementContext);
    }

    @Override
    public Void visitUnloadStatement(JDBCEscaperGrammar.UnloadStatementContext unloadStatementContext) {
        this.m_isUnload = true;
        return (Void)super.visitUnloadStatement(unloadStatementContext);
    }

    @Override
    public Void visitEscapeSequence(JDBCEscaperGrammar.EscapeSequenceContext escapeSequenceContext) {
        String string;
        String string2;
        String string3;
        this.m_IsInEscapeSequence = true;
        TerminalNode terminalNode = escapeSequenceContext.LBRACE();
        if (null != terminalNode) {
            string3 = terminalNode.getText();
            if (string3.length() > 1) {
                this.m_statementBuilder.append(string3.substring(0, string3.length() - 1));
            } else if (0 < this.m_statementBuilder.length() && Character.isLetterOrDigit(this.m_statementBuilder.charAt(this.m_statementBuilder.length() - 1))) {
                this.m_statementBuilder.append(' ');
            }
        }
        string3 = escapeSequenceContext.FN();
        TerminalNode terminalNode2 = escapeSequenceContext.OUTER_JOIN_MARKER();
        JDBCEscaperGrammar.LimitCLauseContext limitCLauseContext = escapeSequenceContext.limitCLause();
        JDBCEscaperGrammar.LikeEscapeClauseContext likeEscapeClauseContext = escapeSequenceContext.likeEscapeClause();
        String string4 = null;
        if (null != string3) {
            string4 = string3;
        } else if (null != terminalNode2) {
            string4 = terminalNode2;
        } else if (null != limitCLauseContext) {
            string4 = limitCLauseContext.getToken(103, 0);
        } else if (null != likeEscapeClauseContext) {
            string4 = likeEscapeClauseContext.getToken(102, 0);
        }
        String string5 = null;
        String string6 = null;
        if (null != string4) {
            string5 = " ";
            string6 = this.getHiddenTokens((TerminalNode)string4, hiddenTokenSide.LEFT);
            if (null != string6) {
                this.m_statementBuilder.append(string6.replaceAll(LEADING_BLANK_REGEX, ""));
            }
            if (null != (string2 = this.getHiddenTokens((TerminalNode)string4, hiddenTokenSide.RIGHT))) {
                string5 = string5 + string2;
            }
        }
        string2 = this.m_statementBuilder.toString();
        if (null != string5) {
            if (LEADING_BLANKS.matcher(string5).find() && (TRAILING_BLANKS.matcher(string2).find() || string2.endsWith("("))) {
                this.m_statementBuilder.append(string5.replaceAll(LEADING_BLANK_REGEX, ""));
            } else if (' ' != string5.charAt(0) || 1 < string5.length() && ' ' != string5.charAt(1)) {
                this.m_statementBuilder.append(string5);
            }
        }
        ParseTree parseTree = null;
        for (int i = 0; i < escapeSequenceContext.getChildCount(); ++i) {
            parseTree = escapeSequenceContext.getChild(i);
            if (parseTree instanceof TerminalNode) continue;
            this.visit(parseTree);
        }
        TerminalNode terminalNode3 = escapeSequenceContext.RBRACE();
        if (null != terminalNode3 && (string = terminalNode3.getText()).length() > 1) {
            String string7 = string.substring(0, string.length() - 1);
            if (0 < (string7 = TRAILING_BLANKS.matcher(string7).replaceAll("")).length()) {
                this.m_statementBuilder.append(string7);
            }
        }
        this.m_IsInEscapeSequence = false;
        return null;
    }

    @Override
    public Void visitParam(JDBCEscaperGrammar.ParamContext paramContext) {
        ++this.m_paramCount;
        this.printParam(paramContext);
        return null;
    }

    public void printParam(JDBCEscaperGrammar.ParamContext paramContext) {
        super.visitParam(paramContext);
    }

    @Override
    public Void visitCallProc(JDBCEscaperGrammar.CallProcContext callProcContext) {
        this.m_storedProcedureHelper.m_procedureName = callProcContext.procName().getText();
        return (Void)super.visitCallProc(callProcContext);
    }

    @Override
    public Void visitReturnArg(JDBCEscaperGrammar.ReturnArgContext returnArgContext) {
        this.m_storedProcedureHelper.m_hasReturnParameter = true;
        return (Void)super.visitReturnArg(returnArgContext);
    }

    @Override
    public Void visitProcName(JDBCEscaperGrammar.ProcNameContext procNameContext) {
        super.visitProcName(procNameContext);
        return null;
    }

    @Override
    public Void visitLimitCLause(JDBCEscaperGrammar.LimitCLauseContext limitCLauseContext) {
        this.addHiddenTokens(limitCLauseContext, hiddenTokenSide.LEFT, true);
        return (Void)super.visitLimitCLause(limitCLauseContext);
    }

    @Override
    public Void visitOuterJoin(JDBCEscaperGrammar.OuterJoinContext outerJoinContext) {
        if (' ' == outerJoinContext.getText().charAt(0) && ' ' == this.m_statementBuilder.charAt(this.m_statementBuilder.length() - 1)) {
            this.m_statementBuilder.deleteCharAt(this.m_statementBuilder.length() - 1);
        }
        return (Void)super.visitOuterJoin(outerJoinContext);
    }

    @Override
    public Void visitAbs(JDBCEscaperGrammar.AbsContext absContext) {
        this.buildGenericScalarFunctionText(absContext);
        return null;
    }

    @Override
    public Void visitConcat(JDBCEscaperGrammar.ConcatContext concatContext) {
        this.buildGenericScalarFunctionText(concatContext);
        return null;
    }

    @Override
    public Void visitDateLiteral(JDBCEscaperGrammar.DateLiteralContext dateLiteralContext) {
        this.m_statementBuilder.append(dateLiteralContext.getText());
        return null;
    }

    @Override
    public Void visitTimeLiteral(JDBCEscaperGrammar.TimeLiteralContext timeLiteralContext) {
        this.m_statementBuilder.append(timeLiteralContext.getText());
        return null;
    }

    @Override
    public Void visitTimestampLiteral(JDBCEscaperGrammar.TimestampLiteralContext timestampLiteralContext) {
        this.m_statementBuilder.append(timestampLiteralContext.getText());
        return null;
    }

    @Override
    public Void visitAcos(JDBCEscaperGrammar.AcosContext acosContext) {
        this.buildGenericScalarFunctionText(acosContext);
        return null;
    }

    @Override
    public Void visitAscii(JDBCEscaperGrammar.AsciiContext asciiContext) {
        this.buildGenericScalarFunctionText(asciiContext);
        return null;
    }

    @Override
    public Void visitAsin(JDBCEscaperGrammar.AsinContext asinContext) {
        this.buildGenericScalarFunctionText(asinContext);
        return null;
    }

    @Override
    public Void visitAtan(JDBCEscaperGrammar.AtanContext atanContext) {
        this.buildGenericScalarFunctionText(atanContext);
        return null;
    }

    @Override
    public Void visitAtan2(JDBCEscaperGrammar.Atan2Context atan2Context) {
        this.buildGenericScalarFunctionText(atan2Context);
        return null;
    }

    @Override
    public Void visitCeiling(JDBCEscaperGrammar.CeilingContext ceilingContext) {
        this.buildGenericScalarFunctionText(ceilingContext);
        return null;
    }

    @Override
    public Void visitCos(JDBCEscaperGrammar.CosContext cosContext) {
        this.buildGenericScalarFunctionText(cosContext);
        return null;
    }

    @Override
    public Void visitCot(JDBCEscaperGrammar.CotContext cotContext) {
        this.buildGenericScalarFunctionText(cotContext);
        return null;
    }

    @Override
    public Void visitDegrees(JDBCEscaperGrammar.DegreesContext degreesContext) {
        this.buildGenericScalarFunctionText(degreesContext);
        return null;
    }

    @Override
    public Void visitExp(JDBCEscaperGrammar.ExpContext expContext) {
        this.buildGenericScalarFunctionText(expContext);
        return null;
    }

    @Override
    public Void visitFloor(JDBCEscaperGrammar.FloorContext floorContext) {
        this.buildGenericScalarFunctionText(floorContext);
        return null;
    }

    @Override
    public Void visitMod(JDBCEscaperGrammar.ModContext modContext) {
        this.buildGenericScalarFunctionText(modContext);
        return null;
    }

    @Override
    public Void visitPi(JDBCEscaperGrammar.PiContext piContext) {
        this.buildGenericScalarFunctionText(piContext);
        return null;
    }

    @Override
    public Void visitPower(JDBCEscaperGrammar.PowerContext powerContext) {
        this.buildGenericScalarFunctionText(powerContext);
        return null;
    }

    @Override
    public Void visitRadians(JDBCEscaperGrammar.RadiansContext radiansContext) {
        this.buildGenericScalarFunctionText(radiansContext);
        return null;
    }

    @Override
    public Void visitRand(JDBCEscaperGrammar.RandContext randContext) {
        this.buildGenericScalarFunctionText(randContext);
        return null;
    }

    @Override
    public Void visitRound(JDBCEscaperGrammar.RoundContext roundContext) {
        this.buildGenericScalarFunctionText(roundContext);
        return null;
    }

    @Override
    public Void visitSign(JDBCEscaperGrammar.SignContext signContext) {
        this.buildGenericScalarFunctionText(signContext);
        return null;
    }

    @Override
    public Void visitSin(JDBCEscaperGrammar.SinContext sinContext) {
        this.buildGenericScalarFunctionText(sinContext);
        return null;
    }

    @Override
    public Void visitSoundex(JDBCEscaperGrammar.SoundexContext soundexContext) {
        this.buildGenericScalarFunctionText(soundexContext);
        return null;
    }

    @Override
    public Void visitSqrt(JDBCEscaperGrammar.SqrtContext sqrtContext) {
        this.buildGenericScalarFunctionText(sqrtContext);
        return null;
    }

    @Override
    public Void visitTan(JDBCEscaperGrammar.TanContext tanContext) {
        this.buildGenericScalarFunctionText(tanContext);
        return null;
    }

    @Override
    public Void visitLog(JDBCEscaperGrammar.LogContext logContext) {
        this.buildGenericScalarFunctionText(logContext);
        return null;
    }

    @Override
    public Void visitLog10(JDBCEscaperGrammar.Log10Context log10Context) {
        this.buildGenericScalarFunctionText(log10Context);
        return null;
    }

    @Override
    public Void visitTruncate(JDBCEscaperGrammar.TruncateContext truncateContext) {
        this.buildGenericScalarFunctionText(truncateContext);
        return null;
    }

    @Override
    public Void visitLeft(JDBCEscaperGrammar.LeftContext leftContext) {
        this.buildGenericScalarFunctionText(leftContext);
        return null;
    }

    @Override
    public Void visitRepeat(JDBCEscaperGrammar.RepeatContext repeatContext) {
        this.buildGenericScalarFunctionText(repeatContext);
        return null;
    }

    @Override
    public Void visitReplace(JDBCEscaperGrammar.ReplaceContext replaceContext) {
        this.buildGenericScalarFunctionText(replaceContext);
        return null;
    }

    @Override
    public Void visitRight(JDBCEscaperGrammar.RightContext rightContext) {
        this.buildGenericScalarFunctionText(rightContext);
        return null;
    }

    @Override
    public Void visitChar_fn(JDBCEscaperGrammar.Char_fnContext char_fnContext) {
        this.buildGenericScalarFunctionText(char_fnContext);
        return null;
    }

    @Override
    public Void visitCharLength(JDBCEscaperGrammar.CharLengthContext charLengthContext) {
        this.buildGenericScalarFunctionText(charLengthContext);
        return null;
    }

    @Override
    public Void visitDifference(JDBCEscaperGrammar.DifferenceContext differenceContext) {
        this.buildGenericScalarFunctionText(differenceContext);
        return null;
    }

    @Override
    public Void visitInsert(JDBCEscaperGrammar.InsertContext insertContext) {
        this.buildGenericScalarFunctionText(insertContext);
        return null;
    }

    @Override
    public Void visitLcase(JDBCEscaperGrammar.LcaseContext lcaseContext) {
        this.buildGenericScalarFunctionText(lcaseContext);
        return null;
    }

    @Override
    public Void visitLtrim(JDBCEscaperGrammar.LtrimContext ltrimContext) {
        this.buildGenericScalarFunctionText(ltrimContext);
        return null;
    }

    @Override
    public Void visitOctetLength(JDBCEscaperGrammar.OctetLengthContext octetLengthContext) {
        this.buildGenericScalarFunctionText(octetLengthContext);
        return null;
    }

    @Override
    public Void visitPosition(JDBCEscaperGrammar.PositionContext positionContext) {
        this.buildGenericScalarFunctionText(positionContext);
        return null;
    }

    @Override
    public Void visitPosition_chars(JDBCEscaperGrammar.Position_charsContext position_charsContext) {
        this.buildGenericScalarFunctionText(position_charsContext);
        return null;
    }

    @Override
    public Void visitPosition_octets(JDBCEscaperGrammar.Position_octetsContext position_octetsContext) {
        this.buildGenericScalarFunctionText(position_octetsContext);
        return null;
    }

    @Override
    public Void visitRtrim(JDBCEscaperGrammar.RtrimContext rtrimContext) {
        this.buildGenericScalarFunctionText(rtrimContext);
        return null;
    }

    @Override
    public Void visitSpace(JDBCEscaperGrammar.SpaceContext spaceContext) {
        this.buildGenericScalarFunctionText(spaceContext);
        return null;
    }

    @Override
    public Void visitSubstringChar(JDBCEscaperGrammar.SubstringCharContext substringCharContext) {
        this.buildGenericScalarFunctionText(substringCharContext);
        return null;
    }

    @Override
    public Void visitSubstringOctet(JDBCEscaperGrammar.SubstringOctetContext substringOctetContext) {
        this.buildGenericScalarFunctionText(substringOctetContext);
        return null;
    }

    @Override
    public Void visitUcase(JDBCEscaperGrammar.UcaseContext ucaseContext) {
        this.buildGenericScalarFunctionText(ucaseContext);
        return null;
    }

    @Override
    public Void visitCurdate(JDBCEscaperGrammar.CurdateContext curdateContext) {
        this.buildGenericScalarFunctionText(curdateContext);
        return null;
    }

    @Override
    public Void visitCurtime(JDBCEscaperGrammar.CurtimeContext curtimeContext) {
        this.buildGenericScalarFunctionText(curtimeContext);
        return null;
    }

    @Override
    public Void visitCurtimestamp(JDBCEscaperGrammar.CurtimestampContext curtimestampContext) {
        this.buildGenericScalarFunctionText(curtimestampContext);
        return null;
    }

    @Override
    public Void visitDayName(JDBCEscaperGrammar.DayNameContext dayNameContext) {
        this.buildGenericScalarFunctionText(dayNameContext);
        return null;
    }

    @Override
    public Void visitDayOfMonth(JDBCEscaperGrammar.DayOfMonthContext dayOfMonthContext) {
        this.buildGenericScalarFunctionText(dayOfMonthContext);
        return null;
    }

    @Override
    public Void visitDayofweek(JDBCEscaperGrammar.DayofweekContext dayofweekContext) {
        this.buildGenericScalarFunctionText(dayofweekContext);
        return null;
    }

    @Override
    public Void visitDayofyear(JDBCEscaperGrammar.DayofyearContext dayofyearContext) {
        this.buildGenericScalarFunctionText(dayofyearContext);
        return null;
    }

    @Override
    public Void visitExtract(JDBCEscaperGrammar.ExtractContext extractContext) {
        this.buildGenericScalarFunctionText(extractContext);
        return null;
    }

    @Override
    public Void visitHour(JDBCEscaperGrammar.HourContext hourContext) {
        this.buildGenericScalarFunctionText(hourContext);
        return null;
    }

    @Override
    public Void visitLocate(JDBCEscaperGrammar.LocateContext locateContext) {
        this.buildGenericScalarFunctionText(locateContext);
        return null;
    }

    @Override
    public Void visitMinute(JDBCEscaperGrammar.MinuteContext minuteContext) {
        this.buildGenericScalarFunctionText(minuteContext);
        return null;
    }

    @Override
    public Void visitMonth(JDBCEscaperGrammar.MonthContext monthContext) {
        this.buildGenericScalarFunctionText(monthContext);
        return null;
    }

    @Override
    public Void visitMonthname(JDBCEscaperGrammar.MonthnameContext monthnameContext) {
        this.buildGenericScalarFunctionText(monthnameContext);
        return null;
    }

    @Override
    public Void visitQuarter(JDBCEscaperGrammar.QuarterContext quarterContext) {
        this.buildGenericScalarFunctionText(quarterContext);
        return null;
    }

    @Override
    public Void visitSecond(JDBCEscaperGrammar.SecondContext secondContext) {
        this.buildGenericScalarFunctionText(secondContext);
        return null;
    }

    @Override
    public Void visitTimestampadd(JDBCEscaperGrammar.TimestampaddContext timestampaddContext) {
        timestampaddContext.arg();
        this.buildGenericScalarFunctionText(timestampaddContext);
        return null;
    }

    @Override
    public Void visitTimestampdiff(JDBCEscaperGrammar.TimestampdiffContext timestampdiffContext) {
        this.buildGenericScalarFunctionText(timestampdiffContext);
        return null;
    }

    @Override
    public Void visitWeek(JDBCEscaperGrammar.WeekContext weekContext) {
        this.buildGenericScalarFunctionText(weekContext);
        return null;
    }

    @Override
    public Void visitYear(JDBCEscaperGrammar.YearContext yearContext) {
        this.buildGenericScalarFunctionText(yearContext);
        return null;
    }

    @Override
    public Void visitDatabase(JDBCEscaperGrammar.DatabaseContext databaseContext) {
        this.buildGenericScalarFunctionText(databaseContext);
        return null;
    }

    @Override
    public Void visitIfnull(JDBCEscaperGrammar.IfnullContext ifnullContext) {
        this.buildGenericScalarFunctionText(ifnullContext);
        return null;
    }

    @Override
    public Void visitUser(JDBCEscaperGrammar.UserContext userContext) {
        this.buildGenericScalarFunctionText(userContext);
        return null;
    }

    @Override
    public Void visitConvert(JDBCEscaperGrammar.ConvertContext convertContext) {
        this.buildGenericScalarFunctionText(convertContext);
        return null;
    }

    public Void visitTerminal(TerminalNode terminalNode) {
        int n = terminalNode.getSymbol().getType();
        if (-1 != n) {
            this.m_statementBuilder.append(terminalNode.getText());
            this.addHiddenTokens(terminalNode, hiddenTokenSide.RIGHT, false);
        }
        return null;
    }

    @Override
    public Void visitArg(JDBCEscaperGrammar.ArgContext argContext) {
        return (Void)super.visitArg(argContext);
    }

    private void addStatement() {
        ProcessedStatement processedStatement = new ProcessedStatement(this.m_statementBuilder, this.m_paramCount, this.m_isUnload, this.m_storedProcedureHelper.m_procedureName, this.m_storedProcedureHelper.m_hasReturnParameter, this.m_storedProcedureHelper.m_paramsInfo);
        this.m_statements.add(processedStatement);
        this.m_totalParamCount += processedStatement.getParamCount();
    }

    private Void visitGenericStatement(ParserRuleContext parserRuleContext) {
        this.m_statementBuilder = new StringBuilder();
        this.m_paramCount = 0;
        this.m_isUnload = false;
        this.m_storedProcedureHelper.resetInfos();
        this.visitChildren((RuleNode)parserRuleContext);
        this.m_queryBuilder.append(this.m_statementBuilder.toString());
        int n = this.m_statementBuilder.length() - 1;
        if (0 < n && this.m_statementBuilder.lastIndexOf("\n") == n) {
            this.m_statementBuilder.deleteCharAt(n);
        }
        this.addStatement();
        return null;
    }

    protected void buildScalarFnArgumentList(ParserRuleContext parserRuleContext) {
        for (int i = 1; i < parserRuleContext.getChildCount(); ++i) {
            this.visit(parserRuleContext.getChild(i));
        }
    }

    protected void buildGenericScalarFunctionText(ParserRuleContext parserRuleContext) {
        this.m_statementBuilder.append(parserRuleContext.start.getText().toUpperCase());
        this.addHiddenTokens(parserRuleContext.start, hiddenTokenSide.RIGHT, false);
        this.buildScalarFnArgumentList(parserRuleContext);
    }

    protected void addHiddenTokens(ParserRuleContext parserRuleContext, hiddenTokenSide hiddenTokenSide2, boolean bl) {
        if (null != parserRuleContext) {
            this.addHiddenTokens(parserRuleContext.getStop(), hiddenTokenSide2, bl);
        }
    }

    protected void addHiddenTokens(TerminalNode terminalNode, hiddenTokenSide hiddenTokenSide2, boolean bl) {
        if (null != terminalNode) {
            this.addHiddenTokens(terminalNode.getSymbol(), hiddenTokenSide2, bl);
        }
    }

    protected void addHiddenTokens(Token token, hiddenTokenSide hiddenTokenSide2, boolean bl) {
        int n = token.getTokenIndex();
        if (n >= 0) {
            List list = null;
            list = hiddenTokenSide2 == hiddenTokenSide.RIGHT ? this.m_tokens.getHiddenTokensToRight(n) : this.m_tokens.getHiddenTokensToLeft(n);
            if (null != list) {
                boolean bl2 = true;
                for (Token token2 : list) {
                    String string = token2.getText();
                    if (bl2 && bl && ' ' == string.charAt(0)) {
                        string = string.substring(1);
                        bl2 = false;
                    }
                    this.m_statementBuilder.append(string);
                }
            }
        }
    }

    protected String getHiddenTokens(ParserRuleContext parserRuleContext, hiddenTokenSide hiddenTokenSide2) {
        return this.getHiddenTokens(parserRuleContext.getStop(), hiddenTokenSide2);
    }

    protected String getHiddenTokens(TerminalNode terminalNode, hiddenTokenSide hiddenTokenSide2) {
        if (null != terminalNode) {
            return this.getHiddenTokens(terminalNode.getSymbol(), hiddenTokenSide2);
        }
        return null;
    }

    protected String getHiddenTokens(Token token, hiddenTokenSide hiddenTokenSide2) {
        int n = token.getTokenIndex();
        if (n >= 0) {
            List list = null;
            list = hiddenTokenSide2 == hiddenTokenSide.RIGHT ? this.m_tokens.getHiddenTokensToRight(n) : this.m_tokens.getHiddenTokensToLeft(n);
            if (null != list) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Token token2 : list) {
                    stringBuilder.append(token2.getText());
                }
                return stringBuilder.toString();
            }
        }
        return null;
    }

    protected static enum hiddenTokenSide {
        RIGHT,
        LEFT;

    }

    public class NoOpSPHelper
    extends AbstractStoredProcedureHelper {
        @Override
        public AbstractStoredProcedureHelper.ParamInfo getArg(int n) {
            AbstractStoredProcedureHelper.ParamInfo paramInfo = new AbstractStoredProcedureHelper.ParamInfo();
            paramInfo.m_paramMode = 1;
            return paramInfo;
        }

        @Override
        public void getArgInfoForStoredProcedure(String string, String string2) throws Exception {
            this.m_procedureName = string;
        }
    }

    public class EscaperResult {
        protected List<ProcessedStatement> m_statements = null;
        protected int m_totalParamCount = 0;
        protected String m_query;
        protected boolean m_containsCallWithOutput = false;

        private EscaperResult(List<ProcessedStatement> list, int n, String string, boolean bl) {
            this.m_statements = list;
            this.m_totalParamCount = n;
            this.m_query = string;
            this.m_containsCallWithOutput = bl;
        }

        public boolean getContainsCallWithOutput() {
            return this.m_containsCallWithOutput;
        }

        public List<ProcessedStatement> getStatements() {
            return this.m_statements;
        }

        public int getTotalParamCount() {
            return this.m_totalParamCount;
        }

        public String getQuery() {
            return this.m_query;
        }
    }
}

