/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.antlr4.sql.escaper;

import java.util.List;

public abstract class AbstractStoredProcedureHelper {
    private static final int NO_OUTPUT = -1;
    private static final int IN = 1;
    private static final int OUTPUT = 4;
    private static final int INPUT_OUTPUT = 2;
    private static final int RETURN = 5;
    protected String m_procedureName = null;
    protected boolean m_hasReturnParameter = false;
    protected int m_firstInputParameter = -1;
    protected int m_firstOutputParameter = -1;
    protected List<ParamInfo> m_paramsInfo = null;
    protected boolean m_isFunction = false;
    protected int m_outputParamCount = 0;

    public abstract void getArgInfoForStoredProcedure(String var1, String var2) throws Exception;

    public ParamInfo getArg(int n) {
        if (null != this.m_paramsInfo && n < this.m_paramsInfo.size()) {
            return this.m_paramsInfo.get(n);
        }
        return null;
    }

    protected void resetInfos() {
        this.m_procedureName = null;
        this.m_hasReturnParameter = false;
        this.m_paramsInfo = null;
        this.m_firstInputParameter = -1;
        this.m_firstOutputParameter = -1;
        this.m_isFunction = false;
        this.m_outputParamCount = 0;
    }

    protected void removeParamWithValue(int n) {
        if (null != this.m_paramsInfo) {
            if (n < this.m_firstOutputParameter) {
                --this.m_firstOutputParameter;
                --this.m_outputParamCount;
            } else if (n == this.m_firstOutputParameter) {
                boolean bl = false;
                for (int i = n; i < this.m_paramsInfo.size() && !bl; ++i) {
                    if (this.m_paramsInfo.get((int)i).m_paramMode != 4 && this.m_paramsInfo.get((int)i).m_paramMode != 2) continue;
                    this.m_firstOutputParameter = i;
                    bl = true;
                    --this.m_outputParamCount;
                }
                if (!bl) {
                    this.m_firstOutputParameter = -1;
                    --this.m_outputParamCount;
                }
            }
            this.m_paramsInfo.remove(n);
        }
    }

    protected void finalizeParamsList() {
        if (null != this.m_paramsInfo) {
            if (null != this.m_paramsInfo && 0 < this.m_paramsInfo.size() && this.m_paramsInfo.get(0).getParamMode() == 5) {
                if (!this.m_hasReturnParameter) {
                    this.m_paramsInfo.remove(0);
                    --this.m_outputParamCount;
                } else {
                    this.m_paramsInfo.get((int)0).m_paramMode = 4;
                }
            } else if (this.m_hasReturnParameter && -1 != this.m_firstOutputParameter) {
                ParamInfo paramInfo = this.m_paramsInfo.remove(this.m_firstOutputParameter);
                this.m_paramsInfo.add(0, paramInfo);
            }
        }
    }

    public class ParamInfo {
        protected String m_paramName = "";
        protected Integer m_paramMode = 0;
        protected Integer m_paramTypeOID = null;

        public ParamInfo() {
        }

        public ParamInfo(Integer n, String string, int n2) {
            this.m_paramMode = n;
            this.m_paramName = string;
            this.m_paramTypeOID = n2;
        }

        public String getParamName() {
            return this.m_paramName;
        }

        public Integer getParamMode() {
            return this.m_paramMode;
        }

        public Integer getParamTypeOID() {
            return this.m_paramTypeOID;
        }
    }
}

