/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.aeprocessor.aetree.relation;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.utilities.ColumnMetadata;
import com.amazon.dsi.dataengine.utilities.TypeMetadata;
import com.amazon.sqlengine.aeprocessor.AEUtils;
import com.amazon.sqlengine.aeprocessor.aetree.AETreeWalker;
import com.amazon.sqlengine.aeprocessor.aetree.IAENode;
import com.amazon.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEValueSubQuery;
import com.amazon.sqlengine.aeprocessor.metadatautil.AEAbstractColumnInfo;
import com.amazon.sqlengine.aeprocessor.metadatautil.AECoercionColumnInfo;
import com.amazon.sqlengine.aeprocessor.metadatautil.MetadataColumnInfo;
import com.amazon.sqlengine.aeprocessor.metadatautil.MetadataUtilities;
import com.amazon.sqlengine.dsiext.dataengine.ICoercionHandler;
import com.amazon.sqlengine.dsiext.dataengine.IColumnInfo;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class AETableConstructor
extends AERelationalExpr {
    private final ICoercionHandler m_coercionHandler;
    private final List<AEValueExprList> m_rowConstructors;
    private List<? extends IColumn> m_metadata;
    private final boolean m_externalMetadata;

    public AETableConstructor(List<AEValueExprList> list, ICoercionHandler iCoercionHandler) throws ErrorException {
        this(list, null, iCoercionHandler);
    }

    public AETableConstructor(List<AEValueExprList> list, List<? extends IColumn> list2, ICoercionHandler iCoercionHandler) throws ErrorException {
        if (0 == list.size()) {
            throw new IllegalArgumentException();
        }
        this.m_metadata = list2;
        this.m_rowConstructors = list;
        this.m_coercionHandler = iCoercionHandler;
        if (null != list2) {
            this.m_externalMetadata = true;
            this.m_metadata = list2;
            this.validateMetadata();
        } else {
            this.m_externalMetadata = false;
            this.m_metadata = AETableConstructor.calculateMetadata(list, iCoercionHandler);
        }
        for (AEValueExprList aEValueExprList : this.m_rowConstructors) {
            aEValueExprList.setParent(this);
        }
    }

    private AETableConstructor(AETableConstructor aETableConstructor) {
        super(aETableConstructor);
        this.m_coercionHandler = aETableConstructor.m_coercionHandler;
        this.m_rowConstructors = new ArrayList<AEValueExprList>();
        for (AEValueExprList aEValueExprList : aETableConstructor.m_rowConstructors) {
            boolean bl = false;
            AETreeWalker aETreeWalker = new AETreeWalker(aEValueExprList);
            while (aETreeWalker.hasNext()) {
                IAENode iAENode = aETreeWalker.next();
                if (!(iAENode instanceof AEValueSubQuery)) continue;
                bl = true;
                break;
            }
            if (bl) {
                this.m_rowConstructors.add(aEValueExprList.copy());
                continue;
            }
            this.m_rowConstructors.add(aEValueExprList);
        }
        this.m_metadata = new ArrayList<IColumn>(aETableConstructor.m_metadata);
        this.m_externalMetadata = aETableConstructor.m_externalMetadata;
        for (AEValueExprList aEValueExprList : this.m_rowConstructors) {
            aEValueExprList.setParent(this);
        }
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    @Override
    public AETableConstructor copy() {
        return new AETableConstructor(this);
    }

    @Override
    public Iterator<? extends IAENode> getChildItr() {
        return Collections.unmodifiableList(this.m_rowConstructors).iterator();
    }

    @Override
    public IColumn getColumn(int n) {
        return this.m_metadata.get(n);
    }

    @Override
    public int getColumnCount() {
        return this.m_metadata.size();
    }

    @Override
    public int getNumChildren() {
        return this.m_rowConstructors.size();
    }

    public AEValueExprList getRow(int n) {
        return this.m_rowConstructors.get(n);
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        if (this == iAENode) {
            return true;
        }
        if (!(iAENode instanceof AETableConstructor)) {
            return false;
        }
        AETableConstructor aETableConstructor = (AETableConstructor)iAENode;
        if (this.m_rowConstructors.size() != aETableConstructor.m_rowConstructors.size()) {
            return false;
        }
        for (int i = 0; i < this.m_rowConstructors.size(); ++i) {
            if (this.m_rowConstructors.get(i).isEquivalent(aETableConstructor.m_rowConstructors.get(i))) continue;
            return false;
        }
        return true;
    }

    public void reprocessMetadata() throws ErrorException {
        if (this.m_externalMetadata) {
            this.validateMetadata();
        } else {
            this.m_metadata = AETableConstructor.calculateMetadata(this.m_rowConstructors, this.m_coercionHandler);
        }
    }

    @Override
    public boolean getDataNeeded(int n) {
        return true;
    }

    @Override
    public int setDataNeeded(AERelationalExpr aERelationalExpr, int n) throws ErrorException {
        return n;
    }

    @Override
    public void setDataNeededOnChild() throws ErrorException {
    }

    private void validateMetadata() throws ErrorException {
        assert (this.m_externalMetadata);
        assert (!this.m_rowConstructors.isEmpty());
        int n = this.m_metadata.size();
        for (AEValueExprList aEValueExprList : this.m_rowConstructors) {
            if (n != aEValueExprList.getNumChildren()) {
                throw SQLEngineExceptionFactory.invalidAETreeException();
            }
            for (int i = 0; i < n; ++i) {
                TypeMetadata typeMetadata = ((AEValueExpr)aEValueExprList.getChild(i)).getTypeMetadata();
                TypeMetadata typeMetadata2 = this.m_metadata.get(i).getTypeMetadata();
                boolean bl = AEUtils.isConversionLegal(typeMetadata.getType(), typeMetadata2.getType());
                if (bl) continue;
                throw SQLEngineExceptionFactory.conversionNotSupported(typeMetadata.getTypeName(), typeMetadata2.getTypeName());
            }
        }
    }

    private static List<ColumnMetadata> calculateMetadata(List<AEValueExprList> list, ICoercionHandler iCoercionHandler) throws ErrorException {
        Iterator<AEValueExprList> iterator = list.iterator();
        ArrayList<AEAbstractColumnInfo> arrayList = new ArrayList<AEAbstractColumnInfo>();
        AEValueExprList aEValueExprList = iterator.next();
        int n = aEValueExprList.getNumChildren();
        for (int i = 0; i < n; ++i) {
            arrayList.add(new AECoercionColumnInfo((AEValueExpr)aEValueExprList.getChild(i)));
        }
        while (iterator.hasNext()) {
            AEValueExprList aEValueExprList2 = iterator.next();
            if (aEValueExprList2.getNumChildren() != n) {
                throw SQLEngineExceptionFactory.invalidAETreeException();
            }
            for (int i = 0; i < n; ++i) {
                IColumn object = iCoercionHandler.coerceUnionColumns((IColumnInfo)arrayList.get(i), new AECoercionColumnInfo((AEValueExpr)aEValueExprList2.getChild(i)));
                arrayList.set(i, new MetadataColumnInfo(object, IColumnInfo.ColumnType.COLUMN));
            }
        }
        ArrayList<ColumnMetadata> arrayList2 = new ArrayList<ColumnMetadata>(arrayList.size());
        for (IColumnInfo iColumnInfo : arrayList) {
            arrayList2.add(MetadataUtilities.createColumnMetadata(iColumnInfo));
        }
        return arrayList2;
    }
}

