/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.redshift.CredentialsHolder;
import com.amazon.redshift.IPlugin;
import com.amazon.redshift.core.PGJDBCSettings;
import com.amazon.support.ILogger;
import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.profile.ProfilesConfigFile;
import com.amazonaws.auth.profile.internal.BasicProfile;
import com.amazonaws.auth.profile.internal.ProfileStaticCredentialsProvider;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleResult;
import com.amazonaws.services.securitytoken.model.Credentials;
import com.amazonaws.util.StringUtils;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PluginProfilesConfigFile
extends ProfilesConfigFile {
    private Map<String, CredentialsHolder> cache = new ConcurrentHashMap<String, CredentialsHolder>();
    private PGJDBCSettings m_settings;
    private ILogger m_log;

    public PluginProfilesConfigFile(PGJDBCSettings pGJDBCSettings, ILogger iLogger) {
        this.m_settings = pGJDBCSettings;
        this.m_log = iLogger;
    }

    public CredentialsHolder getCredentials(String string) {
        Object object;
        CredentialsHolder credentialsHolder = this.cache.get(string);
        if (credentialsHolder != null && !credentialsHolder.isExpired()) {
            return credentialsHolder;
        }
        Map map = this.getAllBasicProfiles();
        BasicProfile basicProfile = (BasicProfile)map.get(string);
        if (basicProfile == null) {
            throw new SdkClientException("No AWS profile named '" + string + "'");
        }
        if (basicProfile.isRoleBasedProfile()) {
            String string2 = basicProfile.getRoleSourceProfile();
            CredentialsHolder credentialsHolder2 = this.getCredentials(string2);
            AWSStaticCredentialsProvider aWSStaticCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)credentialsHolder2);
            credentialsHolder = this.assumeRole(basicProfile, (AWSCredentialsProvider)aWSStaticCredentialsProvider);
            credentialsHolder.setMetadata(credentialsHolder2.getMetadata());
            this.cache.put(string, credentialsHolder);
            return credentialsHolder;
        }
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = basicProfile.getPropertyValue("plugin_name");
        if (!StringUtils.isNullOrEmpty((String)string6)) {
            try {
                object = Class.forName(string6).asSubclass(AWSCredentialsProvider.class);
                AWSCredentialsProvider aWSCredentialsProvider = (AWSCredentialsProvider)((Class)object).newInstance();
                if (aWSCredentialsProvider instanceof IPlugin) {
                    String string2;
                    IPlugin iPlugin = (IPlugin)aWSCredentialsProvider;
                    iPlugin.setILogger(this.m_log);
                    Map map2 = basicProfile.getProperties();
                    for (Map.Entry entry : map2.entrySet()) {
                        string2 = ((String)entry.getKey()).toLowerCase(Locale.getDefault());
                        if ("plugin_name".equals(string2)) continue;
                        String string7 = (String)entry.getValue();
                        iPlugin.addParameter(string2, string7);
                        if ("DbUser".equalsIgnoreCase(string2)) {
                            string3 = string7;
                            continue;
                        }
                        if ("DbGroups".equalsIgnoreCase(string2)) {
                            string5 = string7;
                            continue;
                        }
                        if (!"AutoCreate".equalsIgnoreCase(string2)) continue;
                        string4 = string7;
                    }
                    for (Map.Entry<Object, Object> entry : this.m_settings.m_pluginArgs.entrySet()) {
                        string2 = ((String)entry.getKey()).toLowerCase(Locale.getDefault());
                        if ("plugin_name".equals(string2)) continue;
                        iPlugin.addParameter((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                credentialsHolder = CredentialsHolder.newInstance(aWSCredentialsProvider.getCredentials());
            }
            catch (InstantiationException instantiationException) {
                throw new SdkClientException("Invalid plugin: '" + string6 + "'");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SdkClientException("Invalid plugin: '" + string6 + "'");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SdkClientException("Invalid plugin: '" + string6 + "'");
            }
        } else {
            object = new ProfileStaticCredentialsProvider(basicProfile).getCredentials();
            credentialsHolder = CredentialsHolder.newInstance((AWSCredentials)object);
        }
        object = credentialsHolder.getMetadata();
        if (null == object) {
            object = new CredentialsHolder.IamMetadata();
        }
        if (null != string3) {
            ((CredentialsHolder.IamMetadata)object).setProfileDbUser(string3);
        }
        if (null != string4) {
            ((CredentialsHolder.IamMetadata)object).setAutoCreate(Boolean.valueOf(string4));
        }
        if (null != string5) {
            ((CredentialsHolder.IamMetadata)object).setDbGroups(string5);
        }
        credentialsHolder.setMetadata((CredentialsHolder.IamMetadata)object);
        this.cache.put(string, credentialsHolder);
        return credentialsHolder;
    }

    private CredentialsHolder assumeRole(BasicProfile basicProfile, AWSCredentialsProvider aWSCredentialsProvider) {
        AWSSecurityTokenServiceClientBuilder aWSSecurityTokenServiceClientBuilder = AWSSecurityTokenServiceClientBuilder.standard();
        if (!StringUtils.isNullOrEmpty((String)this.m_settings.m_awsRegion)) {
            aWSSecurityTokenServiceClientBuilder.setRegion(this.m_settings.m_awsRegion);
        }
        AWSSecurityTokenService aWSSecurityTokenService = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)aWSSecurityTokenServiceClientBuilder.withCredentials(aWSCredentialsProvider)).build();
        String string = basicProfile.getRoleArn();
        String string2 = basicProfile.getRoleSessionName();
        if (StringUtils.isNullOrEmpty((String)string2)) {
            string2 = "redshift-jdbc-" + System.currentTimeMillis();
        }
        String string3 = basicProfile.getRoleExternalId();
        AssumeRoleRequest assumeRoleRequest = new AssumeRoleRequest().withRoleArn(string).withRoleSessionName(string2);
        if (!StringUtils.isNullOrEmpty((String)string3)) {
            assumeRoleRequest = assumeRoleRequest.withExternalId(string3);
        }
        AssumeRoleResult assumeRoleResult = aWSSecurityTokenService.assumeRole(assumeRoleRequest);
        Credentials credentials = assumeRoleResult.getCredentials();
        Date date = credentials.getExpiration();
        BasicSessionCredentials basicSessionCredentials = new BasicSessionCredentials(credentials.getAccessKeyId(), credentials.getSecretAccessKey(), credentials.getSessionToken());
        return CredentialsHolder.newInstance((AWSCredentials)basicSessionCredentials, date);
    }
}

