/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.value.functor.arithmetic;

import com.amazon.sqlengine.executor.conversions.ConversionUtil;
import com.amazon.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.amazon.sqlengine.executor.etree.ETDataRequest;
import com.amazon.sqlengine.executor.etree.value.functor.arithmetic.DateTimeFunctorUtil;
import com.amazon.sqlengine.executor.etree.value.functor.arithmetic.IBinaryArithmeticFunctor;
import com.amazon.support.IWarningListener;
import com.amazon.support.conv.ConversionResult;
import com.amazon.support.conv.DateTimeConverter;
import com.amazon.support.exceptions.ErrorException;
import java.math.BigInteger;
import java.sql.Timestamp;

public class TimestampAddBigIntFunctor
implements IBinaryArithmeticFunctor {
    @Override
    public boolean execute(ETDataRequest eTDataRequest, ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2, IWarningListener iWarningListener) throws ErrorException {
        if (iSqlDataWrapper.isNull() || iSqlDataWrapper2.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        Timestamp timestamp = null;
        BigInteger bigInteger = null;
        if (iSqlDataWrapper.getType() == 93) {
            timestamp = iSqlDataWrapper.getTimestamp();
            bigInteger = iSqlDataWrapper2.getBigInt();
        } else {
            timestamp = iSqlDataWrapper2.getTimestamp();
            bigInteger = iSqlDataWrapper.getBigInt();
        }
        timestamp = DateTimeFunctorUtil.timestampPlusBigint(timestamp, bigInteger);
        ConversionResult conversionResult = new ConversionResult();
        timestamp = DateTimeConverter.toTimestamp(timestamp, conversionResult, eTDataRequest.getColumn().getTypeMetadata().getPrecision());
        ConversionUtil.checkResult(conversionResult, iWarningListener, -1, -1);
        eTDataRequest.getData().setTimestamp(timestamp);
        return false;
    }
}

