/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.support.EscapeTypes;
import com.amazon.support.IReplacer;
import java.util.ArrayList;

public class PGReplacer
implements IReplacer {
    public static final String CHAR = "&f%n&char";
    public static final String UCASE = "&f%n&ucase";
    public static final String LCASE = "&f%n&lcase";
    public static final String IFNULL = "&f%n&ifnull";
    public static final String NOW = "&f%n&now";
    public static final String MONTHNAME = "&f%n&monthname";
    public static final String QUARTER = "&f%n&quarter";
    public static final String DAYOFMONTH = "&f%n&dayofmonth";
    public static final String DAYOFYEAR = "&f%n&dayofyear";
    public static final String DAYOFWEEK = "&f%n&dayofweek";
    public static final String DAYNAME = "&f%n&dayname";
    public static final String WEEK = "&f%n&week";
    public static final String DAY = "&f%n&day";
    public static final String HOUR = "&f%n&hour";
    public static final String MINUTE = "&f%n&minute";
    public static final String SECOND = "&f%n&second";
    public static final String RAND = "&f%n&rand";
    public static final String LOG10 = "&f%n&log10";
    public static final String USER = "&f%n&user";
    public static final String CURDATE = "&f%n&curdate";
    public static final String CURTIME = "&f%n&curtime";
    public static final String LOG = "&f%n&log";
    public static final String TRUNCATE = "&f%n&truncate";
    public static final String DATABASE = "&f%n&database";
    public static final String SPACE = "&f%n&space";
    public static final String MONTH = "&f%n&month";
    public static final String YEAR = "&f%n&year";
    public static final String LOCATE = "&f%n&locate";
    public static final String INSERT = "&f%n&insert";
    public static final String CONVERT = "&f%n&convert";
    private static int m_numParams;
    private boolean m_unloadQuery;

    public PGReplacer() {
        m_numParams = 0;
        this.m_unloadQuery = false;
    }

    public static int getNumParams() {
        return m_numParams;
    }

    public void resetReplacer() {
        m_numParams = 0;
        this.m_unloadQuery = false;
    }

    public void isUnloadQuery(boolean bl) {
        this.m_unloadQuery = bl;
    }

    @Override
    public StringBuilder replace(EscapeTypes escapeTypes, ArrayList<StringBuilder> arrayList) {
        StringBuilder stringBuilder = new StringBuilder();
        switch (escapeTypes) {
            case PARAM: {
                return stringBuilder.append(" $" + ++m_numParams + " ");
            }
            case TIME: 
            case ESCAPE: {
                return stringBuilder.append(escapeTypes.toString()).append(" " + arrayList.get(0));
            }
            case DATE: 
            case TIMESTAMP: {
                return stringBuilder.append(escapeTypes.toString().toLowerCase() + " ").append((CharSequence)arrayList.get(0));
            }
            case OUTERJOIN: {
                int n = arrayList.size();
                stringBuilder.append("(");
                for (int i = 0; i < n; ++i) {
                    stringBuilder.append((CharSequence)arrayList.get(i));
                    if (i == n - 1) continue;
                    stringBuilder.append(" ");
                }
                return stringBuilder.append(")");
            }
            case GUID: {
                return stringBuilder.append(arrayList.get(0) + "::UUID ");
            }
            case RESULT: 
            case CALL: {
                return stringBuilder.append("select " + this.replace(EscapeTypes.FN, arrayList) + " as result");
            }
            case FN: {
                if (arrayList.size() == 1) {
                    return arrayList.get(0);
                }
                String string = "&f%n&" + arrayList.get(0).toString().toLowerCase();
                if (string.equals(CHAR)) {
                    arrayList.set(0, new StringBuilder("chr"));
                } else if (string.equals(LCASE)) {
                    arrayList.set(0, new StringBuilder("lower"));
                } else if (string.equals(UCASE)) {
                    arrayList.set(0, new StringBuilder("upper"));
                } else if (string.equals(LOCATE)) {
                    if (3 == arrayList.size() || 4 == arrayList.size()) {
                        String string2 = arrayList.get(1).toString();
                        String string3 = arrayList.get(2).toString();
                        if (3 == arrayList.size()) {
                            return stringBuilder.append("strpos(" + string3 + " , " + string2 + ")");
                        }
                        if (4 == arrayList.size()) {
                            String string4 = arrayList.get(3).toString();
                            return stringBuilder.append("strpos ( substring(" + string3 + " from " + string4 + "), " + string2 + ") +" + string4 + "-1");
                        }
                    }
                } else if (string.equals(INSERT)) {
                    if (5 == arrayList.size()) {
                        String string5 = arrayList.get(1).toString();
                        String string6 = arrayList.get(2).toString();
                        String string7 = arrayList.get(3).toString();
                        String string8 = arrayList.get(4).toString();
                        return stringBuilder.append("substring(" + string5 + " from " + string7 + " for " + string6 + "-" + string7 + ") || " + string8 + " || substring(" + string5 + " from " + string6 + "+" + string7 + ")");
                    }
                } else {
                    if (string.equals(SPACE)) {
                        return stringBuilder.append("repeat(' '," + arrayList.get(1) + ")");
                    }
                    if (string.equals(LOG10)) {
                        arrayList.set(0, new StringBuilder("log"));
                    } else if (string.equals(TRUNCATE)) {
                        arrayList.set(0, new StringBuilder("trunc"));
                    } else {
                        if (string.equals(DATABASE)) {
                            return stringBuilder.append("current_database");
                        }
                        if (string.equals(USER)) {
                            return stringBuilder.append("user");
                        }
                        if (string.equals(RAND)) {
                            return stringBuilder.append("random");
                        }
                        if (string.equals(CURDATE)) {
                            return stringBuilder.append("current_date");
                        }
                        if (string.equals(CURTIME)) {
                            return stringBuilder.append("current_time");
                        }
                        if (string.equals(DAYNAME)) {
                            if (this.m_unloadQuery) {
                                return stringBuilder.append("to_char( " + arrayList.get(1) + ", \\'day\\')");
                            }
                            return stringBuilder.append("to_char( " + arrayList.get(1) + ", 'day')");
                        }
                        if (string.equals(MONTHNAME)) {
                            if (this.m_unloadQuery) {
                                return stringBuilder.append("to_char( " + arrayList.get(1) + ", \\'month\\')");
                            }
                            return stringBuilder.append("to_char( " + arrayList.get(1) + ", 'month')");
                        }
                        if (string.equals(DAYOFMONTH)) {
                            return stringBuilder.append("extract ( day from " + arrayList.get(1) + ")");
                        }
                        if (string.equals(DAYOFWEEK)) {
                            return stringBuilder.append("extract ( dow from " + arrayList.get(1) + ")+1");
                        }
                        if (string.equals(DAYOFYEAR)) {
                            return stringBuilder.append("extract(doy from " + arrayList.get(1) + ")");
                        }
                        if (string.equals(HOUR)) {
                            return stringBuilder.append("extract ( hour from " + arrayList.get(1) + ")");
                        }
                        if (string.equals(MINUTE)) {
                            return stringBuilder.append("extract ( minute from " + arrayList.get(1) + ")");
                        }
                        if (string.equals(MONTH)) {
                            return stringBuilder.append("extract ( month from " + arrayList.get(1) + ")");
                        }
                        if (string.equals(QUARTER)) {
                            return stringBuilder.append("extract ( quarter from " + arrayList.get(1) + ")");
                        }
                        if (string.equals(SECOND)) {
                            return stringBuilder.append("extract ( second from " + arrayList.get(1) + ")");
                        }
                        if (string.equals(WEEK)) {
                            return stringBuilder.append("extract ( week from " + arrayList.get(1) + ")");
                        }
                        if (string.equals(YEAR)) {
                            return stringBuilder.append("extract ( year from " + arrayList.get(1) + ")");
                        }
                        if (string.equals(DAY)) {
                            return stringBuilder.append("extract ( day from " + arrayList.get(1) + ")");
                        }
                        if (string.equals(IFNULL)) {
                            arrayList.set(0, new StringBuilder("coalesce"));
                        } else {
                            if (string.equals(NOW)) {
                                return stringBuilder.append("getdate");
                            }
                            if (string.equals(CONVERT)) {
                                return stringBuilder.append("cast( " + arrayList.get(2) + " as " + arrayList.get(1) + " )");
                            }
                        }
                    }
                }
                return stringBuilder.append(arrayList.get(0) + "(" + this.joinStrings(arrayList, 1, arrayList.size(), ',') + ")");
            }
            case LIKE_ESCAPE: {
                return stringBuilder.append(arrayList.get(0) + " escape " + arrayList.get(1));
            }
        }
        return stringBuilder.append("NOT IMPLEMENTED: ").append(escapeTypes.toString());
    }

    private String joinStrings(ArrayList<StringBuilder> arrayList, int n, int n2, char c) {
        StringBuilder stringBuilder = new StringBuilder();
        while (n < n2) {
            stringBuilder.append((CharSequence)arrayList.get(n));
            stringBuilder.append(c);
            ++n;
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }
}

