/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.dataengine.PGReplacer;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.EscapeTypes;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PGEscaper {
    private static final int RETYPE_NAME = 1;
    private static final int RETYPE_VALUE = 2;
    private static final int RETYPE_LIMIT = 3;
    private static final int RETYPE_OFFSET = 4;
    private static final int RETYPE_FNAME = 5;
    private static final int RETYPE_ARGIND = 6;
    private static final int RETYPE_LAST = 6;
    private static final int LIKEESCAPE_PATTERN = 2;
    private static final String WS = " \\s* ";
    private static final String QWORD = "\\[ [^\\]]* \\] ";
    private static final String QNUM = "\\? | \\d+";
    private static final String CCB = "[}]";
    private static final String ARGIND = "[(] |[}]";
    private static final String CONVERT = "convert";
    private static final String LIKE = "like";
    private static final String ESCAPE = "escape";
    private static final int flags = 14;
    private static final Pattern s_re_scan = Pattern.compile("(?:           \" [^\"]* \" | (?<! \\b E ) \" [^\"]*   (?<!\\\\{1})\" |      \\b E   ' (?: \\\\.  |  [^'] )* ' | (?<! \\b E ) ' [^']*   (?<!\\\\{1})' |(?<!\\\\{1})'[^']*(?<!\\\\{1})'?|  \\[ [^\\]]* \\] | -- [^\\n]*   $| /[*]  (?: [^/] | (?<= [^*]) / )*  \\*/| (?! \\b ( CONVERT \\( | LIKE \\b) ) [^$,{?}()] | [^$,{?}()] ){0,1000}", 14);
    private static final Pattern s_re_type = Pattern.compile(" \\s* (  (?:    (?: d | escape | guid | interval | ts | t ) \\s*     ( (?: - \\s* )?      ' [^']* '      [-().,:/\\s\\w]*    )  ) \\s* [}]| (?:limit \\s* (\\? | \\d+) (?:  \\s*  offset  \\s*  (\\? | \\d+) )? ) \\s* [}]| oj | (?: call | fn | [?] \\s* = \\s* call ) \\s*   ( [\\w.]+   | \" [^\"]* \"    | \\[ [^\\]]* \\]  (?:  \\s* [.] \\s* \\[ [^\\]]* \\]  )*  ) \\s*   ( [(] |[}] )) \\s* ", 14);
    private static final Pattern s_re_likeEscape = Pattern.compile("(LIKE(\\s)*((?:'[^']*')+|\\?|(?:(\\s)+\"[^\"]*\")+))((?:(\\s)+ESCAPE(\\s)+((?:'[^']*')+|\\?|(?:(\\s)+\"[^\"]*\")+))|(\\s)*\\{(\\s)*ESCAPE(\\s)+((?:'[^']*')+|\\?|(?:(\\s)+\"[^\"]*\")+)(\\s)*\\})", 14);
    private static final Pattern s_re_unloadType = Pattern.compile(" \\s* (  (?:    (?: d | escape | guid | interval | ts | t ) \\s*     ( (?: - \\s* )?      (\\\\)*' [^']* (\\\\)*'      [-().,:/\\s\\w]*    )  ) \\s* [}]| (?:limit \\s* (\\? | \\d+) (?:  \\s*  offset  \\s*  (\\? | \\d+) )? ) \\s* [}]| oj | (?: call | fn | [?] \\s* = \\s* call ) \\s*   ( [\\w.]+ |\"[^\"]*\"  | \\[ [^\\]]* \\]  (?:  \\s* [.] \\s* \\[ [^\\]]* \\]  )*  ) \\s*   ( [(] |[}] )) \\s* ", 14);
    private static final Pattern s_re_unloadQuery = Pattern.compile("(?:(?<!--|/\\*|#|\\w)(unload)(.*)(\\s)*\\(')(.*)(?:'\\))");
    private static final Pattern s_re_unloadScan = Pattern.compile("(?:\"[^\"]*\"|\\bE'(?:\\\\.|[^'])*'|(?<!\\bE)\\\\'[^']*\\\\'|\\[ [^\\]]* \\] |--[^\\n]*$|/[*](?:[^/]|(?<= [^*])/)*\\*/|(?!\\b(CONVERT\\(|LIKE\\b))[^$,{?}()]|[^$,{?}()])*", 14);
    private static final Pattern s_re_escapeQuote = Pattern.compile("(?<!\\\\)(\\\\{1}'[^']*\\\\{1}')|(\\\\{1}\"[^\"]*\\\\{1}\")", 14);
    private static final Pattern s_re_parameters = Pattern.compile("(?<!')\\?|\\\\{1}'\\?", 14);
    private static final Pattern s_re_queryAsParameter = Pattern.compile("(?:(([^{])(\\s)*([^f][^n])(\\s)*(\\w*\\(')))(.*'\\))", 14);
    private static final Pattern s_re_comment = Pattern.compile("(?:-- [^\\n]*   $| /[*]  (?: [^/] | (?<= [^*]) / )*  \\*/)", 14);
    private static final Pattern s_re_string = Pattern.compile("(?: \" [^\"]* \" | (?<! \\b E ) \" [^\"]*  (?<!\\\\{1})\" |      \\b E   ' (?: \\\\.  |  [^'] )* ' | (?<! \\b E ) ' [^']* (?<!\\\\{1})' |(?<!\\\\{1})'[^']*(?<!\\\\{1})'| \\[ [^\\]]* \\]  )", 14);
    private static final Pattern s_re_unloadString = Pattern.compile("(?: \" [^\"]* \" | (?<! \\b E ) \" [^\"]*  (?<!\\\\{1})\" |      \\b E   ' (?: \\\\.  |  [^'] )* ' | (?<! \\b E ) \\\\'[^']* (?<!\\\\{2})' |(?<!\\\\{2})'[^']*(?<!\\\\{2})'| \\[ [^\\]]* \\]  )", 14);
    private static final Pattern s_re_inlineFunc = Pattern.compile("(?:(\\b ( CONVERT \\( | LIKE \\b) ) [^$,{?}()] )", 14);
    private static final Pattern s_re_sign = Pattern.compile("(?:[^$,{?}()] )*", 14);
    private static final PGReplacer s_re_replacer = new PGReplacer();
    private String m_query;
    private Matcher typeMatcher;
    private Matcher likeMatcher;
    private Matcher parameterMatcher;
    private Matcher commentMatcher;
    private Matcher stringMatcher;
    private Matcher inlineFuncMatcher;
    private Matcher signMatcher;
    private boolean m_queryAsParameterFlag;

    public boolean isUnloadStatement() {
        return this.m_queryAsParameterFlag;
    }

    public boolean isUnloadStatement(String string) {
        Matcher matcher = s_re_unloadQuery.matcher(string.toLowerCase());
        if (matcher.find()) {
            this.m_queryAsParameterFlag = true;
        }
        return this.m_queryAsParameterFlag;
    }

    public int parameterCounter() {
        return s_re_replacer.getNumParams();
    }

    public int parameterCounter(String string) {
        try {
            this.apply(string);
        }
        catch (ErrorException errorException) {
            return -1;
        }
        return s_re_replacer.getNumParams();
    }

    public String apply(String string) throws ErrorException {
        int n;
        Object object;
        if (null == string || string.isEmpty()) {
            return string;
        }
        assert (s_re_replacer != null);
        s_re_replacer.resetReplacer();
        StringBuilder stringBuilder = new StringBuilder();
        this.m_query = string;
        this.typeMatcher = null;
        this.likeMatcher = null;
        this.parameterMatcher = null;
        this.commentMatcher = null;
        this.stringMatcher = null;
        this.signMatcher = null;
        this.inlineFuncMatcher = null;
        Matcher matcher = s_re_escapeQuote.matcher(string);
        if (matcher.find()) {
            object = new StringBuilder();
            n = matcher.start();
            int n2 = matcher.end();
            ((StringBuilder)object).append(string.substring(0, n));
            ((StringBuilder)object).append(string.substring(n + 2, n2 - 2));
            ((StringBuilder)object).append(string.substring(n2));
            this.m_query = ((StringBuilder)object).toString();
        }
        if (((Matcher)(object = s_re_unloadQuery.matcher(this.m_query.toLowerCase()))).find()) {
            this.m_queryAsParameterFlag = true;
            s_re_replacer.isUnloadQuery(this.m_queryAsParameterFlag);
            n = ((Matcher)object).start() + ((Matcher)object).group().indexOf("('") + 2;
            stringBuilder.append(this.m_query.substring(0, n));
            this.m_query = string.substring(n);
            this.stringMatcher = s_re_unloadString.matcher(this.m_query);
            this.typeMatcher = s_re_unloadType.matcher(this.m_query.toLowerCase());
        } else {
            this.m_queryAsParameterFlag = false;
            this.stringMatcher = s_re_string.matcher(this.m_query);
            this.typeMatcher = s_re_type.matcher(this.m_query.toLowerCase());
        }
        this.likeMatcher = s_re_likeEscape.matcher(string.toUpperCase());
        this.parameterMatcher = s_re_parameters.matcher(this.m_query);
        this.commentMatcher = s_re_comment.matcher(this.m_query);
        this.signMatcher = s_re_sign.matcher(this.m_query);
        this.inlineFuncMatcher = s_re_inlineFunc.matcher(this.m_query.toUpperCase());
        n = this.apply(0, 0, stringBuilder);
        return stringBuilder.toString();
    }

    public int scan(String string, int n, String string2) {
        if (string == null || string.isEmpty()) {
            return 0;
        }
        this.m_query = string;
        Matcher matcher = s_re_scan.matcher(this.m_query);
        n = this.scan(n, string2, matcher);
        return n;
    }

    /*
     * Unable to fully structure code
     */
    private int apply(int var1_1, int var2_2, StringBuilder var3_3) throws ErrorException {
        if (!PGEscaper.$assertionsDisabled && PGEscaper.s_re_replacer == null) {
            throw new AssertionError();
        }
        if (!PGEscaper.$assertionsDisabled && this.stringMatcher == null) {
            throw new AssertionError();
        }
        if (!PGEscaper.$assertionsDisabled && this.commentMatcher == null) {
            throw new AssertionError();
        }
        if (!PGEscaper.$assertionsDisabled && this.inlineFuncMatcher == null) {
            throw new AssertionError();
        }
        if (!PGEscaper.$assertionsDisabled && this.signMatcher == null) {
            throw new AssertionError();
        }
        if (!PGEscaper.$assertionsDisabled && this.typeMatcher == null) {
            throw new AssertionError();
        }
        if (!PGEscaper.$assertionsDisabled && this.m_query == null) {
            throw new AssertionError();
        }
        var4_4 = "?{";
        var5_5 = EscapeTypes.UNKNOWN;
        var6_6 = -1;
        var7_7 = 0;
        var8_8 = 0;
        var9_9 = new StringBuilder();
        var10_10 = new ArrayList<StringBuilder>();
        while (true) {
            block83: {
                block82: {
                    var11_11 = this.scan(var1_1, var4_4, this.commentMatcher);
                    var12_12 = this.scan(var1_1, var4_4, this.stringMatcher);
                    var13_13 = this.scan(var1_1, var4_4, this.inlineFuncMatcher);
                    var14_14 = this.scan(var1_1, var4_4, this.signMatcher);
                    var8_8 = Math.min(var11_11, Math.min(var12_12, Math.min(var13_13, var14_14)));
                    var15_15 = "?{".equals(var4_4) != false ? var3_3 : ("}".equals(var4_4) != false ? var9_9 : (StringBuilder)var10_10.get(var10_10.size() - 1));
                    if (var8_8 > var1_1) {
                        var15_15.append(this.m_query.substring(var1_1, var8_8));
                    }
                    if (var8_8 >= this.m_query.length()) break;
                    if (!Character.isLetter(this.m_query.charAt(var8_8))) break block82;
                    if (var4_4.equals(",)(}?{")) {
                        if (!PGEscaper.$assertionsDisabled && var7_7 <= 0) {
                            throw new AssertionError();
                        }
                        try {
                            var8_8 = this.apply(var8_8, var2_2, var15_15);
                        }
                        catch (Throwable var16_17) {
                            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_ESCAPER_ERR, this.m_query);
                        }
                    } else if ('L' != this.m_query.charAt(var8_8) && 'l' != this.m_query.charAt(var8_8) && this.m_query.length() - var8_8 > 6 && this.m_query.substring(var8_8, var8_8 + 6).equalsIgnoreCase("convert")) {
                        if (!PGEscaper.$assertionsDisabled && var7_7 != 0) {
                            throw new AssertionError();
                        }
                        var5_5 = EscapeTypes.FN;
                        var17_19 = var16_16 = this.m_query.indexOf("(", var8_8);
                        while (Character.isSpaceChar(this.m_query.charAt(var17_19 - 1))) {
                            --var17_19;
                        }
                        var10_10.clear();
                        var10_10.add(new StringBuilder(this.m_query.substring(var8_8, var17_19)));
                        var8_8 = var16_16 + 1;
                        var7_7 = 1;
                        var4_4 = ",)(}?{";
                    } else if (this.m_query.length() - var8_8 > 6 && this.m_query.substring(var8_8, var8_8 + 4).equalsIgnoreCase("like") && !this.likeMatcher.find(var8_8)) {
                        var3_3.append("like".toUpperCase());
                        var8_8 += 4;
                    } else if (this.m_query.length() - var8_8 > 10 && this.m_query.substring(var8_8, var8_8 + 4).equalsIgnoreCase("like") && this.m_query.toLowerCase().contains("escape")) {
                        var5_5 = EscapeTypes.LIKE_ESCAPE;
                        var16_16 = 2;
                        while (null == this.likeMatcher.group(var16_16)) {
                            ++var16_16;
                        }
                        var3_3.append(this.m_query.substring(var8_8, this.likeMatcher.start(var16_16)));
                        var3_3.append(" ");
                        var10_10.clear();
                        var17_20 = this.likeMatcher.group(var16_16);
                        var18_22 = var16_16 + 1;
                        while (2 > var17_20.length()) {
                            var19_23 = this.likeMatcher.start(var18_22);
                            var20_24 = this.likeMatcher.end(var18_22);
                            if (-1 != var19_23 && -1 != var20_24) {
                                var17_20 = this.m_query.substring(this.likeMatcher.start(var18_22), this.likeMatcher.end(var18_22++));
                                if (var17_20.equals("?")) {
                                    var17_20 = PGEscaper.s_re_replacer.replace(EscapeTypes.PARAM, var10_10).toString();
                                }
                                if (var18_22 != this.likeMatcher.groupCount()) continue;
                                return this.m_query.length();
                            }
                            ++var18_22;
                        }
                        var21_25 = -1;
                        while (-1 == var21_25) {
                            var21_25 = this.likeMatcher.start(var18_22);
                            if (null == this.likeMatcher.group(var18_22) || 2 > this.likeMatcher.group(var18_22).length() || this.likeMatcher.group(var18_22).toUpperCase().contains("escape".toUpperCase())) {
                                var21_25 = -1;
                            }
                            if (++var18_22 != this.likeMatcher.groupCount()) continue;
                            return this.m_query.length();
                        }
                        if ((var22_26 = this.m_query.substring(this.likeMatcher.start(--var18_22), this.likeMatcher.end(var18_22))).equals("?")) {
                            var22_26 = PGEscaper.s_re_replacer.replace(EscapeTypes.PARAM, var10_10).toString();
                        }
                        var10_10.add(new StringBuilder(var17_20));
                        var10_10.add(new StringBuilder(var22_26));
                        var3_3.append(PGEscaper.s_re_replacer.replace(var5_5, var10_10).toString());
                        var4_4 = "?{";
                        var8_8 = this.likeMatcher.end(0);
                    } else {
                        var16_16 = this.m_query.indexOf(" ", var8_8) + 1;
                        if (var16_16 > var8_8) {
                            var15_15.append(this.m_query.substring(var8_8, var16_16));
                            var8_8 = var16_16;
                        } else {
                            var15_15.append(this.m_query.substring(var8_8++, var8_8));
                        }
                    }
                    break block83;
                }
                block2 : switch (this.m_query.charAt(var8_8++)) {
                    case '?': {
                        if (this.parameterMatcher.find(var8_8 - 3)) {
                            var16_16 = (int)this.stringMatcher.find(0);
                            if (var16_16 != 0 && this.stringMatcher.start(0) < var8_8 - 1 && this.stringMatcher.end(0) > var8_8 - 1) {
                                var15_15.append('?');
                                break;
                            }
                            var17_19 = 0;
                            while (var16_16 != 0 && -1 != this.stringMatcher.end(0) && this.stringMatcher.end(0) < var8_8 - 1) {
                                var18_22 = this.stringMatcher.end(0);
                                var16_16 = (int)this.stringMatcher.find(var18_22);
                                if (var16_16 == 0 || this.stringMatcher.start(0) >= var8_8 - 1 || this.stringMatcher.end(0) <= var8_8 - 1) continue;
                                var15_15.append('?');
                                var17_19 = 1;
                                var16_16 = 0;
                            }
                            if (var17_19 != 0) break;
                            var18_22 = this.stringMatcher.find(var1_1);
                            var19_23 = this.commentMatcher.find(var1_1);
                            if (var18_22 != 0 || var19_23 != 0) {
                                if (var18_22 != 0 && (this.stringMatcher.start(0) > var8_8 - 1 || this.stringMatcher.end(0) < var8_8 - 1)) {
                                    if (var19_23 == 0 || var19_23 != 0 && (this.commentMatcher.start(0) > var8_8 - 1 || this.commentMatcher.end(0) < var8_8 - 1)) {
                                        var15_15.append((CharSequence)PGEscaper.s_re_replacer.replace(EscapeTypes.PARAM, var10_10));
                                        break;
                                    }
                                    var15_15.append('?');
                                    break;
                                }
                                if (var18_22 != 0) {
                                    var15_15.append('?');
                                    break;
                                }
                                if (var19_23 != 0 && (this.commentMatcher.start(0) > var8_8 - 1 || this.commentMatcher.end(0) < var8_8 - 1)) {
                                    var15_15.append((CharSequence)PGEscaper.s_re_replacer.replace(EscapeTypes.PARAM, var10_10));
                                    break;
                                }
                                var15_15.append('?');
                                break;
                            }
                            var15_15.append((CharSequence)PGEscaper.s_re_replacer.replace(EscapeTypes.PARAM, var10_10));
                            break;
                        }
                        var15_15.append('?');
                        break;
                    }
                    case '(': {
                        ++var7_7;
                        var15_15.append('(');
                        break;
                    }
                    case ')': {
                        if (--var7_7 == 0 && ",)(}?{".equals(var4_4)) {
                            var4_4 = "}";
                            break;
                        }
                        var15_15.append(')');
                        break;
                    }
                    case ',': {
                        if (var7_7 == 1) {
                            var6_6 = var8_8;
                            var10_10.add(new StringBuilder(""));
                            break;
                        }
                        var15_15.append(',');
                        break;
                    }
                    case '}': {
                        if (!PGEscaper.$assertionsDisabled && "?{".equals(var4_4)) {
                            throw new AssertionError();
                        }
                        for (var16_16 = 1; var16_16 < var10_10.size(); ++var16_16) {
                            var17_21 = (StringBuilder)var10_10.get(var16_16);
                            while (0 != var17_21.length() && Character.isWhitespace(var17_21.charAt(0))) {
                                var17_21.deleteCharAt(0);
                            }
                        }
                        var23_27 = var3_3.length();
                        if (var23_27 > 0 && Character.isLetterOrDigit(var3_3.charAt(var23_27 - 1))) {
                            var3_3.append(" ");
                        }
                        var3_3.append((CharSequence)PGEscaper.s_re_replacer.replace(var5_5, var10_10)).append((CharSequence)var9_9);
                        var10_10.clear();
                        var9_9 = new StringBuilder();
                        if (var2_2 > 0) {
                            return var8_8;
                        }
                        var4_4 = "?{";
                        break;
                    }
                    case '{': {
                        if (!"?{".equals(var4_4)) {
                            try {
                                var8_8 = this.apply(var8_8 - 1, var2_2 + 1, var10_10.get(var10_10.size() - 1));
                                break;
                            }
                            catch (Throwable var16_18) {
                                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_ESCAPER_ERR, this.m_query);
                            }
                        }
                        if (!(PGEscaper.$assertionsDisabled || var8_8 >= 0 && var8_8 <= this.m_query.length())) {
                            throw new AssertionError();
                        }
                        if (!this.typeMatcher.find(var8_8) || var8_8 != this.typeMatcher.start()) {
                            var3_3.append(this.m_query.substring(var8_8 - 1, ++var8_8));
                            break;
                        }
                        var8_8 = this.m_queryAsParameterFlag != false ? this.typeMatcher.start(0) : this.typeMatcher.start(1);
                        switch (Character.toLowerCase(this.m_query.charAt(var8_8))) {
                            case 'd': {
                                var5_5 = EscapeTypes.DATE;
                                break;
                            }
                            case 'e': {
                                var5_5 = EscapeTypes.ESCAPE;
                                break;
                            }
                            case 'l': {
                                var5_5 = EscapeTypes.LIMIT_OFFSET;
                                break;
                            }
                            case 't': {
                                var5_5 = Character.toLowerCase(this.m_query.charAt(var8_8 + 1)) == 's' ? EscapeTypes.TIMESTAMP : EscapeTypes.TIME;
                                break;
                            }
                            case 'i': {
                                var5_5 = EscapeTypes.INTERVAL;
                                break;
                            }
                            case 'o': {
                                var5_5 = EscapeTypes.OUTERJOIN;
                                break;
                            }
                            case 'c': {
                                var5_5 = EscapeTypes.CALL;
                                break;
                            }
                            case '?': {
                                var5_5 = EscapeTypes.RESULT;
                                break;
                            }
                            case 'f': {
                                var5_5 = EscapeTypes.FN;
                                break;
                            }
                            case 'g': {
                                var5_5 = EscapeTypes.GUID;
                                break;
                            }
                        }
                        var10_10.clear();
                        switch (1.$SwitchMap$com$amazon$support$EscapeTypes[var5_5.ordinal()]) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: {
                                var10_10.add(new StringBuilder(this.m_query.substring(this.typeMatcher.start(2), this.typeMatcher.end(2))));
                                var23_27 = var3_3.length();
                                if (var23_27 > 0 && Character.isLetterOrDigit(var3_3.charAt(var23_27 - 1))) {
                                    var3_3.append(" ");
                                }
                                var3_3.append((CharSequence)PGEscaper.s_re_replacer.replace(var5_5, var10_10));
                                if (var2_2 > 0) {
                                    return this.typeMatcher.end(0);
                                }
                                var10_10.clear();
                                ** GOTO lbl298
                            }
                            case 7: {
                                var10_10.add(new StringBuilder(this.m_query.substring(this.typeMatcher.start(3), this.typeMatcher.end(3))));
                                if (this.typeMatcher.start(4) != -1) {
                                    var10_10.add(new StringBuilder(this.m_query.substring(this.typeMatcher.start(4), this.typeMatcher.end(4))));
                                }
                                var3_3.append((CharSequence)PGEscaper.s_re_replacer.replace(var5_5, var10_10));
                                ** GOTO lbl298
                            }
                            case 8: {
                                var4_4 = "}?{";
                                var6_6 = this.typeMatcher.end(0);
                                var10_10.add(new StringBuilder(""));
                                ** GOTO lbl298
                            }
                            case 9: 
                            case 10: 
                            case 11: {
                                if (!this.m_queryAsParameterFlag) ** GOTO lbl289
                                for (var16_16 = this.typeMatcher.groupCount() - 1; -1 < var16_16; --var16_16) {
                                    if (null == this.typeMatcher.group(var16_16) || this.typeMatcher.group(var16_16).contains("fn")) {
                                        continue;
                                    }
                                    var10_10.add(new StringBuilder(this.m_query.substring(this.typeMatcher.start(var16_16), this.typeMatcher.end(var16_16))));
                                    var8_8 = this.typeMatcher.end(var16_16);
                                    ** GOTO lbl292
                                }
                                ** GOTO lbl292
lbl289:
                                // 1 sources

                                var10_10.add(new StringBuilder(this.m_query.substring(this.typeMatcher.start(5), this.typeMatcher.end(5))));
                                var8_8 = this.typeMatcher.start(6);
lbl292:
                                // 3 sources

                                var4_4 = ",)(}?{";
                                if (this.m_query.charAt(var8_8) == '}') break block2;
                                var7_7 = 1;
                                var6_6 = this.typeMatcher.end(0);
                                var10_10.add(new StringBuilder(""));
                            }
lbl298:
                            // 5 sources

                            default: {
                                var8_8 = this.typeMatcher.end(0);
                            }
                        }
                    }
                }
            }
            var1_1 = var8_8;
        }
        return var8_8;
    }

    private int scan(int n, String string, Matcher matcher) {
        assert (matcher != null);
        assert (string != null);
        assert (n >= 0 && n <= this.m_query.length());
        while (true) {
            int n2 = -1;
            if (!matcher.find(n)) {
                return this.m_query.length();
            }
            if (matcher.groupCount() > 0) {
                n2 = matcher.start(1);
            }
            if (-1 == n2) {
                n2 = matcher.end(0);
            }
            if (n2 == -1 || n2 >= this.m_query.length()) {
                return this.m_query.length();
            }
            char[] cArray = string.toCharArray();
            char c = this.m_query.charAt(n2);
            if (Character.isLetter(c)) {
                return n2;
            }
            for (int i = 0; i < cArray.length; ++i) {
                if (c != cArray[i]) continue;
                return n2;
            }
            n = n2 + 1;
        }
    }
}

