/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.dsi.dataengine.impl.DSIDataEngine;
import com.amazon.dsi.dataengine.impl.DSIEmptyMetadataSource;
import com.amazon.dsi.dataengine.impl.DSITableTypeOnlyMetadataSource;
import com.amazon.dsi.dataengine.interfaces.IMetadataSource;
import com.amazon.dsi.dataengine.interfaces.IQueryExecutor;
import com.amazon.dsi.dataengine.interfaces.IResultSet;
import com.amazon.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.amazon.dsi.dataengine.utilities.MetadataSourceID;
import com.amazon.dsi.dataengine.utilities.OrderType;
import com.amazon.dsi.exceptions.ParsingException;
import com.amazon.jdbc.utils.ParseQueryUtils;
import com.amazon.redshift.client.PGClient;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.core.PGCallableStatementParser;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGJDBCSettings;
import com.amazon.redshift.core.PGJDBCStatement;
import com.amazon.redshift.dataengine.PGBatchQueryExecutor;
import com.amazon.redshift.dataengine.PGCatalogQueryBuilder;
import com.amazon.redshift.dataengine.PGEscaper;
import com.amazon.redshift.dataengine.PGQueryExecutor;
import com.amazon.redshift.dataengine.PGResultSet;
import com.amazon.redshift.dataengine.metadata.PGJDBCTypeInfoMetadataSource;
import com.amazon.redshift.dataengine.metadata.PGMetadatSourceFromQuery;
import com.amazon.redshift.dataengine.metadata.PGProcedureColumnsMetadatSourceFromQuery;
import com.amazon.redshift.dataengine.metadata.PGTablePrivilegesMetadatSourceFromQuery;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PGDataEngine
extends DSIDataEngine {
    private PGClient m_client;
    private PGJDBCStatement m_statement;
    private ILogger m_log;
    private boolean m_isDirectExecution;
    private int m_socketTimeoutMS;
    private PGJDBCSettings m_settings;
    private PGEscaper m_jdbcEscaper = new PGEscaper();

    public PGDataEngine(PGJDBCStatement pGJDBCStatement, PGClient pGClient, PGJDBCSettings pGJDBCSettings, ILogger iLogger, int n) {
        super(pGJDBCStatement);
        this.m_statement = pGJDBCStatement;
        this.m_log = iLogger;
        this.m_client = pGClient;
        this.m_settings = pGJDBCSettings;
        this.m_isDirectExecution = false;
        this.m_socketTimeoutMS = n;
    }

    @Override
    public IQueryExecutor prepareBatch(List<String> list) throws ParsingException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, list);
        return new PGBatchQueryExecutor(null, list, this.m_client, this.m_log, this.m_isDirectExecution, this.m_statement, this.m_socketTimeoutMS, true);
    }

    @Override
    public IQueryExecutor prepare(String string) throws ParsingException, ErrorException {
        List<String> list;
        if (this.m_statement.isCallableStatement()) {
            try {
                PGCallableStatementParser pGCallableStatementParser = new PGCallableStatementParser();
                pGCallableStatementParser.Translate(string);
                this.m_statement.sethasReturnQuestionMark(pGCallableStatementParser.isReturnParameter());
                return new PGQueryExecutor(this.m_jdbcEscaper.apply(string), this.m_client, this.m_log, this.m_isDirectExecution, this.m_statement, this.m_socketTimeoutMS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (1 == (list = ParseQueryUtils.splitQueries(string, true)).size()) {
            return new PGQueryExecutor(this.m_jdbcEscaper.apply(list.get(0)), this.m_client, this.m_log, this.m_isDirectExecution, this.m_statement, this.m_socketTimeoutMS);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : list) {
            String string3 = this.m_jdbcEscaper.apply(string2);
            arrayList.add(string3);
        }
        return new PGBatchQueryExecutor(string, arrayList, this.m_client, this.m_log, this.m_isDirectExecution, this.m_statement, this.m_socketTimeoutMS, false);
    }

    @Override
    public void setDirectExecute() {
        this.m_isDirectExecution = true;
    }

    @Override
    public IResultSet makeNewMetadataResult(MetadataSourceID metadataSourceID, ArrayList<String> arrayList, String string, String string2, boolean bl, OrderType orderType) throws ErrorException {
        if (MetadataSourceID.PRIMARY_KEYS == metadataSourceID) {
            return super.makeNewMetadataResult(metadataSourceID, arrayList, string, string2, bl, OrderType.NONE);
        }
        return super.makeNewMetadataResult(metadataSourceID, arrayList, string, string2, bl, orderType);
    }

    @Override
    protected IMetadataSource makeNewMetadataSource(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map, String string, String string2, boolean bl) throws ErrorException {
        switch (metadataSourceID) {
            case TYPE_INFO: {
                return new PGJDBCTypeInfoMetadataSource(this.getLog());
            }
            case TABLETYPE_ONLY: {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("TABLE");
                arrayList.add("VIEW");
                arrayList.add("SEQUENCE");
                arrayList.add("INDEX");
                arrayList.add("SYSTEM TABLE");
                arrayList.add("SYSTEM TOAST TABLE");
                arrayList.add("TEMPORARY TABLE");
                arrayList.add("EXTERNAL TABLE");
                arrayList.add("SYSTEM VIEW");
                arrayList.add("TEMPORARY VIEW");
                arrayList.add("SYSTEM INDEX");
                arrayList.add("SYSTEM TOAST INDEX");
                arrayList.add("TEMPORARY INDEX");
                arrayList.add("TEMPORARY SEQUENCE");
                arrayList.add("TYPE");
                return new DSITableTypeOnlyMetadataSource(this.getLog(), arrayList);
            }
            case TABLES: 
            case COLUMNS: {
                Object object;
                String string3 = ParseQueryUtils.escapeString(map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME), "'");
                if (null != string3 && !string3.equals("")) {
                    object = new PGResultSet(this.m_client.directExecute("select 1 from svv_external_schemas where schemaname like '" + string3 + "'", false, 0, 0, null, true), this.m_log);
                    ((PGResultSet)object).closeCursor();
                    this.m_settings.m_hasExtSchemaPatternMatch = ((PGResultSet)object).getRowCount() > 0L;
                } else {
                    this.m_settings.m_hasExtSchemaPatternMatch = true;
                }
                object = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                PGMessagingContext pGMessagingContext = this.m_client.directExecute((String)object, false, 0, 0, null, true);
                return new PGMetadatSourceFromQuery(metadataSourceID, pGMessagingContext, 0, this.m_log);
            }
            case CATALOG_ONLY: 
            case CATALOG_SCHEMA_ONLY: 
            case SCHEMA_ONLY: 
            case FOREIGN_KEYS: 
            case PRIMARY_KEYS: {
                String string4 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                PGMessagingContext pGMessagingContext = this.m_client.directExecute(string4, false, 0, 0, null, true);
                return new PGMetadatSourceFromQuery(metadataSourceID, pGMessagingContext, 0, this.m_log);
            }
            case TABLE_PRIVILEGES: {
                String string5 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                PGMessagingContext pGMessagingContext = this.m_client.directExecute(string5, false, 0, 0, null, false);
                return new PGTablePrivilegesMetadatSourceFromQuery(pGMessagingContext, this.m_log);
            }
            case PROCEDURES: {
                String string6 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                PGMessagingContext pGMessagingContext = this.m_client.directExecute(string6, false, 0, 0, null, false);
                return new PGMetadatSourceFromQuery(metadataSourceID, pGMessagingContext, 0, this.m_log);
            }
            case PROCEDURE_COLUMNS: {
                String string7 = PGCoreUtils.SERVER_VERSION;
                int n = Integer.parseInt(string7.split("\\.")[0]);
                int n2 = Integer.parseInt(string7.split("\\.")[1]);
                if (n >= 8 && n2 >= 4) {
                    String string8 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    PGMessagingContext pGMessagingContext = this.m_client.directExecute(string8, false, 0, 0, null, false);
                    return new PGMetadatSourceFromQuery(metadataSourceID, pGMessagingContext, 0, this.m_log);
                }
                String string9 = PGCatalogQueryBuilder.buildProcedureColumnsQueryForOldPostgres(map);
                PGMessagingContext pGMessagingContext = this.m_client.directExecute(string9, false, 0, 0, null, false);
                return new PGProcedureColumnsMetadatSourceFromQuery(pGMessagingContext, 0, this.m_log);
            }
            case FUNCTIONS_JDBC4: {
                if (!PGCoreUtils.REDSHIFT_SERVER) {
                    String string10 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    PGMessagingContext pGMessagingContext = this.m_client.directExecute(string10, false, 0, 0, null, false);
                    return new PGMetadatSourceFromQuery(metadataSourceID, pGMessagingContext, 0, this.m_log);
                }
                return new DSIEmptyMetadataSource(this.getLog());
            }
        }
        return new DSIEmptyMetadataSource(this.getLog());
    }
}

