/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.dsi.core.impl.DSIConnection;
import com.amazon.dsi.core.impl.DSILogger;
import com.amazon.dsi.core.interfaces.IEnvironment;
import com.amazon.dsi.core.interfaces.IStatement;
import com.amazon.dsi.core.interfaces.ITransactionStateListener;
import com.amazon.dsi.core.utilities.ConnSettingRequestMap;
import com.amazon.dsi.core.utilities.ConnSettingResponseMap;
import com.amazon.dsi.core.utilities.Variant;
import com.amazon.dsi.exceptions.BadAttrValException;
import com.amazon.dsi.exceptions.BadAuthException;
import com.amazon.dsi.exceptions.IncorrectTypeException;
import com.amazon.dsi.exceptions.NumericOverflowException;
import com.amazon.dsi.utilities.DSIMessageKey;
import com.amazon.jdbc.common.CommonCoreUtils;
import com.amazon.jdbc.common.ProductInfoHandler;
import com.amazon.redshift.AuthMech;
import com.amazon.redshift.client.PGClient;
import com.amazon.redshift.core.BrandingPreferences;
import com.amazon.redshift.core.IPGLogger;
import com.amazon.redshift.core.IamHelper;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.core.PGJDBCPropertyKey;
import com.amazon.redshift.core.PGJDBCSettings;
import com.amazon.redshift.core.PGJDBCStatement;
import com.amazon.redshift.core.PGLogger;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.redshift.ssl.NonValidatingFactory;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.Warning;
import com.amazon.support.WarningCode;
import com.amazon.support.exceptions.ErrorException;
import java.sql.DriverManager;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class PGJDBCConnection
extends DSIConnection {
    private static int s_connectionID = 0;
    private PGClient m_postgresqlClient;
    protected ILogger m_log;
    protected IPGLogger m_driverlog;
    private PGJDBCSettings m_settings;
    private ProductInfoHandler m_productInfoHandler;
    private final Lock m_txLock = new ReentrantLock();
    private static final String POSTGRESQL_LOG_NAME_PREFIX = "RedshiftJDBC_connection_";
    private static final int MIN_LOGIN_TIMEOUT = 0;
    private static final int DEFAULT_SOCKET_TIMEOUT = 0;
    private static final int MIN_UNKNOWN_LENGTH = Integer.MIN_VALUE;
    private static final int MAX_UNKNOWN_LENGTH = Integer.MAX_VALUE;

    public PGJDBCConnection(IEnvironment iEnvironment) throws ErrorException {
        super(iEnvironment);
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        String string = PGJDBCDriver.DRIVER_MAJOR_VERSION + "." + PGJDBCDriver.DRIVER_MINOR_VERSION;
        this.m_productInfoHandler = new ProductInfoHandler("SimbaAmazonRedshiftJDBCDriver.lic", "Simba Amazon Redshift JDBC Driver", string, PGJDBCDriver.class);
        try {
            this.setProperty(136, new Variant(2, Character.valueOf('\u0002')));
            this.setProperty(1000, new Variant(5, (short)0));
            this.setProperty(137, new Variant(7, 11L));
            this.setProperty(151, new Variant("\\\\"));
        }
        catch (NumericOverflowException numericOverflowException) {
            LogUtilities.logError(numericOverflowException, this.m_log);
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_SESSION_ERR.name(), (Throwable)numericOverflowException);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            LogUtilities.logError(incorrectTypeException, this.m_log);
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_SESSION_ERR.name(), (Throwable)incorrectTypeException);
        }
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        if (null != this.m_postgresqlClient) {
            this.m_postgresqlClient.closeSession();
        }
    }

    public PGClient getPostgresqlClient() {
        return this.m_postgresqlClient;
    }

    public PGJDBCSettings getConnectionSettings() {
        return this.m_settings;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void connect(ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        Variant variant;
        Variant variant2;
        Variant variant3;
        Variant variant4;
        Variant variant5;
        Object object;
        Object object2;
        Object object3;
        String[] stringArray;
        block53: {
            CommonCoreUtils.logConnectionFunctionEntrance(this.getConnectionLog(), connSettingRequestMap, String.valueOf(PGJDBCDriver.DRIVER_MAJOR_VERSION), String.valueOf(PGJDBCDriver.DRIVER_MINOR_VERSION), String.valueOf(PGJDBCDriver.DRIVER_HOT_FIX_VERSION), String.valueOf(PGJDBCDriver.DRIVER_BUILD_NUMBER));
            this.m_productInfoHandler.validateLicense();
            this.m_settings = new PGJDBCSettings();
            this.m_settings.m_loginTimeoutMS = 0;
            this.m_settings.m_rowsFetchedPerBlock = 10000;
            this.m_settings.m_authMech = BrandingPreferences.defaultSslOption;
            this.m_settings.m_newTCPConnectionKeepAliveMinutes = 0;
            this.m_settings.m_disableIsValid = false;
            this.m_settings.m_socketTimeoutMS = 0;
            Variant variant6 = this.getOptionalSetting("BlockingRowsMode", connSettingRequestMap);
            if (null != variant6) {
                try {
                    this.m_settings.m_nRowMode = variant6.getInt();
                    if (this.m_settings.m_nRowMode < 0) {
                        this.m_settings.m_nRowMode = 0;
                        this.getWarningListener().postWarning(this.buildWarningForIncorrectIntPropertyValue("BlockingRowsMode"));
                        break block53;
                    }
                    if (0 < this.m_settings.m_nRowMode && 0 > this.m_settings.m_nRowMode) {
                        this.m_settings.m_nRowMode = 0;
                        stringArray = new String[2];
                        object3 = new StringBuilder();
                        ((StringBuilder)object3).append("The given value is too small. Falling back to the default value ");
                        stringArray[0] = "BlockingRowsMode";
                        stringArray[1] = ((StringBuilder)object3).toString();
                        object2 = new Warning(WarningCode.GENERAL_WARNING, 101, PGJDBCMessageKey.CONN_INVALID_PROPERTY_VALUE.name(), stringArray);
                        this.getWarningListener().postWarning((Warning)object2);
                    }
                }
                catch (Exception exception) {
                    this.m_settings.m_nRowMode = 0;
                    this.getWarningListener().postWarning(this.buildWarningForIncorrectIntPropertyValue("BlockingRowsMode"));
                }
            }
        }
        if (null != (stringArray = this.getOptionalSetting("SSLTrustStorePath", connSettingRequestMap))) {
            this.m_settings.m_sslTrustStorePath = stringArray.getString();
        }
        if (null != (object3 = this.getOptionalSetting("SSLTruststore ", connSettingRequestMap)) && this.m_settings.m_sslTrustStorePath != null) {
            this.m_settings.m_sslTrustStorePwd = ((Variant)object3).getString();
        }
        this.m_settings.m_filterLevel = null != (object2 = this.getOptionalSetting("FilterLevel", connSettingRequestMap)) ? ((Variant)object2).getString() : "NOTICE";
        Variant variant7 = this.getOptionalSetting("selectorProvider", connSettingRequestMap);
        if (null != variant7) {
            this.m_settings.m_selectorProvider = variant7.getString();
            object = this.getOptionalSetting("selectorProviderArg", connSettingRequestMap);
            if (null != object) {
                this.m_settings.m_selectorProviderArg = ((Variant)object).getString();
            }
        }
        object = null;
        Variant variant8 = this.getOptionalSetting("tcpKeepAlive", connSettingRequestMap);
        if (null != variant8) {
            if (0 == variant8.getString().length() || Boolean.parseBoolean(variant8.getString())) {
                object = true;
                this.m_settings.m_newTCPConnectionKeepAliveMinutes = 5;
            } else {
                object = false;
            }
        } else {
            object = true;
            this.m_settings.m_newTCPConnectionKeepAliveMinutes = 5;
        }
        variant8 = this.getOptionalSetting("TCPKeepAliveMinutes", connSettingRequestMap);
        if (null != variant8) {
            try {
                this.m_settings.m_newTCPConnectionKeepAliveMinutes = variant8.getInt();
            }
            catch (Exception exception) {
                this.m_settings.m_newTCPConnectionKeepAliveMinutes = 5;
                this.getWarningListener().postWarning(this.buildWarningForIncorrectIntPropertyValue("TCPKeepAliveMinutes"));
            }
            if (null != object && (((Boolean)object).booleanValue() && this.m_settings.m_newTCPConnectionKeepAliveMinutes == 0 || !((Boolean)object).booleanValue() && this.m_settings.m_newTCPConnectionKeepAliveMinutes != 0)) {
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_PROPERTY_CONFLICT_ERR.name(), new String[]{"tcpKeepAlive", "TCPKeepAliveMinutes"});
                LogUtilities.logError(errorException, this.m_log);
                throw errorException;
            }
            if (this.m_settings.m_newTCPConnectionKeepAliveMinutes < 0) {
                this.m_settings.m_newTCPConnectionKeepAliveMinutes = 5;
                this.getWarningListener().postWarning(this.buildWarningForIncorrectIntPropertyValue("TCPKeepAliveMinutes"));
            }
        }
        if (null != (variant5 = this.getOptionalSetting("socketTimeout", connSettingRequestMap))) {
            try {
                int n = variant5.getInt();
                if (n > 0) {
                    this.m_settings.m_socketTimeoutMS = n * 1000;
                } else {
                    this.getWarningListener().postWarning(this.buildWarningForIncorrectIntPropertyValue("socketTimeout"));
                }
            }
            catch (Exception exception) {
                this.getWarningListener().postWarning(this.buildWarningForIncorrectIntPropertyValue("socketTimeout"));
            }
        }
        if (DriverManager.getLoginTimeout() > 0) {
            this.m_settings.m_loginTimeoutMS = DriverManager.getLoginTimeout() * 1000;
        }
        if (null != (variant4 = this.getOptionalSetting("loginTimeout", connSettingRequestMap))) {
            try {
                int n = variant4.getInt();
                if (n > 0) {
                    this.m_settings.m_loginTimeoutMS = n * 1000;
                } else {
                    this.getWarningListener().postWarning(this.buildWarningForIncorrectIntPropertyValue("loginTimeout"));
                }
            }
            catch (Exception exception) {
                this.getWarningListener().postWarning(this.buildWarningForIncorrectIntPropertyValue("loginTimeout"));
            }
        }
        if (null != (variant3 = this.getOptionalSetting("unknownLength", connSettingRequestMap))) {
            boolean bl = false;
            try {
                int n = variant3.getInt();
                if (n >= Integer.MIN_VALUE && n <= Integer.MAX_VALUE) {
                    this.m_settings.m_unknownLength = n;
                } else {
                    bl = true;
                }
            }
            catch (Exception exception) {
                LogUtilities.logDebug(exception, this.m_log);
                bl = true;
            }
            if (bl) {
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_INVALID_PROPERTY_VALUE_TYPE_OR_RANGE.name(), new String[]{"unknownLength", variant3.getString(), String.valueOf(Integer.MIN_VALUE), String.valueOf(Integer.MAX_VALUE)});
                LogUtilities.logError(errorException, this.m_log);
                throw errorException;
            }
        }
        this.m_settings.m_Schema = this.getRequiredSetting("ConnSchema", connSettingRequestMap).getString();
        Variant variant9 = PGJDBCConnection.getOptionalConnSetting("Host", connSettingRequestMap);
        Variant variant10 = PGJDBCConnection.getOptionalConnSetting("Port", connSettingRequestMap);
        if (null != variant9) {
            this.m_settings.m_host = variant9.getString();
        }
        if (null != variant10) {
            try {
                this.m_settings.m_port = variant10.getInt();
            }
            catch (Exception exception) {
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.DRIVER_DEFAULT_PROP_ERR.name(), exception.getMessage());
                errorException.initCause(exception);
                throw errorException;
            }
        }
        this.setAuthMech(connSettingRequestMap);
        Variant variant11 = this.getRequiredSetting("IAMAuth", connSettingRequestMap);
        this.m_settings.m_iamAuth = Boolean.parseBoolean(variant11.getString());
        if (this.m_settings.m_iamAuth) {
            IamHelper.setIAMProperties(connSettingRequestMap, this.m_settings, this.m_log);
        }
        if (null == this.m_settings.m_host) {
            this.m_settings.m_host = this.getRequiredSetting("Host", connSettingRequestMap).getString();
        }
        if (0 == this.m_settings.m_port) {
            variant10 = this.getRequiredSetting("Port", connSettingRequestMap);
            try {
                this.m_settings.m_port = variant10.getInt();
            }
            catch (Exception exception) {
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.DRIVER_DEFAULT_PROP_ERR.name(), exception.getMessage());
                errorException.initCause(exception);
                throw errorException;
            }
        }
        if (null == this.m_settings.m_username) {
            this.m_settings.m_username = this.getRequiredSetting("UID", connSettingRequestMap).getString();
        }
        if (null == this.m_settings.m_password) {
            this.m_settings.m_password = this.getRequiredSetting("PWD", connSettingRequestMap).getString();
        }
        if (null != (variant2 = this.getOptionalSetting("sslrootcert", connSettingRequestMap))) {
            this.m_settings.m_sslRootCert = variant2.getString();
        }
        if (null != (variant = this.getOptionalSetting("sslpassword", connSettingRequestMap))) {
            this.m_settings.m_sslPassword = variant.getString();
        }
        Variant variant12 = this.getOptionalSetting("sslcert", connSettingRequestMap);
        Variant variant13 = this.getOptionalSetting("sslkey", connSettingRequestMap);
        if (null != variant12) {
            this.m_settings.m_sslCert = variant12.getString();
            if (null == variant13) {
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_MISSING_PROPERTY_ERROR.name(), "sslkey");
                LogUtilities.logError(errorException, this.m_log);
                throw errorException;
            }
            this.m_settings.m_sslKey = variant13.getString();
        } else if (null != variant13) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_MISSING_PROPERTY_ERROR.name(), "sslcert");
            LogUtilities.logError(errorException, this.m_log);
            throw errorException;
        }
        Variant variant14 = this.getOptionalSetting("DisableIsValidQuery", connSettingRequestMap);
        if (null != variant14) {
            this.m_settings.m_disableIsValid = Boolean.parseBoolean(variant14.getString());
        }
        this.m_postgresqlClient = new PGClient(this.m_settings, this.getDriverConnectionLog(), this.getWarningListener());
        this.incrementConnectionID();
    }

    @Override
    public IStatement createStatement() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        return new PGJDBCStatement(this, this.m_postgresqlClient, this.m_settings.m_socketTimeoutMS);
    }

    public IStatement prepareStatement() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        return new PGJDBCStatement(this, this.m_postgresqlClient, this.m_settings.m_socketTimeoutMS);
    }

    @Override
    public void disconnect() throws ErrorException {
        if (null != this.m_postgresqlClient) {
            this.m_postgresqlClient.closeSession();
        }
    }

    @Override
    protected void doReset() throws ErrorException {
    }

    @Override
    public ILogger getConnectionLog() {
        if (null == this.m_log) {
            this.m_log = new DSILogger(POSTGRESQL_LOG_NAME_PREFIX + Integer.toString(s_connectionID));
            this.m_log.setLocale(this.getLocale());
        }
        return this.m_log;
    }

    public IPGLogger getDriverConnectionLog() {
        if (null == this.m_driverlog) {
            this.m_driverlog = new PGLogger(POSTGRESQL_LOG_NAME_PREFIX, s_connectionID);
            this.m_driverlog.setLocale(this.getLocale());
        }
        return this.m_driverlog;
    }

    @Override
    public String toNativeSQL(String string) {
        String string2;
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), string);
        try {
            string2 = PGCoreUtils.parseStoredProcedure(string, this);
        }
        catch (NullPointerException nullPointerException) {
            this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, PGJDBCMessageKey.PG_PROCEDURE_CALL_FORMAT_ERROR.name()));
            return string;
        }
        return string2;
    }

    @Override
    public ConnSettingResponseMap updateConnectionSettings(ConnSettingRequestMap connSettingRequestMap) throws BadAuthException, ErrorException {
        connSettingRequestMap.setHiddenKey("PWD", "password", "SecretAccessKey");
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), connSettingRequestMap);
        ConnSettingResponseMap connSettingResponseMap = new ConnSettingResponseMap();
        for (String string : PGJDBCPropertyKey.getRequiredKeys()) {
            this.verifyRequiredSetting(string, connSettingRequestMap, connSettingResponseMap);
        }
        for (String string : PGJDBCPropertyKey.getOptionalKeys()) {
            this.verifyOptionalSetting(string, connSettingRequestMap, connSettingResponseMap);
        }
        return connSettingResponseMap;
    }

    @Override
    public void setProperty(int n, Variant variant) throws BadAttrValException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        switch (n) {
            case 26: {
                try {
                    if (1L == variant.getLong()) {
                        this.m_postgresqlClient.directExecuteImmediately("SET default_transaction_isolation='read uncommitted'", null);
                        break;
                    }
                    if (2L == variant.getLong()) {
                        this.m_postgresqlClient.directExecuteImmediately("SET default_transaction_isolation='read committed'", null);
                        break;
                    }
                    if (4L == variant.getLong()) {
                        this.m_postgresqlClient.directExecuteImmediately("SET default_transaction_isolation='repeatable read'", null);
                        break;
                    }
                    if (8L != variant.getLong()) break;
                    this.m_postgresqlClient.directExecuteImmediately("SET default_transaction_isolation='serializable'", null);
                    break;
                }
                catch (NumericOverflowException numericOverflowException) {
                    LogUtilities.logError(numericOverflowException, this.m_log);
                    ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_SESSION_ERR.name(), numericOverflowException.getMessage());
                    errorException.initCause(numericOverflowException);
                    throw errorException;
                }
                catch (IncorrectTypeException incorrectTypeException) {
                    LogUtilities.logError(incorrectTypeException, this.m_log);
                    ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_SESSION_ERR.name(), incorrectTypeException.getMessage());
                    errorException.initCause(incorrectTypeException);
                    throw errorException;
                }
            }
        }
        super.setProperty(n, variant);
    }

    @Override
    public void beginTransaction() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        this.m_postgresqlClient.directExecuteImmediately("BEGIN;", null);
    }

    @Override
    public void commit() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        this.m_postgresqlClient.directExecuteImmediately("COMMIT;", null);
    }

    @Override
    public void registerWarningListener(IWarningListener iWarningListener) {
        super.registerWarningListener(iWarningListener);
        if (null != this.m_postgresqlClient) {
            this.m_postgresqlClient.registerWarningListener(iWarningListener);
        }
    }

    @Override
    public void rollback() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        this.m_postgresqlClient.directExecuteImmediately("ROLLBACK;", null);
    }

    final Lock getTransactionLock() {
        return this.m_txLock;
    }

    final ITransactionStateListener getTransactionStateListener() {
        return this.m_transactionListener;
    }

    private void setAuthMech(ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        boolean bl = false;
        boolean bl2 = false;
        Variant variant = this.getOptionalSetting("ssl", connSettingRequestMap);
        if (null != variant) {
            if (Boolean.parseBoolean(variant.getString()) || variant.getString().equals("")) {
                bl = true;
                this.m_settings.m_authMech = AuthMech.VERIFY_CA;
            } else if (!Boolean.parseBoolean(variant.getString())) {
                bl2 = true;
            }
        }
        Variant variant2 = this.getOptionalSetting("AuthMech", connSettingRequestMap);
        AuthMech authMech = null;
        if (null != variant2) {
            try {
                authMech = AuthMech.valueOf(variant2.getString().toUpperCase().trim());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < AuthMech.values().length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append((Object)AuthMech.values()[i]);
                }
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_INVALID_PROPERTY_VALUE.name(), new String[]{"AuthMech", stringBuffer.toString()});
                LogUtilities.logError(errorException, this.m_log);
                throw errorException;
            }
        }
        boolean bl3 = false;
        if (null != authMech) {
            bl3 = true;
        }
        if ((bl && AuthMech.DISABLE == authMech || bl && AuthMech.ALLOW == authMech || bl && AuthMech.PREFER == authMech || bl2 && AuthMech.REQUIRE == authMech || bl2 && AuthMech.ALLOW == authMech || bl2 && AuthMech.PREFER == authMech) && null != this.m_settings.m_authMech && this.m_settings.m_authMech != authMech) {
            this.throwConflictingPropertyException(new String[]{"AuthMech", "ssl"});
        }
        if (bl3) {
            this.m_settings.m_authMech = authMech;
        }
        Variant variant3 = this.getOptionalSetting("sslfactory", connSettingRequestMap);
        boolean bl4 = false;
        if (null != variant3 && this.isNonValidationFactory(variant3.getString())) {
            if (bl3 && this.m_settings.m_authMech != AuthMech.REQUIRE) {
                this.throwConflictingPropertyException(new String[]{"AuthMech", "sslfactory"});
            }
            bl4 = true;
            this.m_settings.m_authMech = AuthMech.REQUIRE;
        }
        Variant variant4 = this.getOptionalSetting("sslmode", connSettingRequestMap);
        boolean bl5 = false;
        if (null != variant4) {
            bl5 = true;
        }
        if (bl5) {
            if (bl3 && AuthMech.REQUIRE != authMech) {
                this.throwConflictingPropertyException(new String[]{"sslmode", "AuthMech"});
            }
            if (bl2) {
                this.throwConflictingPropertyException(new String[]{"sslmode", "ssl"});
            }
            if (bl4) {
                this.throwConflictingPropertyException(new String[]{"sslmode", "sslfactory"});
            }
            if (variant4.getString().equals("verify-full")) {
                this.m_settings.m_authMech = AuthMech.VERIFY_FULL;
            } else if (variant4.getString().equals("verify-ca")) {
                this.m_settings.m_authMech = AuthMech.VERIFY_CA;
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("verify-full");
                stringBuilder.append(", ");
                stringBuilder.append("verify-ca");
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_INVALID_PROPERTY_VALUE.name(), new String[]{"sslmode", stringBuilder.toString()});
                LogUtilities.logError(errorException, this.m_log);
                throw errorException;
            }
        }
        if (!(bl || bl2 || bl4 || bl5)) {
            this.m_settings.m_authMech = AuthMech.VERIFY_CA;
        }
    }

    private void throwConflictingPropertyException(String[] stringArray) throws ErrorException {
        ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_PROPERTY_CONFLICT_ERR.name(), stringArray);
        LogUtilities.logError(errorException, this.m_log);
        throw errorException;
    }

    private boolean isNonValidationFactory(String string) {
        boolean bl = false;
        if (string.equals(PGCoreUtils.NON_VALIDATING_SSL_FACTORY) || string.equals(NonValidatingFactory.class.getName())) {
            bl = true;
        }
        return bl;
    }

    private Warning buildWarningForIncorrectIntPropertyValue(String string) {
        String[] stringArray = new String[2];
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Numbers between 0 and 2147483647");
        stringBuilder.append(". The value is either negative, too large or not a number. ");
        stringBuilder.append("Falling back to the default value");
        stringArray[0] = string;
        stringArray[1] = stringBuilder.toString();
        return new Warning(WarningCode.GENERAL_WARNING, 101, PGJDBCMessageKey.CONN_INVALID_PROPERTY_VALUE.name(), stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementConnectionID() {
        PGJDBCConnection pGJDBCConnection = this;
        synchronized (pGJDBCConnection) {
            ++s_connectionID;
        }
    }

    public static Variant getOptionalConnSetting(String string, ConnSettingRequestMap connSettingRequestMap) {
        return connSettingRequestMap.getProperty(string);
    }

    public static Variant getRequiredConnSetting(String string, ConnSettingRequestMap connSettingRequestMap) throws BadAuthException {
        Variant variant = connSettingRequestMap.getProperty(string);
        if (null == variant) {
            throw new BadAuthException(2, DSIMessageKey.REQ_SETTING_NOT_FOUND.name(), string);
        }
        return variant;
    }
}

