/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.redshift.client.interfaces.Notification;
import com.amazon.redshift.client.messages.inbound.NotificationResponse;
import com.amazon.redshift.core.PGJDBCConnection;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.dataengine.PGReplacer;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.IWarningListener;
import com.amazon.support.Warning;
import com.amazon.support.WarningCode;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PGCoreUtils {
    private static final Pattern URL_PATTERN = Pattern.compile("(iam:)?//([^:/?]+)(:([^/?]*))?(/([^?;]*))?([?;](.*))?");
    private static final Pattern HOST_PATTERN = Pattern.compile("(.+)\\.(.+)\\.(.+).redshift(-dev)?\\.amazonaws\\.com(.)*");
    private static final String DEFAULT_PORT = System.getProperty("redshift.default-port", "5439");
    private static final char SQL_QUERY_PARAMETER_SIGN = '?';
    private static final char PG_QUERY_PARAMETER_SIGN = '$';
    public static boolean REDSHIFT_SERVER = false;
    public static String SERVER_NAME = null;
    public static String SERVER_VERSION = null;
    public static String NON_VALIDATING_SSL_FACTORY_PART1 = "org.post";
    public static String NON_VALIDATING_SSL_FACTORY_PART2 = "gresql.ssl.NonValidatingFactory";
    public static String NON_VALIDATING_SSL_FACTORY = NON_VALIDATING_SSL_FACTORY_PART1 + NON_VALIDATING_SSL_FACTORY_PART2;
    public static final List<FunctionDefinition> FUNCTION_DEFINITIONS;

    public static String parameterQueryBuilder(String string, ArrayList<String> arrayList) throws ErrorException {
        int n = 0;
        int n2 = string.length();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        boolean bl = PGCoreUtils.parameterQueryAnalyzeHelper(string, '$', n, n2, arrayList2);
        if (arrayList2.size() == 0) {
            return string;
        }
        if (bl) {
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_PARAMETER_QUERY_BUILD_ERR.name());
        }
        if (arrayList2.size() != arrayList.size()) {
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_PARAMETER_QUERY_BUILD_ERR.name());
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (!arrayList2.contains(i)) {
                stringBuilder.append(string.charAt(i));
                continue;
            }
            stringBuilder.append(arrayList.get(n3));
            ++i;
            ++n3;
        }
        return stringBuilder.toString();
    }

    public static String parameterQueryFormatter(String string, List<Integer> list) throws ErrorException {
        int n = 0;
        int n2 = string.length();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        boolean bl = PGCoreUtils.parameterQueryAnalyzeHelper(string, '?', n, n2, arrayList);
        String string2 = null;
        if (arrayList.size() != 0) {
            StringBuilder stringBuilder = new StringBuilder();
            int n3 = 1;
            for (int i = 0; i < n2; ++i) {
                if (!arrayList.contains(i)) {
                    stringBuilder.append(string.charAt(i));
                    continue;
                }
                stringBuilder.append('$').append(n3);
                ++n3;
            }
            string2 = stringBuilder.toString();
        } else {
            string2 = string;
        }
        n2 = string2.length();
        bl = PGCoreUtils.generateMetadataForRegisteredFunctions(string2, '$', n, n2, list);
        if (bl) {
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_PARAMETER_QUERY_BUILD_ERR.name());
        }
        return string2;
    }

    public static int parameterCounter(String string) throws ErrorException {
        return PGReplacer.getNumParams();
    }

    public static String parseStoredProcedure(String string, PGJDBCConnection pGJDBCConnection) {
        String string2 = string.trim();
        if (string2.charAt(0) == '{' && string2.length() > 1 && (string2 = string2.substring(1, string2.length()).trim()).length() > 6 && string2.charAt(string2.length() - 1) == '}') {
            String string3 = string2.trim().substring(0, "CALL".length()).toUpperCase();
            if (!string3.equals("CALL")) {
                pGJDBCConnection.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, PGJDBCMessageKey.PG_PROCEDURE_CALL_FORMAT_ERROR.name()));
                return string;
            }
            string2 = PGCoreUtils.storedProcedureQueryFormatter(string2, "CALL");
            return string2;
        }
        return string;
    }

    public static boolean parseSubName(String string, Properties properties, boolean bl) {
        String string2;
        String[] stringArray;
        Matcher matcher = URL_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        boolean bl2 = matcher.group(1) != null;
        String string3 = matcher.group(2);
        String string4 = matcher.group(4);
        String string5 = matcher.group(6);
        String string6 = matcher.group(8);
        treeMap.put("IAMAuth", String.valueOf(bl2));
        if (bl2) {
            if (null != string4 && !string4.matches("\\d*")) {
                treeMap.put("ClusterID", string3);
                treeMap.put("Region", string4);
            } else {
                treeMap.put("Host", string3);
                if (null == string4 || string4.isEmpty()) {
                    string4 = DEFAULT_PORT;
                }
                treeMap.put("Port", string4);
                stringArray = HOST_PATTERN.matcher(string3);
                if (stringArray.matches()) {
                    treeMap.put("ClusterID", stringArray.group(1));
                    treeMap.put("Region", stringArray.group(3));
                }
            }
        } else {
            treeMap.put("Host", string3);
            if (null == string4 || string4.isEmpty()) {
                string4 = DEFAULT_PORT;
            }
            treeMap.put("Port", string4);
        }
        if (null != string5) {
            treeMap.put("ConnSchema", string5);
        }
        if (string6 != null && !string6.isEmpty()) {
            for (String string7 : stringArray = string6.split("[;&]")) {
                String[] stringArray2 = string7.split("=", 2);
                if (stringArray2.length > 1) {
                    treeMap.put(stringArray2[0], stringArray2[1]);
                    continue;
                }
                treeMap.put(string7, "");
            }
        }
        stringArray = properties.keys();
        while (stringArray.hasMoreElements()) {
            String string8 = (String)stringArray.nextElement();
            if (treeMap.containsKey(string8)) continue;
            treeMap.put(string8, properties.get(string8).toString());
        }
        if (bl && treeMap.containsKey("OpenSourceSubProtocolOverride") && Boolean.parseBoolean((String)treeMap.get("OpenSourceSubProtocolOverride"))) {
            try {
                Class.forName("org.postgresql.Driver");
                return false;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (null != (string2 = (String)treeMap.remove("user"))) {
            treeMap.put("UID", string2);
        }
        if (null != (string2 = (String)treeMap.remove("password"))) {
            treeMap.put("PWD", string2);
        }
        if (bl2) {
            if (!treeMap.containsKey("UID")) {
                treeMap.put("UID", "*");
            }
            if (!treeMap.containsKey("PWD")) {
                treeMap.put("PWD", "*");
            }
        }
        properties.clear();
        properties.putAll((Map<?, ?>)treeMap);
        return true;
    }

    public static TransactionVerb parseTransactionVerb(String string) {
        TransactionVerb transactionVerb = TransactionVerb.NONE;
        boolean bl = false;
        boolean bl2 = false;
        block12: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (string.charAt(i)) {
                case 'A': 
                case 'a': {
                    if (!bl && TransactionVerb.NONE == transactionVerb && PGCoreUtils.matchesRegionCI(string, "bort", i + 1)) {
                        transactionVerb = TransactionVerb.ROLLBACK;
                        i += "bort".length();
                        continue block12;
                    }
                    return TransactionVerb.NONE;
                }
                case 'B': 
                case 'b': {
                    if (!bl && TransactionVerb.NONE == transactionVerb && PGCoreUtils.matchesRegionCI(string, "egin", i + 1)) {
                        transactionVerb = TransactionVerb.BEGIN;
                        i += "egin".length();
                        continue block12;
                    }
                    return TransactionVerb.NONE;
                }
                case 'C': 
                case 'c': {
                    if (!bl && TransactionVerb.NONE == transactionVerb && PGCoreUtils.matchesRegionCI(string, "ommit", i + 1)) {
                        transactionVerb = TransactionVerb.COMMIT;
                        i += "ommit".length();
                        continue block12;
                    }
                    return TransactionVerb.NONE;
                }
                case 'E': 
                case 'e': {
                    if (!bl && TransactionVerb.NONE == transactionVerb && PGCoreUtils.matchesRegionCI(string, "nd", i + 1)) {
                        transactionVerb = TransactionVerb.COMMIT;
                        i += "nd".length();
                        continue block12;
                    }
                    return TransactionVerb.NONE;
                }
                case 'R': 
                case 'r': {
                    if (!bl && TransactionVerb.NONE == transactionVerb && PGCoreUtils.matchesRegionCI(string, "ollback", i + 1)) {
                        transactionVerb = TransactionVerb.ROLLBACK;
                        i += "ollback".length();
                        continue block12;
                    }
                    return TransactionVerb.NONE;
                }
                case 'T': 
                case 't': {
                    if (!bl && TransactionVerb.NONE == transactionVerb && PGCoreUtils.matchesRegionCI(string, "runcate", i + 1)) {
                        transactionVerb = TransactionVerb.COMMIT;
                        i += "runcate".length();
                        bl2 = true;
                        continue block12;
                    }
                    return TransactionVerb.NONE;
                }
                case '#': {
                    ++i;
                    while (string.length() > i && '\n' != string.charAt(i)) {
                        ++i;
                    }
                    continue block12;
                }
                case '-': {
                    if (i + 1 < string.length() && '-' == string.charAt(i + 1)) {
                        i += 2;
                        while (string.length() > i && '\n' != string.charAt(i)) {
                            ++i;
                        }
                        continue block12;
                    }
                    return TransactionVerb.NONE;
                }
                case '/': {
                    int n;
                    if (i + 1 < string.length() && '*' == string.charAt(i + 1) && 0 < (n = string.indexOf("*/", i + 2))) {
                        i = n + 1;
                        continue block12;
                    }
                    return TransactionVerb.NONE;
                }
                case ';': {
                    bl = true;
                    continue block12;
                }
                default: {
                    if (!Character.isWhitespace(c)) {
                        return TransactionVerb.NONE;
                    }
                    if (!bl2) continue block12;
                    return transactionVerb;
                }
            }
        }
        return transactionVerb;
    }

    public static int safeLongToInt(long l) throws ErrorException {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_DATA_CONVERSION_ERROR_INTEGER.name(), new BigDecimal(l).toString(), ExceptionType.DATA);
        }
        return (int)l;
    }

    public static List<Notification> getNotifications(IWarningListener iWarningListener) {
        List<Warning> list;
        ArrayList<NotificationResponse> arrayList = null;
        if (null != iWarningListener && null != (list = iWarningListener.getWarnings())) {
            NotificationResponse notificationResponse = null;
            arrayList = new ArrayList<NotificationResponse>();
            for (Warning warning : list) {
                if (null == warning || null == (notificationResponse = new NotificationResponse(warning)).getName()) continue;
                arrayList.add(notificationResponse);
            }
        }
        return arrayList;
    }

    public static void clearNotifications(IWarningListener iWarningListener) {
        List<Warning> list;
        if (null != iWarningListener && null != (list = iWarningListener.getWarnings())) {
            list.clear();
        }
    }

    private static boolean parameterQueryAnalyzeHelper(String string, char c, int n, int n2, ArrayList<Integer> arrayList) {
        ParseStatus parseStatus = new ParseStatus();
        parseStatus.currentStrPointer = n;
        while (parseStatus.currentStrPointer < n2) {
            PGCoreUtils.skipEscapedContent(string, parseStatus, n2);
            if (string.charAt(parseStatus.currentStrPointer) == c) {
                arrayList.add(parseStatus.currentStrPointer);
                ++parseStatus.currentStrPointer;
                continue;
            }
            ++parseStatus.currentStrPointer;
        }
        return parseStatus.invalidQuery;
    }

    private static boolean generateMetadataForRegisteredFunctions(String string, char c, int n, int n2, List<Integer> list) {
        boolean bl = false;
        String string2 = string.toLowerCase();
        HashMap<Integer, FunctionDefinition> hashMap = new HashMap<Integer, FunctionDefinition>();
        block0: for (FunctionDefinition functionDefinition : FUNCTION_DEFINITIONS) {
            int n3 = n;
            while (-1 != (n3 = string2.indexOf(functionDefinition.functionName, n3))) {
                hashMap.put(n3, functionDefinition);
                if ((n3 += functionDefinition.functionName.length()) < string2.length()) continue;
                continue block0;
            }
        }
        if (0 == hashMap.size()) {
            return false;
        }
        ParseStatus parseStatus = new ParseStatus();
        parseStatus.currentStrPointer = n;
        while (parseStatus.currentStrPointer < n2) {
            FunctionDefinition functionDefinition;
            PGCoreUtils.skipEscapedContent(string2, parseStatus, n2);
            functionDefinition = (FunctionDefinition)hashMap.get(parseStatus.currentStrPointer);
            if (null != functionDefinition && PGCoreUtils.parseFunctionArguments(string2, parseStatus, n2, functionDefinition, hashMap, list)) {
                return true;
            }
            if (string2.charAt(parseStatus.currentStrPointer) == c) {
                list.add(0);
                ++parseStatus.currentStrPointer;
                continue;
            }
            ++parseStatus.currentStrPointer;
        }
        return bl;
    }

    private static boolean parseFunctionArguments(String string, ParseStatus parseStatus, int n, FunctionDefinition functionDefinition, Map<Integer, FunctionDefinition> map, List<Integer> list) {
        int n2 = 0;
        int n3 = 0;
        char c = string.charAt(parseStatus.currentStrPointer - 1);
        if (Character.isLetterOrDigit(c)) {
            return false;
        }
        parseStatus.currentStrPointer += functionDefinition.functionName.length();
        int n4 = string.indexOf(40, parseStatus.currentStrPointer);
        if (-1 == n4) {
            return true;
        }
        while (parseStatus.currentStrPointer < n4) {
            if (!Character.isWhitespace(string.charAt(parseStatus.currentStrPointer))) {
                return false;
            }
            ++parseStatus.currentStrPointer;
        }
        ++parseStatus.currentStrPointer;
        block1: while (parseStatus.currentStrPointer < n) {
            char c2;
            PGCoreUtils.skipEscapedContent(string, parseStatus, n);
            FunctionDefinition functionDefinition2 = map.get(parseStatus.currentStrPointer);
            if (null != functionDefinition2 && PGCoreUtils.parseFunctionArguments(string, parseStatus, n, functionDefinition2, map, list)) {
                return true;
            }
            if (0 == n2) {
                String string2 = string.substring(parseStatus.currentStrPointer);
                for (DelimiterDefinition delimiterDefinition : functionDefinition.delimiterSets) {
                    String string3;
                    if (delimiterDefinition.delimiters.size() <= n3 || !string2.startsWith(string3 = delimiterDefinition.delimiters.get(n3)) || delimiterDefinition.isWhiteSpaceRequired && (!delimiterDefinition.isWhiteSpaceRequired || !Character.isWhitespace(string.charAt(parseStatus.currentStrPointer - 1)) || !Character.isWhitespace(string2.charAt(string3.length())))) continue;
                    ++n3;
                    parseStatus.currentStrPointer += string3.length();
                    continue block1;
                }
            }
            if ('$' == (c2 = string.charAt(parseStatus.currentStrPointer))) {
                if (0 == n2) {
                    list.add(functionDefinition.oid.get(n3));
                } else {
                    list.add(0);
                }
            } else if ('(' == c2) {
                ++n2;
            } else if (')' == c2) {
                if (0 == n2) {
                    if (parseStatus.currentStrPointer < string.length() - 1) {
                        ++parseStatus.currentStrPointer;
                    }
                    return false;
                }
                --n2;
            }
            ++parseStatus.currentStrPointer;
        }
        return false;
    }

    private static boolean matchesRegionCI(String string, String string2, int n) {
        return string.regionMatches(true, n, string2, 0, string2.length());
    }

    private static void skipEscapedContent(String string, ParseStatus parseStatus, int n) {
        int n2 = parseStatus.currentStrPointer;
        switch (string.charAt(n2)) {
            case '[': {
                int n3 = string.indexOf(93, n2 + 1);
                if (n3 != -1) {
                    parseStatus.currentStrPointer = n3;
                    break;
                }
                parseStatus.invalidQuery = true;
                break;
            }
            case '\'': {
                if (0 != n2 && (0 >= n2 || '\\' == string.charAt(n2 - 1))) break;
                int n4 = string.indexOf(39, n2 + 1);
                while (0 < n4 && n4 < string.length() && '\\' == string.charAt(n4 - 1)) {
                    n4 = string.indexOf(39, n4 + 1);
                }
                if (n4 != -1) {
                    parseStatus.currentStrPointer = n4;
                    break;
                }
                parseStatus.invalidQuery = true;
                break;
            }
            case '\"': {
                if (0 != n2 && (0 >= n2 || '\\' == string.charAt(n2 - 1))) break;
                int n5 = string.indexOf(34, n2 + 1);
                while (0 < n5 && n5 < string.length() && '\\' == string.charAt(n5 - 1)) {
                    n5 = string.indexOf(34, n5 + 1);
                }
                if (n5 != -1) {
                    parseStatus.currentStrPointer = n5;
                    break;
                }
                parseStatus.invalidQuery = true;
                break;
            }
            case '-': {
                if (n2 + 1 >= n || string.charAt(n2 + 1) != '-') break;
                int n6 = string.indexOf("\n", n2 + 1);
                if (n6 != -1) {
                    parseStatus.currentStrPointer = n6;
                    break;
                }
                parseStatus.invalidQuery = true;
                break;
            }
            case '/': {
                if (n2 + 2 >= n || string.charAt(n2 + 1) != '*') break;
                int n7 = string.indexOf("*/", n2 + 1);
                if (n7 != -1) {
                    parseStatus.currentStrPointer = n7 + 1;
                    break;
                }
                parseStatus.invalidQuery = true;
            }
        }
    }

    private static String storedProcedureQueryFormatter(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = string.substring(0, string.length() - 1).trim();
        if ((string3 = string3.substring(string2.length())).charAt(string.length() - 1) != ')') {
            string3 = string3 + "()";
        }
        stringBuilder.append("SELECT").append(" ").append(string3.trim());
        return stringBuilder.toString();
    }

    public static boolean willAdditionOverflow(long l, long l2) {
        return ((l ^ l2 ^ 0xFFFFFFFFFFFFFFFFL) & (l ^ l + l2)) < 0L;
    }

    static {
        ArrayList<FunctionDefinition> arrayList = new ArrayList<FunctionDefinition>();
        FunctionDefinition functionDefinition = new FunctionDefinition();
        functionDefinition.functionName = "substring".toLowerCase();
        functionDefinition.oid = new ArrayList<Integer>();
        functionDefinition.oid.add(1043);
        functionDefinition.oid.add(23);
        functionDefinition.oid.add(23);
        DelimiterDefinition delimiterDefinition = new DelimiterDefinition();
        delimiterDefinition.isWhiteSpaceRequired = false;
        delimiterDefinition.delimiters.add(",");
        delimiterDefinition.delimiters.add(",");
        functionDefinition.delimiterSets.add(delimiterDefinition);
        DelimiterDefinition delimiterDefinition2 = new DelimiterDefinition();
        delimiterDefinition2.isWhiteSpaceRequired = true;
        delimiterDefinition2.delimiters.add("from");
        delimiterDefinition2.delimiters.add("for");
        functionDefinition.delimiterSets.add(delimiterDefinition2);
        arrayList.add(functionDefinition);
        FUNCTION_DEFINITIONS = Collections.unmodifiableList(arrayList);
    }

    private static class ParseStatus {
        int currentStrPointer;
        boolean invalidQuery = false;

        private ParseStatus() {
        }
    }

    public static enum TransactionVerb {
        BEGIN,
        COMMIT,
        ROLLBACK,
        NONE;

    }

    public static class DelimiterDefinition {
        List<String> delimiters = new ArrayList<String>();
        boolean isWhiteSpaceRequired;
    }

    public static class FunctionDefinition {
        public String functionName;
        public List<Integer> oid;
        public List<DelimiterDefinition> delimiterSets = new ArrayList<DelimiterDefinition>();
    }
}

