/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client;

import com.amazon.jdbc.communications.exceptions.MessageBoundarySyncronizationLostException;
import com.amazon.jdbc.communications.interfaces.AbstractInboundDataHandler;
import com.amazon.jdbc.communications.interfaces.IInboundMessage;
import com.amazon.redshift.client.FilterUtilities;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.client.messages.inbound.Authentication;
import com.amazon.redshift.client.messages.inbound.BindComplete;
import com.amazon.redshift.client.messages.inbound.CloseComplete;
import com.amazon.redshift.client.messages.inbound.CommandComplete;
import com.amazon.redshift.client.messages.inbound.DataRow;
import com.amazon.redshift.client.messages.inbound.EmptyQueryResponse;
import com.amazon.redshift.client.messages.inbound.ErrorResponse;
import com.amazon.redshift.client.messages.inbound.KeyData;
import com.amazon.redshift.client.messages.inbound.NoData;
import com.amazon.redshift.client.messages.inbound.NoticeResponse;
import com.amazon.redshift.client.messages.inbound.NotificationResponse;
import com.amazon.redshift.client.messages.inbound.ParameterDescription;
import com.amazon.redshift.client.messages.inbound.ParameterStatus;
import com.amazon.redshift.client.messages.inbound.ParseComplete;
import com.amazon.redshift.client.messages.inbound.ReadyForQuery;
import com.amazon.redshift.client.messages.inbound.RowDescription;
import com.amazon.redshift.core.IPGLogger;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class InboundDataHandler
extends AbstractInboundDataHandler
implements PGConstants {
    private static final char NULL_CHAR = '\uffff';
    public Map<String, String> m_parameterStatus;
    public KeyData m_keyData;
    private DataRow m_currentDataRow;
    private boolean m_processingDataRow;
    private char m_currentMessageType = (char)65535;
    private int m_currentMessageLength = -1;
    private ErrorResponse m_currentErrorResponse;
    private PGMessagingContext m_currentMessagingContext;
    private char m_lastMessageLogged = (char)88;
    private StringBuilder m_messageTypeLogging;
    private IWarningListener m_connectionWarningListener;
    protected IPGLogger m_log;

    public InboundDataHandler(IPGLogger iPGLogger, int n, int n2) {
        super(iPGLogger, n, n2);
        this.m_log = iPGLogger;
        this.m_parameterStatus = new HashMap<String, String>();
    }

    @Override
    public void closeOperation() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        super.closeOperation();
    }

    @Override
    protected boolean validateCurrentPipeline() {
        boolean bl = super.validateCurrentPipeline();
        if (null != this.m_currentPipeline && this.m_currentPipeline instanceof PGMessagingContext) {
            this.m_currentMessagingContext = (PGMessagingContext)this.m_currentPipeline;
        }
        return bl;
    }

    private void logMessageType() {
        if ('\uffff' != this.m_currentMessageType) {
            if (this.m_lastMessageLogged != this.m_currentMessageType) {
                if (null != this.m_messageTypeLogging) {
                    LogUtilities.logDebug(this.m_messageTypeLogging.toString(), (ILogger)this.m_log);
                    this.m_messageTypeLogging = null;
                }
                this.m_messageTypeLogging = new StringBuilder();
                this.m_messageTypeLogging.append("Message Type: ");
                this.m_messageTypeLogging.append(this.m_currentMessageType);
            } else {
                this.m_messageTypeLogging.append(this.m_currentMessageType);
            }
        } else if (null != this.m_messageTypeLogging) {
            LogUtilities.logDebug("Finally:" + this.m_messageTypeLogging.toString(), (ILogger)this.m_log);
            this.m_messageTypeLogging = null;
        }
        this.m_lastMessageLogged = this.m_currentMessageType;
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws ErrorException {
        Object object;
        if (this.m_log.isEnabled()) {
            LogUtilities.logInfo("Deserializing # of bytes: " + byteBuffer.remaining(), (ILogger)this.m_log);
        }
        try {
            Object object2;
            if (this.m_processingDataRow) {
                this.m_currentDataRow.read(byteBuffer);
                if (this.m_log.isEnabled()) {
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("Adding to Data row #");
                    ((StringBuilder)object2).append(this.m_currentMessagingContext.m_dataRowCount);
                    ((StringBuilder)object2).append(", # of columns: ");
                    ((StringBuilder)object2).append(this.m_currentDataRow.getNumberOfColumns());
                    LogUtilities.logDebug(((StringBuilder)object2).toString(), (ILogger)this.m_log);
                }
                if (this.m_currentDataRow.isRowComplete()) {
                    ++this.m_currentMessagingContext.m_dataRowCount;
                    this.addToPipeline(this.m_currentDataRow, false);
                    this.m_processingDataRow = false;
                    this.m_currentDataRow = null;
                }
            }
            while (byteBuffer.hasRemaining() && byteBuffer.remaining() > 5) {
                if ('\uffff' == this.m_currentMessageType) {
                    this.m_currentMessageType = (char)byteBuffer.get();
                    if (this.m_log.isEnabled()) {
                        this.logMessageType();
                    }
                }
                if (-1 == this.m_currentMessageLength) {
                    this.m_currentMessageLength = byteBuffer.getInt();
                    if (this.m_log.isEnabled()) {
                        LogUtilities.logDebug("Message Length: " + this.m_currentMessageLength, (ILogger)this.m_log);
                    }
                }
                if ('D' == this.m_currentMessageType && DataRow.getUniqueMessageSize() > byteBuffer.remaining() || 'D' != this.m_currentMessageType && this.m_currentMessageLength - 4 > byteBuffer.remaining()) {
                    if (this.m_log.isEnabled()) {
                        object2 = new StringBuilder();
                        ((StringBuilder)object2).append("Next message spanning into the next buffer read, currently have ");
                        ((StringBuilder)object2).append(byteBuffer.remaining());
                        ((StringBuilder)object2).append(" bytes. Message type: ");
                        ((StringBuilder)object2).append(this.m_currentMessageType);
                        ((StringBuilder)object2).append(", total messages in pipeline:");
                        ((StringBuilder)object2).append(this.m_currentPipeline.m_totalMessageCount);
                        ((StringBuilder)object2).append(", length expected: ");
                        ((StringBuilder)object2).append(this.m_currentMessageLength);
                        LogUtilities.logDebug(((StringBuilder)object2).toString(), (ILogger)this.m_log);
                    }
                    return;
                }
                switch (this.m_currentMessageType) {
                    case 'D': {
                        this.m_currentDataRow = new DataRow(byteBuffer, this.m_log, this.m_currentMessageLength);
                        if (this.m_log.isEnabled()) {
                            object2 = new StringBuilder();
                            ((StringBuilder)object2).append("Data row #");
                            ((StringBuilder)object2).append(this.m_currentMessagingContext.m_dataRowCount);
                            ((StringBuilder)object2).append(", # of columns: ");
                            ((StringBuilder)object2).append(this.m_currentDataRow.getNumberOfColumns());
                            ((StringBuilder)object2).append(", complete:");
                            ((StringBuilder)object2).append(this.m_currentDataRow.isRowComplete());
                            LogUtilities.logDebug(((StringBuilder)object2).toString(), (ILogger)this.m_log);
                        }
                        if (this.m_currentDataRow.isRowComplete()) {
                            ++this.m_currentMessagingContext.m_dataRowCount;
                            this.addToPipeline(this.m_currentDataRow, false);
                            this.m_currentDataRow = null;
                            break;
                        }
                        this.m_processingDataRow = true;
                        break;
                    }
                    case 'S': {
                        object2 = new ParameterStatus(byteBuffer, this.m_log);
                        this.m_parameterStatus.put(((ParameterStatus)object2).getName(), ((ParameterStatus)object2).getValue());
                        if (!this.m_log.isEnabled()) break;
                        LogUtilities.logInfo(((ParameterStatus)object2).toString(), (ILogger)this.m_log);
                        break;
                    }
                    case 'E': {
                        this.m_currentErrorResponse = new ErrorResponse(byteBuffer, this.m_currentMessageLength, this.m_log);
                        if (this.m_log.isEnabled()) {
                            LogUtilities.logError(this.m_currentErrorResponse.toString(), (ILogger)this.m_log);
                        }
                        if (0 == this.m_currentErrorResponse.getTranslateSeverity().compareTo(ErrorResponse.Severity.FATAL) || 0 == this.m_currentErrorResponse.getTranslateSeverity().compareTo(ErrorResponse.Severity.PANIC)) {
                            throw this.m_currentErrorResponse.toErrorException();
                        }
                        if (!FilterUtilities.checkFilterLevel(this.m_currentErrorResponse.getSeverity(), this.m_filterLevel)) break;
                        this.addToPipeline(this.m_currentErrorResponse, true);
                        break;
                    }
                    case 'N': {
                        object2 = new NoticeResponse(byteBuffer, this.m_currentMessageLength, this.m_log);
                        if (!FilterUtilities.checkFilterLevel(((ErrorResponse)object2).getSeverity(), this.m_filterLevel)) break;
                        this.addToPipeline((IInboundMessage)object2, true);
                        if (!this.m_log.isEnabled()) break;
                        LogUtilities.logError(((ErrorResponse)object2).toString(), (ILogger)this.m_log);
                        break;
                    }
                    case 'A': {
                        object2 = new NotificationResponse(byteBuffer, this.m_log);
                        this.m_connectionWarningListener.postWarning(((NotificationResponse)object2).toWarning());
                        if (!this.m_log.isEnabled()) break;
                        LogUtilities.logError(((NotificationResponse)object2).toString(), (ILogger)this.m_log);
                        break;
                    }
                    case '1': {
                        this.addToPipeline(new ParseComplete(byteBuffer, this.m_log), false);
                        break;
                    }
                    case '2': {
                        this.addToPipeline(new BindComplete(byteBuffer, this.m_log), false);
                        break;
                    }
                    case 't': {
                        this.addToPipeline(new ParameterDescription(byteBuffer, this.m_log), false);
                        break;
                    }
                    case 'T': {
                        this.addToPipeline(new RowDescription(byteBuffer, this.m_log), false);
                        break;
                    }
                    case 'n': {
                        this.addToPipeline(new NoData(byteBuffer, this.m_log), false);
                        break;
                    }
                    case 's': {
                        break;
                    }
                    case 'I': {
                        this.addToPipeline(new EmptyQueryResponse(this.m_log), false);
                        this.handleCommandComplete();
                        break;
                    }
                    case 'C': {
                        object2 = new CommandComplete(byteBuffer, this.m_currentMessageLength, this.m_log);
                        this.addToPipeline((IInboundMessage)object2, false);
                        this.handleCommandComplete();
                        break;
                    }
                    case '3': {
                        object2 = new CloseComplete(byteBuffer, this.m_log);
                        this.addToPipeline((IInboundMessage)object2, false);
                        this.m_currentMessagingContext.m_closeCompleteFromWire = true;
                        this.evaluateContainerRemoval(PGMessagingContext.CloseMode.CloseComplete);
                        break;
                    }
                    case 'Z': {
                        object2 = new ReadyForQuery(byteBuffer, this.m_log);
                        if (null == object2) break;
                        if (this.m_log.isEnabled()) {
                            if (((ReadyForQuery)object2).isIdle()) {
                                LogUtilities.logDebug("Ready for query - idle.", (ILogger)this.m_log);
                            } else if (((ReadyForQuery)object2).isTransactionBlock()) {
                                LogUtilities.logDebug("Ready for query - in transaction block.", (ILogger)this.m_log);
                            } else if (((ReadyForQuery)object2).isFailedTransactionBlock()) {
                                LogUtilities.logFatal("Ready for query - in a failed transaction block.", (ILogger)this.m_log);
                            }
                        }
                        if (!this.validateCurrentPipeline()) {
                            LogUtilities.logError("Unable to get pipeline", (ILogger)this.m_log);
                        }
                        if (PGMessagingContext.CloseMode.ReadyForQuery != this.m_currentMessagingContext.getCloseMode() && !this.m_currentMessagingContext.m_finalCommandInBatch) {
                            while (!this.m_currentMessagingContext.m_finalCommandInBatch) {
                                object = this.m_currentMessagingContext.getCloseMode();
                                if (null != this.m_currentErrorResponse) {
                                    this.addToPipeline(this.m_currentErrorResponse, false);
                                }
                                this.addToPipeline((IInboundMessage)object2, false);
                                this.removeCurrentContainer();
                                if (this.validateCurrentPipeline()) continue;
                                LogUtilities.logError("Previous pipeline was closeMode of " + object + ", another is not available", (ILogger)this.m_log);
                            }
                            if (null != this.m_currentErrorResponse) {
                                this.addToPipeline(this.m_currentErrorResponse, false);
                            }
                        }
                        this.m_currentErrorResponse = null;
                        this.addToPipeline((IInboundMessage)object2, false);
                        this.removeCurrentContainer();
                        break;
                    }
                    case 'R': {
                        this.addToPipeline(new Authentication(byteBuffer, this.m_log), false);
                        break;
                    }
                    case 'K': {
                        this.m_keyData = new KeyData(byteBuffer, this.m_log);
                        break;
                    }
                    default: {
                        if (this.m_log.isEnabled()) {
                            object2 = new StringBuilder();
                            ((StringBuilder)object2).append("Message boundary syncronization lost (unrecognized message type)");
                            ((StringBuilder)object2).append(". Terminate. Found message type:" + this.m_currentMessageType);
                            ((StringBuilder)object2).append(":ReadBuffer.remaining:" + byteBuffer.remaining());
                            ((StringBuilder)object2).append(":ReadBuffer.pos:" + byteBuffer.position());
                            ((StringBuilder)object2).append(":ReadBuffer.limit:" + byteBuffer.limit());
                            LogUtilities.logError(((StringBuilder)object2).toString(), (ILogger)this.m_log);
                        }
                        throw new MessageBoundarySyncronizationLostException();
                    }
                }
                this.m_currentMessageType = (char)65535;
                this.m_currentMessageLength = -1;
            }
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (Throwable throwable) {
            LogUtilities.logFatal("InboundDataHandler caught throwable: " + throwable.getMessage(), (ILogger)this.m_log);
            object = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
            object.initCause(throwable);
            throw object;
        }
        finally {
            if (this.m_log.isEnabled()) {
                this.logMessageType();
            }
            byteBuffer.compact();
        }
    }

    private void handleCommandComplete() {
        this.m_currentMessagingContext.m_commandCompleteFromWire = true;
        if (this.m_currentMessagingContext.m_multipleParameterSetsMode) {
            ++this.m_currentMessagingContext.m_batchCommandCompleteToPipelineCount;
        }
        this.evaluateContainerRemoval(PGMessagingContext.CloseMode.CommandComplete);
    }

    @Override
    public void removeCurrentContainer() {
        this.m_currentPipeline = null;
        this.m_currentMessagingContext = null;
        super.removeCurrentContainer();
    }

    private void evaluateContainerRemoval(PGMessagingContext.CloseMode closeMode) {
        if (this.m_currentMessagingContext.m_finalCommandInBatch) {
            if (this.m_currentMessagingContext.m_multipleParameterSetsMode) {
                if (this.m_currentMessagingContext.m_batchCommandCompleteToPipelineCount == this.m_currentMessagingContext.m_batchCount) {
                    return;
                }
            } else {
                return;
            }
        }
        if (this.m_currentMessagingContext.getCloseMode() == closeMode) {
            this.removeCurrentContainer();
        }
    }

    public void registerWarningListener(IWarningListener iWarningListener) {
        this.m_connectionWarningListener = iWarningListener;
    }

    @Override
    public boolean isOpenOperation() {
        if (null == this.m_currentPipeline) {
            this.validateCurrentPipeline();
        }
        return null != this.m_currentPipeline && this.m_currentPipeline.hasOpenOperation();
    }
}

