/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ion.impl.bin;

import com.amazon.ion.Decimal;
import com.amazon.ion.IonType;
import com.amazon.ion.Timestamp;
import com.amazon.ion.impl.bin.WriteBuffer;
import com.amazon.ion.impl.bin.utf8.Utf8StringEncoder;
import com.amazon.ion.impl.bin.utf8.Utf8StringEncoderPool;
import java.math.BigDecimal;
import java.math.BigInteger;

public class IonEncoder_1_1 {
    private static final BigInteger BIG_INT_LONG_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger BIG_INT_LONG_MIN_VALUE = BigInteger.valueOf(Long.MIN_VALUE);

    public static int writeNullValue(WriteBuffer buffer, IonType ionType) {
        if (ionType == IonType.NULL) {
            buffer.writeByte((byte)-22);
            return 1;
        }
        buffer.writeByte((byte)-21);
        switch (ionType) {
            case BOOL: {
                buffer.writeByte((byte)0);
                break;
            }
            case INT: {
                buffer.writeByte((byte)1);
                break;
            }
            case FLOAT: {
                buffer.writeByte((byte)2);
                break;
            }
            case DECIMAL: {
                buffer.writeByte((byte)3);
                break;
            }
            case TIMESTAMP: {
                buffer.writeByte((byte)4);
                break;
            }
            case STRING: {
                buffer.writeByte((byte)5);
                break;
            }
            case SYMBOL: {
                buffer.writeByte((byte)6);
                break;
            }
            case BLOB: {
                buffer.writeByte((byte)7);
                break;
            }
            case CLOB: {
                buffer.writeByte((byte)8);
                break;
            }
            case LIST: {
                buffer.writeByte((byte)9);
                break;
            }
            case SEXP: {
                buffer.writeByte((byte)10);
                break;
            }
            case STRUCT: {
                buffer.writeByte((byte)11);
                break;
            }
            case DATAGRAM: {
                throw new IllegalArgumentException("Cannot write a null datagram");
            }
        }
        return 2;
    }

    public static int writeBoolValue(WriteBuffer buffer, boolean value) {
        if (value) {
            buffer.writeByte((byte)94);
        } else {
            buffer.writeByte((byte)95);
        }
        return 1;
    }

    public static int writeIntValue(WriteBuffer buffer, long value) {
        if (value == 0L) {
            buffer.writeByte((byte)80);
            return 1;
        }
        int length = WriteBuffer.fixedIntLength(value);
        buffer.writeByte((byte)(80 + length));
        buffer.writeFixedInt(value);
        return 1 + length;
    }

    public static int writeIntValue(WriteBuffer buffer, BigInteger value) {
        if (value == null) {
            return IonEncoder_1_1.writeNullValue(buffer, IonType.INT);
        }
        if (value.compareTo(BIG_INT_LONG_MIN_VALUE) >= 0 && value.compareTo(BIG_INT_LONG_MAX_VALUE) <= 0) {
            return IonEncoder_1_1.writeIntValue(buffer, value.longValue());
        }
        buffer.writeByte((byte)-11);
        byte[] intBytes = value.toByteArray();
        int totalBytes = 1 + intBytes.length + buffer.writeFlexUInt(intBytes.length);
        for (int i = intBytes.length; i > 0; --i) {
            buffer.writeByte(intBytes[i - 1]);
        }
        return totalBytes;
    }

    public static int writeFloat(WriteBuffer buffer, float value) {
        if ((double)value == 0.0) {
            buffer.writeByte((byte)90);
            return 1;
        }
        buffer.writeByte((byte)92);
        buffer.writeUInt32(Float.floatToIntBits(value));
        return 5;
    }

    public static int writeFloat(WriteBuffer buffer, double value) {
        if (value == 0.0) {
            buffer.writeByte((byte)90);
            return 1;
        }
        if (!Double.isFinite(value) || value == (double)((float)value)) {
            buffer.writeByte((byte)92);
            buffer.writeUInt32(Float.floatToIntBits((float)value));
            return 5;
        }
        buffer.writeByte((byte)93);
        buffer.writeUInt64(Double.doubleToRawLongBits(value));
        return 9;
    }

    public static int writeDecimalValue(WriteBuffer buffer, BigDecimal value) {
        if (value == null) {
            return IonEncoder_1_1.writeNullValue(buffer, IonType.DECIMAL);
        }
        int exponent = -value.scale();
        if (BigDecimal.ZERO.compareTo(value) == 0 && !Decimal.isNegativeZero(value)) {
            if (exponent == 0) {
                buffer.writeByte((byte)96);
                return 1;
            }
            buffer.writeByte((byte)111);
            return 1 + buffer.writeFlexInt(exponent);
        }
        BigInteger coefficient = value.unscaledValue();
        int numCoefficientBytes = WriteBuffer.flexIntLength(coefficient);
        int numExponentBytes = 0;
        if (exponent != 0) {
            numExponentBytes = WriteBuffer.fixedIntLength(exponent);
        }
        int opCodeAndLengthBytes = 1;
        if (numExponentBytes + numCoefficientBytes < 15) {
            int opCode = 96 + numExponentBytes + numCoefficientBytes;
            buffer.writeByte((byte)opCode);
        } else {
            buffer.writeByte((byte)-10);
            opCodeAndLengthBytes += buffer.writeFlexUInt(numExponentBytes + numCoefficientBytes);
        }
        buffer.writeFlexInt(coefficient);
        if (exponent != 0) {
            buffer.writeFixedInt(exponent);
        }
        return opCodeAndLengthBytes + numCoefficientBytes + numExponentBytes;
    }

    public static int writeTimestampValue(WriteBuffer buffer, Timestamp value) {
        int secondsScale;
        if (value == null) {
            return IonEncoder_1_1.writeNullValue(buffer, IonType.TIMESTAMP);
        }
        if (value.getYear() < 1970 || value.getYear() > 2097) {
            return IonEncoder_1_1.writeLongFormTimestampValue(buffer, value);
        }
        if (!value.getPrecision().includes(Timestamp.Precision.MINUTE)) {
            return IonEncoder_1_1.writeShortFormTimestampValue(buffer, value);
        }
        if (value.getZFractionalSecond() != null && (secondsScale = value.getZFractionalSecond().scale()) != 0 && secondsScale != 3 && secondsScale != 6 && secondsScale != 9) {
            return IonEncoder_1_1.writeLongFormTimestampValue(buffer, value);
        }
        Integer offset = value.getLocalOffset();
        if (offset != null && (offset < -840 || offset > 840 || offset % 15 != 0)) {
            return IonEncoder_1_1.writeLongFormTimestampValue(buffer, value);
        }
        return IonEncoder_1_1.writeShortFormTimestampValue(buffer, value);
    }

    private static int writeShortFormTimestampValue(WriteBuffer buffer, Timestamp value) {
        long bits = (long)value.getYear() - 1970L;
        if (value.getPrecision() == Timestamp.Precision.YEAR) {
            buffer.writeByte((byte)112);
            buffer.writeFixedIntOrUInt(bits, 1);
            return 2;
        }
        bits |= (long)value.getMonth() << 7;
        if (value.getPrecision() == Timestamp.Precision.MONTH) {
            buffer.writeByte((byte)113);
            buffer.writeFixedIntOrUInt(bits, 2);
            return 3;
        }
        bits |= (long)value.getDay() << 11;
        if (value.getPrecision() == Timestamp.Precision.DAY) {
            buffer.writeByte((byte)114);
            buffer.writeFixedIntOrUInt(bits, 2);
            return 3;
        }
        bits |= (long)value.getHour() << 16;
        bits |= (long)value.getMinute() << 21;
        if (value.getLocalOffset() == null || value.getLocalOffset() == 0) {
            if (value.getLocalOffset() != null) {
                bits |= 0x8000000L;
            }
            if (value.getPrecision() == Timestamp.Precision.MINUTE) {
                buffer.writeByte((byte)115);
                buffer.writeFixedIntOrUInt(bits, 4);
                return 5;
            }
            bits |= (long)value.getSecond() << 28;
            int secondsScale = 0;
            if (value.getZFractionalSecond() != null) {
                secondsScale = value.getZFractionalSecond().scale();
            }
            if (secondsScale != 0) {
                long fractionalSeconds = value.getZFractionalSecond().unscaledValue().longValue();
                bits |= fractionalSeconds << 34;
            }
            switch (secondsScale) {
                case 0: {
                    buffer.writeByte((byte)116);
                    buffer.writeFixedIntOrUInt(bits, 5);
                    return 6;
                }
                case 3: {
                    buffer.writeByte((byte)117);
                    buffer.writeFixedIntOrUInt(bits, 6);
                    return 7;
                }
                case 6: {
                    buffer.writeByte((byte)118);
                    buffer.writeFixedIntOrUInt(bits, 7);
                    return 8;
                }
                case 9: {
                    buffer.writeByte((byte)119);
                    buffer.writeFixedIntOrUInt(bits, 8);
                    return 9;
                }
            }
            throw new IllegalStateException("This is unreachable!");
        }
        long localOffset = value.getLocalOffset().longValue() / 15L + 56L;
        bits |= (localOffset & 0x7FL) << 27;
        if (value.getPrecision() == Timestamp.Precision.MINUTE) {
            buffer.writeByte((byte)120);
            buffer.writeFixedIntOrUInt(bits, 5);
            return 6;
        }
        bits |= (long)value.getSecond() << 34;
        long fractionBits = 0L;
        int secondsScale = 0;
        if (value.getZFractionalSecond() != null) {
            secondsScale = value.getZFractionalSecond().scale();
        }
        if (secondsScale != 0) {
            fractionBits = value.getZFractionalSecond().unscaledValue().longValue();
        }
        switch (secondsScale) {
            case 0: {
                buffer.writeByte((byte)121);
                buffer.writeFixedIntOrUInt(bits, 5);
                return 6;
            }
            case 3: {
                buffer.writeByte((byte)122);
                buffer.writeFixedIntOrUInt(bits, 5);
                buffer.writeFixedIntOrUInt(fractionBits, 2);
                return 8;
            }
            case 6: {
                buffer.writeByte((byte)123);
                buffer.writeFixedIntOrUInt(bits, 5);
                buffer.writeFixedIntOrUInt(fractionBits, 3);
                return 9;
            }
            case 9: {
                buffer.writeByte((byte)124);
                buffer.writeFixedIntOrUInt(bits, 5);
                buffer.writeFixedIntOrUInt(fractionBits, 4);
                return 10;
            }
        }
        throw new IllegalStateException("This is unreachable!");
    }

    static int writeLongFormTimestampValue(WriteBuffer buffer, Timestamp value) {
        buffer.writeByte((byte)-9);
        long bits = value.getYear();
        if (value.getPrecision() == Timestamp.Precision.YEAR) {
            buffer.writeFlexUInt(2L);
            buffer.writeFixedIntOrUInt(bits, 2);
            return 4;
        }
        bits |= (long)value.getMonth() << 14;
        if (value.getPrecision() == Timestamp.Precision.MONTH) {
            buffer.writeFlexUInt(3L);
            buffer.writeFixedIntOrUInt(bits, 3);
            return 5;
        }
        bits |= (long)value.getDay() << 18;
        if (value.getPrecision() == Timestamp.Precision.DAY) {
            buffer.writeFlexUInt(3L);
            buffer.writeFixedIntOrUInt(bits, 3);
            return 5;
        }
        bits |= (long)value.getHour() << 23;
        bits |= (long)value.getMinute() << 28;
        long localOffsetValue = 4095L;
        if (value.getLocalOffset() != null) {
            localOffsetValue = value.getLocalOffset() + 1440;
        }
        bits |= localOffsetValue << 34;
        if (value.getPrecision() == Timestamp.Precision.MINUTE) {
            buffer.writeFlexUInt(6L);
            buffer.writeFixedIntOrUInt(bits, 6);
            return 8;
        }
        bits |= (long)value.getSecond() << 46;
        int secondsScale = 0;
        if (value.getZFractionalSecond() != null) {
            secondsScale = value.getZFractionalSecond().scale();
        }
        if (secondsScale == 0) {
            buffer.writeFlexUInt(7L);
            buffer.writeFixedIntOrUInt(bits, 7);
            return 9;
        }
        BigDecimal fractionalSeconds = value.getZFractionalSecond();
        BigInteger coefficient = fractionalSeconds.unscaledValue();
        long exponent = fractionalSeconds.scale();
        int numCoefficientBytes = WriteBuffer.flexUIntLength(coefficient);
        int numExponentBytes = WriteBuffer.fixedUIntLength(exponent);
        int dataLength = 7 + numCoefficientBytes + numExponentBytes;
        buffer.writeFlexUInt(dataLength);
        buffer.writeFixedIntOrUInt(bits, 7);
        buffer.writeFlexUInt(coefficient);
        buffer.writeFixedUInt(exponent);
        return 1 + WriteBuffer.flexUIntLength(dataLength) + dataLength;
    }

    public static int writeStringValue(WriteBuffer buffer, String value) {
        return IonEncoder_1_1.writeInlineText(buffer, value, IonType.STRING, (byte)-128, (byte)-8);
    }

    public static int writeSymbolValue(WriteBuffer buffer, String value) {
        return IonEncoder_1_1.writeInlineText(buffer, value, IonType.SYMBOL, (byte)-112, (byte)-7);
    }

    private static int writeInlineText(WriteBuffer buffer, String value, IonType type, byte zeroLengthOpCode, byte variableLengthOpCode) {
        if (value == null) {
            return IonEncoder_1_1.writeNullValue(buffer, type);
        }
        Utf8StringEncoder.Result encoderResult = ((Utf8StringEncoder)Utf8StringEncoderPool.getInstance().getOrCreate()).encode(value);
        byte[] utf8Buffer = encoderResult.getBuffer();
        int numValueBytes = encoderResult.getEncodedLength();
        int numLengthBytes = 0;
        if (numValueBytes <= 15) {
            buffer.writeByte((byte)(zeroLengthOpCode | numValueBytes));
        } else {
            buffer.writeByte(variableLengthOpCode);
            numLengthBytes = buffer.writeFlexUInt(numValueBytes);
        }
        buffer.writeBytes(utf8Buffer, 0, numValueBytes);
        return 1 + numLengthBytes + numValueBytes;
    }

    public static int writeSymbolValue(WriteBuffer buffer, long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("Symbol Address cannot be negative; was: " + value);
        }
        if (value < 256L) {
            buffer.writeByte((byte)-31);
            buffer.writeFixedUInt(value);
            return 2;
        }
        if (value < 65792L) {
            buffer.writeByte((byte)-30);
            buffer.writeFixedIntOrUInt(value - 256L, 2);
            return 3;
        }
        buffer.writeByte((byte)-29);
        int addressBytes = buffer.writeFlexUInt(value - 65792L);
        return 1 + addressBytes;
    }

    public static int writeBlobValue(WriteBuffer buffer, byte[] value) {
        if (value == null) {
            return IonEncoder_1_1.writeNullValue(buffer, IonType.BLOB);
        }
        buffer.writeByte((byte)-2);
        int numLengthBytes = buffer.writeFlexUInt(value.length);
        buffer.writeBytes(value);
        return 1 + numLengthBytes + value.length;
    }

    public static int writeClobValue(WriteBuffer buffer, byte[] value) {
        if (value == null) {
            return IonEncoder_1_1.writeNullValue(buffer, IonType.CLOB);
        }
        buffer.writeByte((byte)-1);
        int numLengthBytes = buffer.writeFlexUInt(value.length);
        buffer.writeBytes(value);
        return 1 + numLengthBytes + value.length;
    }

    public static int writeAnnotations(WriteBuffer buffer, long[] annotations) {
        if (annotations == null || annotations.length == 0) {
            return 0;
        }
        if (annotations.length == 1) {
            buffer.writeByte((byte)-28);
            int numAddressBytes = buffer.writeFlexUInt(annotations[0]);
            return 1 + numAddressBytes;
        }
        if (annotations.length == 2) {
            buffer.writeByte((byte)-27);
            int numAddressBytes = buffer.writeFlexUInt(annotations[0]);
            return 1 + (numAddressBytes += buffer.writeFlexUInt(annotations[1]));
        }
        int numAddressBytes = 0;
        for (long ann : annotations) {
            numAddressBytes += WriteBuffer.flexUIntLength(ann);
        }
        buffer.writeByte((byte)-26);
        int numLengthBytes = buffer.writeFlexUInt(numAddressBytes);
        for (long ann : annotations) {
            buffer.writeFlexUInt(ann);
        }
        return 1 + numLengthBytes + numAddressBytes;
    }
}

