/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb.write;

import com.google.common.base.Strings;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.dynamodb.DynamoDBClient;
import org.apache.hadoop.dynamodb.DynamoDBConstants;
import org.apache.hadoop.dynamodb.DynamoDBUtil;
import org.apache.hadoop.dynamodb.IopsCalculator;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputDescription;
import software.amazon.awssdk.services.dynamodb.model.TableDescription;

public class WriteIopsCalculator
implements IopsCalculator {
    private static final Log log = LogFactory.getLog(WriteIopsCalculator.class);
    private final DynamoDBClient dynamoDBClient;
    private final JobClient jobClient;
    private final JobConf jobConf;
    private final String tableName;
    private final int maxParallelTasks;
    private final double throughputPercent;

    public WriteIopsCalculator(JobClient jobClient, DynamoDBClient dynamoDBClient, String tableName) {
        this.jobConf = (JobConf)jobClient.getConf();
        this.jobClient = jobClient;
        this.dynamoDBClient = dynamoDBClient;
        this.tableName = tableName;
        this.throughputPercent = Double.parseDouble(this.jobConf.get("dynamodb.throughput.write.percent", "0.5"));
        log.info((Object)("Table name: " + tableName));
        log.info((Object)("Throughput percent: " + this.throughputPercent));
        String taskId = this.jobConf.get("mapreduce.task.attempt.id");
        log.info((Object)("Task Id: " + taskId));
        log.info((Object)("Number of mappers from config: " + this.jobConf.getNumMapTasks()));
        log.info((Object)("Number of reducers from config: " + this.jobConf.getNumReduceTasks()));
        int totalMapTasks = this.jobConf.getNumMapTasks();
        log.info((Object)("Total map tasks: " + totalMapTasks));
        this.maxParallelTasks = Strings.isNullOrEmpty((String)taskId) ? 1 : (DynamoDBUtil.isYarnEnabled(this.jobConf) ? Math.min(this.calculateMaxMapTasks(totalMapTasks), totalMapTasks) : totalMapTasks);
        log.info((Object)("Max parallel map tasks: " + this.maxParallelTasks));
    }

    @Override
    public long calculateTargetIops() {
        double configuredThroughput = Boolean.parseBoolean(this.jobConf.get("dynamodb.throughput.write.autoscaling")) || this.jobConf.get("dynamodb.throughput.write") == null ? this.getThroughput() : Double.parseDouble(this.jobConf.get("dynamodb.throughput.write"));
        double calculatedThroughput = Math.floor(configuredThroughput * this.throughputPercent);
        long throughputPerTask = Math.max((long)(calculatedThroughput / (double)this.maxParallelTasks), 1L);
        log.info((Object)("Throughput per task for table " + this.tableName + " : " + throughputPerTask));
        return throughputPerTask;
    }

    int calculateMaxMapTasks(int totalMapTasks) {
        try {
            return DynamoDBUtil.calcMaxMapTasks(this.jobClient);
        }
        catch (IOException e) {
            log.warn((Object)"Exception calculating max map tasks", (Throwable)e);
            return totalMapTasks;
        }
    }

    protected double getThroughput() {
        TableDescription tableDescription = this.dynamoDBClient.describeTable(this.tableName);
        if (tableDescription.billingModeSummary() == null || tableDescription.billingModeSummary().billingMode() == BillingMode.PROVISIONED) {
            ProvisionedThroughputDescription provisionedThroughput = tableDescription.provisionedThroughput();
            return provisionedThroughput.writeCapacityUnits().longValue();
        }
        return DynamoDBConstants.DEFAULT_CAPACITY_FOR_ON_DEMAND.longValue();
    }
}

